/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.utils;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextLayout;
import java.text.AttributedString;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.UIManager;
import org.jdesktop.jxlayer.JXLayer;
import org.jdesktop.jxlayer.plaf.ext.LockableUI;

public class TextLockableUI
extends LockableUI {
    private static final long serialVersionUID = 1L;
    private String text = "";
    private boolean displayText = true;
    private Color foreground = UIManager.getColor("TextArea.inactiveForeground");
    private Font font = REGULAR_FONT;
    public static final Font REGULAR_FONT = UIManager.getFont("Label.font").deriveFont(1, 12.0f);
    public static final Font LARGE_FONT = UIManager.getFont("Label.font").deriveFont(1, 16.0f);

    public TextLockableUI() {
    }

    public TextLockableUI(String string) {
        this.setText(string);
    }

    public final void setText(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Text cannot be null");
        }
        this.text = string;
    }

    public final String getText() {
        return this.text;
    }

    public final void setTextVisible(boolean bl) {
        this.displayText = bl;
    }

    public final boolean isTextVisible() {
        return this.displayText;
    }

    public final void setForeground(Color color) {
        this.foreground = color;
    }

    public final Color getForeground() {
        return this.foreground;
    }

    /*
     * WARNING - void declaration
     */
    protected void paintLayer(Graphics2D graphics2D, JXLayer<? extends JComponent> jXLayer) {
        if (this.isLocked()) {
            ((JComponent)jXLayer.getView()).setVisible(true);
            jXLayer.paint((Graphics)graphics2D);
            if (this.displayText) {
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                String[] stringArray = this.text.split("\\n");
                ArrayList<TextLayout> arrayList = new ArrayList<TextLayout>();
                float f = Double.valueOf((double)jXLayer.getWidth() * 0.8).floatValue();
                for (String string : stringArray) {
                    void object;
                    if (string.isEmpty()) {
                        String string2 = " ";
                    }
                    AttributedString attributedString = new AttributedString((String)object, this.font.getAttributes());
                    LineBreakMeasurer lineBreakMeasurer = new LineBreakMeasurer(attributedString.getIterator(), graphics2D.getFontRenderContext());
                    TextLayout textLayout = lineBreakMeasurer.nextLayout(f);
                    while (textLayout != null) {
                        arrayList.add(textLayout);
                        textLayout = lineBreakMeasurer.nextLayout(f);
                    }
                }
                int n = 0;
                for (TextLayout textLayout : arrayList) {
                    n = (int)((double)n + textLayout.getBounds().getHeight());
                }
                int n2 = n / arrayList.size() / 2;
                int n3 = jXLayer.getHeight() / 3 - (n += n2 * (arrayList.size() - 1)) / 2;
                for (TextLayout textLayout : arrayList) {
                    n3 = (int)((float)n3 + textLayout.getAscent());
                    int n4 = (int)((float)(jXLayer.getWidth() / 2) - textLayout.getAdvance() / 2.0f);
                    graphics2D.setColor(UIManager.getColor("TextArea.background"));
                    textLayout.draw(graphics2D, (float)n4 + 0.75f, (float)n3 + 0.75f);
                    graphics2D.setColor(this.foreground);
                    textLayout.draw(graphics2D, n4, n3);
                    n3 += n2;
                }
            }
            ((JComponent)jXLayer.getView()).setVisible(false);
        }
    }

    public final void setFont(Font font) {
        this.font = font;
    }

    public final Font getFont() {
        return this.font;
    }
}

