/*
 * Decompiled with CFR 0.152.
 */
package oracle.mdeditor.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import oracle.mdeditor.resources.icons.Icons;
import oracle.mdeditor.ui.GeometryViewPanel;
import oracle.mdeditor.ui.resources.MessagesBundle;

public class GeometryRenderPanel
extends JPanel {
    private NavigationToolBar toolPane = new NavigationToolBar();
    private GeometryViewPanel drawPane = new GeometryViewPanel();

    public GeometryRenderPanel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() {
        this.setSize(500, 400);
        this.setLayout(new GridBagLayout());
        this.setSize(new Dimension(518, 474));
        this.drawPane.setPreferredSize(new Dimension(800, 600));
        this.toolPane.setMinimumSize(new Dimension(339, 32));
        this.toolPane.setBorderPainted(false);
        this.add((Component)this.toolPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(2, 0, 2, 0), 0, 0));
        this.add((Component)this.drawPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public GeometryViewPanel getGeometryViewPanel() {
        return this.drawPane;
    }

    public void enableSelectionButton(boolean enable) {
        this.toolPane.enableSelectionButton(enable);
    }

    class NavigationToolBar
    extends JToolBar {
        public static final String IDENTIFY = "identify";
        public static final String ZOOMALL = "zoomall";
        public static final String ZOOMIN = "zoomin";
        public static final String ZOOMOUT = "zoomout";
        public static final String ZOOMBOX = "zoombox";
        public static final String PAN = "pan";
        protected JToggleButton identify = new JToggleButton(Icons.getIcon("selectobject_qualifier.png"));
        protected JButton zoomAll = new JButton(Icons.getIcon("zoomall.png"));
        protected JToggleButton zoomIn = new JToggleButton(Icons.getIcon("zoomin.gif"));
        protected JToggleButton zoomOut = new JToggleButton(Icons.getIcon("zoomout.gif"));
        protected JToggleButton zoomBox = new JToggleButton(Icons.getIcon("zoombox.gif"));
        protected JToggleButton pan = new JToggleButton(Icons.getIcon("pan.gif"));
        protected Object[] buttons = new Object[]{this.identify, this.zoomAll, this.zoomIn, this.zoomOut, this.zoomBox, this.pan};
        private JToggleButton clearButton = new JToggleButton();
        protected String action = null;
        protected GridBagLayout gridBagLayout1 = new GridBagLayout();
        protected ButtonGroup buttonGroup = new ButtonGroup();

        public NavigationToolBar() {
            try {
                this.jbInit();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        protected void jbInit() throws Exception {
            this.setSize(new Dimension(399, 24));
            this.buttonGroup = new ButtonGroup();
            this.buttonGroup.add(this.identify);
            this.buttonGroup.add(this.zoomIn);
            this.buttonGroup.add(this.zoomOut);
            this.buttonGroup.add(this.zoomBox);
            this.buttonGroup.add(this.pan);
            this.buttonGroup.add(this.clearButton);
            this.setRollover(true);
            this.identify.setToolTipText(MessagesBundle.getMessage("Tooltip_identify"));
            this.identify.setActionCommand(IDENTIFY);
            this.zoomAll.setToolTipText(MessagesBundle.getMessage("Tooltip_zoom_in"));
            this.zoomAll.setActionCommand(ZOOMALL);
            this.zoomIn.setToolTipText(MessagesBundle.getMessage("Tooltip_zoom_all"));
            this.zoomIn.setActionCommand(ZOOMIN);
            this.zoomOut.setToolTipText(MessagesBundle.getMessage("Tooltip_zoom_out"));
            this.zoomOut.setActionCommand(ZOOMOUT);
            this.zoomBox.setToolTipText(MessagesBundle.getMessage("Tooltip_zoom_box"));
            this.zoomBox.setActionCommand(ZOOMBOX);
            this.pan.setToolTipText(MessagesBundle.getMessage("Tooltip_pan"));
            this.pan.setActionCommand(PAN);
            this.setLayout(this.gridBagLayout1);
            this.add((Component)this.identify, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 0, 10), 0, 0));
            this.add((Component)this.zoomAll, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 0, 10), 0, 0));
            this.add((Component)this.pan, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 0, 0), 0, 0));
            this.add((Component)this.zoomIn, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 0, 0), 0, 0));
            this.add((Component)this.zoomOut, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 0, 0), 0, 0));
            this.add((Component)this.zoomBox, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 0, 0), 0, 0));
            this.identify.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    NavigationToolBar.this.identify_actionPerformed(e);
                }
            });
            this.zoomIn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    NavigationToolBar.this.zoomIn_actionPerformed(e);
                }
            });
            this.zoomOut.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    NavigationToolBar.this.zoomOut_actionPerformed(e);
                }
            });
            this.zoomBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    NavigationToolBar.this.zoomBox_actionPerformed(e);
                }
            });
            this.zoomAll.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    NavigationToolBar.this.zoomAll_actionPerformed(e);
                }
            });
            this.pan.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    NavigationToolBar.this.pan_actionPerformed(e);
                }
            });
        }

        public void enableSelectionButton(boolean enable) {
            this.identify.setEnabled(enable);
        }

        public String getCurrentAction() {
            return this.action;
        }

        private void identify_actionPerformed(ActionEvent e) {
            if (this.action == null || this.action != null && !this.action.equals(IDENTIFY)) {
                this.action = IDENTIFY;
                this.identify.setSelected(true);
                GeometryRenderPanel.this.drawPane.setAction(IDENTIFY);
            }
        }

        private void zoomIn_actionPerformed(ActionEvent e) {
            if (this.action == null || this.action != null && !this.action.equals(ZOOMIN)) {
                this.action = ZOOMIN;
                this.zoomIn.setSelected(true);
                GeometryRenderPanel.this.drawPane.setAction(ZOOMIN);
            }
        }

        private void zoomOut_actionPerformed(ActionEvent e) {
            if (this.action == null || this.action != null && !this.action.equals(ZOOMOUT)) {
                this.action = ZOOMOUT;
                this.zoomOut.setSelected(true);
                GeometryRenderPanel.this.drawPane.setAction(ZOOMOUT);
            }
        }

        private void pan_actionPerformed(ActionEvent e) {
            if (this.action == null || this.action != null && !this.action.equals(PAN)) {
                this.action = PAN;
                this.pan.setSelected(true);
                GeometryRenderPanel.this.drawPane.setAction(PAN);
            }
        }

        private void zoomBox_actionPerformed(ActionEvent e) {
            if (this.action == null || this.action != null && !this.action.equals(ZOOMBOX)) {
                this.action = ZOOMBOX;
                this.zoomBox.setSelected(true);
                GeometryRenderPanel.this.drawPane.setAction(ZOOMBOX);
            }
        }

        private void zoomAll_actionPerformed(ActionEvent e) {
            GeometryRenderPanel.this.drawPane.renderData();
        }
    }
}

