/*
 * Decompiled with CFR 0.152.
 */
package oracle.mdeditor.session;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Properties;
import oracle.maps.util.PropertySupportObject;
import oracle.mdeditor.session.EditSession;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLElement;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class SessionXMLUtils {
    public static final String TAG_SESSION_DEF = "session_definition";

    public static Element sessionToXMLElement(EditSession editSession) throws IOException, SAXException {
        Element propsElem;
        XMLDocument doc = new XMLDocument();
        doc.setXmlVersion("1.0");
        Element root = doc.createElement(TAG_SESSION_DEF);
        Properties props = editSession.getProperties();
        if (props.size() > 0 && (propsElem = PropertySupportObject.toXMLElement(props)) != null) {
            root.appendChild(doc.adoptNode((Node)propsElem));
        }
        Element layersElem = editSession.getLayers().toXMLElement();
        root.appendChild(doc.adoptNode((Node)layersElem));
        return root;
    }

    public static String sessionToXMLString(EditSession editSession) throws IOException, SAXException {
        StringWriter sw = new StringWriter(200);
        try {
            XMLElement elem = (XMLElement)SessionXMLUtils.sessionToXMLElement(editSession);
            elem.print(new PrintWriter(sw));
            String string = sw.toString();
            return string;
        }
        catch (IOException ex) {
            throw ex;
        }
        finally {
            if (sw != null) {
                try {
                    sw.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }
}

