/*
 * Decompiled with CFR 0.152.
 */
package oracle.maps.tools;

import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.EventObject;
import oracle.maps.layer.ui.ShapeDrawingLayer;

public class RectangleDrawer {
    protected ShapeDrawingLayer targetLayer = null;
    protected Rectangle2D box = null;
    protected Point2D start = null;
    protected int button = 1;
    protected int buttonMask = 1024;

    public RectangleDrawer(ShapeDrawingLayer targetLayer) {
        this(targetLayer, 1, 1024);
    }

    public RectangleDrawer(ShapeDrawingLayer targetLayer, int button, int buttonMask) {
        this.targetLayer = targetLayer;
        this.button = button;
        this.buttonMask = buttonMask;
    }

    public boolean handleEvent(EventObject evt) {
        boolean propagate = true;
        if (evt instanceof MouseEvent) {
            MouseEvent e = (MouseEvent)evt;
            int id = e.getID();
            if (id == 501) {
                if (this.targetLayer != null && (e.getModifiersEx() & this.buttonMask) == this.buttonMask) {
                    Point2D p = this.targetLayer.getSnapPoint(e.getPoint());
                    this.start = new Point2D.Double();
                    this.start.setLocation(p);
                    this.box = new Rectangle2D.Double(this.start.getX(), this.start.getY(), 0.0, 0.0);
                    this.targetLayer.setShape(this.box);
                    propagate = false;
                }
            } else if (id == 502) {
                if (this.targetLayer != null && e.getButton() == this.button) {
                    this.targetLayer.shapeCompleted(e);
                    this.box = null;
                    propagate = false;
                }
            } else if (id == 506 && this.box != null && this.targetLayer != null && (e.getModifiersEx() & this.buttonMask) == this.buttonMask) {
                Point2D p = this.targetLayer.getSnapPoint(e.getPoint());
                double x = Math.min(this.start.getX(), p.getX());
                double y = Math.min(this.start.getY(), p.getY());
                double w = Math.abs(this.start.getX() - p.getX());
                double h = Math.abs(this.start.getY() - p.getY());
                this.box.setRect(x, y, w, h);
                propagate = false;
            }
        }
        return propagate;
    }
}

