/*
 * Decompiled with CFR 0.152.
 */
package oracle.maps.graphics;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import javax.swing.SwingUtilities;
import oracle.maps.graphics.ShadowRenderer;

public class MapTip {
    protected int padding = 15;
    protected int minimumWidth = 120;
    protected int minimumHeight = 13;
    protected int preferredWidth = 140;
    protected int preferredHeight = 25;
    private int maxWidth = this.minimumWidth;
    private Font font = new Font("Tahoma", 0, 11);
    private FontMetrics fm = null;
    private String text;
    private static Image dummyImage = new BufferedImage(1, 1, 2);
    private Color textColor = new Color(56, 58, 71);
    private Color borderColor = new Color(155, 162, 176);
    private Image shapeImage;
    private Image shadowImage;
    private boolean rounded = false;
    private boolean draggable = false;
    private boolean shadow = true;
    private boolean borderless = false;
    private boolean neverShrink = false;

    protected double calculateTextLength(Graphics2D g) {
        if (this.fm == null) {
            this.fm = g.getFontMetrics(this.font);
        }
        return SwingUtilities.computeStringWidth(this.fm, this.text);
    }

    public long render(Graphics2D g, Point2D topLeftCorner) {
        long t1 = System.currentTimeMillis();
        this.renderTipShapeAndText();
        if (this.shadow) {
            this.renderTipShadow();
        }
        if (this.shadow) {
            g.drawImage(this.shadowImage, (int)topLeftCorner.getX(), (int)topLeftCorner.getY(), null);
        }
        g.drawImage(this.shapeImage, (int)topLeftCorner.getX(), (int)topLeftCorner.getY(), null);
        long t2 = System.currentTimeMillis();
        return t2 - t1;
    }

    protected void renderTipShapeAndText() {
        if (this.text == null) {
            return;
        }
        Graphics2D g = (Graphics2D)this.shapeImage.getGraphics();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(new Color(0, 0, 0, 0));
        int w = this.shapeImage.getWidth(null);
        int h = this.shapeImage.getHeight(null);
        Composite oldComp = g.getComposite();
        g.setComposite(AlphaComposite.getInstance(1, 0.0f));
        g.fillRect(0, 0, w, h);
        g.setComposite(oldComp);
        GradientPaint p = new GradientPaint(w / 2, 1.0f, new Color(193, 204, 215, 200), w / 2, h - 1, new Color(255, 255, 255, 200));
        g.setPaint(p);
        if (this.rounded) {
            g.fillRoundRect(0, 0, w, h, 20, 20);
        } else {
            g.fillRect(0, 0, w, h);
        }
        if (!this.borderless) {
            g.setColor(this.borderColor);
            if (this.rounded) {
                g.drawRoundRect(0, 0, w - 1, h - 1, 20, 20);
            } else {
                g.drawRect(0, 0, w - 1, h - 1);
            }
        }
        int sx = 10;
        int sy = h / 2 + 5;
        g.setColor(this.textColor);
        g.drawString(this.text, sx, sy);
        g.dispose();
    }

    protected void renderTipShadow() {
        this.shadowImage = null;
        ShadowRenderer sr = new ShadowRenderer();
        this.shadowImage = sr.createShadow((BufferedImage)this.shapeImage);
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
        Graphics2D g = (Graphics2D)dummyImage.getGraphics();
        double stringLen = this.calculateTextLength(g);
        int w = (int)Math.max((double)this.preferredWidth, stringLen + (double)(this.padding * 2));
        if (this.shapeImage != null && (this.shapeImage.getWidth(null) == w || this.neverShrink && w < this.maxWidth)) {
            return;
        }
        if (this.maxWidth < w) {
            this.maxWidth = w;
        }
        this.shapeImage = null;
        this.shapeImage = new BufferedImage(w, this.preferredHeight, 2);
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public boolean isRounded() {
        return this.rounded;
    }

    public void setRounded(boolean rounded) {
        this.rounded = rounded;
    }

    public boolean isDraggable() {
        return this.draggable;
    }

    public void setDraggable(boolean draggable) {
        this.draggable = draggable;
    }

    public boolean isShadow() {
        return this.shadow;
    }

    public void setShadow(boolean shadow) {
        this.shadow = shadow;
    }

    public boolean isBorderless() {
        return this.borderless;
    }

    public void setBorderless(boolean borderless) {
        this.borderless = borderless;
    }

    public boolean isNeverShrink() {
        return this.neverShrink;
    }

    public void setNeverShrink(boolean neverShrink) {
        this.neverShrink = neverShrink;
    }

    public int getWidth() {
        return this.shapeImage != null ? this.shapeImage.getWidth(null) : 0;
    }

    public int getHeight() {
        return this.shapeImage != null ? this.shapeImage.getHeight(null) : 0;
    }
}

