/*
 * Decompiled with CFR 0.152.
 */
package oracle.maps.core;

import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.event.EventListenerList;
import oracle.maps.core.GeoObject;
import oracle.maps.core.Layer;
import oracle.maps.core.SelectionEvent;
import oracle.maps.core.SelectionListener;

public class DefaultSelectionManager<V extends GeoObject> {
    private Layer parent = null;
    private Hashtable<Object, Vector<V>> selected = new Hashtable(0);
    private int size = 0;
    private EventListenerList listenerList = new EventListenerList();

    public DefaultSelectionManager(Layer parent) {
        this.parent = parent;
    }

    public synchronized boolean isSelected(V obj) {
        if (this.size() == 0) {
            return false;
        }
        Vector<V> sub = this.selected.get(obj.getKey());
        if (sub != null) {
            for (GeoObject existing : sub) {
                if (!obj.equals(existing) && !obj.isSubElementOf(existing)) continue;
                return true;
            }
        }
        return false;
    }

    public synchronized boolean clear() {
        return this.clear(true);
    }

    private synchronized boolean clear(boolean fireEvent) {
        boolean change = false;
        if (this.size != 0) {
            this.selected.clear();
            this.size = 0;
            change = true;
            if (fireEvent) {
                this.fireSelectionChanged(new SelectionEvent(this.parent, 2));
            }
        }
        return change;
    }

    public synchronized int size() {
        return this.size;
    }

    public synchronized List<V> getSelection() {
        Vector<V> allSelected = new Vector<V>(this.size());
        for (Vector<V> sub : this.selected.values()) {
            allSelected.addAll(sub);
        }
        return allSelected;
    }

    public synchronized List<V> getSelection(V obj) {
        Vector<V> sub = this.selected.get(obj.getKey());
        Vector<Object> result = null;
        result = sub != null ? new Vector<V>(sub) : new Vector(0);
        return result;
    }

    public synchronized boolean setSelection(List<V> objs) {
        boolean change = this.clear(false);
        if (objs != null) {
            for (GeoObject obj : objs) {
                if (!this.add(obj)) continue;
                change = true;
            }
        }
        if (change) {
            this.fireSelectionChanged(new SelectionEvent(this.parent, 0));
        }
        return change;
    }

    public synchronized boolean select(List<V> objs) {
        if (objs == null || objs.size() == 0) {
            return false;
        }
        Hashtable trees = new Hashtable();
        Vector<GeoObject> toAdd = new Vector<GeoObject>();
        Vector<GeoObject> toRemove = new Vector<GeoObject>();
        for (GeoObject newObj : objs) {
            boolean add = true;
            Vector<V> sub = this.selected.get(newObj.getKey());
            if (sub != null) {
                for (GeoObject existing : sub) {
                    Vector<GeoObject> children;
                    GeoObject parent = null;
                    GeoObject child = null;
                    if (((Object)newObj).equals(existing)) {
                        add = false;
                        toRemove.add(existing);
                    } else if (newObj.isSubElementOf(existing)) {
                        parent = existing;
                        child = newObj;
                    } else if (existing.isSubElementOf(newObj)) {
                        parent = newObj;
                        child = existing;
                    }
                    if (parent == null || child == null) continue;
                    add = false;
                    Hashtable<GeoObject, Vector<GeoObject>> keyTrees = (Hashtable<GeoObject, Vector<GeoObject>>)trees.get(parent.getKey());
                    if (keyTrees == null) {
                        keyTrees = new Hashtable<GeoObject, Vector<GeoObject>>();
                        trees.put(parent.getKey(), keyTrees);
                    }
                    if ((children = (Vector<GeoObject>)keyTrees.get(parent)) == null) {
                        children = new Vector<GeoObject>(1);
                        keyTrees.put(parent, children);
                    }
                    children.add(child);
                }
            }
            if (!add) continue;
            toAdd.add(newObj);
        }
        for (Hashtable keyTrees : trees.values()) {
            for (GeoObject parent : keyTrees.keySet()) {
                Vector children = (Vector)keyTrees.get(parent);
                toRemove.add(parent);
                toRemove.addAll(children);
                List<GeoObject> siblings = parent.substract(children);
                for (GeoObject sib : siblings) {
                    toAdd.add(sib);
                }
            }
        }
        boolean change = false;
        for (GeoObject o : toAdd) {
            if (!this.add(o)) continue;
            change = true;
        }
        for (GeoObject o : toRemove) {
            if (!this.remove(o)) continue;
            change = true;
        }
        if (change) {
            this.fireSelectionChanged(null);
        }
        return change;
    }

    public synchronized boolean unselect(List<V> objs) {
        boolean change = false;
        for (GeoObject o : objs) {
            if (!this.remove(o)) continue;
            change = true;
        }
        if (change) {
            this.fireSelectionChanged(new SelectionEvent(this.parent, 1));
        }
        return change;
    }

    public void addSelectionListener(SelectionListener l) {
        this.listenerList.add(SelectionListener.class, l);
    }

    public void removeSelectionListener(SelectionListener l) {
        this.listenerList.remove(SelectionListener.class, l);
    }

    public void fireSelectionChanged(SelectionEvent evt) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != SelectionListener.class) continue;
            if (evt == null) {
                evt = new SelectionEvent(this.parent, -1);
            }
            ((SelectionListener)listeners[i + 1]).selectionChanged(evt);
        }
    }

    private boolean add(V obj) {
        boolean change = false;
        Vector<Object> sub = this.selected.get(obj.getKey());
        if (sub == null) {
            sub = new Vector(1);
            this.selected.put(obj.getKey(), sub);
        }
        if (!sub.contains(obj)) {
            change = sub.add(obj);
            ++this.size;
        }
        return change;
    }

    private boolean remove(V obj) {
        boolean change = false;
        Vector<V> sub = this.selected.get(obj.getKey());
        if (sub != null && sub.remove(obj)) {
            if (sub.size() == 0) {
                this.selected.remove(obj.getKey());
            }
            change = true;
            --this.size;
        }
        return change;
    }
}

