/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.java.filter;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import oracle.ide.net.WildcardURLFilter;
import oracle.javatools.util.CamelCaseFilter;
import oracle.jdeveloper.java.filter.SimpleNameFilter;

public class PatternMatchNameFilter
extends SimpleNameFilter {
    private Pattern _pattern;
    private CamelCaseFilter _camelFilter;

    public PatternMatchNameFilter() {
        this(false);
    }

    public PatternMatchNameFilter(boolean matchSubString) {
        super("", false, matchSubString ? 3 : 2);
    }

    @Override
    public void setMatchName(String criteria) {
        super.setMatchName(criteria);
        this.buildPattern();
        this._camelFilter = new CamelCaseFilter(this._matchName);
    }

    public void setMatchSubstring(boolean matchSubString) {
        this._matchType = matchSubString ? 3 : 2;
    }

    @Override
    public boolean acceptPackageName(String packageName) {
        if (this._pattern != null) {
            return this._pattern.matcher(packageName).matches();
        }
        return super.acceptPackageName(packageName);
    }

    @Override
    public boolean acceptClassName(String className, String packagePrefix) {
        boolean hasDot;
        String qualifiedClassName = packagePrefix + "." + className;
        boolean bl = hasDot = this._matchName.indexOf(46) != -1;
        if (this._pattern != null) {
            Object toMatch;
            Object object = toMatch = hasDot ? qualifiedClassName : className;
            if (this._pattern.matcher((CharSequence)toMatch).matches()) {
                return true;
            }
        } else {
            if (hasDot && super.acceptName(qualifiedClassName)) {
                return true;
            }
            if (super.acceptClassName(className, packagePrefix)) {
                return true;
            }
        }
        return this._camelFilter != null && this._camelFilter.matches(className);
    }

    private void buildPattern() {
        Pattern pattern = null;
        boolean caseSensitive = false;
        String criteria = null;
        if (this.containsWildcard()) {
            criteria = this.adjustFilterExpression(this._matchName);
        }
        if (criteria != null) {
            String regexp = WildcardURLFilter.wildcard2Regexp(criteria);
            try {
                pattern = caseSensitive ? Pattern.compile(regexp) : Pattern.compile(regexp, 2);
            }
            catch (PatternSyntaxException e) {
                e.printStackTrace();
            }
        }
        this._pattern = pattern;
    }

    private boolean containsWildcard() {
        return this._matchName.indexOf(42) >= 0 || this._matchName.indexOf(63) >= 0;
    }

    private String adjustFilterExpression(String filterText) {
        char first;
        Object criteria = 3 == this._matchType ? ('*' != (first = filterText.charAt(0)) ? "*" + filterText : filterText) : filterText;
        char last = ((String)criteria).charAt(((String)criteria).length() - 1);
        if ('*' != last) {
            criteria = (String)criteria + "*";
        }
        return criteria;
    }
}

