/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.library;

import oracle.ide.net.URLPath;
import oracle.javatools.exports.library.ExportLibrary;
import oracle.jdeveloper.library.JLibraryAdapter;
import oracle.jdeveloper.library.JPaths;

public class Libraries {
    public static URLPath getBaseClassPath(Object library) {
        if (library instanceof ExportLibrary) {
            return new URLPath(((ExportLibrary)library).getSuppliedClassPath());
        }
        if (library instanceof JPaths) {
            return ((JPaths)library).getClassPath();
        }
        return null;
    }

    public static URLPath getManifestClassPath(Object library) {
        if (library instanceof ExportLibrary) {
            return new URLPath(((ExportLibrary)library).getExpandedClassPath());
        }
        if (library instanceof JLibraryAdapter) {
            JLibraryAdapter adapter = (JLibraryAdapter)library;
            URLPath manifestClassPath = adapter.getManifestClassPath();
            return manifestClassPath;
        }
        if (library instanceof JPaths) {
            URLPath classPath = ((JPaths)library).getClassPath();
            URLPath manifestClassPath = new URLPath(classPath);
            long start = System.currentTimeMillis();
            manifestClassPath.expandToIncludeManifestClassPaths();
            return manifestClassPath;
        }
        return null;
    }

    public static URLPath maybeGetManifestClassPath(Object library) {
        if (library instanceof ExportLibrary) {
            return new URLPath(((ExportLibrary)library).getExpandedClassPath());
        }
        if (library instanceof JLibraryAdapter) {
            JLibraryAdapter adapter = (JLibraryAdapter)library;
            URLPath manifestClassPath = adapter.getManifestClassPath();
            return manifestClassPath;
        }
        return null;
    }

    public static boolean hasManifestClassPath(Object library) {
        if (library instanceof ExportLibrary) {
            return ((ExportLibrary)library).hasManifestClassPath();
        }
        return false;
    }

    public static URLPath getDeferredManifestClassPath(URLPath baseClassPath) {
        URLPath manifestClassPath = new URLPath(baseClassPath);
        long start = System.currentTimeMillis();
        manifestClassPath.expandToIncludeManifestClassPaths();
        return manifestClassPath;
    }
}

