/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.util;

import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofSerializer;
import com.tangosol.io.pof.PofWriter;
import java.io.IOException;
import oracle.sdovis.JSDOGeometry;

public class JSDOGeomSerializer
implements PofSerializer {
    public Object deserialize(PofReader in) throws IOException {
        int gtype = in.readInt(0);
        int srid = in.readInt(1);
        double[] lp = in.readDoubleArray(2);
        int[] elemInfo = in.readIntArray(3);
        double[] ordinates = in.readDoubleArray(4);
        in.readRemainder();
        return new JSDOGeometry(gtype, srid, lp[0], lp[1], lp[2], elemInfo, ordinates);
    }

    public void serialize(PofWriter out, Object o) throws IOException {
        JSDOGeometry geom = (JSDOGeometry)o;
        int gt = geom.getType();
        int dim = geom.getDimensions();
        int lrm = geom.getLRMDimension();
        int gtype = dim * 1000 + lrm * 100 + gt;
        double[] lp = geom.getLabelPointXYZ();
        out.writeInt(0, gtype);
        out.writeInt(1, geom.getSRID());
        out.writeDoubleArray(2, lp);
        out.writeIntArray(3, geom.getElemInfo());
        out.writeDoubleArray(4, geom.getOrdinatesArray());
        out.writeRemainder(null);
    }
}

