/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.stylex;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import oracle.sdovis.JSDOGeometry;
import oracle.sdovis.stylex.Dot;

class DotDistributor {
    private Area area;
    private int numofpoints;
    private Dot dots;
    private double density;

    public DotDistributor() {
    }

    public DotDistributor(Shape shape, int pointNumber) {
        this.area = new Area(shape);
        this.numofpoints = pointNumber;
        this.density = this.getDensity(this.getAreaSize(null));
        Rectangle2D mbr = this.area.getBounds2D();
        double morepoints = Math.ceil(Math.sqrt(this.numofpoints));
        morepoints = Math.pow(morepoints, 2.0);
        Rectangle2D.Double square = new Rectangle2D.Double();
        morepoints = this.extendMBR(mbr, (long)morepoints, this.density, square);
        this.dots = new Dot((long)morepoints, this.area, square);
    }

    public DotDistributor(JSDOGeometry geom, int pointNumber) {
        this(geom.createShape(), pointNumber);
    }

    private double getDensity(double areaSize) {
        return areaSize / (double)this.numofpoints;
    }

    public double getAreaSize(AffineTransform at) {
        double size = 0.0;
        double[] coords = new double[6];
        double[] oldcoords = new double[2];
        PathIterator itor = this.area.getPathIterator(at);
        while (!itor.isDone()) {
            int type = itor.currentSegment(coords);
            switch (type) {
                case 0: {
                    oldcoords[0] = coords[0];
                    oldcoords[1] = coords[1];
                    break;
                }
                case 4: {
                    break;
                }
                case 1: {
                    size += (oldcoords[0] + coords[0]) * (coords[1] - oldcoords[1]);
                    oldcoords[0] = coords[0];
                    oldcoords[1] = coords[1];
                    break;
                }
                default: {
                    System.out.println("Error: cannot calculate area of polygon with curve/cubic edge");
                    System.exit(1);
                }
            }
            itor.next();
        }
        return (size /= 2.0) > 0.0 ? size : -1.0 * size;
    }

    private long extendMBR(Rectangle2D mbr, long num, double density, Rectangle2D.Double square) {
        Rectangle2D.Double ext = new Rectangle2D.Double();
        boolean i = false;
        double maxWidth = mbr.getWidth() > mbr.getHeight() ? mbr.getWidth() : mbr.getHeight();
        long root = (long)Math.sqrt(num);
        double width = (double)root * Math.sqrt(density);
        while (width < maxWidth) {
            width += Math.sqrt(density);
            ++root;
        }
        num = root * root;
        double xPos = mbr.getX();
        double yPos = mbr.getY();
        ext.setRect(xPos, yPos, width, width);
        square.setRect(ext);
        return num;
    }

    public void checkDots() {
        for (int count = 0; count < this.numofpoints; ++count) {
            this.dots.arrangeDot(count);
        }
    }

    public JSDOGeometry getDots() {
        double[][] coords = new double[this.numofpoints][2];
        for (int i = 0; i < this.numofpoints; ++i) {
            Point2D.Double dot = this.dots.getDot(i);
            coords[i][0] = dot.getX();
            coords[i][1] = dot.getY();
        }
        return JSDOGeometry.recast(JSDOGeometry.createMultiPoint((Object[])coords, (int)2, (int)8265));
    }
}

