/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.raytracing;

import javax.vecmath.Matrix3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import oracle.sdovis.raytracing.Camera;
import oracle.sdovis.raytracing.Hit;
import oracle.sdovis.raytracing.Material;
import oracle.sdovis.raytracing.Object3d;
import oracle.sdovis.raytracing.Ray;

public class Plane
extends Object3d {
    double offset;
    Vector3d up;
    int width;
    int height;
    Camera cam;

    public Plane(Vector3d normal_, double d, Material mat_, Camera cam_) {
        super(mat_, normal_);
        this.cam = cam_;
        this.offset = d;
        double nsquared = this.normal.x * this.normal.x + this.normal.y * this.normal.y + this.normal.z * this.normal.z;
        this.origin = new Vector3d(this.offset / nsquared * this.normal.x, this.offset / nsquared * this.normal.y, this.offset / nsquared * this.normal.z);
    }

    public void setWindow(int w_, int h_) {
        this.width = w_;
        this.height = h_;
    }

    @Override
    public Vector3d getTextureCoordinates(Hit h, Ray r) {
        Vector3d ro = r.getOrigin();
        Vector3d rd = r.getDirection();
        double x_ws = ro.x + rd.x * h.getT();
        double y_ws = ro.y + rd.y * h.getT();
        double z_ws = ro.z + rd.z * h.getT();
        Vector3d intsctPt_ws = new Vector3d(x_ws, y_ws, z_ws);
        Vector3d n = h.getNormal();
        double ln = n.length();
        Vector3d u = new Vector3d();
        u.cross(n, new Vector3d(1.0, 0.0, 0.0));
        if (u.length() < 1.0E-5 || u.length() >= Double.POSITIVE_INFINITY || u.length() <= Double.NEGATIVE_INFINITY) {
            u = new Vector3d();
            u.cross(n, new Vector3d(0.0, 1.0, 0.0));
        }
        u.normalize();
        Vector3d v = new Vector3d();
        v.cross(n, u);
        v.normalize();
        Matrix3d onb = new Matrix3d(u.x, v.x, n.x, u.y, v.y, n.y, u.z, v.z, n.z);
        Matrix3d onb_inv = new Matrix3d();
        onb_inv.invert(onb);
        Vector3d intsctPt_os = new Vector3d();
        onb_inv.transform((Tuple3d)intsctPt_ws, (Tuple3d)intsctPt_os);
        Vector3d ori_os = new Vector3d();
        onb_inv.transform((Tuple3d)this.origin, (Tuple3d)ori_os);
        Vector3d diff = new Vector3d();
        diff.sub((Tuple3d)intsctPt_os, (Tuple3d)ori_os);
        Vector3d texcoord = new Vector3d();
        Matrix3d scaleIt = new Matrix3d(1.0 / (double)this.width, 0.0, 0.0, 0.0, 1.0 / (double)this.height, 0.0, 0.0, 0.0, 1.0);
        Vector3d txmove = new Vector3d();
        Matrix3d moveIt = new Matrix3d(1.0, 0.0, -0.5, 0.0, 1.0, -0.5, 0.0, 0.0, 1.0);
        scaleIt.transform((Tuple3d)intsctPt_os, (Tuple3d)txmove);
        moveIt.transform((Tuple3d)txmove, (Tuple3d)texcoord);
        if (texcoord.x < 0.0 || texcoord.x > 1.0) {
            return null;
        }
        if (texcoord.y < 0.0 || texcoord.y > 1.0) {
            return null;
        }
        return texcoord;
    }

    @Override
    public boolean intersect(Ray r, Hit h, double tmin) {
        double normDotDir = this.normal.dot(r.getDirection());
        if (normDotDir == 0.0) {
            return false;
        }
        double t = -(this.normal.dot(r.getOrigin()) - this.offset) / normDotDir;
        if (t < 0.0 || t < tmin) {
            return false;
        }
        double t_prev = h.getT();
        if (t < t_prev) {
            h.set(t, this.getMaterial(), this.calcNormal());
        }
        return true;
    }

    public Vector3d calcNormal() {
        return this.normal;
    }
}

