/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis;

import java.awt.geom.Rectangle2D;
import java.io.File;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Logger;
import oracle.mapviewer.share.ArrayParameter;
import oracle.mapviewer.share.Field;
import oracle.mapviewer.share.ext.SDataProvider;
import oracle.mapviewer.share.ext.SDataSet;
import oracle.mapviewer.share.ext.SObject;
import oracle.mapviewer.share.util.LogFactory;
import oracle.mapviewer.share.util.SharedUtils;
import oracle.spatial.geometry.JGeometry;
import oracle.spatial.util.WKB;
import org.gdal.ogr.DataSource;
import org.gdal.ogr.Feature;
import org.gdal.ogr.FeatureDefn;
import org.gdal.ogr.FieldDefn;
import org.gdal.ogr.Geometry;
import org.gdal.ogr.Layer;
import org.gdal.ogr.ogr;

public class OGRDataProvider
implements SDataProvider {
    private static final Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    private String dataDirectory = null;
    private String globalDataDirectory = null;
    private static boolean libsRegistered = false;
    private Hashtable<String, DataSource> dataSources = new Hashtable();

    @Override
    public synchronized boolean destroy() {
        this.clearCache();
        return true;
    }

    @Override
    public synchronized String[] getInitParameterNames() {
        return new String[]{"datadir"};
    }

    @Override
    public synchronized String[] getRuntimeParameterNames() {
        return new String[]{"datasource"};
    }

    @Override
    public synchronized String getRuntimeParameterHintValue(String runtimeParam) {
        return null;
    }

    @Override
    public synchronized boolean init(Properties params) {
        this.dataDirectory = null;
        if (params == null) {
            return true;
        }
        this.dataDirectory = params.getProperty("datadir");
        if (this.dataDirectory == null || this.dataDirectory.trim().length() == 0) {
            this.dataDirectory = params.getProperty("DATADIR");
            if (this.dataDirectory == null || this.dataDirectory.trim().length() == 0) {
                log.fine("Init properties does not define \"datadir\" parameter.");
            }
        }
        return true;
    }

    @Override
    public synchronized SDataSet buildDataSet(Rectangle2D queryWin, String[] nonSpatialColumns, String queryCondition, Object[] bindingParameters, Properties params) {
        String[] paramNames;
        if (!this.registerOGR()) {
            return null;
        }
        String datasource = this.getDataSource(params);
        if (datasource == null) {
            log.warning("Unable to get data source");
            return null;
        }
        DataSource poDS = this.dataSources.get(datasource.toUpperCase());
        if (poDS == null && (poDS = ogr.Open((String)datasource, (boolean)false)) != null) {
            this.dataSources.put(datasource.toUpperCase(), poDS);
        }
        if (poDS == null) {
            log.severe("Unable to get OGR datasource for: " + datasource);
            return null;
        }
        boolean fullExtent = this.isFullExtent(queryWin);
        SDataSet dataset = new SDataSet();
        SObject obj = null;
        int nLayerCount = poDS.GetLayerCount();
        if (nLayerCount == 0) {
            return null;
        }
        Layer layer = poDS.GetLayer(0);
        if (layer == null) {
            log.severe("Unable to get OGR layer for data source: " + datasource);
            return null;
        }
        if (fullExtent) {
            double[] lyExtent = layer.GetExtent();
            if (lyExtent != null) {
                layer.SetSpatialFilterRect(lyExtent[0], lyExtent[2], lyExtent[1], lyExtent[3]);
            } else {
                layer.ResetReading();
            }
        } else {
            layer.SetSpatialFilterRect(queryWin.getMinX(), queryWin.getMinY(), queryWin.getMaxX(), queryWin.getMaxY());
        }
        String condition = queryCondition;
        if (condition != null && bindingParameters != null && bindingParameters.length > 0 && (paramNames = SharedUtils.getBindingVariablesNames(condition)) != null && paramNames.length > 0) {
            if (bindingParameters.length != paramNames.length) {
                log.warning("Number of binding parameters not equal to binding parameters in query condition.");
                return null;
            }
            String changedcondition = "";
            for (int i = 0; i < paramNames.length; ++i) {
                if (bindingParameters[i] instanceof ArrayParameter) {
                    Object bdvalues = ((ArrayParameter)bindingParameters[i]).getValue();
                    Object[] values = (Object[])bdvalues;
                    for (int l = 0; l < values.length; ++l) {
                        if (l > 0) {
                            changedcondition = changedcondition + ",";
                        }
                        changedcondition = changedcondition + "'" + values[l].toString() + "'";
                    }
                } else {
                    changedcondition = "'" + bindingParameters[i].toString() + "'";
                }
                condition = condition.replaceFirst(":" + paramNames[i], changedcondition);
            }
        }
        String nsdpKeyColumn = params.getProperty("nsdpkeycolumn");
        String nsdpKeyValues = params.getProperty("nsdpkeyvalues");
        if (nsdpKeyColumn != null && nsdpKeyValues != null) {
            condition = condition != null ? "(" + condition + ") and (" + nsdpKeyColumn + " in (" + nsdpKeyValues + "))" : nsdpKeyColumn + " in (" + nsdpKeyValues + ")";
            log.finest("NSDP filter added to base query: " + nsdpKeyColumn + " in (?)");
            log.finest("NSDP key values: " + nsdpKeyValues);
        }
        if (condition != null && condition.trim().length() > 0) {
            layer.SetAttributeFilter(condition);
        }
        FeatureDefn poFDefn = layer.GetLayerDefn();
        Feature poFeature = null;
        WKB wkb = new WKB();
        while ((poFeature = layer.GetNextFeature()) != null) {
            byte[] bytes;
            Geometry poGeometry = poFeature.GetGeometryRef();
            if (poGeometry == null || (bytes = poGeometry.ExportToWkb()) == null) continue;
            JGeometry jgeom = null;
            try {
                jgeom = wkb.toJGeometry(bytes);
            }
            catch (Exception ex) {
                jgeom = null;
            }
            if (jgeom == null) continue;
            ArrayList<Field> fields = new ArrayList<Field>();
            if (nonSpatialColumns != null && nonSpatialColumns.length > 0) {
                for (int i = 0; i < nonSpatialColumns.length; ++i) {
                    Field f = null;
                    String column = nonSpatialColumns[i];
                    int iField = poFDefn.GetFieldIndex(column);
                    if (iField < 0) continue;
                    FieldDefn poFieldDefn = poFDefn.GetFieldDefn(iField);
                    if (poFieldDefn.GetFieldType() == 0) {
                        f = new Field(poFeature.GetFieldAsInteger(iField));
                        f.setName(column);
                    } else if (poFieldDefn.GetFieldType() == 2) {
                        f = new Field(poFeature.GetFieldAsDouble(iField));
                        f.setName(column);
                    } else if (poFieldDefn.GetFieldType() == 4) {
                        f = Field.createField(poFeature.GetFieldAsString(iField), "string");
                        f.setName(column);
                    } else {
                        f = Field.createField(poFeature.GetFieldAsString(iField), "string");
                        f.setName(column);
                    }
                    if (f == null) continue;
                    fields.add(f);
                }
            }
            Field[] attrFields = null;
            if (fields.size() > 0) {
                attrFields = fields.toArray(new Field[fields.size()]);
            }
            obj = new SObject(jgeom, attrFields);
            dataset.addObject(obj);
        }
        if (dataset.getSize() == 0) {
            return null;
        }
        return dataset;
    }

    @Override
    public synchronized Field[] getAttributeList(Properties params) {
        if (!this.registerOGR()) {
            return null;
        }
        String datasource = this.getDataSource(params);
        if (datasource == null) {
            log.warning("Unable to get data source.");
            return null;
        }
        DataSource poDS = this.dataSources.get(datasource.toUpperCase());
        if (poDS == null && (poDS = ogr.Open((String)datasource, (boolean)false)) != null) {
            this.dataSources.put(datasource.toUpperCase(), poDS);
        }
        if (poDS == null) {
            log.severe("Unable to get OGR datasource for: " + datasource);
            return null;
        }
        int nLayerCount = poDS.GetLayerCount();
        if (nLayerCount == 0) {
            return null;
        }
        Layer layer = poDS.GetLayer(0);
        if (layer == null) {
            return null;
        }
        FeatureDefn poFDefn = layer.GetLayerDefn();
        Vector<Field> fields = new Vector<Field>();
        for (int iField = 0; iField < poFDefn.GetFieldCount(); ++iField) {
            Field f = null;
            int javaType = 0;
            FieldDefn poFieldDefn = poFDefn.GetFieldDefn(iField);
            javaType = poFieldDefn.GetFieldType() == 0 ? 3 : (poFieldDefn.GetFieldType() == 2 ? 6 : (poFieldDefn.GetFieldType() == 4 ? 8 : 8));
            if (javaType == 0) continue;
            f = new Field();
            f.setName(poFieldDefn.GetName());
            f.setType(javaType);
            fields.add(f);
        }
        if (fields.size() == 0) {
            return null;
        }
        return fields.toArray(new Field[fields.size()]);
    }

    @Override
    public synchronized Rectangle2D getDataExtents(Properties params) {
        return null;
    }

    @Override
    public synchronized boolean buildSpatialIndex(Properties params) {
        return true;
    }

    private synchronized boolean isFullExtent(Rectangle2D queryWin) {
        if (queryWin == null) {
            return true;
        }
        double xl = queryWin.getMinX();
        double yl = queryWin.getMinY();
        double xh = queryWin.getMaxX();
        double yh = queryWin.getMaxY();
        return Double.isInfinite(xl) || Double.isNaN(xl) || Double.isInfinite(yl) || Double.isNaN(yl) || Double.isInfinite(xh) || Double.isNaN(xh) || Double.isInfinite(yh) || Double.isNaN(yh);
    }

    private synchronized String getDataSource(Properties params) {
        if (params == null) {
            return null;
        }
        String dataSource = params.getProperty("datasource");
        if (!(dataSource != null && dataSource.trim().length() != 0 || (dataSource = params.getProperty("DATASOURCE")) != null && dataSource.trim().length() != 0)) {
            log.severe("Input properties must define \"datasource\" parameter.");
            return null;
        }
        String dataSourceOut = null;
        String directory = null;
        if (this.isFileDataSource(dataSource)) {
            File fl = new File(dataSource);
            if (!fl.exists()) {
                File flg;
                int lastindex;
                log.warning("Can not access file from original path: " + dataSource);
                if (this.dataDirectory == null && this.globalDataDirectory == null) {
                    return null;
                }
                if (this.dataDirectory != null) {
                    log.finest("Trying provider local directory: " + this.dataDirectory);
                    dataSourceOut = null;
                    directory = this.dataDirectory;
                    lastindex = dataSource.lastIndexOf(File.separator);
                    dataSourceOut = lastindex == -1 ? (directory.endsWith(File.separator) ? directory + dataSource : directory + File.separator + dataSource) : (directory.endsWith(File.separator) ? directory + dataSource.substring(lastindex + 1, dataSource.length()) : directory + File.separator + dataSource.substring(lastindex + 1, dataSource.length()));
                    flg = new File(dataSourceOut);
                    if (!flg.exists()) {
                        log.warning("File can not be accessed on provider local data directory.");
                        dataSourceOut = null;
                    }
                }
                if (dataSourceOut == null && this.globalDataDirectory != null) {
                    log.finest("Trying provider global directory: " + this.globalDataDirectory);
                    directory = this.globalDataDirectory;
                    lastindex = dataSource.lastIndexOf(File.separator);
                    dataSourceOut = lastindex == -1 ? (directory.endsWith(File.separator) ? directory + dataSource : directory + File.separator + dataSource) : (directory.endsWith(File.separator) ? directory + dataSource.substring(lastindex + 1, dataSource.length()) : directory + File.separator + dataSource.substring(lastindex + 1, dataSource.length()));
                    flg = new File(dataSourceOut);
                    if (!flg.exists()) {
                        log.severe("File can not be accessed on providers local or global data directory. Copy files there.");
                        return null;
                    }
                }
                log.info("Provider data directory being used: " + directory);
                log.info("File to be processed: " + dataSourceOut);
            } else {
                dataSourceOut = dataSource;
            }
        } else {
            dataSourceOut = dataSource;
        }
        return dataSourceOut;
    }

    private synchronized boolean isFileDataSource(String datasource) {
        if (datasource == null) {
            return false;
        }
        String dsrc = datasource.toLowerCase();
        return dsrc.endsWith(".shp") || dsrc.endsWith(".e00") || dsrc.endsWith(".mdb") || dsrc.endsWith(".tab") || dsrc.endsWith(".mif") || dsrc.endsWith(".dxf") || dsrc.endsWith(".dgn") || dsrc.endsWith(".bna") || dsrc.endsWith(".csv") || dsrc.endsWith(".dat") || dsrc.endsWith(".fdd") || dsrc.endsWith(".txt") || dsrc.endsWith(".gxt") || dsrc.endsWith(".gmt") || dsrc.endsWith(".gml") || dsrc.endsWith(".gtm") || dsrc.endsWith(".gtz") || dsrc.endsWith(".htf") || dsrc.endsWith(".kml") || dsrc.endsWith(".kmz") || dsrc.endsWith(".rec") || dsrc.endsWith(".ddf") || dsrc.endsWith(".sua") || dsrc.endsWith(".ntf") || dsrc.endsWith(".vkf");
    }

    @Override
    public synchronized void clearCache() {
        this.dataSources.clear();
    }

    @Override
    public synchronized boolean canBuildSpatialIndex() {
        return false;
    }

    @Override
    public synchronized String[] getParametersToQuerySpatialMetadata() {
        return null;
    }

    @Override
    public synchronized String[][] getSpatialTables(Properties params) {
        return null;
    }

    private synchronized boolean registerOGR() {
        if (!libsRegistered) {
            try {
                ogr.RegisterAll();
                libsRegistered = true;
            }
            catch (Exception ex) {
                log.severe("Unable to register OGR: " + ex.getMessage());
                return false;
            }
        }
        return true;
    }

    @Override
    public String getGlobalDataDirectory() {
        return this.globalDataDirectory;
    }

    @Override
    public void setGlobalDataDirectory(String dir) {
        this.globalDataDirectory = dir;
    }
}

