/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.style.profile;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import oracle.ide.ceditor.keymap.EditorFactory;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.EditorProperties;
import oracle.jdevimpl.style.profile.CodingStyleProfile;

public class CodingStylePreviewPanel
extends JPanel {
    private CodingStyleProfile profile;
    private BasicEditorPane editor = EditorFactory.createStandaloneEditorPane();
    private String sample;

    public CodingStylePreviewPanel() {
        this.editor.setLanguageSupport("Sample.java");
        this.editor.setProtected(true);
        JScrollPane scrollPane = new JScrollPane((Component)this.editor);
        this.setLayout(new BorderLayout());
        this.add((Component)scrollPane, "Center");
    }

    public void dispose() {
        this.editor.dispose();
    }

    public void setSampleCode(String sample) {
        this.sample = sample;
    }

    public void setProfile(CodingStyleProfile profile) {
        this.profile = profile;
    }

    public BasicEditorPane getEditor() {
        return this.editor;
    }

    public void update() {
        if (this.profile != null && this.sample != null) {
            Rectangle visibleRect = new Rectangle();
            this.editor.computeVisibleRect(visibleRect);
            String text = this.profile.applyNamingConventions(this.sample);
            text = this.organizeImports(text);
            text = this.profile.format(text);
            this.editor.setProtected(false);
            this.editor.setText(text);
            this.editor.setProtected(true);
            this.editor.putProperty("tab-size", (Object)this.profile.getTabSize());
            if (EditorProperties.getProperties().getBooleanProperty("right-margin-column-at-wrap")) {
                this.editor.putProperty("right-margin-column", (Object)this.profile.getWrapLineWidth());
            }
            this.editor.scrollRectToVisible(visibleRect);
        }
    }

    private String organizeImports(String text) {
        StringBuffer result = new StringBuffer();
        Pattern pattern = Pattern.compile("\\$\\{import\\}");
        Matcher matcher = pattern.matcher(text);
        int current = 0;
        while (matcher.find(current)) {
            int start = matcher.start();
            int end = matcher.end();
            result.append(text.substring(current, start));
            if (this.profile.getUseWideImports() && this.profile.getWideImportThreshold() < 2) {
                result.append("import java.util.*;");
            } else {
                result.append("import java.util.List;");
            }
            current = end;
        }
        result.append(text.substring(current));
        return result.toString();
    }
}

