/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.spnego;

import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import oracle.security.spnego.ASNException;
import oracle.security.spnego.ASNReader;
import oracle.security.spnego.ASNWriter;
import oracle.security.spnego.IType;
import oracle.security.spnego.Tag;
import oracle.security.spnego.Type;

public class Any
extends Type
implements IType {
    public Any() {
        super("", null);
    }

    public Any(String name) {
        super(name, null);
    }

    public Any(String name, Tag tag) {
        super(name, tag);
    }

    public Any(String name, Tag tag, Object value) {
        super(name, tag);
        if (value != null) {
            if (value instanceof IType) {
                this.value(value);
            } else if (value instanceof ArrayList) {
                this.value(value);
            } else {
                this.value(value);
            }
        }
        if (this.value != null) {
            this.defaultValue(this.value);
        }
    }

    public static Any getInstance(IType value) {
        return new Any("", null, value);
    }

    @Override
    public void decode(ASNReader is) throws IOException {
        is.mark(Integer.MAX_VALUE);
        try {
            IType result = is.decodeAny(this.name());
            if (result == null) {
                throw new ASNException(1, "Decoding ANY");
            }
            result.name(this.name());
            this.value(result);
        }
        catch (IOException x) {
            if (x instanceof ASNException || x instanceof EOFException) {
                is.reset();
            }
            throw x;
        }
    }

    @Override
    public void encode(ASNWriter os) throws IOException {
        IType val = (IType)this.value();
        if (val != null) {
            val.encode(os);
        } else {
            val = (IType)this.defaultValue();
            if (val != null) {
                val.encode(os);
            } else if (!this.isOptional()) {
                throw new ASNException(0, "Encoding ANY");
            }
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("-- ");
        if (this.value != null) {
            sb.append(String.valueOf(this.value));
        } else {
            sb.append("N/A");
        }
        return sb.toString();
    }
}

