/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.internal.ui;

import java.awt.AWTEvent;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.javatools.internal.ui.EventQueueFilter;
import oracle.javatools.internal.ui.EventQueueObserver;

public final class EventQueueWrapper
extends EventQueue {
    private static EventQueueWrapper _sInstance = null;
    private final CopyOnWriteArraySet<EventQueueObserver> _observerSet = new CopyOnWriteArraySet();
    private final AtomicReference<EventQueueFilter> _filterReference = new AtomicReference();
    private static final Logger _sLogger = Logger.getLogger(EventQueueWrapper.class.getName());
    private List<AWTEvent> _postponedEvents = new ArrayList<AWTEvent>();
    private volatile boolean _deliverPostponedEventsOnNextDispatch = false;

    public static EventQueueWrapper install() {
        EventQueue current;
        if (_sInstance == null) {
            _sInstance = new EventQueueWrapper();
        }
        if ((current = Toolkit.getDefaultToolkit().getSystemEventQueue()) != _sInstance) {
            current.push(_sInstance);
        }
        return _sInstance;
    }

    public void addObserver(EventQueueObserver observer) {
        this._observerSet.add(observer);
    }

    public void removeObserver(EventQueueObserver observer) {
        this._observerSet.remove(observer);
    }

    public void setFilter(EventQueueFilter filter) {
        boolean attached = this._filterReference.compareAndSet(null, filter);
        if (!attached) {
            throw new IllegalStateException("Error: setFilter called when a filter is already attached, attached filter=" + this._filterReference.get());
        }
    }

    public void removeFilter(EventQueueFilter filter) {
        boolean detached = this._filterReference.compareAndSet(filter, null);
        if (!detached) {
            throw new IllegalStateException("Error: removeFilter called with a filter that was not already attached, attached filter=" + this._filterReference.get());
        }
    }

    public void deliverPostponedEventsOnNextDispatch() {
        this._deliverPostponedEventsOnNextDispatch = true;
    }

    @Override
    protected void dispatchEvent(AWTEvent event) {
        this._checkForPostponedEvents();
        this._dispatchEvent(event);
    }

    private void _dispatchEvent(AWTEvent event) {
        EventQueueFilter.Result result = EventQueueFilter.Result.DELIVER_EVENT;
        EventQueueFilter filter = this._filterReference.get();
        if (filter != null) {
            result = filter.filterEvent(this, event);
        }
        switch (result) {
            case DELIVER_EVENT: {
                this._notifyObservers(event, true);
                super.dispatchEvent(event);
                this._notifyObservers(event, false);
                break;
            }
            case POSTPONE_EVENT: {
                this._postponedEvents.add(event);
                break;
            }
            case SKIP_EVENT: {
                return;
            }
            default: {
                throw new IllegalStateException("Unexpected EventQueueFilter.Result type :" + result);
            }
        }
    }

    private void _notifyObservers(AWTEvent event, boolean preDispatch) {
        for (EventQueueObserver observer : this._observerSet) {
            try {
                if (preDispatch) {
                    observer.preDispatchEvent(this, event);
                    continue;
                }
                observer.postDispatchEvent(this, event);
            }
            catch (RuntimeException e) {
                _sLogger.log(Level.SEVERE, "Unexpected runtime exception caught while notifying EventQueueObserver: " + observer + " with event: " + event, e);
            }
        }
    }

    private void _checkForPostponedEvents() {
        if (this._deliverPostponedEventsOnNextDispatch) {
            this._deliverPostponedEventsOnNextDispatch = false;
            if (!this._postponedEvents.isEmpty()) {
                List<AWTEvent> eventsToDeliverNow = this._postponedEvents;
                this._postponedEvents = new ArrayList<AWTEvent>();
                for (AWTEvent event : eventsToDeliverNow) {
                    this._dispatchEvent(event);
                }
            }
        }
    }
}

