/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.keys;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.editor.ActionPreInvoker;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.FeedbackManager;
import oracle.javatools.editor.keys.MultiKeyHandler;
import oracle.javatools.editor.resource.EditorBundle;
import oracle.javatools.resource.BundleHelper;

public final class KeyRecorder
implements ActionPreInvoker,
FocusListener,
KeyListener,
Runnable {
    private static final int FEEDBACK_LENGTH = 3000;
    private static final String RECORDING_STARTED;
    private static final String RECORDING_CANCELLED;
    private static final String RECORDING_ENDED;
    private static final String PLAYBACK_STARTED;
    private static final String PLAYBACK_CANCELLED;
    private static final String PLAYBACK_ENDED;
    private static final String NOTHING_RECORDED;
    public static final String MACRO_PLAYBACK_DELAY = "macro-playback-delay";
    private MultiKeyHandler keyHandler = null;
    private boolean shutdown = false;
    private boolean finished = true;
    private Thread playbackThread = null;
    private List macroList = null;
    private boolean recording = false;
    private boolean playing = false;
    private BasicEditorPane editorPane = null;

    public boolean isRecording() {
        return this.recording;
    }

    public boolean isPlaying() {
        return this.playing;
    }

    private synchronized void install(BasicEditorPane editor) {
        this.shutdown = false;
        this.editorPane = editor;
        this.recording = false;
        this.playing = false;
        this.finished = true;
        this.playbackThread = null;
        this.keyHandler = MultiKeyHandler.getInstalledHandler(this.editorPane);
        this.keyHandler.addKeyFilter(this);
        editor.addFocusListener(this);
        editor.addPreActionInvoker(this, -100.0);
    }

    private synchronized void deinstall(BasicEditorPane editor) {
        editor.removePreActionInvoker(this, -100.0);
        editor.removeFocusListener(this);
        this.keyHandler.removeKeyFilter(this);
        this.keyHandler = null;
        this.shutdown = true;
        this.finished = true;
        this.editorPane = null;
        this.recording = false;
        this.playing = false;
        this.playbackThread = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void toggleRecording(BasicEditorPane editorPane) {
        if (this.playing) {
            Thread pt = null;
            Runnable runnable = this;
            synchronized (runnable) {
                pt = this.playbackThread;
                this.finished = true;
            }
            if (pt != null) {
                runnable = pt;
                synchronized (runnable) {
                    pt.notify();
                }
            }
            return;
        }
        if (this.recording) {
            if (editorPane != this.editorPane) {
                throw new IllegalStateException("toggle in wrong editor");
            }
            this.showFeedback(this.shutdown ? RECORDING_CANCELLED : RECORDING_ENDED);
            this.deinstall(editorPane);
        } else {
            this.install(editorPane);
            this.recording = true;
            if (this.macroList == null) {
                this.macroList = new ArrayList();
            }
            this.macroList.clear();
            this.showFeedback(RECORDING_STARTED);
        }
    }

    public synchronized void playbackRecording(BasicEditorPane editorPane) {
        if (this.recording) {
            return;
        }
        if (this.playing) {
            return;
        }
        if (this.macroList == null || this.macroList.size() == 0) {
            this.showFeedback(editorPane, NOTHING_RECORDED);
            return;
        }
        this.install(editorPane);
        this.playing = true;
        this.finished = false;
        this.shutdown = false;
        this.showFeedback(PLAYBACK_STARTED);
        this.playbackThread = new Thread((Runnable)this, "Macro Playback Thread");
        this.playbackThread.start();
    }

    private synchronized void handleKeyEvent(KeyEvent event) {
        if (this.recording) {
            RecordedEvent recordedEvent = new RecordedEvent(event);
            this.macroList.add(recordedEvent);
        } else if (this.playing && event instanceof StopEvent) {
            this.toggleRecording(this.editorPane);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void cancelOperation() {
        if (this.recording) {
            this.shutdown = true;
            this.toggleRecording(this.editorPane);
        } else if (this.playing) {
            Thread pt = null;
            Runnable runnable = this;
            synchronized (runnable) {
                pt = this.playbackThread;
                this.shutdown = true;
                this.finished = true;
            }
            if (pt != null) {
                runnable = pt;
                synchronized (runnable) {
                    pt.notify();
                }
            }
        } else {
            throw new IllegalStateException("nothing to cancel");
        }
    }

    private synchronized void handleFocusEvent(FocusEvent event) {
        if (event.getID() == 1005 && !event.isTemporary()) {
            this.cancelOperation();
        }
    }

    private synchronized void showFeedback(String message) {
        this.showFeedback(this.editorPane, message);
    }

    private synchronized void showFeedback(BasicEditorPane editor, String message) {
        FeedbackManager feedbackManager;
        if (editor != null && (feedbackManager = editor.getFeedbackManager()) != null) {
            feedbackManager.showFeedback(this.editorPane, message, 3000);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Thread thread = this.playbackThread;
        synchronized (thread) {
            this.sleep(this.playbackThread, 10L);
            EventQueue eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
            int numEvents = this.macroList.size();
            for (int i = 0; i < numEvents && !this.shutdown; ++i) {
                RecordedEvent recordedEvent = (RecordedEvent)this.macroList.get(i);
                KeyRecorder keyRecorder = this;
                synchronized (keyRecorder) {
                    KeyEvent keyEvent = recordedEvent.getKeyEvent(this.editorPane);
                    eventQueue.postEvent(keyEvent);
                    continue;
                }
            }
            KeyRecorder keyRecorder = this;
            synchronized (keyRecorder) {
                eventQueue.postEvent(new StopEvent());
            }
            while (!this.shutdown && !this.finished) {
                this.sleep(this.playbackThread, 1000L);
            }
        }
        final String message = this.shutdown ? PLAYBACK_CANCELLED : PLAYBACK_ENDED;
        Runnable stopPlayback = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                KeyRecorder keyRecorder = KeyRecorder.this;
                synchronized (keyRecorder) {
                    KeyRecorder.this.showFeedback(message);
                    KeyRecorder.this.deinstall(KeyRecorder.this.editorPane);
                    KeyRecorder.this.playing = false;
                }
            }
        };
        SwingUtilities.invokeLater(stopPlayback);
    }

    private void sleep(Object object, long milliseconds) {
        try {
            object.wait(milliseconds);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public boolean invokeAction(String actionKey) {
        if (actionKey.equals("completion-insight") && this.recording) {
            MessageDialog.information(this.editorPane, EditorBundle.get((String)"MACRO_RECORDING_INCOMPATIBLE_ACTION"), EditorBundle.get((String)"MACRO_RECORDING_INCOMPATIBLE_ACTION_TITLE"), null);
            return true;
        }
        return false;
    }

    @Override
    public void focusGained(FocusEvent event) {
        this.handleFocusEvent(event);
    }

    @Override
    public void focusLost(FocusEvent event) {
        this.handleFocusEvent(event);
    }

    @Override
    public void keyPressed(KeyEvent event) {
        this.handleKeyEvent(event);
    }

    @Override
    public void keyTyped(KeyEvent event) {
        this.handleKeyEvent(event);
    }

    @Override
    public void keyReleased(KeyEvent event) {
        this.handleKeyEvent(event);
    }

    static {
        BundleHelper resources = EditorProperties.getEditorBundle();
        RECORDING_STARTED = resources.getString("MACRO_RECORDING_STARTED");
        RECORDING_CANCELLED = resources.getString("MACRO_RECORDING_CANCELLED");
        RECORDING_ENDED = resources.getString("MACRO_RECORDING_ENDED");
        PLAYBACK_STARTED = resources.getString("MACRO_PLAYBACK_STARTED");
        PLAYBACK_CANCELLED = resources.getString("MACRO_PLAYBACK_CANCELLED");
        PLAYBACK_ENDED = resources.getString("MACRO_PLAYBACK_ENDED");
        NOTHING_RECORDED = resources.getString("MACRO_NOTHING_RECORDED");
    }

    private static final class RecordedEvent {
        int id;
        long when;
        int modifiers;
        int keyCode;
        char keyChar;

        private RecordedEvent(KeyEvent event) {
            this.id = event.getID();
            this.when = event.getWhen();
            this.modifiers = event.getModifiers();
            this.keyCode = event.getKeyCode();
            this.keyChar = event.getKeyChar();
        }

        private KeyEvent getKeyEvent(Component newSource) {
            return new KeyEvent(newSource, this.id, System.currentTimeMillis(), this.modifiers, this.keyCode, this.keyChar);
        }
    }

    private class StopEvent
    extends KeyEvent {
        private StopEvent() {
            super(KeyRecorder.this.editorPane, 401, System.currentTimeMillis(), 0, 0, '\uffff');
        }

        @Override
        public String toString() {
            return "STOP!";
        }
    }
}

