/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.insight;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import oracle.javatools.editor.insight.InsightInputFilter;
import oracle.javatools.editor.insight.ListDataItem;
import oracle.javatools.util.CamelCaseFilter;
import oracle.javatools.util.ModelUtil;

@Deprecated
public final class CamelCaseInsightInputFilter
extends InsightInputFilter {
    public static final CamelCaseInsightInputFilter INSTANCE = new CamelCaseInsightInputFilter();
    private static final Comparator<ListDataItem> DEFAULT_COMPARATOR = new Comparator<ListDataItem>(){

        @Override
        public int compare(ListDataItem o1, ListDataItem o2) {
            return o1.getName().compareToIgnoreCase(o2.getName());
        }
    };
    private static final Comparator<ListDataItem> UPPER_FIRST_COMPARATOR = new ListDataItemComparator(true);
    private static final Comparator<ListDataItem> LOWER_FIRST_COMPARATOR = new ListDataItemComparator(false);

    private CamelCaseInsightInputFilter() {
    }

    @Override
    protected void sortData(ListDataItem[] dataList) {
        this.sort(dataList, "a");
    }

    @Override
    public ListDataItem findClosestDataItem(ListDataItem[] dataList, String name) {
        this.sort(dataList, name);
        CamelCaseFilter filter = new CamelCaseFilter(name);
        for (ListDataItem listDataItem : dataList) {
            String itemName = listDataItem.getName();
            if (!filter.matches(itemName)) continue;
            return listDataItem;
        }
        return null;
    }

    @Override
    public ListDataItem[] getMatchingData(ListDataItem[] dataList, String prefix) {
        ListDataItem[] listDataItems;
        if (ModelUtil.hasLength((String)prefix)) {
            ArrayList<ListDataItem> ret = this.getMatchingDataList(dataList, prefix);
            listDataItems = ret.toArray(new ListDataItem[ret.size()]);
        } else {
            listDataItems = (ListDataItem[])dataList.clone();
        }
        this.sort(listDataItems, prefix);
        return listDataItems;
    }

    public ArrayList<ListDataItem> getMatchingDataList(ListDataItem[] dataList, String prefix) {
        ArrayList<ListDataItem> data = new ArrayList<ListDataItem>(dataList.length);
        if (ModelUtil.hasLength((String)prefix)) {
            CamelCaseFilter camelCaseFilter = new CamelCaseFilter(prefix);
            for (ListDataItem listDataItem : dataList) {
                String itemName = listDataItem.getName();
                if (!camelCaseFilter.matches(itemName)) continue;
                data.add(listDataItem);
            }
        } else {
            for (ListDataItem listDataItem : dataList) {
                data.add(listDataItem);
            }
        }
        return data;
    }

    public void sort(ListDataItem[] listDataItems, String prefix) {
        Comparator<ListDataItem> comparator = this.getComparator(prefix);
        Arrays.sort(listDataItems, comparator);
    }

    public Comparator<ListDataItem> getComparator(String prefix) {
        Comparator<ListDataItem> comparator = DEFAULT_COMPARATOR;
        if (prefix.length() > 0) {
            char firstChar = prefix.charAt(0);
            if (Character.isUpperCase(firstChar)) {
                comparator = UPPER_FIRST_COMPARATOR;
            } else if (Character.isLowerCase(firstChar)) {
                comparator = LOWER_FIRST_COMPARATOR;
            }
        }
        return comparator;
    }

    @Override
    public String findCommonPrefix(ListDataItem[] dataList, String prefix) {
        String lowercasePrefix = prefix.toLowerCase();
        int prefixLength = prefix.length();
        Object ret = null;
        block0: for (ListDataItem listDataItem : dataList) {
            String itemName = listDataItem.getName();
            if (!itemName.toLowerCase().startsWith(lowercasePrefix)) continue;
            if (ret != null) {
                int length = Math.min(((String)ret).length(), itemName.length());
                for (int j = prefixLength; j < length; ++j) {
                    char c2;
                    char c1 = ((String)ret).charAt(j);
                    if (c1 == (c2 = itemName.charAt(j))) continue;
                    ret = ((String)ret).substring(0, j);
                    continue block0;
                }
                continue;
            }
            ret = prefix + itemName.substring(prefixLength);
        }
        return ret;
    }

    private static class ListDataItemComparator
    implements Comparator<ListDataItem> {
        private boolean _upperFirst;

        public ListDataItemComparator(boolean upperFirst) {
            this._upperFirst = upperFirst;
        }

        @Override
        public int compare(ListDataItem itemA, ListDataItem itemB) {
            int lengthB;
            String nameA = itemA.getName();
            String nameB = itemB.getName();
            int lengthA = nameA.length();
            if (lengthA > 0 && (lengthB = nameB.length()) > 0) {
                char firstCharA = nameA.charAt(0);
                char firstCharB = nameB.charAt(0);
                if (Character.isUpperCase(firstCharA)) {
                    if (Character.isLowerCase(firstCharB)) {
                        if (this._upperFirst) {
                            return -1;
                        }
                        return 1;
                    }
                } else if (Character.isLowerCase(firstCharA) && Character.isUpperCase(firstCharB)) {
                    if (this._upperFirst) {
                        return 1;
                    }
                    return -1;
                }
            }
            return nameA.compareTo(nameB);
        }
    }
}

