/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import oracle.javatools.editor.BasicEditorPainter;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.EditorSelectionColumns;
import oracle.javatools.editor.highlight.HighlightRegistry;
import oracle.javatools.editor.highlight.HighlightStyle;

final class ColumnSelectionPainter
implements BasicEditorPainter {
    private static Color selectionStyleColor = null;
    private final EditorSelectionColumns editorSelectionColumns;

    ColumnSelectionPainter(EditorSelectionColumns editorSelectionColumns) {
        this.editorSelectionColumns = editorSelectionColumns;
    }

    @Override
    public void paint(Graphics g, BasicEditorPane editor) {
        try {
            g.setColor(selectionStyleColor != null ? selectionStyleColor : editor.getSelectionColor());
            int startCol = Math.min(this.editorSelectionColumns.getMarkColumn(), this.editorSelectionColumns.getDotColumn());
            int endCol = Math.max(this.editorSelectionColumns.getMarkColumn(), this.editorSelectionColumns.getDotColumn());
            int startLine = Math.min(this.editorSelectionColumns.getMarkLine(), this.editorSelectionColumns.getDotLine());
            int endLine = Math.max(this.editorSelectionColumns.getMarkLine(), this.editorSelectionColumns.getDotLine());
            if (startLine == -1 || endLine == -1) {
                return;
            }
            int firstVisOffset = editor.getFirstVisibleOffset();
            int firstVisLine = editor.getLineFromOffset(firstVisOffset);
            startLine = Math.max(firstVisLine, startLine);
            int lastVisOffset = editor.getLastVisibleOffset();
            int lastVisLine = editor.getLineFromOffset(lastVisOffset);
            endLine = Math.min(lastVisLine, endLine);
            int charWidth = this.editorSelectionColumns.getColumnWidth();
            int left = editor.getInsets().left;
            int endX = charWidth * endCol + left;
            int startX = charWidth * startCol + left;
            for (int i = startLine; i <= endLine; ++i) {
                int lineStart;
                int lineEnd;
                int lineCol;
                if (editor.isLineCollapsed(i) || (lineCol = (lineEnd = editor.getLineEndOffset(i)) - (lineStart = editor.getLineStartOffset(i))) > endCol) continue;
                Rectangle startR = editor.modelToView(lineEnd - 1);
                int x = startR.x + startR.width;
                x = Math.max(startX, x);
                int w = endX - x;
                int y = startR.y;
                int h = startR.height;
                g.fillRect(x, y, w, h);
            }
        }
        catch (BadLocationException e) {
            Logger.getLogger("global").log(Level.SEVERE, "Column Selection Error", e);
        }
    }

    @Override
    public int getPriority() {
        return 1;
    }

    static {
        EditorProperties properties = EditorProperties.getProperties();
        final HighlightRegistry registry = properties.getHighlightRegistry();
        HighlightStyle style = registry.lookupStyle("highlight-selection");
        if (style != null) {
            selectionStyleColor = style.getBackgroundColor();
        }
        registry.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                HighlightStyle style = registry.lookupStyle("highlight-selection");
                if (style != null) {
                    selectionStyleColor = style.getBackgroundColor();
                }
            }
        });
    }
}

