/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.mdb.core;

import java.sql.Connection;
import oracle.dbtools.extension.mdb.command.Interfaces.CommandInterface;
import oracle.dbtools.extension.mdb.command.MDBSymbols;
import oracle.dbtools.extension.mdb.service.MDBService;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Id;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ParsedCommand;

public class MdbListCommand
implements CommandInterface {
    private final ParsedCommand parsedCommand;
    private final ScriptRunnerContext context;
    private final Connection connection;

    public MdbListCommand(Connection connection, ScriptRunnerContext context, ParsedCommand parsedCommand) {
        this.parsedCommand = parsedCommand;
        this.context = context;
        this.connection = connection;
    }

    @Override
    public void run() {
        MDBService mdbService = (MDBService)this.context.getService(MDBService.class);
        String mdbFilePath = (String)this.parsedCommand.getOptionValue((Id)MDBSymbols.FILE);
        try {
            if (this.parsedCommand.isFlagSet((Id)MDBSymbols.TABLES) && this.parsedCommand.isFlagSet((Id)MDBSymbols.VIEWS) || !this.parsedCommand.isFlagSet((Id)MDBSymbols.TABLES) && !this.parsedCommand.isFlagSet((Id)MDBSymbols.VIEWS)) {
                mdbService.listAll(this.context, this.connection, mdbFilePath);
            } else if (this.parsedCommand.isFlagSet((Id)MDBSymbols.TABLES)) {
                mdbService.listTables(this.context, this.connection, mdbFilePath);
            } else if (this.parsedCommand.isFlagSet((Id)MDBSymbols.VIEWS)) {
                mdbService.listViews(this.context, this.connection, mdbFilePath);
            }
        }
        catch (Exception e) {
            this.context.writeln(e.getMessage());
        }
    }
}

