/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.tiling;

import ilog.views.IlvManager;
import ilog.views.io.IlvInputStream;
import ilog.views.io.IlvOutputStream;
import ilog.views.io.IlvReadFileException;
import ilog.views.tiling.IlvTile;
import ilog.views.tiling.IlvTileCache;
import ilog.views.tiling.IlvTileController;
import java.io.IOException;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Vector;

public class IlvDefaultTileCache
extends IlvTileCache {
    private int a = 5;
    private static IlvDefaultTileCache b = new IlvDefaultTileCache();
    private transient LinkedList c = new LinkedList();

    public IlvDefaultTileCache() {
    }

    public IlvDefaultTileCache(int n) {
        this.a = n;
    }

    public IlvDefaultTileCache(IlvInputStream ilvInputStream) throws IlvReadFileException {
        this.a = ilvInputStream.readInt("size");
    }

    public static IlvDefaultTileCache GetDefaultCache() {
        return b;
    }

    @Override
    public void tileCached(IlvTile ilvTile) {
        this.c.add(ilvTile);
    }

    @Override
    public void tileRetrieved(IlvTile ilvTile) {
        this.c.remove(ilvTile);
    }

    @Override
    public void tileAboutToLoad(IlvTile ilvTile) {
        Object object;
        int n;
        Vector<IlvManager> vector = new Vector<IlvManager>();
        int n2 = this.c.size() - this.a;
        if (n2 <= 0) {
            return;
        }
        try {
            for (n = n2; n > 0; --n) {
                object = (IlvTile)this.c.removeFirst();
                IlvManager ilvManager = ((IlvTile)object).getController().getManager();
                if (ilvManager != null) {
                    ilvManager.setContentsAdjusting(true);
                    vector.addElement(((IlvTile)object).getController().getManager());
                }
                this.releaseTile((IlvTile)object);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        for (n = 0; n < vector.size(); ++n) {
            object = (IlvManager)vector.elementAt(n);
            ((IlvManager)object).setContentsAdjusting(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void controllerDisposed(IlvTileController ilvTileController) {
        LinkedList linkedList = this.c;
        synchronized (linkedList) {
            ListIterator listIterator = this.c.listIterator();
            while (listIterator.hasNext()) {
                IlvTile ilvTile = (IlvTile)listIterator.next();
                if (ilvTile.getController() != ilvTileController) continue;
                listIterator.remove();
            }
        }
    }

    public final int getCacheSize() {
        return this.a;
    }

    public void setCacheSize(int n) {
        this.a = n;
    }

    @Override
    public void write(IlvOutputStream ilvOutputStream) throws IOException {
        super.write(ilvOutputStream);
        ilvOutputStream.write("size", this.a);
    }
}

