/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.symbology.palettes;

import ilog.views.symbology.palettes.IlvPalette;
import ilog.views.symbology.palettes.IlvPaletteCategory;
import ilog.views.symbology.palettes.IlvPaletteObject;
import ilog.views.symbology.palettes.IlvPaletteSymbol;
import ilog.views.symbology.palettes.IlvPaletteSymbolParameter;
import ilog.views.symbology.palettes.IlvPaletteSymbolParameterValueSet;
import ilog.views.symbology.palettes.IlvPaletteXMLConstants;
import ilog.views.symbology.palettes.internal.IlvPaletteUtil;
import ilog.views.util.convert.IlvConvert;
import ilog.views.util.convert.IlvConvertException;
import java.io.OutputStream;
import java.util.Enumeration;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

class IlvPaletteXMLWriter
implements IlvPaletteXMLConstants {
    private IlvPalette a = null;

    public IlvPaletteXMLWriter(IlvPalette ilvPalette) {
        this.a = ilvPalette;
    }

    public void write(OutputStream outputStream) {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            Element element = document.createElement(IlvPaletteXMLConstants.PALETTE_ELEMENT);
            if (this.a.getIconResourceName() != null) {
                element.setAttribute(IlvPaletteXMLConstants.ICON_ATTRIBUTE, this.a.getIconResourceName());
            }
            document.appendChild(element);
            this.a(this.a, document, element);
            this.a(this.a.getRoot(), document, element);
            try {
                DOMSource dOMSource = new DOMSource(document);
                StreamResult streamResult = new StreamResult(outputStream);
                Transformer transformer = TransformerFactory.newInstance().newTransformer();
                transformer.setOutputProperty("indent", "yes");
                transformer.transform(dOMSource, streamResult);
            }
            catch (TransformerConfigurationException transformerConfigurationException) {
                transformerConfigurationException.printStackTrace();
            }
            catch (TransformerException transformerException) {
                transformerException.printStackTrace();
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
    }

    private void a(Object object, Document document, Element element) {
        if (object instanceof IlvPaletteCategory) {
            IlvPaletteCategory ilvPaletteCategory = (IlvPaletteCategory)object;
            Element element2 = document.createElement(IlvPaletteXMLConstants.CATEGORY_ELEMENT);
            element2.setAttribute(IlvPaletteXMLConstants.ID_ATTRIBUTE, ilvPaletteCategory.getID());
            element.appendChild(element2);
            int n = ilvPaletteCategory.getChildrenCount();
            for (int i = 0; i < n; ++i) {
                IlvPaletteObject ilvPaletteObject = ilvPaletteCategory.getChild(i);
                this.a(ilvPaletteObject, document, element2);
            }
        } else if (object instanceof IlvPaletteSymbol) {
            Object object2;
            IlvPaletteSymbol ilvPaletteSymbol = (IlvPaletteSymbol)object;
            Element element3 = document.createElement(IlvPaletteXMLConstants.SYMBOL_ELEMENT);
            element3.setAttribute(IlvPaletteXMLConstants.ID_ATTRIBUTE, ilvPaletteSymbol.getID());
            element3.setAttribute(IlvPaletteXMLConstants.VERSION_ATTRIBUTE, ilvPaletteSymbol.getVersion());
            if (ilvPaletteSymbol.getCSSResourceName() != null) {
                element3.setAttribute(IlvPaletteXMLConstants.CSS_ATTRIBUTE, ilvPaletteSymbol.getCSSResourceName());
            }
            if (ilvPaletteSymbol.getClassName() != null) {
                element3.setAttribute(IlvPaletteXMLConstants.CLASSNAME_ATTRIBUTE, ilvPaletteSymbol.getClassName());
            }
            if (ilvPaletteSymbol.getIconResourceName() != null) {
                element3.setAttribute(IlvPaletteXMLConstants.ICON_ATTRIBUTE, ilvPaletteSymbol.getIconResourceName());
            }
            element.appendChild(element3);
            int n = ilvPaletteSymbol.getParameterCount();
            for (int i = 0; i < n; ++i) {
                object2 = ilvPaletteSymbol.getParameter(i);
                this.a(object2, document, element3);
            }
            Enumeration enumeration = ilvPaletteSymbol.getResources();
            while (enumeration.hasMoreElements()) {
                object2 = enumeration.nextElement().toString();
                Element element4 = document.createElement(IlvPaletteXMLConstants.RESOURCE_ELEMENT);
                Text text = document.createTextNode((String)object2);
                element4.appendChild(text);
                element3.appendChild(element4);
            }
        } else if (object instanceof IlvPaletteSymbolParameter) {
            IlvPaletteSymbolParameter ilvPaletteSymbolParameter = (IlvPaletteSymbolParameter)object;
            String string = IlvPaletteUtil.getValueAsLocaleIndependentString(ilvPaletteSymbolParameter);
            Element element5 = document.createElement(IlvPaletteXMLConstants.PARAM_ELEMENT);
            element5.setAttribute(IlvPaletteXMLConstants.ID_ATTRIBUTE, ilvPaletteSymbolParameter.getID());
            if (string != null) {
                element5.setAttribute(IlvPaletteXMLConstants.VALUE_ATTRIBUTE, string);
            }
            if (ilvPaletteSymbolParameter.getType() != null) {
                element5.setAttribute(IlvPaletteXMLConstants.TYPE_ATTRIBUTE, ilvPaletteSymbolParameter.getType());
            }
            if (ilvPaletteSymbolParameter.getEditorClassName() != null) {
                element5.setAttribute(IlvPaletteXMLConstants.EDITOR_ATTRIBUTE, ilvPaletteSymbolParameter.getEditorClassName());
            }
            if (ilvPaletteSymbolParameter.getValueSet() != null) {
                element5.setAttribute(IlvPaletteXMLConstants.VALUESET_ATTRIBUTE, ilvPaletteSymbolParameter.getValueSet().getID());
            }
            if (ilvPaletteSymbolParameter.isReadOnly()) {
                element5.setAttribute(IlvPaletteXMLConstants.READONLY_ATTRIBUTE, "true");
            }
            if (!ilvPaletteSymbolParameter.isVisible()) {
                element5.setAttribute(IlvPaletteXMLConstants.VISIBLE_ATTRIBUTE, "false");
            }
            element.appendChild(element5);
        }
    }

    private void a(IlvPalette ilvPalette, Document document, Element element) {
        if (ilvPalette == null) {
            return;
        }
        for (int i = 0; i < ilvPalette.getValueSetCount(); ++i) {
            int n;
            StringBuffer stringBuffer;
            IlvPaletteSymbolParameterValueSet ilvPaletteSymbolParameterValueSet = ilvPalette.getValueSet(i);
            if (ilvPaletteSymbolParameterValueSet == null) continue;
            Element element2 = document.createElement(IlvPaletteXMLConstants.VALUESET_ELEMENT);
            element2.setAttribute(IlvPaletteXMLConstants.ID_ATTRIBUTE, ilvPaletteSymbolParameterValueSet.getID());
            if (ilvPaletteSymbolParameterValueSet.getType() != null) {
                element2.setAttribute(IlvPaletteXMLConstants.TYPE_ATTRIBUTE, ilvPaletteSymbolParameterValueSet.getType());
            }
            int[] nArray = ilvPaletteSymbolParameterValueSet.getIntValues();
            float[] fArray = ilvPaletteSymbolParameterValueSet.getFloatValues();
            double[] dArray = ilvPaletteSymbolParameterValueSet.getDoubleValues();
            Object[] objectArray = ilvPaletteSymbolParameterValueSet.getObjectValues();
            if (nArray != null) {
                stringBuffer = new StringBuffer("i:");
                for (n = 0; n < nArray.length; ++n) {
                    stringBuffer.append(" " + nArray[n]);
                }
                element2.setAttribute(IlvPaletteXMLConstants.VALUESET_ATTRIBUTE, stringBuffer.toString());
            }
            if (fArray != null) {
                stringBuffer = new StringBuffer("f:");
                for (n = 0; n < fArray.length; ++n) {
                    stringBuffer.append(" " + fArray[n]);
                }
                element2.setAttribute(IlvPaletteXMLConstants.VALUESET_ATTRIBUTE, stringBuffer.toString());
            }
            if (dArray != null) {
                stringBuffer = new StringBuffer("d:");
                for (n = 0; n < dArray.length; ++n) {
                    stringBuffer.append(" " + dArray[n]);
                }
                element2.setAttribute(IlvPaletteXMLConstants.VALUESET_ATTRIBUTE, stringBuffer.toString());
            }
            if (objectArray != null) {
                for (int j = 0; j < objectArray.length; ++j) {
                    String string = this.a(objectArray[j]);
                    Element element3 = document.createElement(IlvPaletteXMLConstants.VALUE_ELEMENT);
                    element2.appendChild(element3);
                    Text text = document.createTextNode(string);
                    element3.appendChild(text);
                }
            }
            element.appendChild(element2);
        }
    }

    private String a(Object object) {
        if ("".equals(object)) {
            return "@|emptyString";
        }
        try {
            return (String)IlvConvert.convert(object, String.class);
        }
        catch (IlvConvertException ilvConvertException) {
            return object.toString();
        }
    }
}

