/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.graphic.composite.layout;

import ilog.views.IlvGraphic;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.graphic.composite.IlvCompositeGraphic;
import ilog.views.graphic.composite.layout.IlvAttachable;
import ilog.views.graphic.composite.layout.IlvAttachableGraphic;
import ilog.views.graphic.composite.layout.IlvAttachmentConstraint;
import ilog.views.graphic.composite.layout.IlvChildSize;
import ilog.views.graphic.composite.layout.IlvLayoutManager;
import ilog.views.io.IlvInputStream;
import ilog.views.io.IlvOutputStream;
import ilog.views.io.IlvReadFileException;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public class IlvAttachmentLayout
implements IlvLayoutManager {
    public static final String ANCHOR = "Anchor";
    private IlvAttachable a;
    private Map b = new LinkedHashMap();

    public IlvAttachmentLayout() {
    }

    public IlvAttachmentLayout(IlvInputStream ilvInputStream) throws IlvReadFileException {
    }

    @Override
    public void setConstraints(IlvAttachable ilvAttachable, Object object) {
        if (object == null || object instanceof String) {
            this.a(ilvAttachable, (String)object);
        } else if (object instanceof IlvAttachmentConstraint) {
            this.a(ilvAttachable, (IlvAttachmentConstraint)object);
        } else {
            throw new IllegalArgumentException("cannot add to layout: constraint must be a string (or null)");
        }
    }

    private void a(IlvAttachable ilvAttachable, String string) {
        if (string == null) {
            string = ANCHOR;
        }
        if (!ANCHOR.equals(string)) {
            throw new IllegalArgumentException("cannot add to layout: unknown constraint: " + string);
        }
        this.a = ilvAttachable;
    }

    private void a(IlvAttachable ilvAttachable, IlvAttachmentConstraint ilvAttachmentConstraint) {
        this.b.put(ilvAttachable, ilvAttachmentConstraint);
    }

    @Override
    public void removeConstraints(IlvAttachable ilvAttachable) {
        this.b.remove(ilvAttachable);
    }

    @Override
    public void layoutGroup(IlvAttachable ilvAttachable) {
        if (this.getAnchor() == null) {
            return;
        }
        IlvRect ilvRect = this.getAnchor().getAttachmentBounds();
        for (Map.Entry entry : this.b.entrySet()) {
            IlvPoint ilvPoint;
            IlvAttachmentConstraint ilvAttachmentConstraint = (IlvAttachmentConstraint)entry.getValue();
            IlvAttachable ilvAttachable2 = (IlvAttachable)entry.getKey();
            if (ilvAttachable2 != this.a && ilvAttachmentConstraint.a() != 0.0) {
                ilvAttachable2.rotate(new IlvPoint(0.0f, 0.0f), -ilvAttachmentConstraint.a());
                this.a(ilvAttachable2);
            }
            IlvRect ilvRect2 = ilvAttachable2.getAttachmentBounds();
            IlvChildSize ilvChildSize = ilvAttachmentConstraint.getChildSize();
            if (ilvChildSize != null) {
                ilvPoint = ilvChildSize.getSize(ilvRect, ilvRect2);
                ilvAttachable2.resize(ilvPoint);
            } else {
                boolean bl = ilvAttachmentConstraint.isRelativeSize();
                IlvPoint ilvPoint2 = ilvAttachmentConstraint.getSize();
                if (ilvAttachable2 == this.a) {
                    bl = false;
                }
                if (ilvPoint2 != null && (ilvPoint2.x > 0.0f || ilvPoint2.y > 0.0f)) {
                    if (ilvPoint2.x <= 0.0f) {
                        ilvPoint2.x = ilvRect2.width;
                    } else {
                        float f = ilvPoint2.x = bl ? ilvRect.width * ilvPoint2.x : ilvPoint2.x;
                    }
                    ilvPoint2.y = ilvPoint2.y <= 0.0f ? ilvRect2.height : (bl ? ilvRect.height * ilvPoint2.y : ilvPoint2.y);
                    ilvAttachable2.resize(ilvPoint2);
                }
            }
            if (ilvAttachable2 == this.a) {
                ilvRect = this.getAnchor().getAttachmentBounds();
                continue;
            }
            ilvAttachmentConstraint.getHotSpot().setValue(ilvAttachable2, ilvAttachmentConstraint.compute(this.a, ilvRect));
            if (ilvAttachmentConstraint.getRotationAngle() != 0.0) {
                ilvRect2 = ilvAttachable2.getAttachmentBounds();
                ilvPoint = ilvAttachmentConstraint.getRotationCenter() == null ? (!ilvAttachmentConstraint.isRotationCenterRelativeToBase() ? new IlvPoint((float)ilvRect2.getCenterX(), (float)ilvRect2.getCenterY()) : new IlvPoint((float)ilvRect.getCenterX(), (float)ilvRect.getCenterY())) : ilvAttachmentConstraint.getRotationCenter().getValue(ilvAttachmentConstraint.isRotationCenterRelativeToBase() ? this.a : ilvAttachable2);
                ilvAttachable2.rotate(ilvPoint, ilvAttachmentConstraint.getRotationAngle());
            }
            ilvAttachmentConstraint.a(ilvAttachmentConstraint.getRotationAngle());
        }
    }

    private void a(IlvAttachable ilvAttachable) {
        if (!(ilvAttachable instanceof IlvAttachableGraphic)) {
            return;
        }
        IlvGraphic ilvGraphic = ((IlvAttachableGraphic)ilvAttachable).getGraphic();
        if (!(ilvGraphic instanceof IlvCompositeGraphic)) {
            return;
        }
        ((IlvCompositeGraphic)ilvGraphic).invalidate(false);
    }

    @Override
    public void attach(IlvAttachable ilvAttachable) {
        IlvAttachable[] ilvAttachableArray = ilvAttachable.getAttachables();
        Object[] objectArray = ilvAttachable.getConstraints();
        if (objectArray != null) {
            for (int i = 0; i < ilvAttachableArray.length && i < objectArray.length; ++i) {
                if (objectArray[i] == null || ilvAttachableArray[i] == null) continue;
                this.setConstraints(ilvAttachableArray[i], objectArray[i]);
            }
        }
        if (this.a == null) {
            this.a = ilvAttachableArray[0];
        }
    }

    public void setAnchor(IlvAttachable ilvAttachable) {
        this.a = ilvAttachable;
    }

    public IlvAttachable getAnchor() {
        return this.a;
    }

    @Override
    public void reset() {
        this.b = new LinkedHashMap();
        this.a = null;
    }

    @Override
    public Object clone() {
        try {
            IlvAttachmentLayout ilvAttachmentLayout = (IlvAttachmentLayout)super.clone();
            ilvAttachmentLayout.a = null;
            ilvAttachmentLayout.reset();
            return ilvAttachmentLayout;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new InternalError();
        }
    }

    @Override
    public boolean resizeFirstChildOnly() {
        return true;
    }

    @Override
    public void write(IlvOutputStream ilvOutputStream) throws IOException {
    }
}

