/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.graphic;

import ilog.views.IlvGraphic;
import ilog.views.IlvPoint;
import ilog.views.IlvPolyPointsInterface;
import ilog.views.IlvPolyPointsSelection;
import ilog.views.IlvRect;
import ilog.views.IlvSelection;
import ilog.views.IlvTransformer;
import ilog.views.IlvUtil;
import ilog.views.io.IlvInputStream;
import ilog.views.io.IlvOutputStream;
import ilog.views.io.IlvReadFileException;
import java.io.IOException;

public abstract class IlvPolyPoints
extends IlvGraphic
implements IlvPolyPointsInterface {
    IlvPoint[] a;
    private IlvRect b = new IlvRect();
    private boolean c = false;
    static IlvPoint[] d = new IlvPoint[4];
    static IlvRect e = new IlvRect();
    static boolean f = false;

    public IlvPolyPoints(IlvPoint[] ilvPointArray) {
        this(ilvPointArray, true);
    }

    public IlvPolyPoints(IlvPoint[] ilvPointArray, boolean bl) {
        this.a(ilvPointArray, bl);
    }

    public IlvPolyPoints(IlvPolyPoints ilvPolyPoints) {
        super(ilvPolyPoints);
        this.a(ilvPolyPoints.a, true);
    }

    protected IlvPoint[] getPoints() {
        return this.a;
    }

    protected void computeBBox(IlvRect ilvRect) {
        IlvUtil.BoundingBox(ilvRect, this.a, this.a.length);
    }

    public void recomputeBBox() {
        this.computeBBox(this.b);
    }

    private void b() {
        if (!this.c) {
            this.computeBBox(this.b);
            this.c = true;
        }
    }

    final void a() {
        this.c = false;
    }

    public boolean inBBox(IlvPoint ilvPoint) {
        this.b();
        return this.b.inside(ilvPoint.x, ilvPoint.y);
    }

    private void a(IlvPoint[] ilvPointArray, boolean bl) {
        if (bl) {
            this.a = new IlvPoint[ilvPointArray.length];
            for (int i = 0; i < ilvPointArray.length; ++i) {
                this.a[i] = new IlvPoint(ilvPointArray[i].x, ilvPointArray[i].y);
            }
        } else {
            this.a = ilvPointArray;
        }
        this.recomputeBBox();
    }

    public IlvPolyPoints(IlvInputStream ilvInputStream) throws IlvReadFileException {
        super(ilvInputStream);
        IlvPoint[] ilvPointArray = ilvInputStream.readPointArray("points");
        this.a(ilvPointArray, false);
    }

    @Override
    public void write(IlvOutputStream ilvOutputStream) throws IOException {
        super.write(ilvOutputStream);
        ilvOutputStream.write("points", this.a);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean intersects(IlvRect ilvRect, IlvRect ilvRect2, IlvTransformer ilvTransformer) {
        IlvRect ilvRect3 = e;
        synchronized (ilvRect3) {
            f = true;
            IlvRect ilvRect4 = this.boundingBox(ilvTransformer);
            f = false;
            return ilvRect4.intersects(ilvRect2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IlvRect boundingBox(IlvTransformer ilvTransformer) {
        IlvRect ilvRect;
        this.b();
        IlvRect ilvRect2 = ilvRect = f ? e : new IlvRect();
        if (ilvTransformer != null && !ilvTransformer.isIdentity()) {
            IlvPoint ilvPoint = d[0];
            synchronized (ilvPoint) {
                d[0].move(this.b.x, this.b.y);
                d[1].move(this.b.x, this.b.y + this.b.height);
                d[2].move(this.b.x + this.b.width, this.b.y);
                d[3].move(this.b.x + this.b.width, this.b.y + this.b.height);
                ilvTransformer.apply(d[0]);
                ilvTransformer.apply(d[1]);
                ilvTransformer.apply(d[2]);
                ilvTransformer.apply(d[3]);
                IlvUtil.BoundingBox(ilvRect, d, 4);
            }
        } else {
            ilvRect.x = this.b.x;
            ilvRect.y = this.b.y;
            ilvRect.width = this.b.width;
            ilvRect.height = this.b.height;
        }
        if (ilvRect.width < 1.0E-20f) {
            ilvRect.width = 1.0E-20f;
        }
        if (ilvRect.height < 1.0E-20f) {
            ilvRect.height = 1.0E-20f;
        }
        return ilvRect;
    }

    @Override
    public void applyTransform(IlvTransformer ilvTransformer) {
        for (int i = 0; i < this.a.length; ++i) {
            ilvTransformer.apply(this.a[i]);
        }
        this.a();
    }

    @Override
    public void translate(float f, float f2) {
        int n = this.a.length;
        for (int i = 0; i < n; ++i) {
            this.a[i].x += f;
            this.a[i].y += f2;
        }
        this.a();
    }

    @Override
    public IlvPoint getPointAt(int n, IlvTransformer ilvTransformer) {
        IlvPoint ilvPoint = this.a[n];
        ilvPoint = new IlvPoint(ilvPoint.x, ilvPoint.y);
        if (ilvTransformer != null) {
            ilvTransformer.apply(ilvPoint);
        }
        return ilvPoint;
    }

    @Override
    public int getPointsCardinal() {
        return this.a.length;
    }

    @Override
    public boolean allowsPointInsertion() {
        return true;
    }

    @Override
    public boolean allowsPointRemoval() {
        return this.getPointsCardinal() >= 2;
    }

    @Override
    public boolean allowsPointMove(int n) {
        return true;
    }

    @Override
    public void insertPoint(int n, float f, float f2, IlvTransformer ilvTransformer) {
        if (n >= 0 && n <= this.a.length) {
            IlvPoint[] ilvPointArray = this.a;
            this.a = new IlvPoint[ilvPointArray.length + 1];
            System.arraycopy(ilvPointArray, n, this.a, n + 1, ilvPointArray.length - n);
            this.a[n] = new IlvPoint(f, f2);
            if (n > 0) {
                System.arraycopy(ilvPointArray, 0, this.a, 0, n);
            }
        } else {
            throw new IllegalArgumentException("bad index: " + n);
        }
        this.a();
    }

    @Override
    public void removePoint(int n, IlvTransformer ilvTransformer) {
        if (this.a.length == 1) {
            throw new IllegalArgumentException("PolyPoint must have at least two points.");
        }
        if (n >= 0 && n < this.a.length) {
            int n2;
            IlvPoint[] ilvPointArray = this.a;
            this.a = new IlvPoint[ilvPointArray.length - 1];
            if (n > 0) {
                System.arraycopy(ilvPointArray, 0, this.a, 0, n);
            }
            if ((n2 = ilvPointArray.length - n - 1) > 0) {
                System.arraycopy(ilvPointArray, n + 1, this.a, n, n2);
            }
        } else {
            throw new IllegalArgumentException("bad index: " + n);
        }
        this.a();
    }

    @Override
    public void movePoint(int n, float f, float f2, IlvTransformer ilvTransformer) {
        if (n < 0 || n >= this.a.length) {
            throw new IllegalArgumentException("bad index: " + n);
        }
        this.a[n].x = f;
        this.a[n].y = f2;
        this.a();
    }

    @Override
    public IlvSelection makeSelection() {
        return new IlvPolyPointsSelection(this);
    }

    static {
        for (int i = 0; i < d.length; ++i) {
            IlvPolyPoints.d[i] = new IlvPoint();
        }
    }
}

