/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.customizer.styling.internal.converter;

import ilog.views.css.model.IlvRule;
import ilog.views.css.model.IlvRuleModel;
import ilog.views.css.model.IlvRuleUtils;
import ilog.views.css.model.internal.IlvCSSWriter;
import ilog.views.customizer.IlvCustomizerException;
import ilog.views.customizer.styling.internal.IlvAbstractRuleCustomizer;
import ilog.views.customizer.target.IlvCustomizerPropertyDescriptor;
import ilog.views.util.convert.IlvConvertException;
import ilog.views.util.css.parser.Declaration;
import java.util.ArrayList;

public class IlvGenericValueConverter
implements IlvAbstractRuleCustomizer.ValueConverter {
    IlvAbstractRuleCustomizer a;
    IlvRuleModel b;
    IlvCSSWriter c;

    public IlvGenericValueConverter(IlvAbstractRuleCustomizer ilvAbstractRuleCustomizer, IlvRuleModel ilvRuleModel) {
        this.a = ilvAbstractRuleCustomizer;
        this.b = ilvRuleModel;
        this.c = new IlvCSSWriter(this.b.getCSSBeans().getDOMImplementation());
    }

    @Override
    public boolean isConvertible(String string) {
        return string.startsWith("@#");
    }

    @Override
    public String toString(Object object, IlvCustomizerPropertyDescriptor ilvCustomizerPropertyDescriptor) throws IlvConvertException {
        this.removeOldUnusedSharpIdRules(ilvCustomizerPropertyDescriptor);
        if (object == null) {
            return "";
        }
        String string = this.getNewSelector(object, ilvCustomizerPropertyDescriptor);
        this.convertToRules("Subobject" + string, object);
        return "@" + string;
    }

    protected String getNewSelector(Object object, IlvCustomizerPropertyDescriptor ilvCustomizerPropertyDescriptor) {
        String string = ilvCustomizerPropertyDescriptor.getPropertyName();
        String string2 = new StringBuffer("#").append(string).append(Integer.toHexString(object.hashCode())).toString();
        return string2;
    }

    protected void convertToRules(String string, Object object) {
        this.c.reset();
        IlvCSSWriter.IlvCSSCustomizerDeclarations ilvCSSCustomizerDeclarations = null;
        try {
            ilvCSSCustomizerDeclarations = this.c.convert(string, object, null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        IlvRule ilvRule = IlvRuleUtils.createRule(this.b.getCSSBeans().getDOMImplementation(), string);
        Declaration[] declarationArray = ilvCSSCustomizerDeclarations.getDeclarations();
        for (int i = 0; i < declarationArray.length; ++i) {
            ilvRule.setDeclaration(declarationArray[i].getSource(), declarationArray[i].getValue());
        }
        this.b.addRule(ilvRule);
        IlvRule[] ilvRuleArray = ilvCSSCustomizerDeclarations.getAdditionalRules();
        for (int i = 0; i < ilvRuleArray.length; ++i) {
            this.b.addRule(ilvRuleArray[i]);
        }
    }

    protected void removeOldUnusedSharpIdRules(IlvCustomizerPropertyDescriptor ilvCustomizerPropertyDescriptor) {
        try {
            String string = this.a.getValueAsString(ilvCustomizerPropertyDescriptor, true);
            if (string == null) {
                return;
            }
            ArrayList<String> arrayList = IlvRuleUtils.getSharpRuleReferences(string);
            if (arrayList != null) {
                for (int i = 0; i < arrayList.size(); ++i) {
                    String string2 = arrayList.get(i);
                    if (this.b.getSharpRuleUsageCount(string2) != 1) continue;
                    this.b.removeSharpRule(string2);
                }
            }
        }
        catch (IlvCustomizerException ilvCustomizerException) {
            ilvCustomizerException.printStackTrace();
        }
    }
}

