/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.appframe.form.swing.internal;

import ilog.views.appframe.IlvAction;
import ilog.views.appframe.form.services.IlvServicesProvider;
import ilog.views.appframe.swing.IlvToolBar;
import ilog.views.appframe.swing.util.IlvAppFrameServicesProvider;
import ilog.views.appframe.swing.util.IlvJDKWorkaroundPopupListener;
import ilog.views.appframe.swing.util.IlvSwingUtil;
import java.awt.Component;
import java.awt.Container;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;

public class IlvActionUtils {
    public static Component AddActionItem(Action action, Container container, int n, IlvServicesProvider ilvServicesProvider) {
        if (container instanceof JMenu) {
            JMenuItem jMenuItem = IlvActionUtils.CreateMenuItem(action, ilvServicesProvider);
            if (n != -1) {
                container.add((Component)jMenuItem, n);
            } else {
                container.add(jMenuItem);
            }
            return jMenuItem;
        }
        if (container instanceof JPopupMenu) {
            JMenuItem jMenuItem = IlvActionUtils.CreateMenuItem(action, ilvServicesProvider);
            if (n != -1) {
                container.add((Component)jMenuItem, n);
            } else {
                container.add(jMenuItem);
            }
            return jMenuItem;
        }
        return IlvToolBar.AddActionButton(action, container, n, IlvAppFrameServicesProvider.GetApplication(ilvServicesProvider));
    }

    public static Component AddActionComponent(Action action, Container container, int n, IlvServicesProvider ilvServicesProvider) {
        if (container instanceof JToolBar) {
            return IlvToolBar.AddActionButton(action, container, n, IlvAppFrameServicesProvider.GetApplication(ilvServicesProvider));
        }
        if (container instanceof JMenu || container instanceof JPopupMenu) {
            return IlvActionUtils.AddActionItem(action, container, n, ilvServicesProvider);
        }
        return null;
    }

    public static JMenuItem CreateMenuItem(Action action, IlvServicesProvider ilvServicesProvider) {
        JMenuItem jMenuItem;
        if (IlvSwingUtil.HasBooleanProperty(action, "checkable") && IlvSwingUtil.IsStandardCheckActionLook(action, IlvAppFrameServicesProvider.GetApplication(ilvServicesProvider))) {
            jMenuItem = new JCheckBoxMenuItem();
        } else if (IlvSwingUtil.HasBooleanProperty(action, "listInSubmenu")) {
            jMenuItem = new JMenu();
            ((JMenu)jMenuItem).getPopupMenu().addPopupMenuListener(IlvJDKWorkaroundPopupListener.LISTENER);
        } else {
            jMenuItem = new JMenuItem();
        }
        IlvActionUtils.SetAction(jMenuItem, action, ilvServicesProvider, 0);
        return jMenuItem;
    }

    public static void SetAction(Component component, Action action, IlvServicesProvider ilvServicesProvider) {
        IlvAction.SetAction(component, action, IlvAppFrameServicesProvider.GetApplication(ilvServicesProvider));
    }

    public static void SetAction(AbstractButton abstractButton, Action action, IlvServicesProvider ilvServicesProvider, int n) {
        IlvAction.SetAction(abstractButton, action, IlvAppFrameServicesProvider.GetApplication(ilvServicesProvider), n);
    }

    public static void UpdateButtonProperties(AbstractButton abstractButton, IlvServicesProvider ilvServicesProvider) {
        IlvAction.UpdateButtonProperties(abstractButton, IlvAppFrameServicesProvider.GetApplication(ilvServicesProvider));
    }
}

