/*
 * Decompiled with CFR 0.152.
 */
package ilog.views;

import ilog.views.IlvGraphic;
import ilog.views.IlvObjectInteractorContext;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvSelection;
import ilog.views.IlvTransformer;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;

public abstract class IlvHandlesSelection
extends IlvSelection {
    public static final int FILLED_SQUARE_SHAPE = 0;
    public static final int SQUARE_SHAPE = 1;
    public static final int FILLED_CIRCLE_SHAPE = 2;
    public static final int CIRCLE_SHAPE = 3;
    public static int defaultHandleShape = 0;
    public static Color defaultHandleColor = Color.black;
    public static Color defaultHandleBackgroundColor = Color.white;
    public static float defaultHandleSize = 3.0f;
    private int a = defaultHandleShape;
    private float b = defaultHandleSize;
    private Color c = defaultHandleColor;
    private Color d = new Color(0, 0, 200);
    private boolean e = false;

    public IlvHandlesSelection(IlvGraphic ilvGraphic) {
        super(ilvGraphic);
    }

    public Color getHandlesColor() {
        return this.c;
    }

    public void setHandlesColor(Color color) {
        this.c = color;
    }

    public Color getActiveHandlesColor() {
        return this.d;
    }

    public void setActiveHandlesColor(Color color) {
        this.d = color;
    }

    public boolean isActive() {
        return this.e;
    }

    public final float getHandlesSize() {
        return this.b;
    }

    public final void setHandlesSize(float f) {
        this.b = Math.max(1.0f, f);
    }

    public final int getHandlesShape() {
        return this.a;
    }

    public final void setHandlesShape(int n) {
        this.a = n;
    }

    public abstract IlvPoint getHandle(int var1, IlvTransformer var2);

    public abstract int getHandleCardinal();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getHandle(IlvPoint ilvPoint, IlvTransformer ilvTransformer) {
        int n = this.getHandleCardinal();
        float f = 2.0f * this.b + 1.0f;
        float f2 = ilvPoint.x;
        float f3 = ilvPoint.y;
        this.beforeLoopAllHandles(ilvTransformer);
        try {
            for (int i = 0; i < n; ++i) {
                IlvPoint ilvPoint2 = this.getHandle(i, ilvTransformer);
                if (!(f2 >= ilvPoint2.x - this.b) || !(f2 <= ilvPoint2.x - this.b + f) || !(f3 >= ilvPoint2.y - this.b) || !(f3 <= ilvPoint2.y - this.b + f)) continue;
                int n2 = i;
                return n2;
            }
        }
        finally {
            this.afterLoopAllHandles();
        }
        return -1;
    }

    @Override
    public boolean contains(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvTransformer ilvTransformer) {
        return this.getHandle(ilvPoint2, ilvTransformer) != -1;
    }

    @Override
    public void draw(Graphics graphics, IlvTransformer ilvTransformer) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Object object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        if (this.a < 2) {
            if (object != RenderingHints.VALUE_ANTIALIAS_OFF) {
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            } else {
                object = null;
            }
        } else if (object != RenderingHints.VALUE_ANTIALIAS_ON) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            object = null;
        }
        int n = this.getHandleCardinal();
        float f = 0.0f;
        float f2 = 0.0f;
        this.beforeLoopAllHandles(ilvTransformer);
        for (int i = 0; i < n; ++i) {
            IlvPoint ilvPoint = this.getHandle(i, ilvTransformer);
            if (i == 0 || f != ilvPoint.x || f2 != ilvPoint.y) {
                this.a(graphics, ilvPoint.x, ilvPoint.y);
            }
            f = ilvPoint.x;
            f2 = ilvPoint.y;
        }
        this.afterLoopAllHandles();
        if (object != null) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
        }
    }

    public void drawWithoutHandles(Graphics graphics, IlvTransformer ilvTransformer) {
    }

    void a(Graphics graphics, float f, float f2) {
        int n = (int)Math.floor(f - this.b);
        int n2 = (int)Math.floor(f2 - this.b);
        int n3 = (int)Math.floor(2.0f * this.b + 1.0f);
        if (this.a == 0 || this.a == 2) {
            graphics.setColor(this.getHandlesColor());
        } else {
            graphics.setColor(defaultHandleBackgroundColor);
        }
        if (this.a < 2) {
            graphics.fillRect(n, n2, n3, n3);
            if (this.a == 1) {
                graphics.setColor(this.getHandlesColor());
                graphics.drawRect(n, n2, n3 - 1, n3 - 1);
            }
        } else {
            graphics.fillArc(n, n2, n3 - 1, n3 - 1, 0, 360);
            if (this.a == 3) {
                graphics.setColor(this.getHandlesColor());
                graphics.drawArc(n, n2, n3 - 1, n3 - 1, 0, 360);
            }
        }
    }

    @Override
    public boolean zoomable() {
        return false;
    }

    @Override
    public IlvRect boundingBox(IlvTransformer ilvTransformer) {
        int n = this.getHandleCardinal();
        if (n == 0) {
            IlvRect ilvRect = new IlvRect(0.0f, 0.0f, 1.0E-20f, 1.0E-20f);
            return ilvRect;
        }
        this.beforeLoopAllHandles(ilvTransformer);
        float f = 2.0f * this.b + 1.0f;
        IlvPoint ilvPoint = this.getHandle(0, ilvTransformer);
        IlvRect ilvRect = new IlvRect(ilvPoint.x - this.b, ilvPoint.y - this.b, f, f);
        IlvRect ilvRect2 = new IlvRect(0.0f, 0.0f, f, f);
        for (int i = 1; i < n; ++i) {
            ilvPoint = this.getHandle(i, ilvTransformer);
            ilvRect2.x = ilvPoint.x - this.b;
            ilvRect2.y = ilvPoint.y - this.b;
            ilvRect.add(ilvRect2);
        }
        this.afterLoopAllHandles();
        return ilvRect;
    }

    protected void beforeLoopAllHandles(IlvTransformer ilvTransformer) {
    }

    protected void afterLoopAllHandles() {
    }

    @Override
    public void onEnter(IlvObjectInteractorContext ilvObjectInteractorContext) {
        super.onEnter(ilvObjectInteractorContext);
        Color color = this.d;
        this.d = this.c;
        this.c = color;
        this.e = true;
        this.reDraw();
    }

    @Override
    public void onExit(IlvObjectInteractorContext ilvObjectInteractorContext) {
        super.onExit(ilvObjectInteractorContext);
        Color color = this.d;
        this.d = this.c;
        this.c = color;
        this.e = false;
        this.reDraw();
    }
}

