/*
 * Decompiled with CFR 0.152.
 */
package ilog.views;

import ilog.views.IlvBezier;
import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicBag;
import ilog.views.IlvGraphicVector;
import ilog.views.IlvLinkImage;
import ilog.views.IlvPoint;
import ilog.views.IlvPolyPointsInterface;
import ilog.views.IlvRect;
import ilog.views.IlvThickPolyline;
import ilog.views.IlvTransformer;
import ilog.views.IlvUtil;
import ilog.views.Polyline2D;
import ilog.views.Spline2D;
import ilog.views.internal.IlvUtility;
import ilog.views.util.print.IlvPrintUtil;
import ilog.views.util.text.IlvBidiUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;

public class IlvGraphicUtil {
    public static final float COMPATIBLE_SMOOTHNESS = -1.0f;
    public static final float AUTO_SMOOTHNESS = -2.0f;
    private static boolean a = false;
    private static IlvPoint[] b;
    private static int c;
    private static int[] d;
    private static int[] e;
    private static final IlvPoint f;
    static Boolean g;
    static int[] h;
    static int[] i;
    private static float j;
    private static AffineTransform k;
    private static IlvTransformer l;
    private static IlvRect m;
    private static Object n;
    static boolean o;
    private static float[] p;

    private IlvGraphicUtil() {
    }

    public static float GetArrowSize(IlvLinkImage ilvLinkImage, float f, IlvTransformer ilvTransformer) {
        return ilvLinkImage.getArrowSize(f, ilvTransformer);
    }

    public static void DrawPolyline(Graphics graphics, IlvPoint[] ilvPointArray, int n, float f, int n2, int n3, float[] fArray, IlvTransformer ilvTransformer) {
        IlvGraphicUtil.DrawPolyline(graphics, ilvPointArray, n, f, n2, n3, fArray, ilvTransformer, false);
    }

    public static void DrawPolyline(Graphics graphics, IlvPoint[] ilvPointArray, int n, float f, int n2, int n3, float[] fArray, IlvTransformer ilvTransformer, boolean bl) {
        boolean bl2;
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (ilvTransformer != null && !ilvTransformer.isIdentity()) {
            f = (float)((double)f * ilvTransformer.zoomFactor());
            fArray = IlvGraphicUtil.a(fArray, ilvTransformer);
        }
        Stroke stroke = null;
        if (IlvGraphicUtil.isPrinting(graphics)) {
            bl2 = true;
        } else {
            if (f < 1.0f) {
                f = 1.0f;
            }
            boolean bl3 = bl2 = f > 1.0f || fArray != null;
        }
        if (bl2) {
            n2 = IlvGraphicUtil.c(n2);
            n3 = IlvGraphicUtil.d(n3);
            stroke = graphics2D.getStroke();
            graphics2D.setStroke(new BasicStroke(f, n3, n2, j, fArray, 0.0f));
        }
        IlvGraphicUtil.a(graphics2D, ilvPointArray, n, bl ? null : ilvTransformer);
        if (bl2) {
            graphics2D.setStroke(stroke);
        }
    }

    public static boolean isPrinting(Graphics graphics) {
        return ((Graphics2D)graphics).getRenderingHint(IlvPrintUtil.KEY_PRINTING) == IlvPrintUtil.VALUE_PRINT_ON;
    }

    public static boolean PointInPolyline(IlvPoint ilvPoint, IlvPoint[] ilvPointArray, int n, float f, int n2, int n3, IlvTransformer ilvTransformer) {
        return IlvThickPolyline.a(ilvPoint, ilvPointArray, n, ilvTransformer, f, n2, n3);
    }

    public static IlvRect PolylineBBox(IlvPoint[] ilvPointArray, int n, float f, int n2, int n3, IlvTransformer ilvTransformer) {
        return IlvThickPolyline.a(ilvPointArray, n, ilvTransformer, f, n2, n3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void DrawBezier(Graphics graphics, IlvPoint[] ilvPointArray, int n, boolean bl, float f, float f2, int n2, int n3, float[] fArray, IlvTransformer ilvTransformer, boolean bl2) {
        block5: {
            block4: {
                if (n <= 2) break block4;
                if (f != -1.0f) break block5;
            }
            IlvGraphicUtil.DrawBezier(graphics, ilvPointArray, n, f2, n2, n3, fArray, ilvTransformer, bl2);
            return;
        }
        Boolean bl3 = g;
        synchronized (bl3) {
            IlvPoint[] ilvPointArray2 = IlvGraphicUtil.a(ilvPointArray, n, f, bl);
            IlvGraphicUtil.DrawBezier(graphics, ilvPointArray2, c, f2, n2, n3, fArray, ilvTransformer, bl2);
            return;
        }
    }

    public static void DrawBezier(Graphics graphics, IlvPoint[] ilvPointArray, int n, float f, int n2, int n3, float[] fArray, IlvTransformer ilvTransformer) {
        IlvGraphicUtil.DrawBezier(graphics, ilvPointArray, n, f, n2, n3, fArray, ilvTransformer, false);
    }

    public static void DrawBezier(Graphics graphics, IlvPoint[] ilvPointArray, int n, float f, int n2, int n3, float[] fArray, IlvTransformer ilvTransformer, boolean bl) {
        boolean bl2;
        if (n < 2) {
            return;
        }
        if (ilvTransformer != null && !ilvTransformer.isIdentity()) {
            f = (float)Math.floor((double)f * ilvTransformer.zoomFactor());
            fArray = IlvGraphicUtil.a(fArray, ilvTransformer);
        }
        if (bl) {
            ilvTransformer = null;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        boolean bl3 = IlvGraphicUtil.isPrinting(graphics);
        Stroke stroke = null;
        if (bl3) {
            bl2 = true;
        } else {
            if (f < 1.0f) {
                f = 1.0f;
            }
            boolean bl4 = bl2 = f > 1.0f || fArray != null;
        }
        if (bl2) {
            n2 = IlvGraphicUtil.c(n2);
            n3 = IlvGraphicUtil.d(n3);
            stroke = graphics2D.getStroke();
            graphics2D.setStroke(new BasicStroke(f, n3, n2, j, fArray, 0.0f));
        }
        if (Spline2D.g == null) {
            Spline2D.g = new Spline2D();
        }
        Spline2D.g.setValues(ilvPointArray, n, false, ilvTransformer, bl3);
        graphics2D.draw(Spline2D.g);
        if (bl2) {
            graphics2D.setStroke(stroke);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void BezierBoundingBox(IlvRect ilvRect, IlvPoint[] ilvPointArray, int n, boolean bl, float f, float f2, int n2, int n3, IlvTransformer ilvTransformer) {
        block5: {
            block4: {
                if (n <= 2) break block4;
                if (f != -1.0f) break block5;
            }
            IlvGraphicUtil.BezierBoundingBox(ilvRect, ilvPointArray, n, f2, n2, n3, ilvTransformer);
            return;
        }
        Boolean bl2 = g;
        synchronized (bl2) {
            IlvPoint[] ilvPointArray2 = IlvGraphicUtil.a(ilvPointArray, n, f, bl);
            IlvGraphicUtil.BezierBoundingBox(ilvRect, ilvPointArray2, c, f2, n2, n3, ilvTransformer);
            return;
        }
    }

    public static void BezierBoundingBox(IlvRect ilvRect, IlvPoint[] ilvPointArray, int n, float f, int n2, int n3, IlvTransformer ilvTransformer) {
        IlvBezier.BezierBoundingBox(ilvRect, ilvPointArray, n, ilvTransformer, f, n2, n3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean PointInBezier(IlvPoint ilvPoint, IlvPoint[] ilvPointArray, int n, boolean bl, float f, float f2, int n2, int n3, IlvTransformer ilvTransformer) {
        block6: {
            block5: {
                if (n <= 2) break block5;
                if (f != -1.0f) break block6;
            }
            return IlvGraphicUtil.PointInBezier(ilvPoint, ilvPointArray, n, f2, n2, n3, ilvTransformer);
        }
        Boolean bl2 = g;
        synchronized (bl2) {
            IlvPoint[] ilvPointArray2 = IlvGraphicUtil.a(ilvPointArray, n, f, bl);
            return IlvGraphicUtil.PointInBezier(ilvPoint, ilvPointArray2, c, f2, n2, n3, ilvTransformer);
        }
    }

    public static boolean PointInBezier(IlvPoint ilvPoint, IlvPoint[] ilvPointArray, int n, float f, int n2, int n3, IlvTransformer ilvTransformer) {
        return IlvBezier.a(ilvPoint, ilvPointArray, n, ilvTransformer, f, n2, n3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void DrawClosedBezier(Graphics graphics, IlvPoint[] ilvPointArray, int n, boolean bl, float f, float f2, int n2, int n3, float[] fArray, IlvTransformer ilvTransformer) {
        block5: {
            block4: {
                if (n <= 2) break block4;
                if (f != -1.0f) break block5;
            }
            IlvGraphicUtil.DrawClosedBezier(graphics, ilvPointArray, n, f2, n2, n3, fArray, ilvTransformer);
            return;
        }
        Boolean bl2 = g;
        synchronized (bl2) {
            IlvPoint[] ilvPointArray2 = IlvGraphicUtil.a(ilvPointArray, n, f, bl);
            IlvGraphicUtil.DrawClosedBezier(graphics, ilvPointArray2, c, f2, n2, n3, fArray, ilvTransformer);
            return;
        }
    }

    public static void DrawClosedBezier(Graphics graphics, IlvPoint[] ilvPointArray, int n, float f, int n2, int n3, float[] fArray, IlvTransformer ilvTransformer) {
        IlvGraphicUtil.a(graphics, ilvPointArray, n, f, n2, n3, fArray, ilvTransformer, false);
    }

    private static void a(Graphics graphics, IlvPoint[] ilvPointArray, int n, float f, int n2, int n3, float[] fArray, IlvTransformer ilvTransformer, boolean bl) {
        boolean bl2;
        boolean bl3;
        if (n < 2) {
            return;
        }
        if (ilvTransformer != null && !ilvTransformer.isIdentity()) {
            f = (float)((double)f * ilvTransformer.zoomFactor());
            fArray = IlvGraphicUtil.a(fArray, ilvTransformer);
        }
        if (!(bl3 = IlvGraphicUtil.isPrinting(graphics)) && f < 1.0f) {
            f = 1.0f;
        }
        IlvPoint[] ilvPointArray2 = ilvPointArray;
        Graphics2D graphics2D = (Graphics2D)graphics;
        Stroke stroke = null;
        if (bl3) {
            bl2 = !bl;
        } else {
            if (f < 1.0f) {
                f = 1.0f;
            }
            boolean bl4 = bl2 = !bl && (f > 1.0f || fArray != null);
        }
        if (bl2) {
            n2 = IlvGraphicUtil.c(n2);
            n3 = IlvGraphicUtil.d(n3);
            stroke = graphics2D.getStroke();
            graphics2D.setStroke(new BasicStroke(f, n3, n2, j, fArray, 0.0f));
        }
        if (Spline2D.g == null) {
            Spline2D.g = new Spline2D();
        }
        Spline2D.g.setValues(ilvPointArray2, n, true, ilvTransformer, bl3);
        if (bl) {
            graphics2D.fill(Spline2D.g);
        } else {
            graphics2D.draw(Spline2D.g);
        }
        if (bl2) {
            graphics2D.setStroke(stroke);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void ClosedBezierBoundingBox(IlvRect ilvRect, IlvPoint[] ilvPointArray, int n, boolean bl, float f, float f2, int n2, int n3, IlvTransformer ilvTransformer) {
        block5: {
            block4: {
                if (n <= 2) break block4;
                if (f != -1.0f) break block5;
            }
            IlvGraphicUtil.ClosedBezierBoundingBox(ilvRect, ilvPointArray, n, f2, n2, n3, ilvTransformer);
            return;
        }
        Boolean bl2 = g;
        synchronized (bl2) {
            IlvPoint[] ilvPointArray2 = IlvGraphicUtil.a(ilvPointArray, n, f, bl);
            IlvGraphicUtil.ClosedBezierBoundingBox(ilvRect, ilvPointArray2, c, f2, n2, n3, ilvTransformer);
            return;
        }
    }

    public static void ClosedBezierBoundingBox(IlvRect ilvRect, IlvPoint[] ilvPointArray, int n, float f, int n2, int n3, IlvTransformer ilvTransformer) {
        IlvBezier.ClosedBezierBoundingBox(ilvRect, ilvPointArray, n, ilvTransformer, f, n2, n3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean PointInClosedBezier(IlvPoint ilvPoint, IlvPoint[] ilvPointArray, int n, boolean bl, float f, float f2, int n2, int n3, IlvTransformer ilvTransformer) {
        block6: {
            block5: {
                if (n <= 2) break block5;
                if (f != -1.0f) break block6;
            }
            return IlvGraphicUtil.PointInClosedBezier(ilvPoint, ilvPointArray, n, f2, n2, n3, ilvTransformer);
        }
        Boolean bl2 = g;
        synchronized (bl2) {
            IlvPoint[] ilvPointArray2 = IlvGraphicUtil.a(ilvPointArray, n, f, bl);
            return IlvGraphicUtil.PointInClosedBezier(ilvPoint, ilvPointArray2, c, f2, n2, n3, ilvTransformer);
        }
    }

    public static boolean PointInClosedBezier(IlvPoint ilvPoint, IlvPoint[] ilvPointArray, int n, float f, int n2, int n3, IlvTransformer ilvTransformer) {
        return IlvBezier.b(ilvPoint, ilvPointArray, n, ilvTransformer, f, n2, n3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void FillBezier(Graphics graphics, IlvPoint[] ilvPointArray, int n, boolean bl, float f, IlvTransformer ilvTransformer) {
        block5: {
            block4: {
                if (n <= 2) break block4;
                if (f != -1.0f) break block5;
            }
            IlvGraphicUtil.FillBezier(graphics, ilvPointArray, n, ilvTransformer);
            return;
        }
        Boolean bl2 = g;
        synchronized (bl2) {
            IlvPoint[] ilvPointArray2 = IlvGraphicUtil.a(ilvPointArray, n, f, bl);
            IlvGraphicUtil.FillBezier(graphics, ilvPointArray2, c, ilvTransformer);
            return;
        }
    }

    public static void FillBezier(Graphics graphics, IlvPoint[] ilvPointArray, int n, IlvTransformer ilvTransformer) {
        IlvGraphicUtil.a(graphics, ilvPointArray, n, 1.0f, 0, 0, null, ilvTransformer, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean PointInFilledBezier(IlvPoint ilvPoint, IlvPoint[] ilvPointArray, int n, boolean bl, float f, IlvTransformer ilvTransformer) {
        block6: {
            block5: {
                if (n <= 2) break block5;
                if (f != -1.0f) break block6;
            }
            return IlvGraphicUtil.PointInFilledBezier(ilvPoint, ilvPointArray, n, ilvTransformer);
        }
        Boolean bl2 = g;
        synchronized (bl2) {
            IlvPoint[] ilvPointArray2 = IlvGraphicUtil.a(ilvPointArray, n, f, bl);
            return IlvGraphicUtil.PointInFilledBezier(ilvPoint, ilvPointArray2, c, ilvTransformer);
        }
    }

    public static boolean PointInFilledBezier(IlvPoint ilvPoint, IlvPoint[] ilvPointArray, int n, IlvTransformer ilvTransformer) {
        return IlvBezier.PointInFilledBezier(ilvPoint, ilvPointArray, n, ilvTransformer);
    }

    private static IlvPoint[] a(IlvPoint[] ilvPointArray, int n, float f, boolean bl) {
        if (f != -2.0f) {
            b = IlvGraphicUtil.GetSmoothSpline(ilvPointArray, n, f, bl, b);
            if (n > 2) {
                c = (n - 2) * 3 + 1;
                if (bl) {
                    ++c;
                }
            } else {
                c = n;
            }
        } else {
            d = IlvGraphicUtil.a(d, n);
            b = IlvGraphicUtil.GetAutoSmoothSpline(ilvPointArray, n, bl, b, d, e);
            c = e[0];
        }
        return b;
    }

    public static IlvPoint[] GetSmoothSpline(IlvPoint[] ilvPointArray, int n, float f, boolean bl, IlvPoint[] ilvPointArray2) {
        if (n <= 2) {
            ilvPointArray2 = IlvGraphicUtil.a(ilvPointArray2, n);
            for (int i = 0; i < n; ++i) {
                ilvPointArray2[i].move(ilvPointArray[i].x, ilvPointArray[i].y);
            }
            return ilvPointArray2;
        }
        int n2 = (n - 2) * 3 + 1;
        if (bl) {
            ++n2;
        }
        float f2 = 1.125f - 0.5f * f;
        float f3 = 1.0f - f2;
        ilvPointArray2 = IlvGraphicUtil.a(ilvPointArray2, n2);
        ilvPointArray2[0].move(ilvPointArray[0].x, ilvPointArray[0].y);
        int n3 = 1;
        int n4 = 1;
        while (n3 < n - 1) {
            ilvPointArray2[n4++].move(f2 * ilvPointArray[n3].x + f3 * ilvPointArray[n3 - 1].x, f2 * ilvPointArray[n3].y + f3 * ilvPointArray[n3 - 1].y);
            ilvPointArray2[n4++].move(f2 * ilvPointArray[n3].x + f3 * ilvPointArray[n3 + 1].x, f2 * ilvPointArray[n3].y + f3 * ilvPointArray[n3 + 1].y);
            if (++n3 == n - 1) {
                if (!bl) {
                    ilvPointArray2[n4++].move(ilvPointArray[n3].x, ilvPointArray[n3].y);
                }
                ++n3;
                continue;
            }
            int n5 = n4++;
            ilvPointArray2[n5].move(0.5f * (ilvPointArray[n3 - 1].x + ilvPointArray[n3].x), 0.5f * (ilvPointArray[n3 - 1].y + ilvPointArray[n3].y));
        }
        n3 = n - 1;
        if (bl && n3 > 0) {
            int n6 = n4++;
            ilvPointArray2[n6].move(0.5f * (ilvPointArray[n3 - 1].x + ilvPointArray[n3].x), 0.5f * (ilvPointArray[n3 - 1].y + ilvPointArray[n3].y));
            ilvPointArray2[n4++].move(ilvPointArray[n3].x, ilvPointArray[n3].y);
        }
        return ilvPointArray2;
    }

    public static IlvPoint[] GetSmoothSplineHandlesFromBends(IlvPoint[] ilvPointArray, int n, float f, boolean bl, IlvPoint[] ilvPointArray2) {
        int n2;
        ilvPointArray2 = IlvGraphicUtil.a(ilvPointArray2, n);
        if (n <= 2) {
            for (int i = 0; i < n; ++i) {
                ilvPointArray2[i].move(ilvPointArray[i].x, ilvPointArray[i].y);
            }
            return ilvPointArray2;
        }
        ilvPointArray2[0].move(ilvPointArray[0].x, ilvPointArray[0].y);
        float f2 = 1.125f - 0.5f * f;
        for (n2 = 1; n2 < n - 1; ++n2) {
            IlvPoint ilvPoint = ilvPointArray[n2 - 1];
            IlvPoint ilvPoint2 = ilvPointArray[n2 + 1];
            IlvPoint ilvPoint3 = ilvPointArray[n2];
            float f3 = n2 == 1 ? 0.0f : 0.5f;
            float f4 = n2 == n - 2 ? (bl ? 0.5f : 0.0f) : 0.5f;
            float f5 = 0.5f - (f3 + 3.0f * f2) / 8.0f;
            float f6 = 0.5f - (f4 + 3.0f * f2) / 8.0f;
            float f7 = 0.75f * f2 + (f3 + f4) / 8.0f;
            ilvPointArray2[n2].move(f5 * ilvPoint.x + f6 * ilvPoint2.x + f7 * ilvPoint3.x, f5 * ilvPoint.y + f6 * ilvPoint2.y + f7 * ilvPoint3.y);
        }
        n2 = n - 1;
        ilvPointArray2[n2].move(ilvPointArray[n2].x, ilvPointArray[n2].y);
        return ilvPointArray2;
    }

    public static IlvPoint GetSmoothSplineHandleFromBend(int n, IlvPoint[] ilvPointArray, int n2, float f, boolean bl) {
        if (n == 0 || n == n2 - 1) {
            return new IlvPoint(ilvPointArray[n]);
        }
        float f2 = 1.125f - 0.5f * f;
        float f3 = 0.5f;
        if (n == 1) {
            f3 = 0.0f;
        }
        float f4 = 0.5f;
        if (n == n2 - 2 && !bl) {
            f4 = 0.0f;
        }
        float f5 = 0.5f - (f3 + 3.0f * f2) / 8.0f;
        float f6 = 0.5f - (f4 + 3.0f * f2) / 8.0f;
        float f7 = 0.75f * f2 + (f3 + f4) / 8.0f;
        IlvPoint ilvPoint = ilvPointArray[n - 1];
        IlvPoint ilvPoint2 = ilvPointArray[n + 1];
        IlvPoint ilvPoint3 = ilvPointArray[n];
        return new IlvPoint(f5 * ilvPoint.x + f6 * ilvPoint2.x + f7 * ilvPoint3.x, f5 * ilvPoint.y + f6 * ilvPoint2.y + f7 * ilvPoint3.y);
    }

    public static IlvPoint GetSmoothSplineBendFromHandle(int n, IlvPoint ilvPoint, IlvPoint[] ilvPointArray, int n2, float f, boolean bl) {
        if (n == 0 || n == n2 - 1) {
            return new IlvPoint(ilvPoint);
        }
        float f2 = 1.125f - 0.5f * f;
        float f3 = 0.5f;
        if (n == 1) {
            f3 = 0.0f;
        }
        float f4 = 0.5f;
        if (n == n2 - 2 && !bl) {
            f4 = 0.0f;
        }
        float f5 = 0.5f - (f3 + 3.0f * f2) / 8.0f;
        float f6 = 0.5f - (f4 + 3.0f * f2) / 8.0f;
        float f7 = 0.75f * f2 + (f3 + f4) / 8.0f;
        IlvPoint ilvPoint2 = ilvPointArray[n - 1];
        IlvPoint ilvPoint3 = ilvPointArray[n + 1];
        IlvPoint ilvPoint4 = ilvPoint;
        return new IlvPoint((ilvPoint4.x - f5 * ilvPoint2.x - f6 * ilvPoint3.x) / f7, (ilvPoint4.y - f5 * ilvPoint2.y - f6 * ilvPoint3.y) / f7);
    }

    public static IlvPoint[] GetAutoSmoothSpline(IlvPoint[] ilvPointArray, int n, boolean bl, IlvPoint[] ilvPointArray2, int[] nArray, int[] nArray2) {
        if (n <= 2) {
            nArray2[0] = n;
            ilvPointArray2 = IlvGraphicUtil.a(ilvPointArray2, n);
            for (int i = 0; i < n; ++i) {
                ilvPointArray2[i].move(ilvPointArray[i].x, ilvPointArray[i].y);
            }
            return ilvPointArray2;
        }
        nArray = IlvGraphicUtil.a(ilvPointArray, n, nArray);
        int n2 = 0;
        int n3 = 0;
        while (n3 < n - 1) {
            IlvPoint ilvPoint;
            IlvPoint ilvPoint2;
            int n4;
            int n5 = 0;
            for (n4 = n3 + 1; n4 < n && nArray[n4] != 1; ++n4) {
                ++n5;
            }
            n2 = n3 == 0 ? (n4 == n - 1 ? (n2 += 2) : (n5 >= 1 ? (n2 += 5) : (n2 += 2))) : (n4 == n - 1 ? (n5 >= 1 ? (n2 += 3) : (n2 += 2 + (bl ? 1 : 0))) : (n5 >= 2 ? ((ilvPoint2 = ilvPointArray[n3 + 1]).equals(ilvPoint = ilvPointArray[n4 - 1]) ? (n2 += 3) : (n2 += 6)) : (n5 == 1 ? (n2 += 3) : (n2 += 3))));
            n3 = n4;
        }
        ilvPointArray2 = IlvGraphicUtil.a(ilvPointArray2, n2);
        float f = 0.675f;
        float f2 = 1.0f - f;
        int n6 = 0;
        n3 = 0;
        while (n3 < n - 1) {
            float f3;
            int n7;
            int n8 = 0;
            for (n7 = n3 + 1; n7 < n && nArray[n7] != 1; ++n7) {
                ++n8;
            }
            if (n3 == 0) {
                ilvPointArray2[n6++].move(ilvPointArray[n3].x, ilvPointArray[n3].y);
                if (n7 == n - 1) {
                    ilvPointArray2[n6++].move(ilvPointArray[n7].x, ilvPointArray[n7].y);
                } else if (n8 >= 1) {
                    IlvPoint ilvPoint = ilvPointArray[n7 - 1];
                    int n9 = n6++;
                    ilvPointArray2[n9].move(0.7f * ilvPointArray[n3].x + 0.3f * ilvPoint.x, 0.7f * ilvPointArray[n3].y + 0.3f * ilvPoint.y);
                    int n10 = n6++;
                    ilvPointArray2[n10].move(0.3f * ilvPointArray[n3].x + 0.7f * ilvPoint.x, 0.3f * ilvPointArray[n3].y + 0.7f * ilvPoint.y);
                    ilvPointArray2[n6++].move(ilvPoint.x, ilvPoint.y);
                    ilvPointArray2[n6++].move(f * ilvPointArray[n7].x + f2 * ilvPoint.x, f * ilvPointArray[n7].y + f2 * ilvPoint.y);
                } else {
                    ilvPointArray2[n6++].move(f * ilvPointArray[n7].x + f2 * ilvPointArray[n3].x, f * ilvPointArray[n7].y + f2 * ilvPointArray[n3].y);
                }
            } else if (n7 == n - 1) {
                if (n8 >= 1) {
                    IlvPoint ilvPoint = ilvPointArray[n7 - 1];
                    ilvPointArray2[n6++].move(f * ilvPointArray[n3].x + f2 * ilvPoint.x, f * ilvPointArray[n3].y + f2 * ilvPoint.y);
                    ilvPointArray2[n6++].move(ilvPoint.x, ilvPoint.y);
                    ilvPointArray2[n6++].move(ilvPointArray[n7].x, ilvPointArray[n7].y);
                } else {
                    if (bl) {
                        float f4 = 0.5f * (ilvPointArray[n3].x + ilvPointArray[n7].x);
                        f3 = 0.5f * (ilvPointArray[n3].y + ilvPointArray[n7].y);
                        ilvPointArray2[n6++].move(f * ilvPointArray[n3].x + f2 * f4, f * ilvPointArray[n3].y + f2 * f3);
                        ilvPointArray2[n6++].move(f4, f3);
                    } else {
                        IlvPoint ilvPoint = ilvPointArray[n7];
                        ilvPointArray2[n6++].move(f * ilvPointArray[n3].x + f2 * ilvPoint.x, f * ilvPointArray[n3].y + f2 * ilvPoint.y);
                    }
                    ilvPointArray2[n6++].move(ilvPointArray[n7].x, ilvPointArray[n7].y);
                }
            } else if (n8 >= 2) {
                IlvPoint ilvPoint = ilvPointArray[n3 + 1];
                IlvPoint ilvPoint3 = ilvPointArray[n7 - 1];
                ilvPointArray2[n6++].move(f * ilvPointArray[n3].x + f2 * ilvPoint.x, f * ilvPointArray[n3].y + f2 * ilvPoint.y);
                ilvPointArray2[n6++].move(ilvPoint.x, ilvPoint.y);
                if (!ilvPoint.equals(ilvPoint3)) {
                    int n11 = n6++;
                    ilvPointArray2[n11].move(0.7f * ilvPoint.x + 0.3f * ilvPoint3.x, 0.7f * ilvPoint.y + 0.3f * ilvPoint3.y);
                    int n12 = n6++;
                    ilvPointArray2[n12].move(0.3f * ilvPoint.x + 0.7f * ilvPoint3.x, 0.3f * ilvPoint.y + 0.7f * ilvPoint3.y);
                    ilvPointArray2[n6++].move(ilvPoint3.x, ilvPoint3.y);
                }
                ilvPointArray2[n6++].move(f * ilvPointArray[n7].x + f2 * ilvPoint3.x, f * ilvPointArray[n7].y + f2 * ilvPoint3.y);
            } else if (n8 == 1) {
                IlvPoint ilvPoint = ilvPointArray[n7 - 1];
                ilvPointArray2[n6++].move(f * ilvPointArray[n3].x + f2 * ilvPoint.x, f * ilvPointArray[n3].y + f2 * ilvPoint.y);
                ilvPointArray2[n6++].move(ilvPoint.x, ilvPoint.y);
                ilvPointArray2[n6++].move(f * ilvPointArray[n7].x + f2 * ilvPoint.x, f * ilvPointArray[n7].y + f2 * ilvPoint.y);
            } else {
                float f5 = 0.5f * (ilvPointArray[n3].x + ilvPointArray[n7].x);
                f3 = 0.5f * (ilvPointArray[n3].y + ilvPointArray[n7].y);
                ilvPointArray2[n6++].move(f * ilvPointArray[n3].x + f2 * f5, f * ilvPointArray[n3].y + f2 * f3);
                ilvPointArray2[n6++].move(f5, f3);
                ilvPointArray2[n6++].move(f * ilvPointArray[n7].x + f2 * f5, f * ilvPointArray[n7].y + f2 * f3);
            }
            n3 = n7;
        }
        nArray2[0] = n2;
        return ilvPointArray2;
    }

    private static int[] a(IlvPoint[] ilvPointArray, int n, int[] nArray) {
        nArray = IlvGraphicUtil.a(nArray, n);
        nArray[0] = 1;
        nArray[n - 1] = 1;
        for (int i = 1; i < n - 1; ++i) {
            float f;
            IlvPoint ilvPoint = ilvPointArray[i];
            IlvPoint ilvPoint2 = ilvPointArray[i - 1];
            if (ilvPoint.equals(ilvPoint2)) {
                nArray[i] = 2;
                continue;
            }
            IlvPoint ilvPoint3 = ilvPointArray[i + 1];
            float f2 = ilvPoint3.x - ilvPoint2.x;
            float f3 = ilvPoint3.y - ilvPoint2.y;
            if (f2 == 0.0f && f3 == 0.0f) {
                nArray[i] = 1;
                continue;
            }
            if (Math.abs(f2) > Math.abs(f3)) {
                f = (ilvPoint.x - ilvPoint2.x) / f2;
                if (f <= 0.0f || f >= 1.0f) {
                    nArray[i] = 1;
                    continue;
                }
                if ((double)Math.abs(ilvPoint.y - ilvPoint2.y - f * f3) < 0.1) {
                    nArray[i] = 2;
                    continue;
                }
                nArray[i] = 1;
                continue;
            }
            f = (ilvPoint.y - ilvPoint2.y) / f3;
            nArray[i] = f <= 0.0f || f >= 1.0f ? 1 : ((double)Math.abs(ilvPoint.x - ilvPoint2.x - f * f2) < 0.1 ? 2 : 1);
        }
        return nArray;
    }

    private static IlvPoint[] a(IlvPoint[] ilvPointArray, int n) {
        if (ilvPointArray == null) {
            ilvPointArray = new IlvPoint[n];
            for (int i = 0; i < n; ++i) {
                ilvPointArray[i] = new IlvPoint();
            }
        } else if (n > ilvPointArray.length) {
            IlvPoint[] ilvPointArray2 = new IlvPoint[n];
            System.arraycopy(ilvPointArray, 0, ilvPointArray2, 0, ilvPointArray.length);
            for (int i = ilvPointArray.length; i < n; ++i) {
                ilvPointArray2[i] = new IlvPoint();
            }
            ilvPointArray = ilvPointArray2;
        }
        return ilvPointArray;
    }

    private static int[] a(int[] nArray, int n) {
        if (nArray == null || nArray.length < n) {
            nArray = new int[n];
        }
        return nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void FillPolygon(Graphics graphics, IlvPoint[] ilvPointArray, int n, IlvTransformer ilvTransformer) {
        if (ilvPointArray == null || n < 2) {
            return;
        }
        if (IlvGraphicUtil.isPrinting(graphics)) {
            if (Polyline2D.f == null) {
                Polyline2D.f = new Polyline2D();
            }
            Polyline2D.f.setValues(ilvPointArray, n, true, ilvTransformer);
            ((Graphics2D)graphics).fill(Polyline2D.f);
        } else {
            Boolean bl = g;
            synchronized (bl) {
                int n2 = 0;
                int[] nArray = IlvGraphicUtil.a(n);
                int[] nArray2 = IlvGraphicUtil.b(n);
                for (int i = 0; i < n; ++i) {
                    IlvGraphicUtil.f.x = ilvPointArray[i].x;
                    IlvGraphicUtil.f.y = ilvPointArray[i].y;
                    if (ilvTransformer != null) {
                        ilvTransformer.applyFloor(f);
                    } else {
                        f.floor();
                    }
                    int n3 = (int)IlvGraphicUtil.f.x;
                    int n4 = (int)IlvGraphicUtil.f.y;
                    if (i != 0 && n3 == nArray[n2 - 1] && n4 == nArray2[n2 - 1]) continue;
                    nArray[n2] = n3;
                    nArray2[n2] = n4;
                    ++n2;
                }
                graphics.fillPolygon(nArray, nArray2, n2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void DrawPolygon(Graphics graphics, IlvPoint[] ilvPointArray, int n, IlvTransformer ilvTransformer) {
        if (ilvPointArray == null || n < 2) {
            return;
        }
        if (IlvGraphicUtil.isPrinting(graphics)) {
            if (Polyline2D.f == null) {
                Polyline2D.f = new Polyline2D();
            }
            Polyline2D.f.setValues(ilvPointArray, n, true, ilvTransformer);
            ((Graphics2D)graphics).draw(Polyline2D.f);
        } else {
            Boolean bl = g;
            synchronized (bl) {
                int n2 = 0;
                int[] nArray = IlvGraphicUtil.a(n);
                int[] nArray2 = IlvGraphicUtil.b(n);
                for (int i = 0; i < n; ++i) {
                    IlvGraphicUtil.f.x = ilvPointArray[i].x;
                    IlvGraphicUtil.f.y = ilvPointArray[i].y;
                    if (ilvTransformer != null) {
                        ilvTransformer.applyFloor(f);
                    } else {
                        f.floor();
                    }
                    int n3 = (int)IlvGraphicUtil.f.x;
                    int n4 = (int)IlvGraphicUtil.f.y;
                    if (i != 0 && n3 == nArray[n2 - 1] && n4 == nArray2[n2 - 1]) continue;
                    nArray[n2] = n3;
                    nArray2[n2] = n4;
                    ++n2;
                }
                graphics.drawPolygon(nArray, nArray2, n2);
            }
        }
    }

    public static boolean PointInPolygon(IlvPoint ilvPoint, IlvPoint[] ilvPointArray, int n, IlvTransformer ilvTransformer) {
        return IlvGraphicUtil.PointInPolygon(ilvPoint, ilvPointArray, n, ilvTransformer, true);
    }

    public static boolean PointInPolygon(IlvPoint ilvPoint, IlvPoint[] ilvPointArray, int n, IlvTransformer ilvTransformer, boolean bl) {
        if (bl) {
            IlvPoint ilvPoint2 = new IlvPoint(ilvPointArray[0].x, ilvPointArray[0].y);
            IlvPoint ilvPoint3 = new IlvPoint();
            if (ilvTransformer != null) {
                ilvTransformer.apply(ilvPoint2);
            }
            int n2 = 0;
            for (int i = 1; i < n; ++i) {
                ilvPoint3.move(ilvPointArray[i].x, ilvPointArray[i].y);
                if (ilvTransformer != null) {
                    ilvTransformer.apply(ilvPoint3);
                }
                if (IlvUtility.IntersectHorizontal(ilvPoint, ilvPoint2, ilvPoint3)) {
                    ++n2;
                }
                if (i + 1 >= n) continue;
                IlvPoint ilvPoint4 = ilvPoint2;
                ilvPoint2 = ilvPoint3;
                ilvPoint3 = ilvPoint4;
            }
            ilvPoint2.move(ilvPointArray[0].x, ilvPointArray[0].y);
            if (ilvTransformer != null) {
                ilvTransformer.apply(ilvPoint2);
            }
            if (IlvUtility.IntersectHorizontal(ilvPoint.x, ilvPoint.y, ilvPoint2.x, ilvPoint2.y, ilvPoint3.x, ilvPoint3.y)) {
                ++n2;
            }
            return n2 != 0 && (n2 & 1) != 0;
        }
        if (n >= 1) {
            if (ilvTransformer == null || ilvTransformer.isIdentity()) {
                for (int i = 0; i < n - 1; ++i) {
                    if (!IlvUtil.PointInLine(ilvPoint, ilvPointArray[i], ilvPointArray[i + 1], false)) continue;
                    return true;
                }
                return IlvUtil.PointInLine(ilvPoint, ilvPointArray[n - 1], ilvPointArray[0], false);
            }
            IlvPoint ilvPoint5 = new IlvPoint(ilvPointArray[0].x, ilvPointArray[0].y);
            IlvPoint ilvPoint6 = new IlvPoint();
            ilvTransformer.apply(ilvPoint5);
            for (int i = 0; i < n - 1; ++i) {
                ilvPoint6.move(ilvPointArray[i + 1].x, ilvPointArray[i + 1].y);
                ilvTransformer.apply(ilvPoint6);
                if (IlvUtil.PointInLine(ilvPoint, ilvPoint5, ilvPoint6, false)) {
                    return true;
                }
                IlvPoint ilvPoint7 = ilvPoint5;
                ilvPoint5 = ilvPoint6;
                ilvPoint6 = ilvPoint7;
            }
            ilvPoint6.move(ilvPointArray[0].x, ilvPointArray[0].y);
            ilvTransformer.apply(ilvPoint6);
            return IlvUtil.PointInLine(ilvPoint, ilvPoint5, ilvPoint6, false);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void FillOutlinedPolygon(Graphics graphics, IlvPoint[] ilvPointArray, int n, Color color, Color color2, IlvTransformer ilvTransformer) {
        if (ilvPointArray == null || n < 2) {
            return;
        }
        if (IlvGraphicUtil.isPrinting(graphics)) {
            if (Polyline2D.f == null) {
                Polyline2D.f = new Polyline2D();
            }
            Polyline2D.f.setValues(ilvPointArray, n, true, ilvTransformer);
            graphics.setColor(color);
            ((Graphics2D)graphics).fill(Polyline2D.f);
            graphics.setColor(color2);
            ((Graphics2D)graphics).draw(Polyline2D.f);
        } else {
            Boolean bl = g;
            synchronized (bl) {
                int n2 = 0;
                int[] nArray = IlvGraphicUtil.a(n);
                int[] nArray2 = IlvGraphicUtil.b(n);
                for (int i = 0; i < n; ++i) {
                    IlvGraphicUtil.f.x = ilvPointArray[i].x;
                    IlvGraphicUtil.f.y = ilvPointArray[i].y;
                    if (ilvTransformer != null) {
                        ilvTransformer.applyFloor(f);
                    } else {
                        f.floor();
                    }
                    int n3 = (int)IlvGraphicUtil.f.x;
                    int n4 = (int)IlvGraphicUtil.f.y;
                    if (i != 0 && n3 == nArray[n2 - 1] && n4 == nArray2[n2 - 1]) continue;
                    nArray[n2] = n3;
                    nArray2[n2] = n4;
                    ++n2;
                }
                graphics.setColor(color);
                graphics.fillPolygon(nArray, nArray2, n2);
                graphics.setColor(color2);
                graphics.drawPolygon(nArray, nArray2, n2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void DrawString(Graphics graphics, String string, int n, int n2, boolean bl) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (bl) {
            IlvGraphicUtil.a(graphics2D);
        }
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        LineMetrics lineMetrics = graphics2D.getFont().getLineMetrics(string, fontRenderContext);
        float f = lineMetrics.getDescent();
        if (IlvGraphicUtil.isPrinting(graphics)) {
            Graphics2D graphics2D2 = (Graphics2D)graphics2D.create();
            try {
                AffineTransform affineTransform = (AffineTransform)graphics2D2.getRenderingHint(IlvPrintUtil.KEY_PRINTING_TRANSFORM);
                if (affineTransform != null) {
                    graphics2D2.translate((double)n, (float)n2 - f);
                    graphics2D2.scale(1.0 / affineTransform.getScaleX(), 1.0 / affineTransform.getScaleY());
                    graphics2D2.translate((double)(-n), (float)(-n2) + f);
                }
                graphics2D2.drawString(string, (float)n, (float)n2 - f);
            }
            finally {
                graphics2D2.dispose();
            }
        } else {
            graphics2D.drawString(string, (float)n, (float)n2 - f);
        }
        if (bl) {
            IlvGraphicUtil.b(graphics2D);
        }
    }

    public static void DrawString(IlvGraphic ilvGraphic, Graphics graphics, String string, int n, int n2, boolean bl) {
        IlvGraphicUtil.DrawString(graphics, IlvBidiUtil.getDirectedString(string, ilvGraphic.getResolvedBaseTextDirection(), ilvGraphic.getComponentOrientation()), n, n2, bl);
    }

    public static IlvRect GetStringBounds(String string, Font font, boolean bl) {
        FontRenderContext fontRenderContext;
        block3: {
            block2: {
                fontRenderContext = new FontRenderContext(null, bl, false);
                if (string == null) break block2;
                if (string.length() != 0) break block3;
            }
            LineMetrics lineMetrics = font.getLineMetrics("", fontRenderContext);
            return new IlvRect(0.0f, 0.0f, 0.0f, lineMetrics.getAscent() + lineMetrics.getDescent());
        }
        LineMetrics lineMetrics = font.getLineMetrics(string, fontRenderContext);
        Rectangle2D rectangle2D = font.getStringBounds(string, fontRenderContext);
        return new IlvRect(0.0f, 0.0f, (float)rectangle2D.getWidth(), lineMetrics.getAscent() + lineMetrics.getDescent());
    }

    public static IlvRect GetStringBounds(IlvGraphic ilvGraphic, String string, Font font, boolean bl) {
        return IlvGraphicUtil.GetStringBounds(IlvBidiUtil.getDirectedString(string, ilvGraphic.getResolvedBaseTextDirection(), ilvGraphic.getComponentOrientation()), font, bl);
    }

    public static float GetFontDescent(String string, Font font, boolean bl) {
        FontRenderContext fontRenderContext = new FontRenderContext(null, bl, false);
        return font.getLineMetrics(string, fontRenderContext).getDescent();
    }

    public static void StartAntiAliasing(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
    }

    public static void StopAntiAliasing(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
    }

    public static int GetAlpha(Color color) {
        return color.getAlpha();
    }

    public static Color MakeColor(int n, int n2, int n3, int n4) {
        return new Color(n, n2, n3, n4);
    }

    public static Color MakeColor(int n) {
        return new Color(n, true);
    }

    public static boolean PointInShape(IlvPoint ilvPoint, Shape shape) {
        return shape.contains(ilvPoint);
    }

    public static IlvRect RectBBox(IlvRect ilvRect, IlvTransformer ilvTransformer) {
        if (!ilvTransformer.isIdentity()) {
            ilvTransformer.boundingBox(ilvRect, false);
        }
        return ilvRect;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void DrawImage(Graphics graphics, IlvRect ilvRect, Image image, IlvTransformer ilvTransformer, ImageObserver imageObserver, boolean bl) {
        if (image == null) {
            if (ilvTransformer != null && !ilvTransformer.isIdentity()) {
                ilvTransformer.applyFloor(ilvRect);
            } else {
                ilvRect.floor();
            }
            graphics.setColor(Color.gray);
            graphics.fillRect((int)ilvRect.x, (int)ilvRect.y, (int)ilvRect.width, (int)ilvRect.height);
        } else {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Object object = null;
            if (bl) {
                object = graphics2D.getRenderingHint(RenderingHints.KEY_RENDERING);
                graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            }
            int n = image.getWidth(null);
            int n2 = image.getHeight(null);
            if (ilvTransformer == null || ilvTransformer.isIdentity() || ilvTransformer.isTranslation() || n == -1 || n2 == -1) {
                if (ilvTransformer != null && !ilvTransformer.isIdentity()) {
                    ilvTransformer.applyFloor(ilvRect);
                } else {
                    ilvRect.floor();
                }
                graphics2D.drawImage(image, (int)ilvRect.x, (int)ilvRect.y, (int)ilvRect.width, (int)ilvRect.height, imageObserver);
            } else {
                Object object2 = IlvGraphicUtil.n;
                synchronized (object2) {
                    m.resize(n, n2);
                    IlvTransformer.computeTransformer(m, ilvRect, l);
                    l.compose(ilvTransformer);
                    if (a) {
                        IlvGraphicUtil.a(l, n, n2);
                    }
                    k.setTransform(l.getx11(), l.getx21(), l.getx12(), l.getx22(), l.getx0(), l.gety0());
                    graphics2D.drawImage(image, k, imageObserver);
                }
            }
            if (bl) {
                graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, object);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void DrawRenderedImage(Graphics graphics, IlvRect ilvRect, RenderedImage renderedImage, IlvTransformer ilvTransformer, boolean bl) {
        if (renderedImage == null) {
            if (ilvTransformer != null && !ilvTransformer.isIdentity()) {
                ilvTransformer.applyFloor(ilvRect);
            } else {
                ilvRect.floor();
            }
            graphics.setColor(Color.gray);
            graphics.fillRect((int)ilvRect.x, (int)ilvRect.y, (int)ilvRect.width, (int)ilvRect.height);
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        Object object = null;
        if (bl) {
            object = graphics2D.getRenderingHint(RenderingHints.KEY_RENDERING);
            graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        }
        int n = renderedImage.getWidth();
        int n2 = renderedImage.getHeight();
        Object object2 = IlvGraphicUtil.n;
        synchronized (object2) {
            m.resize(n, n2);
            IlvTransformer.computeTransformer(m, ilvRect, l);
            l.compose(ilvTransformer);
            if (a) {
                IlvGraphicUtil.a(l, n, n2);
            }
            k.setTransform(l.getx11(), l.getx21(), l.getx12(), l.getx22(), l.getx0(), l.gety0());
            graphics2D.drawRenderedImage(renderedImage, k);
        }
        if (bl) {
            graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, object);
        }
    }

    private static void a(IlvTransformer ilvTransformer, int n, int n2) {
        double d = IlvGraphicUtil.a(ilvTransformer.getx11(), n, n2);
        double d2 = IlvGraphicUtil.a(ilvTransformer.getx22(), n, n2);
        ilvTransformer.setValues(d, ilvTransformer.getx12(), ilvTransformer.getx21(), d2);
    }

    private static double a(double d, int n, int n2) {
        if (d < 0.0) {
            d = -Math.min(-d, 2000.0);
            if (n <= 32 || n2 <= 32) {
                d = -Math.max(-d, 0.5);
            }
        } else {
            d = Math.min(d, 2000.0);
            if (n <= 32 || n2 <= 32) {
                d = Math.max(d, 0.5);
            }
        }
        return d;
    }

    public static Shape AddClip(Graphics graphics, Shape shape) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Shape shape2 = graphics2D.getClip();
        graphics2D.clip(shape);
        return shape2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Shape CreateTransformedShape(Shape shape, IlvTransformer ilvTransformer) {
        Object object = n;
        synchronized (object) {
            if (ilvTransformer != null && !ilvTransformer.isIdentity()) {
                k.setTransform(ilvTransformer.getx11(), ilvTransformer.getx21(), ilvTransformer.getx12(), ilvTransformer.getx22(), ilvTransformer.getx0(), ilvTransformer.gety0());
                return k.createTransformedShape(shape);
            }
            return shape;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void a(Graphics graphics, IlvPoint[] ilvPointArray, int n, IlvTransformer ilvTransformer) {
        if (ilvPointArray == null || n < 2) {
            return;
        }
        if (IlvGraphicUtil.isPrinting(graphics)) {
            if (Polyline2D.f == null) {
                Polyline2D.f = new Polyline2D();
            }
            Polyline2D.f.setValues(ilvPointArray, n, false, ilvTransformer);
            ((Graphics2D)graphics).draw(Polyline2D.f);
        } else {
            Boolean bl = g;
            synchronized (bl) {
                int n2 = 0;
                int[] nArray = IlvGraphicUtil.a(n);
                int[] nArray2 = IlvGraphicUtil.b(n);
                for (int i = 0; i < n; ++i) {
                    IlvGraphicUtil.f.x = ilvPointArray[i].x;
                    IlvGraphicUtil.f.y = ilvPointArray[i].y;
                    if (ilvTransformer != null) {
                        ilvTransformer.applyFloor(f);
                    } else {
                        f.floor();
                    }
                    int n3 = (int)IlvGraphicUtil.f.x;
                    int n4 = (int)IlvGraphicUtil.f.y;
                    if (i != 0 && n3 == nArray[n2 - 1] && n4 == nArray2[n2 - 1]) continue;
                    nArray[n2] = n3;
                    nArray2[n2] = n4;
                    ++n2;
                }
                if (n2 > 0) {
                    graphics.drawPolyline(nArray, nArray2, n2);
                }
            }
        }
    }

    static boolean a(IlvPoint ilvPoint, IlvPoint[] ilvPointArray, int n, IlvTransformer ilvTransformer, boolean bl) {
        block5: {
            if (n < 2) break block5;
            if (ilvTransformer == null || ilvTransformer.isIdentity()) {
                for (int i = 0; i < n - 1; ++i) {
                    if (!IlvUtil.PointInLine(ilvPoint, ilvPointArray[i], ilvPointArray[i + 1], bl)) continue;
                    return true;
                }
            } else {
                IlvPoint ilvPoint2 = new IlvPoint(ilvPointArray[0].x, ilvPointArray[0].y);
                IlvPoint ilvPoint3 = new IlvPoint();
                ilvTransformer.apply(ilvPoint2);
                for (int i = 0; i < n - 1; ++i) {
                    ilvPoint3.move(ilvPointArray[i + 1].x, ilvPointArray[i + 1].y);
                    ilvTransformer.apply(ilvPoint3);
                    if (IlvUtil.PointInLine(ilvPoint, ilvPoint2, ilvPoint3, bl)) {
                        return true;
                    }
                    IlvPoint ilvPoint4 = ilvPoint2;
                    ilvPoint2 = ilvPoint3;
                    ilvPoint3 = ilvPoint4;
                }
            }
        }
        return false;
    }

    static IlvRect a(IlvPoint[] ilvPointArray, int n, IlvTransformer ilvTransformer) {
        IlvRect ilvRect = new IlvRect();
        IlvUtil.BoundingBox(ilvRect, ilvPointArray, n);
        if (ilvTransformer != null) {
            ilvTransformer.boundingBox(ilvRect, false);
        }
        return ilvRect;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final int[] a(int n) {
        Boolean bl = g;
        synchronized (bl) {
            if (h.length >= n) {
                return h;
            }
            h = new int[n];
            return h;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final int[] b(int n) {
        Boolean bl = g;
        synchronized (bl) {
            if (i.length >= n) {
                return i;
            }
            i = new int[n];
            return i;
        }
    }

    private static int c(int n) {
        switch (n) {
            case 1: {
                n = 0;
                break;
            }
            case 2: {
                n = 1;
                break;
            }
            case 0: {
                n = 2;
            }
        }
        return n;
    }

    private static int d(int n) {
        switch (n) {
            case 0: {
                n = 0;
                break;
            }
            case 1: {
                n = 1;
                break;
            }
            case 2: {
                n = 2;
            }
        }
        return n;
    }

    private static void a(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
    }

    private static void b(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
    }

    public static void SetJViews60LineStyleMode(boolean bl) {
        o = bl;
    }

    public static boolean IsJViews60LineStyleMode() {
        return o;
    }

    private static float[] a(float[] fArray, IlvTransformer ilvTransformer) {
        if (fArray == null) {
            return null;
        }
        double d = ilvTransformer.zoomFactor();
        if (d == 1.0) {
            return fArray;
        }
        int n = fArray.length;
        if (p == null || p.length != n) {
            p = new float[n];
        }
        if (o) {
            for (int i = 0; i < n; ++i) {
                if ((double)fArray[i] * d < 1.0) {
                    return null;
                }
                IlvGraphicUtil.p[i] = (float)(d * (double)fArray[i]);
            }
        } else {
            boolean bl = true;
            boolean bl2 = n % 2 == 1;
            for (int i = 0; i < n; ++i) {
                IlvGraphicUtil.p[i] = (float)(d * (double)fArray[i]);
                if (!bl2 && i % 2 != 1 || !(p[i] >= 1.0f)) continue;
                bl = false;
            }
            if (bl) {
                return null;
            }
        }
        return p;
    }

    public static final IlvPoint[] GetPolyPoints(IlvPolyPointsInterface ilvPolyPointsInterface, IlvTransformer ilvTransformer) {
        int n = ilvPolyPointsInterface.getPointsCardinal();
        IlvPoint[] ilvPointArray = new IlvPoint[n];
        for (int i = 0; i < n; ++i) {
            ilvPointArray[i] = ilvPolyPointsInterface.getPointAt(i, ilvTransformer);
        }
        return ilvPointArray;
    }

    public static IlvGraphicVector startBidiChange(IlvGraphicBag ilvGraphicBag) {
        return IlvGraphic.a(ilvGraphicBag);
    }

    public static void stopBidiChange(IlvGraphicBag ilvGraphicBag, IlvGraphicVector ilvGraphicVector, boolean bl) {
        IlvGraphic.a(ilvGraphicBag, ilvGraphicVector, true, true, bl);
    }

    /*
     * Unable to fully structure code
     */
    static {
        try {
            var0 = System.getProperty("ibm.ilog.tivoli.transformerworkaround");
            if (var0 == null) ** GOTO lbl-1000
            if (var0.equals("true")) {
                v0 = true;
            } else lbl-1000:
            // 2 sources

            {
                v0 = false;
            }
            IlvGraphicUtil.a = v0;
        }
        catch (Exception var0_1) {
            IlvGraphicUtil.a = false;
        }
        IlvGraphicUtil.b = null;
        IlvGraphicUtil.c = 0;
        IlvGraphicUtil.d = null;
        IlvGraphicUtil.e = new int[1];
        IlvGraphicUtil.f = new IlvPoint();
        IlvGraphicUtil.g = new Boolean(true);
        IlvGraphicUtil.h = new int[100];
        IlvGraphicUtil.i = new int[100];
        IlvGraphicUtil.j = (float)(1.0 / Math.tan(0.2617993877991494));
        IlvGraphicUtil.k = new AffineTransform();
        IlvGraphicUtil.l = new IlvTransformer();
        IlvGraphicUtil.m = new IlvRect();
        IlvGraphicUtil.n = new Object();
        IlvGraphicUtil.o = false;
    }
}

