/*
 * Decompiled with CFR 0.152.
 */
package oracle.bm.browse;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import oracle.bm.browse.BrowseTree;
import oracle.bm.browse.CompositeCreator;
import oracle.bm.browse.res.ModelBrowserResources;
import oracle.bm.browse.util.AbstractItemPicker;
import oracle.bm.util.ResourcePicker;
import oracle.bm.util.ui.EnablingJPanel;
import oracle.javatools.columnlayout.LayoutBuilder;
import oracle.javatools.dialogs.MessageDialog;

public class ElementPicker
extends AbstractItemPicker {
    private JTree m_tree;
    private boolean m_createPanelEnabled = true;
    private EnablingJPanel m_createPanel;
    private DefaultComboBoxModel m_typeList;
    private JComboBox m_typeField;
    private JTextField m_nameField;
    private JButton m_newButton;
    private Component m_component;
    private boolean m_isItemSelected = false;

    public ElementPicker(TreeModel model, boolean canMultiSelect, boolean canCreate) {
        this.m_tree = new BrowseTree(model, canMultiSelect);
        this.m_tree.setName("ElementPicker.browsetree");
        this.m_component = new JScrollPane(this.m_tree);
        class TreeListener
        extends MouseAdapter
        implements TreeSelectionListener,
        TreeModelListener {
            TreeListener() {
            }

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                ElementPicker.this.m_isItemSelected = ElementPicker.this.checkItemSelected();
                this.treeUpdated();
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    ElementPicker.this.fireActionPerformed();
                }
            }

            @Override
            public void treeNodesChanged(TreeModelEvent e) {
                this.treeUpdated();
            }

            @Override
            public void treeNodesInserted(TreeModelEvent e) {
                this.treeUpdated();
            }

            @Override
            public void treeNodesRemoved(TreeModelEvent e) {
                this.treeUpdated();
            }

            @Override
            public void treeStructureChanged(TreeModelEvent e) {
                this.treeUpdated();
            }

            private void treeUpdated() {
                ElementPicker.this.firePropertyChange();
                ElementPicker.this.updateCreatePanel();
            }
        }
        TreeListener listener = new TreeListener();
        this.m_tree.addTreeSelectionListener(listener);
        this.m_tree.addMouseListener(listener);
        model.addTreeModelListener(listener);
        this.m_tree.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                TreePath selectionPath = ElementPicker.this.m_tree.getSelectionPath();
                if (selectionPath == null) {
                    for (int i = 0; i < ElementPicker.this.m_tree.getVisibleRowCount(); ++i) {
                        selectionPath = ElementPicker.this.m_tree.getPathForRow(i);
                        if (selectionPath == null || !ElementPicker.this.m_tree.isVisible(selectionPath)) continue;
                        ElementPicker.this.m_tree.setSelectionPath(selectionPath);
                        break;
                    }
                }
            }
        });
        if (canCreate) {
            this.m_createPanel = new EnablingJPanel();
            this.m_createPanel.setBorder(new EmptyBorder(15, 0, 0, 0));
            JLabel typeLabel = new JLabel();
            typeLabel.setName("ElementPicker.typefield");
            this.m_typeList = new DefaultComboBoxModel();
            this.m_typeField = new JComboBox(this.m_typeList);
            typeLabel.setLabelFor(this.m_typeField);
            JLabel nameLabel = new JLabel();
            nameLabel.setName("ElementPicker.namefield");
            this.m_nameField = new JTextField();
            nameLabel.setLabelFor(this.m_nameField);
            this.m_newButton = new JButton();
            this.m_newButton.setName("ElementPicker.newbutton");
            LayoutBuilder builder = new LayoutBuilder();
            builder.setDefaultAnchor(17);
            builder.add((Component)typeLabel, LayoutBuilder.LABEL_INSETS, 1, false, false);
            builder.add((Component)this.m_typeField, LayoutBuilder.CONTROL_INSETS, 1, false, true);
            builder.nl();
            builder.add((Component)nameLabel, LayoutBuilder.LABEL_INSETS, 1, false, false);
            builder.add((Component)this.m_nameField, LayoutBuilder.CONTROL_INSETS, 1, false, true);
            builder.addHGap(10);
            builder.add((Component)this.m_newButton, null, 1, false, false);
            builder.addToPanel((Container)this.m_createPanel);
            final ResourcePicker rp = new ResourcePicker(ModelBrowserResources.getBundle());
            rp.fillComponent(this.m_createPanel);
            JPanel panel = new JPanel(new BorderLayout());
            panel.add(this.m_component, "Center");
            panel.add((Component)this.m_createPanel, "South");
            this.m_component = panel;
            class CreateCompositeAction
            implements ActionListener,
            TreeModelListener,
            DocumentListener {
                private TreePath m_longestPath;

                CreateCompositeAction() {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void actionPerformed(ActionEvent e) {
                    Object node = ElementPicker.this.m_tree.getLastSelectedPathComponent();
                    this.m_longestPath = null;
                    ElementPicker.this.m_tree.getModel().addTreeModelListener(this);
                    try {
                        ((CompositeCreator)node).createComposite(ElementPicker.this.m_typeList.getSelectedItem(), ElementPicker.this.m_nameField.getText());
                        if (this.m_longestPath != null) {
                            ElementPicker.this.m_tree.setSelectionPath(this.m_longestPath);
                            ElementPicker.this.m_nameField.setText("");
                        }
                    }
                    catch (CompositeCreator.CreationFailureException cfe) {
                        MessageDialog.error((Component)ElementPicker.this.m_component, (Object)cfe.getMessage(), (String)rp.getString("CreationFailed.dialogtitle"), (String)cfe.getHelpTag());
                    }
                    finally {
                        ElementPicker.this.m_tree.getModel().removeTreeModelListener(this);
                        if (ElementPicker.this.m_createPanelEnabled) {
                            ElementPicker.this.m_nameField.requestFocusInWindow();
                        } else {
                            ElementPicker.this.m_tree.requestFocusInWindow();
                        }
                    }
                }

                @Override
                public void treeNodesChanged(TreeModelEvent e) {
                    this.setPath(e.getTreePath());
                }

                @Override
                public void treeNodesInserted(TreeModelEvent e) {
                    this.setPath(e.getTreePath().pathByAddingChild(e.getChildren()[0]));
                }

                @Override
                public void treeNodesRemoved(TreeModelEvent e) {
                    this.m_longestPath = null;
                }

                @Override
                public void treeStructureChanged(TreeModelEvent e) {
                    this.m_longestPath = null;
                }

                private void setPath(TreePath path) {
                    if (this.m_longestPath == null || path != null && path.getPathCount() > this.m_longestPath.getPathCount()) {
                        this.m_longestPath = path;
                    }
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.enableNewButton();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.enableNewButton();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.enableNewButton();
                }

                private void enableNewButton() {
                    ElementPicker.this.enableNewButton(true);
                }
            }
            CreateCompositeAction cca = new CreateCompositeAction();
            this.m_nameField.getDocument().addDocumentListener(cca);
            this.m_newButton.addActionListener(cca);
            this.updateCreatePanel();
        }
    }

    public boolean addSelectedItems(Transferable[] selectedItems) {
        return true;
    }

    public boolean canAcceptFlavors(DataFlavor[] flavors) {
        return flavors != null && flavors.length > 0;
    }

    public void deselectAll() {
        this.m_tree.clearSelection();
    }

    public Transferable[] getAllSelectableItems() {
        return NO_TRANSFERABLES;
    }

    public Component getComponent() {
        return this.m_component;
    }

    public Transferable[] getSelectedItems() {
        TreePath[] paths = this.m_tree.getSelectionPaths();
        if (paths == null || paths.length == 0) {
            return NO_TRANSFERABLES;
        }
        ArrayList<Transferable> list = new ArrayList<Transferable>(paths.length);
        for (int i = 0; i < paths.length; ++i) {
            Transferable node = this.checkItemSelectable(paths[i].getLastPathComponent());
            if (node == null) continue;
            list.add(node);
        }
        return list.toArray(new Transferable[list.size()]);
    }

    public DataFlavor[] getSelectionDataFlavors() {
        return null;
    }

    public boolean isItemSelected() {
        return this.m_isItemSelected;
    }

    public boolean isSelectableItemPresent() {
        return this.m_tree.getRowCount() > 0;
    }

    public void removeAllSelectableItems() {
        this.deselectAll();
    }

    public void removeSelectedItems() {
        this.deselectAll();
    }

    public void addSelectedPath(TreePath path, boolean expand) {
        if (expand) {
            this.m_tree.expandPath(path);
        }
        this.m_tree.addSelectionPath(path);
    }

    private boolean checkItemSelected() {
        TreePath[] paths = this.m_tree.getSelectionPaths();
        if (paths != null) {
            for (int i = 0; i < paths.length; ++i) {
                if (this.checkItemSelectable(paths[i].getLastPathComponent()) == null) continue;
                return true;
            }
        }
        return false;
    }

    private void updateCreatePanel() {
        if (this.m_createPanel != null) {
            Object node;
            if (this.m_tree.getSelectionCount() == 1 && (node = this.m_tree.getLastSelectedPathComponent()) instanceof CompositeCreator) {
                Object oldSelection = this.m_typeList.getSelectedItem();
                Object[] types = ((CompositeCreator)node).getCompositeTypes();
                if (types != null && types.length > 0) {
                    this.m_typeList.removeAllElements();
                    for (int i = 0; i < types.length; ++i) {
                        this.m_typeList.addElement(types[i]);
                    }
                    if (oldSelection != null && this.m_typeList.getIndexOf(oldSelection) != -1) {
                        this.m_typeList.setSelectedItem(oldSelection);
                    }
                    this.enableCreatePanel(true);
                    return;
                }
            }
            this.enableCreatePanel(false);
        }
    }

    private void enableCreatePanel(final boolean enable) {
        if (this.m_createPanelEnabled ^ enable) {
            this.m_createPanelEnabled = enable;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ElementPicker.this.m_createPanel.setEnabled(enable);
                    ElementPicker.this.m_typeField.setEnabled(enable);
                    ElementPicker.this.m_nameField.setEnabled(enable);
                    ElementPicker.this.enableNewButton(enable);
                }
            });
        }
    }

    private void enableNewButton(boolean enable) {
        this.m_newButton.setEnabled(enable && this.m_nameField.getDocument().getLength() > 0);
    }

    private Transferable checkItemSelectable(Object o) {
        Transferable t;
        DataFlavor[] flavors;
        if (o instanceof Transferable && (flavors = (t = (Transferable)o).getTransferDataFlavors()) != null && flavors.length > 0) {
            return t;
        }
        return null;
    }
}

