/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.worksheet.commands;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.backgroundTask.utils.DatabaseQueryTask;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.dbtools.worksheet.ActionProvider;
import oracle.dbtools.worksheet.Messages;
import oracle.dbtools.worksheet.WorksheetAction;
import oracle.dbtools.worksheet.WorksheetCallback;
import oracle.dbtools.worksheet.WorksheetContext;
import oracle.dbtools.worksheet.WorksheetFeatures;
import oracle.dbtools.worksheet.WorksheetResultPanel;
import oracle.dbtools.worksheet.WorksheetTaskWrapper;
import oracle.olap.app.db.DatabaseUtils;

public final class OLAPTransactionControlProvider
implements ActionProvider<Void> {
    private static final String COMMIT_ID = "Worksheet.Commit";
    private static final WorksheetAction[] ACTIONS = new WorksheetAction[]{OLAPTransactionControlProvider.createAction("Worksheet.Commit", -1.0)};
    private static final String COMMIT_FAIL_KEY = "TransactionControlProvider.Commit.Fail";
    private static final String COMMIT_PASS_KEY = "TransactionControlProvider.Commit.Pass";

    private static WorksheetAction createAction(String string, double d) {
        return WorksheetAction.createWorksheetAction((String)string, (WorksheetAction.ActionType)WorksheetAction.ActionType.BOTH, (int)1, (double)d);
    }

    private static boolean isEnabled(String string, String string2) {
        Properties properties;
        String string3 = null;
        try {
            properties = Connections.getInstance().getConnectionInfo(string2);
            if (properties != null) {
                string3 = properties.getProperty("driver");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        properties = WorksheetFeatures.getFeatures(string3);
        if (COMMIT_ID.equals(string)) {
            return properties.isFeatureSupported("WorksheetSupportRegistry.ActionCommitSupported");
        }
        return false;
    }

    public boolean checkActionEnabled(String string, WorksheetContext worksheetContext) {
        String string2;
        if (COMMIT_ID.equals(string) && !worksheetContext.isBusy() && (string2 = worksheetContext.getConnectionName()) != null) {
            return OLAPTransactionControlProvider.isEnabled(string, string2);
        }
        return false;
    }

    public WorksheetTaskWrapper<Void> doAction(String string, WorksheetContext worksheetContext) {
        if (COMMIT_ID.equals(string)) {
            TransactionTask transactionTask = new TransactionTask("update_and_commit", worksheetContext.getConnectionName()){

                @Override
                protected void doAction(Connection connection) throws SQLException {
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("update; commit;");
                    try {
                        DatabaseUtils.ExecuteSPL(connection, stringBuffer.toString());
                    }
                    catch (Exception exception) {
                        Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                    }
                }

                public String getQuery() {
                    return "";
                }
            };
            return new WorksheetTaskWrapper((RaptorTask)transactionTask, Collections.singletonList(new TransactionTaskListener(Messages.getString((String)COMMIT_PASS_KEY), Messages.getString((String)COMMIT_FAIL_KEY), worksheetContext.getCallback())), null, worksheetContext);
        }
        return null;
    }

    public WorksheetAction getActionAt(int n) {
        return ACTIONS[n];
    }

    public int getActionsCount() {
        return ACTIONS.length;
    }

    public WorksheetResultPanel getPanelAt(int n) {
        return null;
    }

    public int getPanelCount() {
        return 0;
    }

    private static class TransactionTaskListener
    extends RaptorTaskAdapter {
        private String m_passMsg;
        private String m_failMsg;
        private WorksheetCallback m_worksheetCallback;

        private TransactionTaskListener(String string, String string2, WorksheetCallback worksheetCallback) {
            assert (string != null && !string.isEmpty());
            assert (string2 != null && !string2.isEmpty());
            assert (worksheetCallback != null);
            this.m_passMsg = string;
            this.m_failMsg = string2;
            this.m_worksheetCallback = worksheetCallback;
        }

        public void taskCancelled(RaptorTaskEvent raptorTaskEvent) {
            this.taskFailed(raptorTaskEvent);
        }

        public void taskFailed(RaptorTaskEvent raptorTaskEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    m_worksheetCallback.setStatusMessage(m_failMsg, null);
                }
            });
            Throwable throwable = raptorTaskEvent.getThrowable();
            if (throwable instanceof Exception) {
                ExceptionHandler.handleException((Throwable)((Exception)throwable));
            }
        }

        public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    m_worksheetCallback.setStatusMessage(m_passMsg, null);
                }
            });
        }
    }

    private static abstract class TransactionTask
    extends DatabaseQueryTask<Void> {
        private String m_conn;

        private TransactionTask(String string, String string2) {
            super(string, IRaptorTaskRunMode.TASKVIEWER, false, false);
            this.m_conn = string2;
        }

        public String getConnectionName() {
            return this.m_conn;
        }

        protected Void doWork() throws TaskException {
            Connections connections = Connections.getInstance();
            connections.lock(this.m_conn);
            try {
                Connection connection = connections.getConnection(this.m_conn);
                this.doAction(connection);
            }
            catch (Exception exception) {
                throw new TaskException((Throwable)exception);
            }
            finally {
                connections.unlock(this.m_conn);
            }
            return null;
        }

        protected abstract void doAction(Connection var1) throws SQLException;
    }
}

