/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.security;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.utils.RaptorVersionTracker;
import oracle.jdbc.pool.OracleDataSource;
import oracle.olap.app.JavaXMLBind;
import oracle.olap.app.Version;
import oracle.olap.app.table.Queries;
import oracle.olap.security.AccessControlEntry;
import oracle.olap.security.AccessControlEntryPrivileges;
import oracle.olap.security.AccessControlList;
import oracle.olap.security.DataSecurityPolicy;
import oracle.olap.security.RealmConstraint;
import oracle.olap.security.jpubgen12101.Xdbms_xds;
import oracle.olap.security.jpubgen12101.XsAceList;
import oracle.olap.security.jpubgen12101.XsAceType;
import oracle.olap.security.jpubgen12101.XsColumnConstraintList;
import oracle.olap.security.jpubgen12101.XsNameList;
import oracle.olap.security.jpubgen12101.XsRealmConstraintList;
import oracle.olap.security.jpubgen12101.XsRealmConstraintType;
import oracle.olap.security.jpubgen12101.Xs_acl;
import oracle.olap.security.jpubgen12101.Xs_data_security;
import oracle.olap.security.jpubgen12102.Xs_data_security12102;
import oracle.olap.util.OLAPErrorDisplay;
import oracle.sql.TIMESTAMP;

public class ORASUtil {
    private static Queries queries;
    private static final String XMLFILE = "orasqueries.xml";
    private static ORASUtil INSTANCE;
    private Logger LOG = Logger.getLogger(ORASUtil.class.getName());
    private final String dataSecurityRoleClassOwner = "SYS";
    private final String dataSecurityRoleClassName = "OlapPrivileges";
    private final String GET_DATA_SECURITY_POLICY = "get_data_security_policy";
    private final String GET_REALMS = "get_realms";
    private final String GET_ACLS_IN_DATA_SECURITY_CLASS = "get_acls_in_data_security_class";
    private final String GET_ACLS_WITH_PARENT = "get_acls_with_parent";
    private final String GET_ACL = "get_acl";
    private final String GET_ACES = "get_aces";
    private final String GET_ENABLED_POLICY = "get_enabled_policy";
    private final String POLICY_NAME_SUFFIX = "_XS_POLICY";

    private ORASUtil() {
    }

    public static ORASUtil getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ORASUtil();
        }
        return INSTANCE;
    }

    private String _getQuery(String string) {
        if (queries == null) {
            try {
                String string2 = "oracle.olap.app.table";
                String string3 = JavaXMLBind.LoadDocument(this.getClass(), XMLFILE);
                JavaXMLBind.BindToJavaStr(string3, string2, this);
            }
            catch (Exception exception) {
                this.LOG.log(Level.WARNING, exception.getLocalizedMessage(), exception);
            }
        }
        return queries.getSQL(string);
    }

    public void addQueries(Queries queries) {
        ORASUtil.queries = queries;
    }

    private void _debugger(String string) {
        boolean bl = false;
    }

    private void _reportException(String string, Exception exception) {
        exception.fillInStackTrace();
        OLAPErrorDisplay oLAPErrorDisplay = new OLAPErrorDisplay();
        oLAPErrorDisplay.show(exception);
        this.LOG.log(Level.SEVERE, exception.getLocalizedMessage(), exception);
    }

    public DataSecurityPolicy getDSPDO(Connection connection, String string) {
        String string2 = "ORASUtil.getDSPDO";
        String string3 = this._getQuery("get_data_security_policy");
        DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
        DataSecurityPolicy dataSecurityPolicy = null;
        ArrayList<RealmConstraint> arrayList = new ArrayList();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("POLICY_NAME", string.toUpperCase());
        try {
            List list = dBUtil.executeReturnList(string3, hashMap);
            SQLException sQLException = dBUtil.getLastException();
            if (sQLException != null) {
                throw sQLException;
            }
            for (Map map : list) {
                arrayList = this.getRealmDOs(connection, string);
                dataSecurityPolicy = new DataSecurityPolicy((String)map.get("NAME"), (TIMESTAMP)map.get("CREATE_TIME"), (TIMESTAMP)map.get("MODIFY_TIME"), (String)map.get("DESCRIPTION"), arrayList);
            }
        }
        catch (SQLException sQLException) {
            this._reportException(string2, sQLException);
        }
        return dataSecurityPolicy;
    }

    public List<RealmConstraint> getRealmDOs(Connection connection, String string) {
        String string2 = "ORASUtil.getRealmDOs";
        String string3 = this._getQuery("get_realms");
        DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
        RealmConstraint realmConstraint = new RealmConstraint();
        ArrayList<RealmConstraint> arrayList = new ArrayList<RealmConstraint>();
        AccessControlList accessControlList = new AccessControlList();
        String string4 = null;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("POLICY_NAME", string.toUpperCase());
        try {
            List list = dBUtil.executeReturnList(string3, hashMap);
            SQLException sQLException = dBUtil.getLastException();
            if (sQLException != null) {
                throw sQLException;
            }
            for (Map map : list) {
                string4 = (String)map.get("ACL");
                if (string4 == null) {
                    this._debugger(string2);
                    continue;
                }
                accessControlList = this.getACLDO(connection, string4);
                BigDecimal bigDecimal = (BigDecimal)map.get("REALM_ORDER");
                int n = bigDecimal.intValue();
                realmConstraint = new RealmConstraint((String)map.get("POLICY"), n, (String)map.get("REALM_TYPE"), (String)map.get("STATIC"), (String)map.get("REALM"), (String)map.get("ACL"), (String)map.get("ACL_OWNER"), (String)map.get("PARENT_OBJECT"), (String)map.get("PARENT_SCHEMA"), accessControlList);
                arrayList.add(realmConstraint);
            }
        }
        catch (SQLException sQLException) {
            this._reportException(string2, sQLException);
        }
        return arrayList;
    }

    public List<AccessControlList> getACLDOsInDataSecurityRolesClass(Connection connection) {
        String string = "ORASUtil.getACLDOsIndataSecurityRolesClass";
        String string2 = this._getQuery("get_acls_in_data_security_class");
        DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
        ArrayList<AccessControlList> arrayList = new ArrayList<AccessControlList>();
        String string3 = null;
        AccessControlList accessControlList = new AccessControlList();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("SEC_CLASS", "OlapPrivileges");
        hashMap.put("SEC_CLASS_OWNER", "SYS");
        try {
            List list = dBUtil.executeReturnList(string2, hashMap);
            SQLException sQLException = dBUtil.getLastException();
            if (sQLException != null) {
                throw sQLException;
            }
            for (Map map : list) {
                string3 = (String)map.get("NAME");
                if (string3.length() >= 5 && string3.substring(0, 5).equalsIgnoreCase("/xds/")) continue;
                accessControlList = this.getACLDO(connection, string3);
                arrayList.add(accessControlList);
            }
        }
        catch (SQLException sQLException) {
            this._reportException(string, sQLException);
        }
        return arrayList;
    }

    public List<AccessControlList> getACLDOsWithParent(Connection connection, String string) {
        String string2 = "ORASUtil.getACLDOsWithParent";
        String string3 = this._getQuery("get_acls_with_parent");
        DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
        ArrayList<AccessControlList> arrayList = new ArrayList<AccessControlList>();
        String string4 = null;
        AccessControlList accessControlList = new AccessControlList();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("PARENT_ACL_NAME", string);
        try {
            List list = dBUtil.executeReturnList(string3, hashMap);
            SQLException sQLException = dBUtil.getLastException();
            if (sQLException != null) {
                throw sQLException;
            }
            for (Map map : list) {
                string4 = (String)map.get("NAME");
                accessControlList = this.getACLDO(connection, string4);
                arrayList.add(accessControlList);
            }
        }
        catch (SQLException sQLException) {
            this._reportException(string2, sQLException);
        }
        return arrayList;
    }

    public AccessControlList getACLDO(Connection connection, String string) {
        String string2 = "ORASUtil.getACLDO";
        String string3 = this._getQuery("get_acl");
        DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
        AccessControlList accessControlList = new AccessControlList();
        String string4 = null;
        AccessControlList accessControlList2 = new AccessControlList();
        ArrayList<AccessControlEntry> arrayList = new ArrayList();
        String string5 = null;
        try {
            if (string != null) {
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("ACL_NAME", string);
                List list = dBUtil.executeReturnList(string3, hashMap);
                SQLException sQLException = dBUtil.getLastException();
                if (sQLException != null) {
                    throw sQLException;
                }
                for (Map map : list) {
                    string4 = (String)map.get("PARENT_ACL");
                    accessControlList2 = this.getACLDO(connection, string4);
                    string5 = (String)map.get("NAME");
                    arrayList = this.getACEDOs(connection, string);
                    accessControlList = new AccessControlList((String)map.get("NAME"), (String)map.get("SECURITY_CLASS"), (String)map.get("SECURITY_CLASS_OWNER"), (String)map.get("PARENT_ACL"), (String)map.get("PARENT_ACL_OWNER"), (String)map.get("INHERITANCE_TYPE"), (String)map.get("DESCRIPTION"), accessControlList2, arrayList);
                }
            }
        }
        catch (SQLException sQLException) {
            this._reportException(string2, sQLException);
        }
        return accessControlList;
    }

    public List<AccessControlEntry> getACEDOs(Connection connection, String string) {
        String string2 = "ORASUtil.getACEDOs";
        String string3 = this._getQuery("get_aces");
        DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
        ArrayList<AccessControlEntry> arrayList = new ArrayList<AccessControlEntry>();
        AccessControlEntry accessControlEntry = new AccessControlEntry();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("ACL_NAME", string);
        try {
            List list = dBUtil.executeReturnList(string3, hashMap);
            SQLException sQLException = dBUtil.getLastException();
            if (sQLException != null) {
                throw sQLException;
            }
            for (Map map : list) {
                String string4 = (String)map.get("PRINCIPAL");
                String string5 = (String)map.get("PRINCIPAL_TYPE");
                BigDecimal bigDecimal = (BigDecimal)map.get("ACE_ORDER");
                int n = bigDecimal.intValue();
                accessControlEntry = new AccessControlEntry((String)map.get("ACL"), n, (Timestamp)map.get("START_DATE"), (Timestamp)map.get("END_DATE"), (String)map.get("GRANT_TYPE"), (String)map.get("INVERTED_PRINCIPAL"), string4, string5, (String)map.get("PRIVILEGE"), (String)map.get("SECURITY_CLASS"), (String)map.get("SECURITY_CLASS_OWNER"));
                arrayList.add(accessControlEntry);
            }
        }
        catch (SQLException sQLException) {
            this._reportException(string2, sQLException);
        }
        return arrayList;
    }

    public String getCreateACLPLSQL(AccessControlList accessControlList) {
        String string = "";
        StringBuffer stringBuffer = new StringBuffer();
        AccessControlEntry[] accessControlEntryArray = accessControlList.getAces();
        int n = 1;
        int n2 = accessControlEntryArray.length;
        for (AccessControlEntry accessControlEntry : accessControlEntryArray) {
            String string2 = accessControlEntry.getPrivilege();
            String string3 = accessControlEntry.getPrincipal();
            stringBuffer.append("XS$ACE_TYPE(privilege_list => XS$NAME_LIST('");
            stringBuffer.append(string2);
            stringBuffer.append("'),granted=>true, principal_name=>'");
            stringBuffer.append(string3);
            stringBuffer.append("', principal_type=> xs_acl.ptype_db)");
            if (n < n2) {
                stringBuffer.append(",\n");
            } else {
                stringBuffer.append("\n");
            }
            ++n;
        }
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append("DECLARE\n");
        stringBuffer2.append(" ace_list XS$ACE_LIST;\n");
        stringBuffer2.append("BEGIN\n");
        stringBuffer2.append(" ace_list := XS$ACE_LIST(\n");
        stringBuffer2.append(stringBuffer.toString());
        stringBuffer2.append(");\n");
        stringBuffer2.append(" xs_acl.create_acl(name => :ACLNAME, ace_list => ace_list, description => :ACLDESC);\n");
        stringBuffer2.append("END;\n");
        string = stringBuffer2.toString();
        return string;
    }

    public void appendRealmConstraints(Connection connection, String string, String string2, List<String> list) throws SQLException {
        String string3 = "ORASUtil.appendRealmConstraints";
        if (this._isDBVersion12102OrHigher(connection)) {
            oracle.olap.security.jpubgen12102.XsNameList xsNameList = new oracle.olap.security.jpubgen12102.XsNameList(list.toArray(new String[list.size()]));
            oracle.olap.security.jpubgen12102.XsRealmConstraintType xsRealmConstraintType = null;
            xsRealmConstraintType = this._createRealmConstraintType12102(connection, string2, xsNameList);
            Xs_data_security12102 xs_data_security12102 = new Xs_data_security12102(connection);
            xs_data_security12102.appendRealmConstraints(string, xsRealmConstraintType);
        } else {
            XsNameList xsNameList = new XsNameList(list.toArray(new String[list.size()]));
            XsRealmConstraintType xsRealmConstraintType = null;
            xsRealmConstraintType = this._createRealmConstraintType(connection, string2, xsNameList);
            Xs_data_security xs_data_security = new Xs_data_security(connection);
            xs_data_security.appendRealmConstraints(string, xsRealmConstraintType);
        }
    }

    private boolean _isDBVersion12102OrHigher(Connection connection) {
        Version version;
        boolean bl = false;
        DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
        String string = RaptorVersionTracker.getDbVersion((Connection)connection).toCanonicalString();
        Version version2 = new Version(string);
        if (version2.compareTo(version = new Version("12.1.0.1.0")) > 0) {
            bl = true;
        }
        return bl;
    }

    private XsRealmConstraintType _createRealmConstraintType(Connection connection, String string, XsNameList xsNameList) throws SQLException {
        String string2 = "ORASUtil.createRealmConstraintType";
        XsRealmConstraintType xsRealmConstraintType = null;
        BigDecimal bigDecimal = new BigDecimal(1);
        xsRealmConstraintType = new XsRealmConstraintType(connection);
        xsRealmConstraintType.setRealmType(bigDecimal);
        xsRealmConstraintType.setRealm(string);
        xsRealmConstraintType.setAclList(this._quoteNameInNameList(xsNameList));
        return xsRealmConstraintType;
    }

    private oracle.olap.security.jpubgen12102.XsRealmConstraintType _createRealmConstraintType12102(Connection connection, String string, oracle.olap.security.jpubgen12102.XsNameList xsNameList) throws SQLException {
        String string2 = "ORASUtil.createRealmConstraintType";
        oracle.olap.security.jpubgen12102.XsRealmConstraintType xsRealmConstraintType = null;
        BigDecimal bigDecimal = new BigDecimal(1);
        xsRealmConstraintType = new oracle.olap.security.jpubgen12102.XsRealmConstraintType(connection);
        xsRealmConstraintType.setRealmType(bigDecimal);
        xsRealmConstraintType.setRealm(string);
        String[] stringArray = xsNameList.getArray();
        String string3 = this._quoteName(stringArray[0]);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string3);
        oracle.olap.security.jpubgen12102.XsNameList xsNameList2 = new oracle.olap.security.jpubgen12102.XsNameList(arrayList.toArray(new String[arrayList.size()]));
        xsRealmConstraintType.setAclList(xsNameList2);
        return xsRealmConstraintType;
    }

    public void removeRealmConstraints(Connection connection, String string, String string2) throws SQLException {
        String string3 = "ORASUtil.removeRealmConstraints";
        boolean bl = this._isDBVersion12102OrHigher(connection);
        Xs_data_security xs_data_security = null;
        Xs_data_security12102 xs_data_security12102 = null;
        List<RealmConstraint> list = this.getRealmDOs(connection, string);
        if (bl) {
            xs_data_security12102 = new Xs_data_security12102(connection);
            xs_data_security12102.removeRealmConstraints(string);
        } else {
            xs_data_security = new Xs_data_security(connection);
            xs_data_security.removeRealmConstraints(string);
        }
        for (RealmConstraint realmConstraint : list) {
            Object object;
            Object[] objectArray;
            Object object2;
            Object object3;
            String[] stringArray;
            if (realmConstraint.getACLName().equalsIgnoreCase(string2)) continue;
            if (bl) {
                stringArray = new String[]{realmConstraint.getACLName()};
                object3 = new oracle.olap.security.jpubgen12102.XsNameList(stringArray);
                object2 = this._createRealmConstraintType12102(connection, realmConstraint.getRealmCondition(), (oracle.olap.security.jpubgen12102.XsNameList)object3);
                objectArray = new oracle.olap.security.jpubgen12102.XsRealmConstraintType[]{object2};
                object = new oracle.olap.security.jpubgen12102.XsRealmConstraintList((oracle.olap.security.jpubgen12102.XsRealmConstraintType[])objectArray);
                xs_data_security12102.appendRealmConstraints(string, (oracle.olap.security.jpubgen12102.XsRealmConstraintList)object);
                continue;
            }
            stringArray = new String[]{realmConstraint.getACLName()};
            object3 = new XsNameList(stringArray);
            object2 = this._createRealmConstraintType(connection, realmConstraint.getRealmCondition(), (XsNameList)object3);
            objectArray = new XsRealmConstraintType[]{object2};
            object = new XsRealmConstraintList((XsRealmConstraintType[])objectArray);
            xs_data_security.appendRealmConstraints(string, (XsRealmConstraintList)object);
        }
    }

    public void createDSP(Connection connection, String string, XsRealmConstraintList xsRealmConstraintList, String string2) throws SQLException {
        String string3 = "ORASUtil.createDSP";
        XsColumnConstraintList xsColumnConstraintList = null;
        Xs_data_security xs_data_security = new Xs_data_security(connection);
        xs_data_security.createPolicy(string, xsRealmConstraintList, xsColumnConstraintList, string2);
    }

    public void deleteDSP(Connection connection, String string) throws SQLException {
        block3: {
            String string2 = "ORASUtil.deleteDSP";
            int n = 2;
            List<Object> list = new ArrayList();
            String string3 = null;
            try {
                Xs_data_security xs_data_security = new Xs_data_security(connection);
                list = this.getRealmDOs(connection, string);
                for (RealmConstraint realmConstraint : list) {
                    string3 = realmConstraint.getACLName();
                    Xs_acl xs_acl = new Xs_acl(connection);
                    xs_acl.removeAces(string3);
                    this.deleteACL(connection, string3);
                }
                xs_data_security.removeRealmConstraints(string);
                xs_data_security.deletePolicy(string, n);
            }
            catch (SQLException sQLException) {
                int n2 = sQLException.getErrorCode();
                if (n2 == 46215) break block3;
                throw sQLException;
            }
        }
    }

    private String _getEnableOLAPDSPName(Connection connection, String string, String string2) {
        String string3 = "ORASUtil.getEnableOLAPDSPName";
        boolean bl = false;
        int n = 1;
        String string4 = this._getQuery("get_enabled_policy");
        DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
        String string5 = null;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("SCHEMA", string.toUpperCase());
        hashMap.put("OBJECT_NAME", string2.toUpperCase());
        hashMap.put("ENABLE_FLAG", n);
        try {
            List list = dBUtil.executeReturnList(string4, hashMap);
            SQLException sQLException = dBUtil.getLastException();
            if (sQLException != null) {
                throw sQLException;
            }
            for (Map map : list) {
                string5 = (String)map.get("POLICY_NAME");
            }
        }
        catch (SQLException sQLException) {
            this._reportException(string3, sQLException);
        }
        return string5;
    }

    public void enableOLAPDSP(Connection connection, String string, String string2, String string3) throws SQLException {
        String string4 = "ORASUtil.enableOLAPDSP";
        boolean bl = true;
        Xdbms_xds xdbms_xds = new Xdbms_xds(connection);
        xdbms_xds.enableOlapPolicy(string2, string3, string, bl);
    }

    public void disableOLAPDSP(Connection connection, String string, String string2) throws SQLException {
        String string3 = "ORASUtil.disableOLAPDSP";
        Xdbms_xds xdbms_xds = new Xdbms_xds(connection);
        xdbms_xds.disableOlapPolicy(string, string2);
    }

    public boolean isOLAPDSPEnabled(Connection connection, String string, String string2) {
        String string3 = "ORASUtil.isOLAPDSPEnabled";
        DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
        BigDecimal bigDecimal = null;
        boolean bl = false;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("SCHEMA", string.toUpperCase());
        hashMap.put("OBJECT_NAME", string2.toUpperCase());
        try {
            List list = dBUtil.executeReturnList("SELECT SCHEMA_NAME, LOGICAL_NAME, POLICY_NAME, ENABLE FROM SYS.XS$OLAP_POLICY WHERE SCHEMA_NAME = :SCHEMA AND LOGICAL_NAME = :OBJECT_NAME", hashMap);
            SQLException sQLException = dBUtil.getLastException();
            if (sQLException != null) {
                throw sQLException;
            }
            for (Map map : list) {
                bigDecimal = (BigDecimal)map.get("ENABLE");
                if (bigDecimal.intValue() != 1) continue;
                bl = true;
            }
        }
        catch (SQLException sQLException) {
            this._reportException(string3, sQLException);
        }
        return bl;
    }

    public void dropOLAPPDSP(Connection connection, String string, String string2) throws SQLException {
        String string3 = "ORASUtil.dropOLAPDSP";
        Xdbms_xds xdbms_xds = new Xdbms_xds(connection);
        xdbms_xds.dropOlapPolicy(string, string2);
    }

    private XsAceType _createACEType(XsNameList xsNameList, String string, boolean bl) throws SQLException {
        String string2 = "ORASUtil.createACEType";
        BigDecimal bigDecimal = new BigDecimal(0);
        if (bl) {
            bigDecimal = new BigDecimal(1);
        }
        BigDecimal bigDecimal2 = new BigDecimal(0);
        BigDecimal bigDecimal3 = new BigDecimal(2);
        XsAceType xsAceType = new XsAceType();
        Timestamp timestamp = null;
        Timestamp timestamp2 = null;
        xsAceType = new XsAceType(xsNameList, bigDecimal, bigDecimal2, string, bigDecimal3, timestamp, timestamp2);
        return xsAceType;
    }

    private void _createACL(Connection connection, String string, String string2, XsAceList xsAceList, String string3, String string4) throws SQLException {
        String string5 = "ORASUtil.createACL";
        Integer n = 1;
        Xs_acl xs_acl = new Xs_acl(connection);
        xs_acl.createAcl(this._quoteName(string), xsAceList, string3, this._quoteName(string4), n, string2);
    }

    public void createACL(Connection connection, String string, String string2, List<AccessControlEntryPrivileges> list) throws SQLException {
        String string3 = "ORASUtil.createACL";
        List<String> list2 = null;
        String string4 = null;
        boolean bl = false;
        ArrayList<XsAceType> arrayList = new ArrayList<XsAceType>();
        for (AccessControlEntryPrivileges object2 : list) {
            if (!object2.getUserType().equalsIgnoreCase("User") && !object2.getUserType().equalsIgnoreCase("Role")) continue;
            list2 = object2.getAccessPrivs();
            string4 = object2.getUser();
            bl = object2.isGranted();
            String[] stringArray = list2.toArray(new String[list2.size()]);
            XsNameList xsNameList = new XsNameList(stringArray);
            XsAceType xsAceType = null;
            xsAceType = this._createACEType(xsNameList, string4, bl);
            arrayList.add(xsAceType);
        }
        XsAceType[] xsAceTypeArray = arrayList.toArray(new XsAceType[arrayList.size()]);
        XsAceList xsAceList = new XsAceList(xsAceTypeArray);
        this._createACL(connection, string, string2, xsAceList);
    }

    private void _createACL(Connection connection, String string, String string2, XsAceList xsAceList) throws SQLException {
        String string3 = "ORASUtil.createACL";
        String string4 = null;
        String string5 = null;
        this._createACL(connection, string, string2, xsAceList, string4, string5);
    }

    public void createACLInDataSecurityRolesClass(Connection connection, String string, String string2, List<AccessControlEntryPrivileges> list) throws SQLException {
        Object object;
        String string3 = "ORASUtil.createACLInDataSecuriyRolesClass";
        ArrayList<XsAceType> arrayList = new ArrayList<XsAceType>();
        for (AccessControlEntryPrivileges object22 : list) {
            object = object22.getAccessPrivs();
            String[] stringArray = object.toArray(new String[object.size()]);
            XsNameList xsNameList = new XsNameList(stringArray);
            String string4 = object22.getUser();
            String string5 = object22.getUserType();
            XsAceType xsAceType = null;
            xsAceType = this._createACEType(xsNameList, string4, object22.isGranted());
            arrayList.add(xsAceType);
        }
        XsAceType[] xsAceTypeArray = arrayList.toArray(new XsAceType[arrayList.size()]);
        XsAceList xsAceList = new XsAceList(xsAceTypeArray);
        object = "SYS.\"OlapPrivileges\"";
        this._createACL(connection, string, string2, xsAceList, (String)object, null);
    }

    private void _setACLDescription(Connection connection, String string, String string2) throws SQLException {
        String string3 = "ORASUtil.setACLDescription";
        Xs_acl xs_acl = new Xs_acl(connection);
        xs_acl.setDescription(this._quoteName(string), string2);
    }

    public void setACLParent(Connection connection, String string, String string2) throws SQLException {
        String string3 = "ORASUtil.setACLParent";
        int n = 1;
        Xs_acl xs_acl = new Xs_acl(connection);
        xs_acl.setParentAcl(this._quoteName(string), this._quoteName(string2), n);
    }

    private void _removeACEs(Connection connection, String string) throws SQLException {
        String string2 = "ORASUtil.removeACEs";
        Xs_acl xs_acl = new Xs_acl(connection);
        xs_acl.removeAces(this._quoteName(string));
    }

    public void appendACEs(Connection connection, String string, String string2, List<AccessControlEntryPrivileges> list) throws SQLException {
        Object object;
        String string3 = "ORASUtil.appendACEs";
        this._setACLDescription(connection, string, string2);
        this._removeACEs(connection, string);
        ArrayList<XsAceType> arrayList = new ArrayList<XsAceType>();
        for (AccessControlEntryPrivileges object22 : list) {
            object = object22.getAccessPrivs();
            String[] stringArray = object.toArray(new String[object.size()]);
            XsNameList xsNameList = new XsNameList(stringArray);
            String string4 = object22.getUser();
            XsAceType xsAceType = null;
            xsAceType = this._createACEType(xsNameList, string4, object22.isGranted());
            arrayList.add(xsAceType);
        }
        XsAceType[] xsAceTypeArray = arrayList.toArray(new XsAceType[arrayList.size()]);
        XsAceList xsAceList = new XsAceList(xsAceTypeArray);
        object = new Xs_acl(connection);
        ((Xs_acl)object).appendAces(this._quoteName(string), xsAceList);
    }

    public void deleteACL(Connection connection, String string) throws SQLException {
        String string2 = "ORASUtil.deleteACL";
        int n = 2;
        Xs_acl xs_acl = new Xs_acl(connection);
        xs_acl.deleteAcl(this._quoteName(string), n);
    }

    public String getSecurityClassName() {
        String string = "ORASUtil.getSecurityClassName";
        return "OlapPrivileges";
    }

    public String createDSPName(String string) {
        return string + "_XS_POLICY";
    }

    public String createDSPDescription(String string, String string2) {
        return "OLAP Data Security for " + string + "_" + string2;
    }

    public String getObjectNameFromPolicyName(String string) {
        String string2 = null;
        int n = "_XS_POLICY".length();
        if (string.endsWith("_XS_POLICY")) {
            int n2 = string.lastIndexOf("_XS_POLICY");
            string2 = string.substring(0, n2);
        }
        return string2;
    }

    private String _quoteName(String string) {
        Object object = string != null && string.startsWith("/") ? "\"" + string + "\"" : string;
        return object;
    }

    private XsNameList _quoteNameInNameList(XsNameList xsNameList) throws SQLException {
        String[] stringArray = xsNameList.getArray();
        String string = this._quoteName(stringArray[0]);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string);
        XsNameList xsNameList2 = new XsNameList(arrayList.toArray(new String[arrayList.size()]));
        return xsNameList2;
    }

    public static final void main(String[] stringArray) {
        Connection connection;
        block30: {
            String string = "main";
            String string2 = ".main";
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = true;
            ORASUtil oRASUtil = ORASUtil.getInstance();
            OracleDataSource oracleDataSource = null;
            String string3 = "adc6141057:1521:main111";
            String string4 = null;
            String string5 = null;
            string4 = "global";
            string5 = "global";
            connection = null;
            try {
                oracleDataSource = new OracleDataSource();
                oracleDataSource.setURL("jdbc:oracle:thin:@" + string3);
                oracleDataSource.setUser(string4);
                oracleDataSource.setPassword(string5);
                connection = oracleDataSource.getConnection();
                connection.setAutoCommit(false);
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                System.exit(1);
            }
            catch (SQLException sQLException) {
                System.exit(1);
            }
            try {
                Object object;
                Object object2;
                Object object3;
                Object object4;
                Object object5;
                Object object6;
                Object object7;
                Object object8;
                Object object9;
                block29: {
                    if (bl) {
                        object9 = DBUtil.getInstance(connection);
                        try {
                            object8 = new HashMap();
                            object7 = object9.executeReturnList("SELECT SCHEMA_NAME,LOGICAL_NAME,POLICY_NAME,ENABLE FROM SYS.XS$OLAP_POLICY WHERE SCHEMA_NAME = 'GLOBAL'", object8);
                            object6 = object9.getLastException();
                            if (object6 != null) {
                                throw object6;
                            }
                            object5 = object7.iterator();
                            while (object5.hasNext()) {
                                object4 = (Map)object5.next();
                                oRASUtil.disableOLAPDSP(connection, (String)object4.get("SCHEMA_NAME"), (String)object4.get("LOGICAL_NAME"));
                                oRASUtil.dropOLAPPDSP(connection, (String)object4.get("SCHEMA_NAME"), (String)object4.get("LOGICAL_NAME"));
                            }
                        }
                        catch (SQLException sQLException) {
                            int n = sQLException.getErrorCode();
                            if (n == 46215) break block29;
                            oRASUtil._reportException(string, sQLException);
                        }
                    }
                }
                if (bl2) {
                    object9 = null;
                    object8 = null;
                    object7 = null;
                    object6 = DBUtil.getInstance((Connection)connection);
                    try {
                        object5 = new HashMap();
                        object4 = object6.executeReturnList("SELECT OWNER ,NAME ,TYPE FROM SYS.XS$OBJ WHERE NAME LIKE 'GLOBAL_CHANNEL_%' OR NAME LIKE 'TEST_%' ORDER BY TYPE, OWNER, NAME", object5);
                        object3 = object6.getLastException();
                        if (object3 != null) {
                            throw object3;
                        }
                        object2 = object4.iterator();
                        while (object2.hasNext()) {
                            object = (Map)object2.next();
                            object9 = (String)object.get("OWNER");
                            object8 = (String)object.get("NAME");
                            object7 = (String)object.get("TYPE");
                            if (((String)object7).equalsIgnoreCase("3")) {
                                oRASUtil.deleteACL(connection, (String)object8);
                            }
                            if (!((String)object7).equalsIgnoreCase("5")) continue;
                            oRASUtil.deleteDSP(connection, (String)object8);
                        }
                    }
                    catch (SQLException sQLException) {
                        sQLException.fillInStackTrace();
                        oRASUtil._reportException(string, sQLException);
                    }
                }
                if (!bl3) break block30;
                object9 = new ArrayList();
                object8 = new ArrayList();
                object8.add("SELECT");
                string2 = ".ACE";
                object7 = new String[]{"SELECT"};
                object6 = new XsNameList((String[])object7);
                boolean bl4 = true;
                object4 = new AccessControlEntryPrivileges("XADEMO", (List<String>)object8, bl4, "User");
                object9.add(object4);
                object3 = null;
                try {
                    object3 = oRASUtil._createACEType((XsNameList)object6, "XADEMO", bl4);
                }
                catch (SQLException sQLException) {
                    sQLException.fillInStackTrace();
                    oRASUtil._reportException(string, sQLException);
                }
                object2 = new AccessControlEntryPrivileges("SCOTT", (List<String>)object8, bl4, "User");
                object9.add(object2);
                object = null;
                try {
                    object = oRASUtil._createACEType((XsNameList)object6, "SCOTT", bl4);
                }
                catch (SQLException sQLException) {
                    sQLException.fillInStackTrace();
                    oRASUtil._reportException(string, sQLException);
                }
                XsAceType[] xsAceTypeArray = new XsAceType[]{object3};
                XsAceType[] xsAceTypeArray2 = new XsAceType[]{object};
                XsAceList xsAceList = new XsAceList(xsAceTypeArray);
                XsAceList xsAceList2 = new XsAceList(xsAceTypeArray2);
                string2 = ".ACL";
                String string6 = "TEST_ACL_XADEMO4";
                String string7 = "TEST_ACL_SCOTT4";
                try {
                    oRASUtil.createACLInDataSecurityRolesClass(connection, string6, "DESCRIPTION: " + string6, (List<AccessControlEntryPrivileges>)object9);
                }
                catch (Exception exception) {
                    exception.fillInStackTrace();
                    oRASUtil._reportException(string, exception);
                }
                try {
                    oRASUtil._createACL(connection, string7, "DESCRIPTION: " + string7, xsAceList2);
                }
                catch (Exception exception) {
                    exception.fillInStackTrace();
                    oRASUtil._reportException(string, exception);
                }
                try {
                    oRASUtil.setACLParent(connection, string7, string6);
                }
                catch (SQLException sQLException) {
                    sQLException.fillInStackTrace();
                    oRASUtil._reportException(string, sQLException);
                }
                string2 = ".DSP";
                String[] stringArray2 = new String[]{string7};
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add(string7);
                XsNameList xsNameList = new XsNameList(stringArray2);
                String string8 = "1=1";
                String string9 = "1!=1";
                String string10 = "GLOBAL.CHANNEL.DIM_KEY IN (1)";
                String string11 = "GLOBAL.CHANNEL.DIM_KEY IN (1,2)";
                String string12 = "GLOBAL.CHANNEL.DIM_KEY IN (1,2,3)";
                String string13 = "GLOBAL.CHANNEL.DIM_KEY IN (1,2,3,4)";
                String string14 = "GLOBAL.CHANNEL.DIM_KEY IN (1)";
                String string15 = "GLOBAL.CHANNEL.DIM_KEY IN (1,2)";
                String string16 = "GLOBAL.CHANNEL.DIM_KEY IN (1,2,3)";
                String string17 = "GLOBAL.CHANNEL.DIM_KEY IN (1,2,3,4)";
                String string18 = "GLOBAL.PRODUCT.DIM_KEY IN (1";
                String string19 = "GLOBAL.PRODUCT.DIM_KEY IN (1,2)";
                String string20 = "GLOBAL.PRODUCT.DIM_KEY IN (1,2,3)";
                String string21 = "GLOBAL.PRODUCT.DIM_KEY IN (1,2,3,4)";
                String string22 = "GLOBAL.TIME.DIM_KEY IN (1)";
                String string23 = "GLOBAL.TIME.DIM_KEY IN (1,2)";
                String string24 = "GLOBAL.TIME.DIM_KEY IN (1,2,3)";
                String string25 = "GLOBAL.TIME.DIM_KEY IN (1,2,3,4)";
                String string26 = "GLOBAL";
                String string27 = "CHANNEL";
                String string28 = oRASUtil.createDSPName(string27);
                String string29 = oRASUtil.createDSPDescription(string26, string27);
                oRASUtil.createDSP(connection, string28, null, string29);
                string2 = ".ENABLE/DISABLE";
                oRASUtil.enableOLAPDSP(connection, string28, string26, string27);
                oracle.olap.security.jpubgen12102.XsNameList xsNameList2 = new oracle.olap.security.jpubgen12102.XsNameList(arrayList.toArray(new String[arrayList.size()]));
                oracle.olap.security.jpubgen12102.XsRealmConstraintType xsRealmConstraintType = null;
                xsRealmConstraintType = oRASUtil._createRealmConstraintType12102(connection, string10, xsNameList2);
                Xs_data_security12102 xs_data_security12102 = new Xs_data_security12102(connection);
                xs_data_security12102.appendRealmConstraints(string28, xsRealmConstraintType);
            }
            catch (Exception exception) {
                System.exit(1);
            }
        }
        try {
            if (connection != null && !connection.isClosed()) {
                connection.close();
                connection = null;
            }
        }
        catch (SQLException sQLException) {
            sQLException.fillInStackTrace();
        }
        System.exit(0);
    }

    static {
        INSTANCE = null;
    }
}

