/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.eif;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.sql.Connection;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.TitledBorder;
import oracle.bali.ewt.button.DialogButtonBar;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.db.DBUtil;
import oracle.ide.Ide;
import oracle.ide.db.controls.DBObjectChooser;
import oracle.ide.help.HelpSystem;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectFilter;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.Tablespace;
import oracle.javatools.db.property.PropertyFilter;
import oracle.javatools.dialogs.MessageDialog;
import oracle.olap.OLAPArb;
import oracle.olap.util.OLAPNameValidator;

public class ImportFromEIFDialog
extends JDialog
implements ActionListener {
    private final String DEFAULT_OPTION = OLAPArb.get("NEWAW_DEFAULT_TABLESPACE_TEXT");
    private final String OK_COMMAND = "OK_ID";
    private final String CANCEL_COMMAND = "CANCEL_ID";
    private final String HELP_COMMAND = "HELP_ID";
    private final String AW_LIST_SQL = "select aw from all_olap2_aws where owner = :OWNER and sf_version not like '10%' order by aw";
    private String owner;
    private DBObjectProvider prov = null;
    private boolean m_clickedOK = false;
    private JPanel mainPanel;
    private JButton m_btnOK;
    private JButton m_btnCancel;
    private JButton m_btnHelp;
    private JComboBox directoryComboBox;
    private JTextField filenameTextField;
    private JTextField m_awNameField;
    private DBObjectChooser cmbTablespace;
    private ImportFromEIFDialog currentInstance = null;

    public ImportFromEIFDialog(Frame frame, DBObjectProvider dBObjectProvider, String string) {
        super(frame, OLAPArb.get("EIF_IMPORT_DIALOG_TITLE"), true);
        this.setName("ImportFromEIFDialog");
        this.currentInstance = this;
        this.owner = string;
        this.prov = dBObjectProvider;
        this.initDialog();
        this.initializeFields();
    }

    @Override
    protected void processComponentEvent(ComponentEvent componentEvent) {
        int n;
        int n2;
        super.processComponentEvent(componentEvent);
        if (componentEvent.getID() != 101) {
            return;
        }
        int n3 = n2 = this.getWidth();
        int n4 = n = this.getHeight();
        Dimension dimension = this.getMinimumSize();
        n3 = Math.max(dimension.width, n3);
        n4 = Math.max(dimension.height, n4);
        if (n2 != n3 || n != n4) {
            this.setSize(n3, n4);
        }
    }

    private void initDialog() {
        this.mainPanel = new JPanel(new GridBagLayout());
        this.mainPanel.setName("mainPanel");
        HelpSystem.getHelpSystem().registerTopic((JComponent)this.mainPanel, "olap_import_from_eif_file");
        this.setLayout(new GridBagLayout());
        this.m_btnOK = new JButton(StringUtils.stripMnemonic((String)OLAPArb.get("DIALOG_OK_BUTTON_TEXT")));
        this.m_btnOK.setName("m_btnOK");
        this.getRootPane().setDefaultButton(this.m_btnOK);
        this.m_btnOK.setActionCommand("OK_ID");
        this.m_btnOK.setMnemonic(StringUtils.getMnemonicKeyCode((String)OLAPArb.get("DIALOG_OK_BUTTON_TEXT")));
        this.m_btnOK.addActionListener(this);
        this.m_btnCancel = new JButton(StringUtils.stripMnemonic((String)OLAPArb.get("DIALOG_CANCEL_BUTTON_TEXT")));
        this.m_btnCancel.setName("m_btnCancel");
        this.m_btnCancel.setActionCommand("CANCEL_ID");
        this.m_btnCancel.setMnemonic(StringUtils.getMnemonicKeyCode((String)OLAPArb.get("DIALOG_CANCEL_BUTTON_TEXT")));
        this.m_btnCancel.addActionListener(this);
        this.m_btnHelp = new JButton(StringUtils.stripMnemonic((String)OLAPArb.get("DIALOG_HELP_BUTTON_TEXT")));
        this.m_btnHelp.setName("m_btnHelp");
        this.m_btnHelp.setActionCommand("HELP_ID");
        this.m_btnHelp.setMnemonic(StringUtils.getMnemonicKeyCode((String)OLAPArb.get("DIALOG_HELP_BUTTON_TEXT")));
        this.m_btnHelp.addActionListener(this);
        this.directoryComboBox = new JComboBox();
        this.directoryComboBox.setName("directoryComboBox");
        this.directoryComboBox.setEditable(false);
        JLabel jLabel = new JLabel();
        JLabel jLabel2 = new JLabel();
        String string = OLAPArb.get("EIF_EXPORT_DIALOG_LABEL_DIRECTORY");
        jLabel2.setText(StringUtils.stripMnemonic((String)string));
        int n = StringUtils.getMnemonicIndex((String)string);
        jLabel2.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)string));
        jLabel2.setLabelFor(this.directoryComboBox);
        this.filenameTextField = new JTextField(1024);
        this.filenameTextField.setName("filenameTextField");
        string = OLAPArb.get("EIF_EXPORT_DIALOG_LABEL_FILENAME");
        jLabel.setText(StringUtils.stripMnemonic((String)string));
        n = StringUtils.getMnemonicIndex((String)string);
        jLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)string));
        jLabel.setLabelFor(this.filenameTextField);
        JPanel jPanel = new JPanel();
        jPanel.setName("objectsPanel");
        jPanel.setBorder(new TitledBorder(OLAPArb.get("EIF_IMPORT_DIALOG_LABEL_IMPORT_FROM")));
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 5, 0, 5);
        jPanel.add((Component)jLabel2, gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.directoryComboBox, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.1;
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.insets = new Insets(10, 5, 0, 5);
        ++gridBagConstraints.gridx;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.filenameTextField, gridBagConstraints);
        JPanel jPanel2 = new JPanel();
        jPanel2.setName("workspacePanel");
        jPanel2.setBorder(new TitledBorder(OLAPArb.get("EIF_IMPORT_DIALOG_LABEL_CREATE_AND_IMPORT")));
        jPanel2.setLayout(new GridBagLayout());
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        this.m_awNameField = new JTextField();
        this.m_awNameField.setName("m_awNameField");
        string = OLAPArb.get("NEWAW_NAME_LABEL");
        JLabel jLabel3 = new JLabel(StringUtils.stripMnemonic((String)string));
        jPanel2.add((Component)jLabel3, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        jLabel3.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)string));
        jLabel3.setLabelFor(this.m_awNameField);
        jPanel2.add((Component)this.m_awNameField, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        string = OLAPArb.get("NEWAW_TABLESPACE_LABEL");
        JLabel jLabel4 = new JLabel(StringUtils.stripMnemonic((String)string));
        jPanel2.add((Component)jLabel4, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        this.cmbTablespace = new DBObjectChooser(new String[]{"TABLESPACE"});
        this.cmbTablespace.setName("cmbTablespace");
        jLabel4.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)string));
        jLabel4.setLabelFor((Component)this.cmbTablespace);
        jPanel2.add((Component)this.cmbTablespace, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        this.mainPanel.add((Component)jPanel, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.mainPanel.add((Component)jPanel2, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.insets = new Insets(10, 4, 0, 4);
        this.mainPanel.add((Component)this.getButtonBar(), gridBagConstraints);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.fill = 1;
        this.add((Component)this.mainPanel, gridBagConstraints);
        this.registerKeyboardActions();
    }

    private DialogButtonBar getButtonBar() {
        DialogButtonBar dialogButtonBar = new DialogButtonBar();
        dialogButtonBar.add((Component)this.m_btnHelp, DialogButtonBar.CONSTRAINT_HELP);
        dialogButtonBar.add((Component)this.m_btnOK, DialogButtonBar.CONSTRAINT_APPLY);
        dialogButtonBar.add((Component)this.m_btnCancel, DialogButtonBar.CONSTRAINT_CANCEL);
        return dialogButtonBar;
    }

    private void registerKeyboardActions() {
        JRootPane jRootPane = this.getRootPane();
        jRootPane.registerKeyboardAction(this, "CANCEL_ID", KeyStroke.getKeyStroke(27, 0), 1);
        jRootPane.registerKeyboardAction(this, "HELP_ID", KeyStroke.getKeyStroke(112, 0), 1);
        jRootPane.registerKeyboardAction(this, "HELP_ID", KeyStroke.getKeyStroke(156, 0), 1);
    }

    private void initializeFields() {
        this.populateDirNames();
        this.populateTableSpaceNames();
    }

    private void populateDirNames() {
        String string = "SELECT d.directory_name directory_name FROM all_directories d ORDER BY directory_name";
        Database database = (Database)this.prov;
        DBUtil dBUtil = DBUtil.getInstance((Connection)database.getConnection());
        List list = dBUtil.executeReturnList(string, null);
        for (Map map : list) {
            this.directoryComboBox.addItem(map.get("DIRECTORY_NAME"));
        }
    }

    private void populateTableSpaceNames() {
        this.cmbTablespace.setFilter((DBObjectFilter)new PropertyFilter("properties/TablespaceType", (Object)Tablespace.TablespaceType.PERMANENT));
        this.cmbTablespace.setProvider(this.prov);
        this.cmbTablespace.setNullText(this.DEFAULT_OPTION);
        this.cmbTablespace.setDBObjectID(null);
    }

    public String getDirectoryName() {
        String string = null;
        string = (String)this.directoryComboBox.getSelectedItem();
        return string;
    }

    public String getEIFFileName() {
        String string = null;
        string = this.filenameTextField.getText();
        return string;
    }

    public String getTableSpaceName() {
        String string = null;
        DBObject dBObject = this.cmbTablespace.getDBObject();
        if (dBObject != null) {
            string = dBObject.getName();
        }
        return string;
    }

    public String getAWName() {
        String string = null;
        string = this.m_awNameField.getText().trim();
        return string;
    }

    public boolean isOKSelected() {
        return this.m_clickedOK;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equalsIgnoreCase("OK_ID")) {
            if (this.validateFields()) {
                this.m_clickedOK = true;
                this.currentInstance.setVisible(false);
            }
        } else if (string.equalsIgnoreCase("CANCEL_ID")) {
            this.m_clickedOK = false;
            this.currentInstance.setVisible(false);
        } else if (string.equalsIgnoreCase("HELP_ID")) {
            HelpSystem.getHelpSystem().showHelp((JComponent)this.mainPanel);
        }
    }

    private boolean validateFields() {
        boolean bl = true;
        String string = this.getEIFFileName();
        String string2 = this.getDirectoryName();
        String string3 = this.getAWName();
        string3 = string3.toUpperCase();
        String string4 = null;
        String string5 = OLAPArb.get("EIF_IMPORT_ERROR_TITLE");
        String string6 = null;
        if (string.length() == 0) {
            string4 = OLAPArb.get("EIF_EXPORT_ERROR_MSG_NO_FILENAME");
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)string4, (String)string5, string6);
            bl = false;
            return bl;
        }
        if (string2.length() == 0) {
            string4 = OLAPArb.get("EIF_EXPORT_ERROR_NO_DIRECTORY_SUPPLIED");
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)string4, (String)string5, string6);
            bl = false;
            return bl;
        }
        if (!OLAPNameValidator.isNameValid(string3, 26)) {
            string4 = OLAPArb.get("NEWAW_ERROR_MSG_INVALID_NAME");
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)string4, (String)string5, string6);
            bl = false;
            return bl;
        }
        Database database = (Database)this.prov;
        DBUtil dBUtil = DBUtil.getInstance((Connection)database.getConnection());
        if (!OLAPNameValidator.isAWNameUnique(string3, dBUtil, this.owner)) {
            string4 = OLAPArb.get("NEWAW_ERROR_MSG_DUPLICATE_NAME");
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)string4, (String)string5, string6);
            bl = false;
            return bl;
        }
        return bl;
    }
}

