/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.db.model;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import javax.xml.bind.JAXBException;
import oracle.javatools.db.AbstractBuildableObject;
import oracle.javatools.db.AbstractDBObjectBuilder;
import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.DBException;
import oracle.olap.app.db.Database;
import oracle.olap.app.db.DatabaseImpl;
import oracle.olap.cubexml.MetadataContext;
import oracle.olap.cubexml.MetadataXML;
import oracle.olap.db.LanguageDBSettings;
import oracle.olap.db.model.LanguageDescription;
import oracle.sql.CLOB;

public abstract class AbstractOLAPDBObjectBuilder<T extends AbstractBuildableObject>
extends AbstractDBObjectBuilder<T> {
    private String defaultLanguage = "";

    public AbstractOLAPDBObjectBuilder(AbstractDBObjectProvider abstractDBObjectProvider, String string) {
        super(abstractDBObjectProvider, string);
    }

    protected Object getObject(Connection connection, String string) throws SQLException, IOException, JAXBException {
        DatabaseImpl databaseImpl = new DatabaseImpl();
        databaseImpl.setConnection(connection);
        String string2 = this.getXML(databaseImpl, string);
        MetadataContext metadataContext = new MetadataContext(this.getProvider());
        MetadataXML metadataXML = new MetadataXML(metadataContext);
        Object object = metadataXML.getObject(string2);
        return object;
    }

    protected String getXML(Database database, String string) throws SQLException, IOException {
        String string2 = "dbms_cube.export_xml";
        Object object = database.executeStoredProc(string2, new Object[]{string, CLOB.class});
        if (object instanceof CLOB) {
            CLOB cLOB = (CLOB)object;
            String string3 = database.convertCLOBToString(cLOB);
            return string3;
        }
        return null;
    }

    protected void checkForNullLanguageDescriptionValues(LanguageDescription languageDescription) {
        if (languageDescription.getShortDescription() == null) {
            languageDescription.setShortDescription("");
        }
        if (languageDescription.getLongDescription() == null) {
            languageDescription.setLongDescription("");
        }
        if (languageDescription.getDescription() == null) {
            languageDescription.setDescription("");
        }
    }

    protected String getDefaultLanguage() throws DBException {
        if (this.defaultLanguage.equalsIgnoreCase("")) {
            this.defaultLanguage = LanguageDBSettings.getDefaultLanguage();
        }
        return this.defaultLanguage;
    }
}

