/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.db;

import java.io.IOException;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import oracle.dbtools.raptor.controls.sqldialog.ObjectAction;
import oracle.dbtools.raptor.controls.sqldialog.ObjectActionController;
import oracle.dbtools.raptor.navigator.impl.ObjectFolder;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.model.Element;
import oracle.javatools.db.DBException;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.ddl.DDLDatabase;
import oracle.olap.app.cubeddl.CubeParser;
import oracle.olap.app.cubeddl.ParseException;
import oracle.olap.app.cubeddl.model.AccessControlList;
import oracle.olap.app.cubeddl.model.Realm;
import oracle.olap.app.db.Database;
import oracle.olap.app.db.DatabaseImpl;
import oracle.olap.app.olapmetadata.OLAPMetadataCache;
import oracle.olap.app.olapmetadata.Schema;
import oracle.olap.cubedimension.model.CubeDimension;
import oracle.olap.cubedimension.model.CubeDimensionLevel;
import oracle.olap.cubexml.CubeDDLStatements;
import oracle.olap.cubexml.MetadataContext;
import oracle.olap.cubexml.MetadataXML;
import oracle.olap.cubexml.ReservedWordsSyntaxHandler;
import oracle.olap.db.view.CubeAWUtil;
import oracle.olap.security.PolicyPersistance;
import org.xml.sax.SAXException;

public class CubeSQL {
    private DDLDatabase db;
    private boolean is12Compatible;
    private boolean execute;
    private MetadataContext metadataContext;

    public CubeSQL(DDLDatabase dDLDatabase, boolean bl, SystemObject systemObject, SystemObject systemObject2, Collection<String> collection, boolean bl2) {
        this.db = dDLDatabase;
        this.is12Compatible = bl;
        this.execute = bl2;
        DatabaseImpl databaseImpl = new DatabaseImpl();
        Connection connection = dDLDatabase.getConnection();
        databaseImpl.setConnection(connection);
        Schema schema = new Schema(dDLDatabase.getUserName());
        CubeDDLStatements cubeDDLStatements = new CubeDDLStatements(systemObject, systemObject2, collection);
        this.metadataContext = new MetadataContext((oracle.javatools.db.Database)dDLDatabase, cubeDDLStatements);
        this.metadataContext.setSchema(schema);
        this.metadataContext.setDatabase(databaseImpl);
    }

    public CubeSQL(DDLDatabase dDLDatabase, boolean bl, List<CubeDDLStatements> list, boolean bl2) {
        this.db = dDLDatabase;
        this.is12Compatible = bl;
        this.execute = bl2;
        DatabaseImpl databaseImpl = new DatabaseImpl();
        Connection connection = dDLDatabase.getConnection();
        databaseImpl.setConnection(connection);
        Schema schema = new Schema(dDLDatabase.getUserName());
        this.metadataContext = new MetadataContext((oracle.javatools.db.Database)dDLDatabase, list);
        this.metadataContext.setSchema(schema);
        this.metadataContext.setDatabase(databaseImpl);
    }

    public static List<String> filterEmpty(SystemObject systemObject, Collection<String> collection) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : collection) {
            String string2 = String.format("ALTER CUBE DIMENSION %s ()", systemObject.getName());
            boolean bl = false;
            if (string.equals(string2)) {
                bl = true;
            }
            if (systemObject instanceof CubeDimension) {
                CubeDimension cubeDimension = (CubeDimension)systemObject;
                for (CubeDimensionLevel cubeDimensionLevel : cubeDimension.getLevels()) {
                    String string3 = String.format("ALTER CUBE DIMENSION %s MODIFY ( %s LEVEL )", systemObject.getName(), cubeDimensionLevel.getName());
                    if (!string.equals(string3)) continue;
                    bl = true;
                }
            }
            if (bl) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    public String execute() throws DBException {
        String string = null;
        try {
            MetadataXML metadataXML = new MetadataXML(this.metadataContext);
            string = this.execute(metadataXML);
            Connection connection = this.metadataContext.getDatabase().getConnection();
            String string2 = Connections.getInstance().getConnectionName(connection);
            String string3 = this.metadataContext.getSchema().getName();
            if (this.execute && OLAPMetadataCache.hasForConnection(string2, string3)) {
                OLAPMetadataCache.removeSchema(string2, string3);
            }
            return string;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw new DBException((oracle.javatools.db.DBObject)this.metadataContext.getUpdatedObject(), throwable);
        }
    }

    private String execute(MetadataXML metadataXML) throws DBException {
        String string = null;
        String string2 = null;
        Collection<String> collection = this.metadataContext.getCubeDDLStatements();
        try {
            if (this.isRealmSQL()) {
                string = this.getExecuteRealmSQL();
                return string;
            }
            if (this.isACLSQL()) {
                string = this.getExecuteACLSQL();
                return string;
            }
            boolean bl = true;
            if (bl) {
                metadataXML.parse();
                string = this.execute ? metadataXML.executeSQL() : metadataXML.getSQLXML();
            } else {
                Iterator<String> iterator = collection.iterator();
                while (iterator.hasNext()) {
                    String string3;
                    string2 = string3 = iterator.next();
                    this.execute(this.metadataContext.getDatabase(), this.metadataContext.getSchema(), string2);
                }
            }
            return string;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw new DBException((oracle.javatools.db.DBObject)this.metadataContext.getUpdatedObject(), throwable);
        }
    }

    private boolean isRealmSQL() {
        boolean bl = false;
        Collection<String> collection = this.metadataContext.getCubeDDLStatements();
        for (String string : collection) {
            if (!string.toUpperCase().startsWith("CREATE REALM") && !string.toUpperCase().startsWith("ALTER REALM")) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private boolean isACLSQL() {
        boolean bl = false;
        Collection<String> collection = this.metadataContext.getCubeDDLStatements();
        for (String string : collection) {
            if (!string.toUpperCase().startsWith("CREATE OLAPACL") && !string.toUpperCase().startsWith("ALTER OLAPACL")) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private String getExecuteRealmSQL() throws ParseException, Exception {
        Collection<String> collection = this.metadataContext.getCubeDDLStatements();
        String string = null;
        Schema schema = this.metadataContext.getSchema();
        String string2 = schema.getName();
        Connection connection = this.metadataContext.getDatabase().getConnection();
        PolicyPersistance policyPersistance = new PolicyPersistance(connection, string2);
        for (String string3 : collection) {
            Realm realm = (Realm)this.parse(this.metadataContext.getSchema(), string3);
            if (this.execute) {
                string = policyPersistance.executeSQL(realm);
                ObjectFolder objectFolder = CubeAWUtil.getChildFolder();
                if (objectFolder == null) continue;
                ObjectAction objectAction = new ObjectAction();
                objectAction.setReload(true);
                DBObject dBObject = new DBObject((Element)objectFolder);
                ObjectActionController.ObjectActionPostProcess objectActionPostProcess = ObjectActionController.getPostProcessCallback((ObjectAction)objectAction, (DBObject)dBObject);
                objectActionPostProcess.run();
                continue;
            }
            string = policyPersistance.getCreateRealmSQL(realm);
        }
        return string;
    }

    private String getExecuteACLSQL() throws ParseException, Exception {
        Collection<String> collection = this.metadataContext.getCubeDDLStatements();
        String string = null;
        Schema schema = this.metadataContext.getSchema();
        String string2 = schema.getName();
        Connection connection = this.metadataContext.getDatabase().getConnection();
        PolicyPersistance policyPersistance = new PolicyPersistance(connection, string2);
        for (String string3 : collection) {
            AccessControlList accessControlList = (AccessControlList)this.parse(this.metadataContext.getSchema(), string3);
            if (this.execute) {
                string = policyPersistance.executeSQL(accessControlList);
                ObjectFolder objectFolder = CubeAWUtil.getChildFolder();
                if (objectFolder == null) continue;
                ObjectAction objectAction = new ObjectAction();
                objectAction.setReload(true);
                DBObject dBObject = new DBObject((Element)objectFolder);
                ObjectActionController.ObjectActionPostProcess objectActionPostProcess = ObjectActionController.getPostProcessCallback((ObjectAction)objectAction, (DBObject)dBObject);
                objectActionPostProcess.run();
                continue;
            }
            string = policyPersistance.getCreateACLinOLAPSecurityClassPLSQL(accessControlList);
        }
        return string;
    }

    private Object parse(Schema schema, String string) throws ParseException {
        string = this.handleReservedWords(string);
        StringReader stringReader = new StringReader(string);
        CubeParser cubeParser = new CubeParser(stringReader);
        cubeParser.setMetadataContext(this.metadataContext);
        Object object = cubeParser.sqlStatement(schema);
        return object;
    }

    private String handleReservedWords(String string) {
        string = ReservedWordsSyntaxHandler.Process(string);
        return string;
    }

    private void execute(Database database, Schema schema, String object) throws Exception {
        if (this.is12Compatible) {
            if (!((String)object).startsWith("COMMENT") && ((String)object).toLowerCase().startsWith("begin")) {
                object = (String)object + ";";
            }
            database.executeSQL((String)object);
        } else {
            this.execute11g(database, schema, this.metadataContext.getOriginalObject(), this.metadataContext.getUpdatedObject(), (String)object);
        }
    }

    private void execute11g(Database database, Schema schema, SystemObject systemObject, SystemObject systemObject2, String string) throws Exception {
        CubeDDLStatements cubeDDLStatements = new CubeDDLStatements(systemObject, systemObject2, string);
        MetadataContext metadataContext = new MetadataContext(database, cubeDDLStatements);
        metadataContext.setSchema(schema);
        MetadataXML metadataXML = new MetadataXML(metadataContext);
        metadataXML.parse();
        metadataXML.executeSQL();
    }

    private String get11gXML(Database database, Schema schema, SystemObject systemObject, SystemObject systemObject2, String string) throws ParseException, SQLException, IOException, JAXBException, ParserConfigurationException, SAXException, TransformerConfigurationException, TransformerException {
        CubeDDLStatements cubeDDLStatements = new CubeDDLStatements(systemObject, systemObject2, string);
        MetadataContext metadataContext = new MetadataContext(database, cubeDDLStatements);
        metadataContext.setSchema(schema);
        MetadataXML metadataXML = new MetadataXML(metadataContext);
        metadataXML.parse();
        boolean bl = false;
        return metadataXML.generateXML(bl);
    }

    public Object get(String string) {
        return this.metadataContext.get(string);
    }

    public void put(String string, Object object) {
        this.metadataContext.put(string, object);
    }

    public void setProperties(Map<String, Object> map) {
        for (String string : map.keySet()) {
            this.metadataContext.put(string, map.get(string));
        }
    }
}

