/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.data;

import java.util.List;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.ora.OracleDatabaseImpl;
import oracle.olap.app.olapmetadata.Cube;
import oracle.olap.app.olapmetadata.Dimension;
import oracle.olap.app.olapmetadata.Measure;
import oracle.olap.data.CubeMetadataContext;
import oracle.olap.data.CubeMetadataType;

public class CubeMetadataContextImpl
implements CubeMetadataContext {
    private String objName;
    private CubeMetadataType objType;
    private DBObjectID objID;
    private Cube cube;
    private OracleDatabaseImpl db;

    public CubeMetadataContextImpl(OracleDatabaseImpl oracleDatabaseImpl, Cube cube) {
        this.db = oracleDatabaseImpl;
        this.cube = cube;
        this.objType = CubeMetadataType.CUBE;
    }

    public CubeMetadataContextImpl(OracleDatabaseImpl oracleDatabaseImpl, Cube cube, boolean bl) {
        this(oracleDatabaseImpl, cube);
        this.db = oracleDatabaseImpl;
        if (bl) {
            this.selectMeasures();
        }
    }

    private void selectMeasures() {
        if (this.getMeasures().size() < 10) {
            for (Measure measure : this.getMeasures()) {
                measure.setSelected(true);
            }
        } else {
            for (Measure measure : this.getMeasures()) {
                if (measure.isDerived()) continue;
                measure.setSelected(true);
            }
        }
    }

    @Override
    public OracleDatabaseImpl getDatabase() {
        return this.db;
    }

    @Override
    public DBObjectID getObject() {
        return this.objID;
    }

    @Override
    public Cube getCube() {
        return this.cube;
    }

    @Override
    public CubeMetadataType getType() {
        return this.objType;
    }

    public String getOwner() {
        return this.cube.getSchema().getName();
    }

    public String getName() {
        return this.objName;
    }

    @Override
    public List<Measure> getMeasures() {
        return this.cube.getMeasures();
    }

    @Override
    public List<Dimension> getCubeDimensions() {
        return this.cube.getDimensions();
    }
}

