/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.cube.panels;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.sql.Connection;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreeNode;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.shuttle.ItemPicker;
import oracle.bali.ewt.shuttle.ListPicker;
import oracle.bali.ewt.shuttle.ReorderableListPicker;
import oracle.bali.ewt.shuttle.Shuttle;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.Ide;
import oracle.ide.db.components.ComponentFactory;
import oracle.ide.dialogs.ProgressBar;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.Schema;
import oracle.javatools.db.event.DBObjectListener;
import oracle.javatools.db.ora.OracleDatabaseImpl;
import oracle.javatools.dialogs.MessageDialog;
import oracle.olap.OLAPArb;
import oracle.olap.app.olapmetadata.Measure;
import oracle.olap.app.olapmetadata.OLAPMetadataCache;
import oracle.olap.app.syntaxparser.ParseNode;
import oracle.olap.cube.CubeDimensionListRunnable;
import oracle.olap.cube.CubeInitializer;
import oracle.olap.cube.model.Cube;
import oracle.olap.cube.model.CubeCalculatedMeasure;
import oracle.olap.cube.model.CubeDimensionality;
import oracle.olap.cube.model.CubePartition;
import oracle.olap.cube.model.MeasureExpressionCascade;
import oracle.olap.cube.panels.PartitionDimensionMetadataLoader;
import oracle.olap.cube.partition.model.HierarchyLevelWrapper;
import oracle.olap.cubedimension.model.CubeDimension;
import oracle.olap.db.view.GeneralBaseEditorPanel;
import oracle.olap.syntax.CubeAggregationDimension;
import oracle.olap.syntax.SolveSyntax;
import oracle.olap.syntaxbuilder.olapihelpers.OLAPISyntaxParser;
import oracle.olap.syntaxbuilder.olapihelpers.Type;
import oracle.olap.util.CubeMeasureDependencyCheck;
import oracle.olap.util.OLAPDimCascadeDroppedMeasuresCache;

public class CubeGeneralPanel
extends GeneralBaseEditorPanel<Cube> {
    private static final Logger LOG = Logger.getLogger(CubeGeneralPanel.class.getName());
    private List<CubeDimension> m_allDimensions;
    private DefaultListModel m_selectedObjectListModel;
    private DefaultListModel m_allObjectListModel;
    private boolean m_initialized;
    private OLAPISyntaxParser parser;
    private CubeMeasureDependencyCheck dependencyCheck;
    private boolean checkMVsOn;
    private JLabel mvLabel;
    private JLabel mvValue;
    public static final String ALL_DIMENSIONS = "dimensions";

    public CubeGeneralPanel() {
        this.layoutComponents();
        this.setDbObjectInitializer(new CubeInitializer());
    }

    @Override
    public boolean isAnalyticWorkspaceRequired() {
        return false;
    }

    @Override
    protected void initialisePanel() {
        Object object;
        Object object2;
        Object object3;
        super.initialisePanel();
        if (!this.m_initialized) {
            Object object4;
            this.m_initialized = true;
            object3 = new MeasureExpressionCascade((Cube)this.getUpdatedObject(), (OracleDatabaseImpl)this.getProvider());
            ((Cube)this.getUpdatedObject()).setCascadeHandler((MeasureExpressionCascade)object3);
            ((Cube)this.getUpdatedObject()).addObjectListener((DBObjectListener)object3);
            object2 = ((Database)this.getProvider()).getConnection();
            object = Connections.getInstance().getConnectionName((Connection)object2);
            Properties properties = new Properties();
            properties.setProperty("SCHEMA", ((Cube)this.getUpdatedObject()).getSchema().getName());
            oracle.olap.app.olapmetadata.Schema schema = null;
            try {
                schema = OLAPMetadataCache.getUpdatedSchema((String)object, ((Cube)this.getUpdatedObject()).getSchema().getName());
            }
            catch (Exception exception) {
                LOG.log(Level.SEVERE, "Reading cache", exception);
            }
            this.parser = new OLAPISyntaxParser(schema, properties);
            Object object5 = this.getDataContext().get(ALL_DIMENSIONS);
            if (object5 == null) {
                object4 = (OracleDatabaseImpl)this.getProvider();
                this.m_allDimensions = this.getAllCubeDimensions((OracleDatabaseImpl)object4);
                this.getDataContext().put(ALL_DIMENSIONS, this.m_allDimensions);
            } else {
                this.m_allDimensions = (List)object5;
            }
            if (this.isEditing()) {
                // empty if block
            }
            object4 = OLAPDimCascadeDroppedMeasuresCache.getInstance();
            ((OLAPDimCascadeDroppedMeasuresCache)object4).clear();
        }
        this.populateDimensions();
        object3 = this.getDataContext();
        object2 = (Window)object3.get("oracle.bali.ewt.dialog.JEWTDialog");
        if (object2 != null) {
            object = (JEWTDialog)object2;
            if (((Cube)this.getUpdatedObject()).getCubeMVEnabled()) {
                object.setOKButtonEnabled(false);
            }
        }
        if (this.isEditing() && !this.checkMVsOn && ((Cube)this.getUpdatedObject()).getCubeMVEnabled()) {
            SwingUtilities.invokeLater(new Runnable(){
                final /* synthetic */ Window val$dialog;
                {
                    this.val$dialog = window;
                }

                @Override
                public void run() {
                    CubeGeneralPanel.this.showMVWarningMessage(this.val$dialog);
                    CubeGeneralPanel.this.mvLabel.setVisible(true);
                    CubeGeneralPanel.this.mvValue.setVisible(true);
                    CubeGeneralPanel.this.checkMVsOn = true;
                }
            });
        }
    }

    private void showMVWarningMessage(Window window) {
        MessageDialog.information((Component)window, (Object)OLAPArb.format("MATERIALIZED_VIEW_CUBE_WARNING_MSG", ((Cube)this.getUpdatedObject()).getName()), (String)OLAPArb.getString("MATERIALIZED_VIEW_CUBE_WARNING_TITLE"), null);
    }

    @Override
    protected void commitPanel() throws TraversalException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        int n;
        super.commitPanel();
        OracleDatabaseImpl oracleDatabaseImpl = (OracleDatabaseImpl)this.getProvider();
        boolean bl = false;
        ArrayList<CubeDimensionality> arrayList = new ArrayList<CubeDimensionality>();
        CubeDimensionality[] cubeDimensionalityArray = ((Cube)this.getUpdatedObject()).getDimensions();
        if (cubeDimensionalityArray.length != this.m_selectedObjectListModel.getSize()) {
            bl = true;
        }
        OLAPDimCascadeDroppedMeasuresCache oLAPDimCascadeDroppedMeasuresCache = OLAPDimCascadeDroppedMeasuresCache.getInstance();
        for (n = 0; n < this.m_selectedObjectListModel.getSize(); ++n) {
            object6 = (String)this.m_selectedObjectListModel.get(n);
            object5 = ((Cube)this.getUpdatedObject()).findDimensionality((String)object6);
            if (object5 == null) {
                object4 = this.m_allDimensions.iterator();
                while (object4.hasNext()) {
                    object3 = object4.next();
                    if (!object3.getName().equals(object6)) continue;
                    object5 = new CubeDimensionality((CubeDimension)object3);
                    object2 = ((CubeDimension)object3).getLeafHierarchyLevel();
                    if (object2 != null) {
                        object = String.format("%s.%s", this.getName(), object2.getName());
                        object5.setMappedDimension((String)object);
                    }
                    bl = true;
                }
            }
            object5.setPhysicalOrder(n + 1);
            arrayList.add((CubeDimensionality)((Object)object5));
            if (!this.isEditing() || (object4 = oLAPDimCascadeDroppedMeasuresCache.getMeasures((String)object6)) == null || object4.isEmpty()) continue;
            object3 = object4.iterator();
            while (object3.hasNext()) {
                object2 = (CubeCalculatedMeasure)object3.next();
                ((Cube)this.getUpdatedObject()).addCalculatedMeasure((CubeCalculatedMeasure)object2);
            }
        }
        if (this.isEditing()) {
            this.dependencyCheck = new CubeMeasureDependencyCheck(oracleDatabaseImpl.getConnection(), ((Cube)this.getUpdatedObject()).getSchema().getName(), ((Cube)this.getUpdatedObject()).getAnalyticWorkspace());
            for (n = 0; n < this.m_allObjectListModel.getSize(); ++n) {
                object6 = (String)this.m_allObjectListModel.get(n);
                this.dropMeasuresDependentOnDimension((String)object6);
            }
        }
        CubeDimensionality[] cubeDimensionalityArray2 = arrayList.toArray(new CubeDimensionality[arrayList.size()]);
        ((Cube)this.getUpdatedObject()).setDimensions(cubeDimensionalityArray2);
        if (bl) {
            object6 = (Cube)this.getUpdatedObject();
            object5 = "SOLVE(SUM MAINTAIN COUNT OVER ALL)";
            object4 = this.getProvider();
            object3 = SolveSyntax.getInstance().fromSyntax((Cube)object6, ((Cube)object6).getDimensionMap(this.m_allDimensions), (DBObjectProvider)object4, (String)object5);
            object5 = SolveSyntax.getInstance().toSyntax((Cube)object6, ((Cube)object6).getDimensionMap(this.m_allDimensions), (DBObjectProvider)object4, (List<CubeAggregationDimension>)object3);
            ((Cube)object6).setConsistentSolveSpec((String)object5);
            object2 = ((Cube)object6).getPartitionDimensionName();
            object = null;
            if (object2 != null && (object = ((Cube)object6).findDimensionality((String)object2)) == null) {
                ((Cube)object6).removeAllPartitions();
            }
            if (object2 == null && object == null) {
                this.createDefaultPartitions();
            }
        }
    }

    private void createDefaultPartitions() {
        String string;
        Object object = this.getDataContext().get(ALL_DIMENSIONS);
        PartitionDimensionMetadataLoader partitionDimensionMetadataLoader = new PartitionDimensionMetadataLoader((Cube)this.getUpdatedObject(), object);
        List<HierarchyLevelWrapper> list = partitionDimensionMetadataLoader.getDefaultPartitions(string = partitionDimensionMetadataLoader.getDefaultPartitionDimension());
        if (list.size() > 0) {
            ((Cube)this.getUpdatedObject()).removeAllPartitions();
            for (HierarchyLevelWrapper hierarchyLevelWrapper : list) {
                String string2 = hierarchyLevelWrapper.getHierarchyName();
                String string3 = hierarchyLevelWrapper.getLevelName();
                int n = 40;
                CubePartition cubePartition = new CubePartition(string2 + "_" + string3);
                cubePartition.setPartitionDimension(string);
                cubePartition.setPartitionHierarchy(string2);
                cubePartition.setPartitionLevel(string3);
                if (((Cube)this.getUpdatedObject()).isCompress()) {
                    cubePartition.setPrecomputePercent(n);
                } else {
                    cubePartition.setPrecomputePercent(0);
                }
                ((Cube)this.getUpdatedObject()).addPartition(cubePartition);
            }
        } else {
            ((Cube)this.getUpdatedObject()).removeAllPartitions();
        }
    }

    private void populateDimensions() {
        this.m_allObjectListModel.removeAllElements();
        this.m_selectedObjectListModel.removeAllElements();
        String string = ((Cube)this.getUpdatedObject()).getAnalyticWorkspace();
        Object object = this.getDataContext().get(ALL_DIMENSIONS);
        for (Object object2 : ((Cube)this.getUpdatedObject()).getDimensions(object)) {
            this.m_selectedObjectListModel.addElement(object2.getName());
        }
        if (this.m_allDimensions != null) {
            for (CubeDimension cubeDimension : this.m_allDimensions) {
                Object object2;
                if (string == null || !string.equals(cubeDimension.getAnalyticWorkspace())) continue;
                String string2 = cubeDimension.getName();
                object2 = ((Cube)this.getUpdatedObject()).findDimensionality(string2);
                if (object2 != null) continue;
                this.m_allObjectListModel.addElement(string2);
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("analyticWorkspace")) {
            String string = (String)propertyChangeEvent.getNewValue();
            if (this.m_initialized) {
                ((Cube)this.getUpdatedObject()).setAnalyticWorkspace(string);
            }
            this.populateDimensions();
        }
    }

    private void layoutComponents() {
        this.registerDescriptionFields();
        Shuttle shuttle = this.createShuttlePanel();
        ComponentFactory componentFactory = this.getComponentFactory();
        componentFactory.registerComponent(shuttle.getToPicker().getComponent(), ALL_DIMENSIONS);
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.setName("CubeGeneralPanel.PNL_CONTEXT");
        int n = this.layoutDescriptionFields(jPanel);
        this.mvLabel = new JLabel(OLAPArb.getString("CUBE_DIMENSION_GENERAL_PANEL_MATERIALIZED_VIEW"));
        this.mvValue = new JLabel(OLAPArb.getString("CUBE_DIMENSION_GENERAL_PANEL_MV_ON"));
        this.mvLabel.setVisible(false);
        this.mvValue.setVisible(false);
        jPanel.add((Component)this.mvLabel, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 12), 0, 0));
        jPanel.add((Component)this.mvValue, new GridBagConstraints(1, n, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 5), 0, 0));
        JPanel jPanel2 = new JPanel();
        jPanel2.setName("CubeGeneralPanel.PNL_DETAILS");
        jPanel2.setLayout(new GridBagLayout());
        jPanel2.add((Component)shuttle, new GridBagConstraints(0, 0, 2, 1, 1.0, 1.0, 13, 1, new Insets(5, 5, 0, 5), 0, 0));
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        jPanel3.setName("pnlCenter");
        jPanel3.add((Component)jPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 0, 5), 0, 0));
        jPanel3.add((Component)jPanel2, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(10, 0, 0, 0), 0, 0));
        jPanel3.add((Component)new JPanel(), new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 17, 1, new Insets(10, 0, 0, 0), 0, 0));
        this.setLayout(new BorderLayout());
        this.add(jPanel3, "Center");
    }

    private Shuttle createShuttlePanel() {
        this.m_allObjectListModel = new DefaultListModel();
        JList jList = new JList(this.m_allObjectListModel);
        jList.setName("allObjectList");
        this.m_selectedObjectListModel = new DefaultListModel();
        JList jList2 = new JList(this.m_selectedObjectListModel);
        jList2.setName("selectedObjectList");
        Shuttle shuttle = new Shuttle();
        shuttle.setName("shuttle");
        shuttle.setButtonsShown(15);
        ReorderableListPicker reorderableListPicker = new ReorderableListPicker(jList2);
        shuttle.setToPicker((ItemPicker)reorderableListPicker);
        ListPicker listPicker = new ListPicker(jList);
        shuttle.setFromPicker((ItemPicker)listPicker);
        JLabel jLabel = new JLabel();
        jLabel.setName("fromListLabel");
        jLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        shuttle.add((Component)jLabel, (Object)"FromHeader");
        JLabel jLabel2 = new JLabel();
        jLabel2.setName("toListLabel");
        jLabel2.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        ResourceUtils.resLabel((JLabel)jLabel, jList, (String)OLAPArb.get("CUBE_AVAILABLE_DIMENSION_LIST_LABEL"));
        ResourceUtils.resLabel((JLabel)jLabel2, jList2, (String)OLAPArb.get("CUBE_SELECTED_DIMENSION_LIST_LABEL"));
        shuttle.add((Component)jLabel2, (Object)"ToHeader");
        shuttle.setMinimumSize(new Dimension(350, 125));
        shuttle.setEnabled(true);
        jList2.setEnabled(true);
        jList.setEnabled(true);
        return shuttle;
    }

    private List<CubeDimension> getAllCubeDimensions(OracleDatabaseImpl oracleDatabaseImpl) {
        Schema schema = ((Cube)this.getUpdatedObject()).getSchema();
        List<CubeDimension> list = null;
        try {
            String string = ((Cube)this.getUpdatedObject()).getAnalyticWorkspace();
            CubeDimensionListRunnable cubeDimensionListRunnable = new CubeDimensionListRunnable(oracleDatabaseImpl, schema, string);
            String string2 = OLAPArb.get("CUBE.FETCH.DIMENSION.LIST.TITLE");
            string2 = MessageFormat.format(string2, "");
            ProgressBar progressBar = new ProgressBar((Component)Ide.getMainWindow(), string2, (Runnable)cubeDimensionListRunnable, true);
            progressBar.setCancelable(false);
            cubeDimensionListRunnable.setProgressBar(progressBar);
            progressBar.start(OLAPArb.get("CUBE.FETCH.DIMENSION.LIST"), null);
            if (cubeDimensionListRunnable.getException() != null) {
                throw cubeDimensionListRunnable.getException();
            }
            list = cubeDimensionListRunnable.getCubeDimensions();
        }
        catch (Exception exception) {
            String string = null;
            String string3 = exception.getLocalizedMessage();
            if (string3 == null || string3.length() == 0) {
                string3 = exception.getClass().toString();
            }
            String string4 = OLAPArb.get("NEWCUBE_ERROR_TITLE");
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)string3, (String)string4, string);
        }
        return list;
    }

    private void dropMeasuresDependentOnDimension(String string) {
        Cube cube = (Cube)this.getUpdatedObject();
        OLAPDimCascadeDroppedMeasuresCache oLAPDimCascadeDroppedMeasuresCache = OLAPDimCascadeDroppedMeasuresCache.getInstance();
        for (CubeCalculatedMeasure cubeCalculatedMeasure : cube.getCalculatedMeasures()) {
            this.parser.setSyntax(cubeCalculatedMeasure.getMeasureExpression());
            ParseNode parseNode = new ParseNode();
            if (!this.parser.parseSyntax(parseNode)) continue;
            Enumeration<TreeNode> enumeration = parseNode.breadthFirstEnumeration();
            while (enumeration.hasMoreElements()) {
                String string2;
                ParseNode parseNode2 = (ParseNode)enumeration.nextElement();
                if (!Type.HIERARCHY.toString().equalsIgnoreCase(parseNode2.getType()) && !Type.DIMENSION.toString().equalsIgnoreCase(parseNode2.getType()) && !Type.LEVEL.toString().equalsIgnoreCase(parseNode2.getType()) || (string2 = (String)parseNode2.getUserObject()).indexOf(string) < 0) continue;
                List<Measure> list = this.dependencyCheck.getMeasureDependencies(cube.getName(), cubeCalculatedMeasure.getName());
                if (!list.isEmpty()) {
                    for (Measure measure : list) {
                        CubeCalculatedMeasure cubeCalculatedMeasure2 = cube.findCalculatedMeasure(measure.getName());
                        if (cubeCalculatedMeasure2 == null) continue;
                        oLAPDimCascadeDroppedMeasuresCache.addMeasure(string, cubeCalculatedMeasure2);
                        cube.removeCalculatedMeasure(cubeCalculatedMeasure2);
                    }
                }
                oLAPDimCascadeDroppedMeasuresCache.addMeasure(string, cubeCalculatedMeasure);
                cube.removeCalculatedMeasure(cubeCalculatedMeasure);
            }
        }
    }
}

