/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.app.templates.templateview;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JOptionPane;
import oracle.ide.Ide;
import oracle.javatools.dialogs.MessageDialog;
import oracle.olap.OLAPArb;
import oracle.olap.app.olapmetadata.Dimension;
import oracle.olap.app.olapmetadata.DimensionHierarchy;
import oracle.olap.app.syntaxparser.ParseNode;
import oracle.olap.app.templates.templateview.MultiSelectShuttlePanel;
import oracle.olap.app.templates.templateview.TemplateHyperParamMultiSelect;
import oracle.olap.db.IdentifierElement;
import oracle.olap.syntaxbuilder.olapihelpers.Type;

public class TemplateHyperParamHierarchies
extends TemplateHyperParamMultiSelect {
    private Dimension dimension;
    private boolean valid;

    public TemplateHyperParamHierarchies() {
        this.editorTitle = OLAPArb.get("EXPRESSION_EDITOR_HIERARCHY_SELECTION_DIALOG_TITLE");
        this.selectionJOptionPanePropertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                if (TemplateHyperParamHierarchies.this.selectionDialog.isVisible() && propertyChangeEvent.getSource() == TemplateHyperParamHierarchies.this.pane && string.equals("value")) {
                    Object object = TemplateHyperParamHierarchies.this.pane.getValue();
                    if (object == JOptionPane.UNINITIALIZED_VALUE) {
                        return;
                    }
                    if ((Integer)object == 0) {
                        List<String> list = TemplateHyperParamHierarchies.this.multiSelectEditor.getSelectedItems();
                        if (list.size() > 0) {
                            TemplateHyperParamHierarchies.this.selectionDialog.setVisible(false);
                        } else {
                            String string2 = OLAPArb.get("EXPRESSION_EDITOR_HIERARCHY_SELECTION_NONE_SELECTED_ERROR_MSG");
                            String string3 = OLAPArb.get("EXPRESSION_EDITOR_HIERARCHY_SELECTION_ERROR_TITLE");
                            String string4 = null;
                            MessageDialog.error((Component)Ide.getMainWindow(), (Object)string2, (String)string3, string4);
                            TemplateHyperParamHierarchies.this.pane.setValue(JOptionPane.UNINITIALIZED_VALUE);
                        }
                    } else {
                        TemplateHyperParamHierarchies.this.selectionDialog.setVisible(false);
                    }
                }
            }
        };
    }

    @Override
    public ParseNode getPattern() {
        ParseNode parseNode = new ParseNode(this.getName(), null, ParseNode.PatternType.LOOP);
        parseNode.add(new ParseNode(this.getName(), Type.HIERARCHY.toString(), ParseNode.PatternType.NONE));
        return parseNode;
    }

    @Override
    public void init() {
        this.setDimension(this.getTemplateContext().getDimensions().get(0));
    }

    private void setDimension(Dimension dimension) {
        this.dimension = dimension;
        boolean bl = this.isValid();
        this.valid = false;
        String string = OLAPArb.getString("EXPRESSION_EDITOR_AVAILABLE_HIERARCHIES");
        String string2 = OLAPArb.getString("EXPRESSION_EDITOR_SELECTED_HIERARCHIES");
        ArrayList<String> arrayList = new ArrayList<String>(dimension.getHierarchies().size());
        for (DimensionHierarchy dimensionHierarchy : dimension.getHierarchies()) {
            arrayList.add(dimensionHierarchy.getName());
        }
        this.multiSelectEditor = new MultiSelectShuttlePanel(arrayList, string, string2);
        if (arrayList.size() > 0) {
            this.valid = true;
            ArrayList arrayList2 = new ArrayList();
            arrayList2.add(arrayList.get(0));
            this.setValue(arrayList2);
        }
        if (bl != this.isValid()) {
            this.firePropertyChangeEvent(new PropertyChangeEvent(this, "VALID_PROPERTY", bl, this.isValid()));
        }
    }

    @Override
    public String getExpression() {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator iterator = this.selections.iterator();
        if (iterator.hasNext()) {
            IdentifierElement identifierElement = new IdentifierElement((String)iterator.next());
            stringBuilder.append(identifierElement.get(identifierElement.getCount() - 1));
            while (iterator.hasNext()) {
                stringBuilder.append(',');
                identifierElement = new IdentifierElement((String)iterator.next());
                stringBuilder.append(identifierElement.get(identifierElement.getCount() - 1));
            }
        }
        return stringBuilder.toString();
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getNewValue() instanceof Dimension) {
            this.setDimension((Dimension)propertyChangeEvent.getNewValue());
        }
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }
}

