/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.actions;

import java.awt.Frame;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.Ide;
import oracle.javatools.db.ora.OracleDatabaseImpl;
import oracle.jdbc.internal.OracleCallableStatement;
import oracle.olap.OLAPArb;
import oracle.olap.actions.AbstractRenameAction;
import oracle.olap.actions.RenameDMLProgramDialog;
import oracle.olap.actions.RenameDialog;
import oracle.olap.app.JavaXMLBind;
import oracle.olap.app.olapmetadata.MetadataChange;
import oracle.olap.app.olapmetadata.OLAPMetadataCache;
import oracle.olap.app.table.Queries;
import oracle.olap.db.view.CubeAWUtil;
import oracle.olap.syntaxbuilder.olapihelpers.Type;

public class RenameDMLProgramAction
extends AbstractRenameAction {
    private static Queries queries;
    private static final String XMLFILE = "dmlprogramactionqueries.xml";
    private static final String RENAME_DMLPROGRAM = "RENAME_DMLPROGRAM";
    private DBObject dbObject;
    private OracleDatabaseImpl oraDb;
    private Connection conn;
    private String connName;
    private String owner;
    private String oldDMLProgName;
    private String awName;
    private final String DML_PROGRAM_TYPE_FOR_LABEL = "DML Program";
    private static Logger LOG;

    @Override
    protected void init() {
        this.dbObject = this.getDBObject();
        this.oraDb = (OracleDatabaseImpl)this.dbObject.getDatabase();
        this.conn = this.oraDb.getConnection();
        this.connName = this.dbObject.getConnectionName();
        this.owner = this.dbObject.getSchemaName();
        this.oldDMLProgName = this.dbObject.getObjectName();
        this.awName = CubeAWUtil.getAnalyticWorkspaceName(this.dbObject);
    }

    @Override
    protected Map<String, String> getObjectDescriptions() {
        return Collections.EMPTY_MAP;
    }

    @Override
    protected String getObjectType() {
        return "DML Program";
    }

    @Override
    protected void updateOLAPObject() {
        this.setNewObjectName(this.getRenameDialog().getNewName());
        this.setNewObjectDescriptions(this.getObjectDescriptions());
    }

    @Override
    protected void executeOLAPDDLStatements() throws Exception {
        String string = this.getOLAPDDLStatements();
        try (OracleCallableStatement oracleCallableStatement = null;){
            if (!string.isEmpty()) {
                oracleCallableStatement = (OracleCallableStatement)this.conn.prepareCall(string);
                oracleCallableStatement.execute();
                OLAPMetadataCache.recordMetadataChange(this.connName, this.owner, new MetadataChange(this.awName, this.oldDMLProgName, Type.DMLPROGRAM, "DELETION"));
                OLAPMetadataCache.recordMetadataChange(this.connName, this.owner, new MetadataChange(this.awName, this.getNewObjectName(), Type.DMLPROGRAM, "RENAMEIT"));
                OLAPMetadataCache.getUpdatedSchema(this.connName, this.owner);
            }
        }
    }

    @Override
    protected RenameDialog createRenameDialog(DBObject dBObject, String string, String string2, String string3, String string4) {
        return new RenameDMLProgramDialog((Frame)Ide.getMainWindow(), string, string2, string3, string4, this.getObjectDescriptions(), dBObject.getDatabase(), this);
    }

    @Override
    protected String getOLAPDDLStatements() throws Exception {
        String string = "";
        Collection<String> collection = this.getOLAPDDL(this.dbObject);
        if (collection != null && !collection.isEmpty()) {
            ArrayList<String> arrayList = new ArrayList<String>(collection);
            string = (String)arrayList.get(0);
        }
        return string;
    }

    @Override
    protected Collection<String> getOLAPDDL(DBObject dBObject) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = String.format("%s.%s", this.owner, this.awName);
        String string2 = this.getQuery(RENAME_DMLPROGRAM);
        if (!this.oldDMLProgName.equals(this.getNewObjectName())) {
            string2 = String.format(string2, string, this.oldDMLProgName, this.getNewObjectName());
            arrayList.add(string2);
        }
        return arrayList;
    }

    private String getQuery(String string) {
        if (queries == null) {
            try {
                String string2 = "oracle.olap.app.table";
                String string3 = JavaXMLBind.LoadDocument(((Object)((Object)this)).getClass(), XMLFILE);
                JavaXMLBind.BindToJavaStr(string3, string2, (Object)this);
            }
            catch (Exception exception) {
                LOG.log(Level.SEVERE, exception.getMessage());
            }
        }
        return queries.getSQL(string);
    }

    public void addQueries(Queries queries) {
        RenameDMLProgramAction.queries = queries;
    }

    @Override
    protected String getConfirmMessage(String string) {
        return null;
    }

    @Override
    protected String getConfirmTitle(String string) {
        return OLAPArb.format("DML_PROGRAM_RENAME_DLG_TITLE", string);
    }

    @Override
    protected String getProgressMessage(String string) {
        return OLAPArb.format("DML_PROGRAM_RENAME_PROGRESS_TITLE", string, this.getNewObjectName());
    }

    @Override
    protected String getSuccessMessage(String string) {
        return OLAPArb.format("DML_PROGRAM_RENAME_SUCCESS_MSG", string, this.getNewObjectName());
    }

    @Override
    protected String getErrorTitle(String string) {
        return OLAPArb.format("DML_PROGRAM_RENAME_ERROR_TITLE", string);
    }

    static {
        LOG = Logger.getLogger(RenameDMLProgramAction.class.getName());
    }
}

