/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.transformations;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.DefaultRowSorter;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import oracle.dmt.dataminer.controls.DataMinerTable;
import oracle.dmt.dataminer.controls.models.SimpleBaseTableModel;
import oracle.dmt.dataminer.core.utils.comparator.ToStringComparator;
import oracle.dmt.dataminer.core.utils.format.NumericFormat;
import oracle.dmt.dataminer.dprofiler.DataProfileStatisticsData;
import oracle.dmt.dataminer.utils.Formats;
import oracle.dmt.dataminer.utils.TimeUtils;
import oracle.dmt.dataminer.workflow.dialog.transformations.RefreshResult;
import oracle.dmt.dataminer.workflow.dialog.transformations.RefreshStatsProgressRunnable;
import oracle.dmt.dataminer.workflow.dialog.transformations.TransformationLoadGraphPanel;
import oracle.dmt.dataminer.workflow.dialog.transformations.TransformationStatisticsState;
import oracle.dmt.dataminer.workflow.dialog.transformations.XformDialogsLrb;
import oracle.dmt.dataminer.workflow.inspect.transformations.StatisticSelectionDefinitions;
import oracle.dmt.dataminer.workflow.xmlschema.StatsSelection;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationSourceAttribute;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationType;
import oracle.ide.Ide;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.ControlBar;
import oracle.javatools.ui.table.GenericTable;

public class TransformationStatisticPanel
extends JPanel {
    private TransformationStatisticsState _state;
    private TransformationLoadGraphPanel _parent;
    private String srcColumnName;
    private String outColumnName;
    private boolean noSource;
    private String customOutputName;
    private ComponentWithTitlebar<JComponent> jAttributesComponent;
    private GenericTable _jStatsTable = new DataMinerTable();
    private JButton jBtnRefresh;
    private static String _statsistics_column_name = XformDialogsLrb.get("STATISTIC_TAB_COLUMN_STATISTICS");
    protected Map<Integer, String> _rowLabels = new HashMap<Integer, String>();
    Map<String, Integer> _rowNameIdMap = new HashMap<String, Integer>();

    public TransformationStatisticPanel(TransformationLoadGraphPanel transformationLoadGraphPanel, TransformationStatisticsState transformationStatisticsState, String string, String string2, boolean bl, String string3) {
        this._state = transformationStatisticsState;
        this.noSource = bl;
        this._parent = transformationLoadGraphPanel;
        this.srcColumnName = string;
        this.outColumnName = string2;
        this.customOutputName = string3;
        this.buildRowLabels();
        this.initComponents();
        this.initUI();
    }

    private void initComponents() {
        this.jAttributesComponent = new ComponentWithTitlebar();
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 379, Short.MAX_VALUE).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent((Component)this.jAttributesComponent, -1, 359, Short.MAX_VALUE).addContainerGap())));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 290, Short.MAX_VALUE).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent((Component)this.jAttributesComponent, -1, 268, Short.MAX_VALUE).addContainerGap())));
    }

    public void initUI() {
        Object object;
        TransformationType transformationType;
        ControlBar controlBar = new ControlBar();
        this.jAttributesComponent.setControlBar(controlBar);
        StatisticsTableModel statisticsTableModel = null;
        TransformationSourceAttribute transformationSourceAttribute = this._state.findTransformationSourceColumn(this.srcColumnName);
        statisticsTableModel = transformationSourceAttribute != null && this.outColumnName == null ? (this.noSource ? new OriginalStatisticsTableModel(this.customOutputName) : new OriginalStatisticsTableModel(this._state.getDataProfileStatisticsData(this.srcColumnName))) : (null != (transformationType = (object = this._state.findTransformedColumn(this.outColumnName)).getTransformationElementType()).getCustomTransformation() || null != transformationType.getCustomTransformationEx() ? new CustomStatisticsTableModel(this._state.getDataProfileStatisticsData(this.outColumnName)) : new StatisticsTableModel(this._state.getDataProfileStatisticsData(this.srcColumnName), this._state.getDataProfileStatisticsData(this.outColumnName)));
        this.setupTableModel(statisticsTableModel);
        object = new JScrollPane((Component)this._jStatsTable);
        this.jAttributesComponent.setComponent((JComponent)object);
        this.jAttributesComponent.setLabel(new JLabel(XformDialogsLrb.get("STATISTIC_TAB_COLUMN_STATISTICS_TITLE")));
        this.updateRefresButtonState();
        if (this.isRefresheVisible()) {
            this.jBtnRefresh.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TransformationStatisticPanel.this.refreshButtonActionListener();
                }
            });
        }
    }

    private void createRefreshButton() {
        if (this.jBtnRefresh != null) {
            return;
        }
        this.jBtnRefresh = new JButton();
        this.jBtnRefresh.setToolTipText(XformDialogsLrb.get("MAIN_TRANSFORMATION_DIALOG_REFRESH_STATS"));
        this.jBtnRefresh.setIcon(OracleIcons.getIcon((String)"refresh.png"));
        this.jBtnRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TransformationStatisticPanel.this.refreshButtonActionListener();
            }
        });
        ControlBar controlBar = this.jAttributesComponent.getControlBar();
        controlBar.add((Component)this.jBtnRefresh);
    }

    private void removeRefreshButton() {
        if (this.jBtnRefresh == null) {
            return;
        }
        ControlBar controlBar = this.jAttributesComponent.getControlBar();
        controlBar.remove((Component)this.jBtnRefresh);
        this.jBtnRefresh = null;
    }

    public RefreshResult refreshStatistics() throws Exception {
        RefreshStatsProgressRunnable refreshStatsProgressRunnable = new RefreshStatsProgressRunnable(this._state, this._parent, this.outColumnName);
        refreshStatsProgressRunnable.setTitle(XformDialogsLrb.get("REFRESHING_STATISTICS"));
        refreshStatsProgressRunnable.setMessage(XformDialogsLrb.get("REFRESHING_STATISTICS_DETAILS"));
        refreshStatsProgressRunnable.start(true);
        return refreshStatsProgressRunnable.getResults();
    }

    boolean isRefresheVisible() {
        return !this._parent.isAddEditDialog();
    }

    void updateRefresButtonState() {
        boolean bl = this.isRefresheVisible();
        if (bl) {
            this.createRefreshButton();
            this.jBtnRefresh.setEnabled(this._state.needsRefresh(this.outColumnName));
        } else {
            this.removeRefreshButton();
        }
        this._parent.peerRefresButtonState(this);
    }

    void updateRefresButtonStateFromPeer() {
        boolean bl = this.isRefresheVisible();
        this.jBtnRefresh.setVisible(bl);
        if (bl) {
            this.createRefreshButton();
            this.jBtnRefresh.setEnabled(this._state.needsRefresh(this.outColumnName));
        } else {
            this.removeRefreshButton();
        }
    }

    public void setupTableModel(StatisticsTableModel statisticsTableModel) {
        Object object;
        assert (statisticsTableModel != null);
        this._jStatsTable.setModel((TableModel)((Object)statisticsTableModel));
        this._jStatsTable.setSorted(true);
        int n = this._jStatsTable.getColumnModel().getColumnCount();
        if (n == 2) {
            object = this._jStatsTable.getColumnModel().getColumn(1);
            ((TableColumn)object).setCellRenderer(new CustomRenderer());
        } else if (n == 3) {
            object = this._jStatsTable.getColumnModel().getColumn(1);
            ((TableColumn)object).setCellRenderer(new CustomRenderer());
            TableColumn tableColumn = this._jStatsTable.getColumnModel().getColumn(2);
            tableColumn.setCellRenderer(new CustomRenderer());
        }
        object = new TableRowSorter<TableModel>(this._jStatsTable.getModel());
        this._jStatsTable.setRowSorter((RowSorter)object);
        if (n == 2) {
            ((DefaultRowSorter)object).setComparator(1, (Comparator<?>)ToStringComparator.getComparator());
        }
        if (n == 3) {
            ((DefaultRowSorter)object).setComparator(2, (Comparator<?>)ToStringComparator.getComparator());
        }
    }

    public void updateTableModel(DataProfileStatisticsData dataProfileStatisticsData) {
        StatisticsTableModel statisticsTableModel = new StatisticsTableModel(this._state.getDataProfileStatisticsData(this.srcColumnName), dataProfileStatisticsData);
        this.setupTableModel(statisticsTableModel);
    }

    private void refreshButtonActionListener() {
        try {
            RefreshResult refreshResult = this.refreshStatistics();
            if (refreshResult.isException()) {
                throw refreshResult.getException();
            }
            if (refreshResult == null) {
                MessageDialog.information((Component)Ide.getMainWindow(), (Object)XformDialogsLrb.get("REFRESHING_STATISTICS_ABORTED"), (String)XformDialogsLrb.get("REFRESH_TRANSFORMATION_DIALOG_ERROR_TITLE"), null);
                return;
            }
            this._parent.updateGraph(refreshResult.getStatsData(), refreshResult.getGrafDataModel());
            this.updateRefresButtonState();
        }
        catch (Exception exception) {
            String string = exception.getLocalizedMessage();
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)string, (String)XformDialogsLrb.get("REFRESH_TRANSFORMATION_DIALOG_ERROR_TITLE"), null);
        }
    }

    private void buildRowLabels() {
        StatsSelection statsSelection = this._state.getStatsSelection();
        int n = 0;
        if (statsSelection.isPercentnull()) {
            this._rowLabels.put(n, StatisticSelectionDefinitions.PERCENT_NULL);
            this._rowNameIdMap.put(StatisticSelectionDefinitions.PERCENT_NULL, n++);
        }
        if (statsSelection.isPercentdistinct()) {
            this._rowLabels.put(n, StatisticSelectionDefinitions.DISTINCT);
            this._rowNameIdMap.put(StatisticSelectionDefinitions.DISTINCT, n++);
        }
        if (statsSelection.isMode()) {
            this._rowLabels.put(n, StatisticSelectionDefinitions.MODE);
            this._rowNameIdMap.put(StatisticSelectionDefinitions.MODE, n++);
        }
        if (statsSelection.isAvg()) {
            this._rowLabels.put(n, StatisticSelectionDefinitions.AVG);
            this._rowNameIdMap.put(StatisticSelectionDefinitions.AVG, n++);
        }
        if (statsSelection.isMedian()) {
            this._rowLabels.put(n, StatisticSelectionDefinitions.MEDIAN);
            this._rowNameIdMap.put(StatisticSelectionDefinitions.MEDIAN, n++);
        }
        if (statsSelection.isMin()) {
            this._rowLabels.put(n, StatisticSelectionDefinitions.MIN);
            this._rowNameIdMap.put(StatisticSelectionDefinitions.MIN, n++);
        }
        if (statsSelection.isMax()) {
            this._rowLabels.put(n, StatisticSelectionDefinitions.MAX);
            this._rowNameIdMap.put(StatisticSelectionDefinitions.MAX, n++);
        }
        if (statsSelection.isStd()) {
            this._rowLabels.put(n, StatisticSelectionDefinitions.STD);
            this._rowNameIdMap.put(StatisticSelectionDefinitions.STD, n++);
        }
        if (statsSelection.isVar()) {
            this._rowLabels.put(n, StatisticSelectionDefinitions.VAR);
            this._rowNameIdMap.put(StatisticSelectionDefinitions.VAR, n++);
        }
        if (statsSelection.isSkewness()) {
            this._rowLabels.put(n, StatisticSelectionDefinitions.SKEWNESS);
            this._rowNameIdMap.put(StatisticSelectionDefinitions.SKEWNESS, n++);
        }
        if (statsSelection.isKurtosis()) {
            this._rowLabels.put(n, StatisticSelectionDefinitions.KURTOSIS);
            this._rowNameIdMap.put(StatisticSelectionDefinitions.KURTOSIS, n++);
        }
    }

    private int getRowNumer(String string) {
        Integer n = this._rowNameIdMap.get(string);
        return n != null ? this._rowNameIdMap.get(string) : -1;
    }

    public int getPercentNullNumber() {
        return this.getRowNumer(StatisticSelectionDefinitions.PERCENT_NULL);
    }

    public int getDistinctNumber() {
        return this.getRowNumer(StatisticSelectionDefinitions.DISTINCT);
    }

    public int getModeNumber() {
        return this.getRowNumer(StatisticSelectionDefinitions.MODE);
    }

    public int getAvgNumber() {
        return this.getRowNumer(StatisticSelectionDefinitions.AVG);
    }

    public int getMedianNumber() {
        return this.getRowNumer(StatisticSelectionDefinitions.MEDIAN);
    }

    public int getMinNumber() {
        return this.getRowNumer(StatisticSelectionDefinitions.MIN);
    }

    public int getMaxNumber() {
        return this.getRowNumer(StatisticSelectionDefinitions.MAX);
    }

    public int getStdNumber() {
        return this.getRowNumer(StatisticSelectionDefinitions.STD);
    }

    public int getVarNumber() {
        return this.getRowNumer(StatisticSelectionDefinitions.VAR);
    }

    public int getSkewnessNumber() {
        return this.getRowNumer(StatisticSelectionDefinitions.SKEWNESS);
    }

    public int getKurtosisNumber() {
        return this.getRowNumer(StatisticSelectionDefinitions.KURTOSIS);
    }

    private class OriginalStatisticsTableModel
    extends StatisticsTableModel {
        OriginalStatisticsTableModel(String string) {
            this._columnNames = new String[]{_statsistics_column_name, string};
            this.setColumnIdentifiers(this._columnNames);
            this.buildData();
        }

        OriginalStatisticsTableModel(DataProfileStatisticsData dataProfileStatisticsData) {
            this._columnNames = new String[]{_statsistics_column_name, TransformationStatisticPanel.this.srcColumnName};
            this.setColumnIdentifiers(this._columnNames);
            this.srcColumnStats = dataProfileStatisticsData;
            this.buildData();
        }

        public String getColumnName(int n) {
            return this._columnNames[n];
        }
    }

    private class CustomStatisticsTableModel
    extends StatisticsTableModel {
        CustomStatisticsTableModel(DataProfileStatisticsData dataProfileStatisticsData) {
            this._columnNames = new String[]{_statsistics_column_name, TransformationStatisticPanel.this.outColumnName};
            this.setColumnIdentifiers(this._columnNames);
            this.newColumnStats = dataProfileStatisticsData;
            this.buildData();
        }
    }

    private class StatisticsTableModel
    extends SimpleBaseTableModel {
        protected Vector<Vector<Object>> data = new Vector();
        protected DataProfileStatisticsData srcColumnStats;
        protected DataProfileStatisticsData newColumnStats;
        protected String[] _columnNames;

        private StatisticsTableModel() {
        }

        StatisticsTableModel(DataProfileStatisticsData dataProfileStatisticsData, DataProfileStatisticsData dataProfileStatisticsData2) {
            this._columnNames = new String[]{_statsistics_column_name, TransformationStatisticPanel.this.srcColumnName, TransformationStatisticPanel.this.outColumnName};
            this.srcColumnStats = dataProfileStatisticsData;
            this.newColumnStats = dataProfileStatisticsData2;
            this.setColumnIdentifiers(this._columnNames);
            this.buildData();
        }

        protected void buildData() {
            for (int i = 0; i < TransformationStatisticPanel.this._rowLabels.size(); ++i) {
                Object object;
                String string;
                Vector<String> vector = new Vector<String>();
                String string2 = TransformationStatisticPanel.this._rowLabels.get(i);
                vector.add(string2);
                if (this.srcColumnStats != null) {
                    string = null;
                    object = this.getValue(i, this.srcColumnStats);
                    if (object != null && object instanceof Double) {
                        string = i == TransformationStatisticPanel.this.getPercentNullNumber() ? Formats.DataExplore.getPercentage().format((Double)object) : Formats.DataExplore.getNumeric().format((Double)object);
                    } else if (object != null && object instanceof GregorianCalendar) {
                        SimpleDateFormat simpleDateFormat = TimeUtils.getShortSimpleDateFormatZoneRFCTZ();
                        StringBuffer stringBuffer = new StringBuffer();
                        GregorianCalendar gregorianCalendar = (GregorianCalendar)object;
                        simpleDateFormat.setTimeZone(gregorianCalendar.getTimeZone());
                        Date date = gregorianCalendar.getTime();
                        simpleDateFormat.format(date, stringBuffer, new FieldPosition(0));
                        string = TimeUtils.removeGMT(stringBuffer.toString());
                    } else {
                        string = object != null ? object.toString() : "";
                    }
                    vector.add(string);
                }
                if (this.newColumnStats != null) {
                    string = null;
                    object = this.getValue(i, this.newColumnStats);
                    string = object != null && object instanceof Double ? (i == TransformationStatisticPanel.this.getPercentNullNumber() ? Formats.DataExplore.getPercentage().format((Double)object) : Formats.DataExplore.getNumeric().format((Double)object)) : (object != null ? object.toString() : "");
                    vector.add(string);
                }
                this.data.add(vector);
            }
        }

        public Object getValueAt(int n, int n2) {
            Object object = null;
            if (n2 < this.getColumnCount()) {
                Vector<Object> vector = this.data.get(n);
                if (n2 >= vector.size()) {
                    return "";
                }
                object = vector.get(n2);
            }
            return object != null ? object : "";
        }

        public int getRowCount() {
            return TransformationStatisticPanel.this._rowLabels.size();
        }

        protected Object getValue(int n, DataProfileStatisticsData dataProfileStatisticsData) {
            if (n == TransformationStatisticPanel.this.getPercentNullNumber()) {
                return dataProfileStatisticsData.getPercentNulls();
            }
            if (n == TransformationStatisticPanel.this.getDistinctNumber()) {
                return dataProfileStatisticsData.getNumOfDistincts();
            }
            if (n == TransformationStatisticPanel.this.getModeNumber()) {
                return dataProfileStatisticsData.getMode();
            }
            if (n == TransformationStatisticPanel.this.getAvgNumber()) {
                return dataProfileStatisticsData.getAvg();
            }
            if (n == TransformationStatisticPanel.this.getMedianNumber()) {
                return dataProfileStatisticsData.getMedian();
            }
            if (n == TransformationStatisticPanel.this.getMinNumber()) {
                return dataProfileStatisticsData.getMin();
            }
            if (n == TransformationStatisticPanel.this.getMaxNumber()) {
                return dataProfileStatisticsData.getMax();
            }
            if (n == TransformationStatisticPanel.this.getStdNumber()) {
                return dataProfileStatisticsData.getStd();
            }
            if (n == TransformationStatisticPanel.this.getVarNumber()) {
                return dataProfileStatisticsData.getVar();
            }
            if (n == TransformationStatisticPanel.this.getSkewnessNumber()) {
                return dataProfileStatisticsData.getSkewness();
            }
            if (n == TransformationStatisticPanel.this.getKurtosisNumber()) {
                return dataProfileStatisticsData.getKurtosis();
            }
            return "";
        }
    }

    public class CustomRenderer
    extends DefaultTableCellRenderer {
        private Formats.Type formatType;

        public CustomRenderer(Formats.Type type) {
            this.formatType = type;
        }

        public CustomRenderer() {
            this.formatType = Formats.Type.NUMERICAL;
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        }

        @Override
        public void setValue(Object object) {
            if (object != null) {
                Object object2 = null;
                if (object instanceof Double) {
                    object2 = this.formatType == Formats.Type.PERCENTAGE ? Formats.DataExplore.getPercentage().format((Double)object) : Formats.DataExplore.getNumeric().format((Double)object);
                } else if (object instanceof Integer) {
                    object2 = NumericFormat.format((int)((Integer)object), (boolean)true, (int)8);
                } else if (object instanceof String) {
                    object2 = (String)object;
                }
                super.setValue(object2);
            }
        }
    }
}

