/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.dynamic;

import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dmt.dataminer.controls.models.ModelHeuristicRules;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.dialog.dynamic.DynamicNodesLrb;
import oracle.dmt.dataminer.workflow.model.DynamicNode;
import oracle.ide.Context;
import oracle.ide.dialogs.ProgressException;
import oracle.ide.dialogs.ProgressRunnable;

public class DynamicEditorHelper {
    private static final Logger theLogger = Logger.getLogger(DynamicEditorHelper.class.getName());
    private Map<String, ModelHeuristicRules> modelRules;

    public Map<String, ModelHeuristicRules> getHeuristicRules(Context context, DynamicNode dynamicNode) {
        if (this.modelRules == null) {
            this.fetchHeuristicRulesInternal(context, dynamicNode);
        }
        return this.modelRules;
    }

    private void fetchHeuristicRulesInternal(Context context, DynamicNode dynamicNode) {
        class GetRules
        extends ProgressRunnable {
            protected DynamicNode dynamicNode;
            protected Context context;

            GetRules(Context context, DynamicNode dynamicNode) {
                this.dynamicNode = dynamicNode;
                this.context = context;
            }

            protected Object doWork() throws Exception {
                DynamicEditorHelper.this.modelRules = MetaDataHelper.getHeuristicsRulesModels(this.context, this.dynamicNode);
                return DynamicEditorHelper.this.modelRules;
            }
        }
        GetRules getRules = new GetRules(context, dynamicNode);
        getRules.setTitle(DynamicNodesLrb.get("LOAD_AVAIL_RULES"));
        getRules.setMessage(DynamicNodesLrb.get("LOAD_AVAIL_RULES_DESCR"));
        getRules.setCancelable(false);
        try {
            getRules.start(true);
        }
        catch (ProgressException progressException) {
            theLogger.log(Level.SEVERE, progressException.getMessage(), progressException);
        }
    }
}

