/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.build.algorithm;

import java.awt.Component;
import java.util.Locale;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.text.NumberTextField;
import oracle.dmt.dataminer.controls.dialog.DialogDisplayable;
import oracle.dmt.dataminer.controls.dialog.DialogExecutionException;
import oracle.dmt.dataminer.controls.dialog.Dialogable;
import oracle.dmt.dataminer.controls.dialog.DialogableExecutableAdapter;
import oracle.dmt.dataminer.exception.DataMinerException;
import oracle.dmt.dataminer.workflow.dialog.build.algorithm.AlgSettingsLrb;
import oracle.dmt.dataminer.workflow.dialog.model.DialogsLrb;
import oracle.ide.Ide;
import oracle.javatools.dialogs.MessageDialog;

public class ModelSVDPCABuildSettingsSolverPanel
extends JPanel
implements DialogDisplayable {
    private String overSampling;
    private String powerIteration;
    private String randomSeed;
    private JLabel lblOverSampling;
    private JLabel lblPowerIteration;
    private JLabel lblRandomSeed;
    private JTextField txtOverSampling;
    private JTextField txtPowerIteration;
    private JTextField txtRandomSeed;

    public ModelSVDPCABuildSettingsSolverPanel(String string, String string2, String string3) {
        this.initComponents();
        this.overSampling = string;
        this.powerIteration = string2;
        this.randomSeed = string3;
        this.initUI();
    }

    private void initUI() {
        ((NumberTextField)this.txtRandomSeed).setDecimal(false);
        this.setDataType(this.txtRandomSeed, Integer.class);
        this.setSigned(this.txtRandomSeed, false);
        this.setNumber(this.txtRandomSeed, Integer.valueOf(this.randomSeed));
        ((NumberTextField)this.txtOverSampling).setDecimal(false);
        this.setDataType(this.txtOverSampling, Integer.class);
        this.setSigned(this.txtOverSampling, false);
        this.setNumber(this.txtOverSampling, Integer.valueOf(this.overSampling));
        ((NumberTextField)this.txtPowerIteration).setDecimal(false);
        this.setDataType(this.txtPowerIteration, Integer.class);
        this.setSigned(this.txtPowerIteration, false);
        this.setNumber(this.txtPowerIteration, Integer.valueOf(this.powerIteration));
    }

    protected void setNumber(JTextField jTextField, Number number) {
        ((NumberTextField)jTextField).setNumber(number);
    }

    protected void setDataType(JTextField jTextField, Class clazz) {
        ((NumberTextField)jTextField).setDataType(clazz);
    }

    protected void setSigned(JTextField jTextField, boolean bl) {
        ((NumberTextField)jTextField).setSigned(bl);
    }

    protected void setLocale(JTextField jTextField, Locale locale) {
        ((NumberTextField)jTextField).setLocale(locale);
    }

    protected Number getNumber(JTextField jTextField) {
        return ((NumberTextField)jTextField).getNumber();
    }

    @Override
    public Dialogable asDialog() {
        return new DialogableExecutableAdapter(){

            @Override
            public void onFailure(DialogExecutionException dialogExecutionException, JEWTDialog jEWTDialog) {
            }

            @Override
            public void onOK() throws DialogExecutionException {
                Number number = ((NumberTextField)ModelSVDPCABuildSettingsSolverPanel.this.txtOverSampling).getNumber();
                if (null == number || number.doubleValue() < 0.0 || number.doubleValue() > 10000.0) {
                    String string = AlgSettingsLrb.get("SVMS_OVERSAMPLING_OUT_OF_RANGE");
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)string, (String)AlgSettingsLrb.get("ALGORITHM_SETTINGS_ERROR_TITLE"), null);
                    throw new DataMinerException(AlgSettingsLrb.get("ALGORITHM_SETTINGS_ERROR_TITLE"));
                }
                Number number2 = ((NumberTextField)ModelSVDPCABuildSettingsSolverPanel.this.txtPowerIteration).getNumber();
                if (null == number2 || number2.doubleValue() < 0.0 || number2.doubleValue() > 20.0) {
                    String string = AlgSettingsLrb.get("SVMS_POWER_ITERATION_OUT_OF_RANGE");
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)string, (String)AlgSettingsLrb.get("ALGORITHM_SETTINGS_ERROR_TITLE"), null);
                    throw new DataMinerException(AlgSettingsLrb.get("ALGORITHM_SETTINGS_ERROR_TITLE"));
                }
                Number number3 = ((NumberTextField)ModelSVDPCABuildSettingsSolverPanel.this.txtRandomSeed).getNumber();
                if (null == number3 || number3.doubleValue() < 0.0) {
                    String string = AlgSettingsLrb.get("SVMS_RANDOM_SEED_OUT_OF_RANGE");
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)string, (String)AlgSettingsLrb.get("ALGORITHM_SETTINGS_ERROR_TITLE"), null);
                    throw new DataMinerException(AlgSettingsLrb.get("ALGORITHM_SETTINGS_ERROR_TITLE"));
                }
            }

            @Override
            public String getTitle() {
                return DialogsLrb.get("SVMS_SOLVER_OPTION_DIALOG");
            }

            @Override
            public String getHelpTopic() {
                return "sva_pca_solver_options_id";
            }

            @Override
            public JComponent getContent() {
                return ModelSVDPCABuildSettingsSolverPanel.this;
            }
        };
    }

    public String getOverSampling() {
        return this.getNumber(this.txtOverSampling).toString();
    }

    public String getPowerIteration() {
        return this.getNumber(this.txtPowerIteration).toString();
    }

    public String getRandomSeed() {
        return this.getNumber(this.txtRandomSeed).toString();
    }

    private void initComponents() {
        this.lblOverSampling = new JLabel();
        this.txtOverSampling = new NumberTextField();
        this.lblPowerIteration = new JLabel();
        this.txtPowerIteration = new NumberTextField();
        this.lblRandomSeed = new JLabel();
        this.txtRandomSeed = new NumberTextField();
        this.lblOverSampling.setText("Oversampling:");
        this.txtOverSampling.setText("5");
        this.lblPowerIteration.setText("Power Iteration:");
        this.txtPowerIteration.setText("2");
        this.lblRandomSeed.setText("Random Seed:");
        this.txtRandomSeed.setText("0");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblPowerIteration).addComponent(this.lblRandomSeed).addComponent(this.lblOverSampling)).addGap(18, 26, Short.MAX_VALUE).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.txtOverSampling, GroupLayout.Alignment.LEADING).addComponent(this.txtPowerIteration, GroupLayout.Alignment.LEADING, -1, 113, Short.MAX_VALUE).addComponent(this.txtRandomSeed, GroupLayout.Alignment.LEADING)).addContainerGap(19, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(21, 21, 21).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblOverSampling).addComponent(this.txtOverSampling, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblPowerIteration).addComponent(this.txtPowerIteration, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblRandomSeed).addComponent(this.txtRandomSeed, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }
}

