/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.apply;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dmt.dataminer.common.model.AttrTableModel;
import oracle.dmt.dataminer.controls.DataMinerTable;
import oracle.dmt.dataminer.controls.DialogDisplayer;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.dialog.AttributeNameCellRenderer;
import oracle.dmt.dataminer.workflow.dialog.apply.ApplyDataPanel;
import oracle.dmt.dataminer.workflow.dialog.apply.DialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.data.DataDialogsLrb;
import oracle.dmt.dataminer.workflow.model.ApplyNode;
import oracle.dmt.dataminer.workflow.model.DataProvider;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.SupplementalAttributesType;
import oracle.ide.Context;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.table.GenericTable;

public class SuppAttrsPanel
extends DialogDisplayer<ApplyNode> {
    private List<AttributeType> availAttrsCache = new ArrayList<AttributeType>();
    private List<AttributeType> selectedAttrsCache;
    private boolean _dirty = false;
    private DataMinerTable jAvailAttrs;
    private JScrollPane jAvailAttrsScrollPane;
    private JLabel jAvailableLabel;
    private JLabel jSelectedLabel;
    private JButton jRemoveAllBtn;
    private JButton jRemoveBtn;
    private JButton jSelectAllBtn;
    private JButton jSelectBtn;
    private DataMinerTable jSelectedAttrs;
    private JScrollPane jSelectedAttrsScrollPane;

    public SuppAttrsPanel(Context context, ApplyDataPanel applyDataPanel, DataProvider dataProvider, SupplementalAttributesType supplementalAttributesType) {
        super(context, (ApplyNode)applyDataPanel.getData());
        List list = dataProvider.getAttributes().getAttribute();
        for (AttributeType attributeType : list) {
            AttributeType attributeType2 = (AttributeType)MetaDataHelper.copyMetadataObject(attributeType);
            this.availAttrsCache.add(attributeType2);
        }
        SupplementalAttributesType supplementalAttributesType2 = (SupplementalAttributesType)MetaDataHelper.copyMetadataObject(supplementalAttributesType);
        this.selectedAttrsCache = supplementalAttributesType2.getAttribute();
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this.jSelectedAttrsScrollPane = new JScrollPane();
        this.jSelectedAttrs = new DataMinerTable();
        this.jSelectBtn = new JButton();
        this.jSelectAllBtn = new JButton();
        this.jRemoveBtn = new JButton();
        this.jRemoveAllBtn = new JButton();
        this.jAvailableLabel = new JLabel();
        this.jSelectedLabel = new JLabel();
        this.jAvailAttrsScrollPane = new JScrollPane();
        this.jAvailAttrs = new DataMinerTable();
        this.jSelectedAttrs.setModel(new DefaultTableModel(new Object[][]{{null, null}}, new String[]{"Name", "Data Type"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, String.class};
                this.canEdit = new boolean[]{false, false};
            }

            public Class getColumnClass(int n) {
                return this.types[n];
            }

            @Override
            public boolean isCellEditable(int n, int n2) {
                return this.canEdit[n2];
            }
        });
        this.jSelectedAttrsScrollPane.setViewportView((Component)((Object)this.jSelectedAttrs));
        this.jSelectBtn.setText(">");
        this.jSelectAllBtn.setText(">>");
        this.jRemoveBtn.setText("<");
        this.jRemoveAllBtn.setText("<<");
        this.jAvailableLabel.setLabelFor(this.jAvailAttrsScrollPane);
        this.jAvailableLabel.setText("Available Attributes");
        this.jSelectedLabel.setLabelFor(this.jSelectedAttrsScrollPane);
        this.jSelectedLabel.setText("Selected Attributes");
        this.jAvailAttrs.setModel(new DefaultTableModel(new Object[][]{{null, null}}, new String[]{"Name", "Data Type"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, String.class};
                this.canEdit = new boolean[]{false, false};
            }

            public Class getColumnClass(int n) {
                return this.types[n];
            }

            @Override
            public boolean isCellEditable(int n, int n2) {
                return this.canEdit[n2];
            }
        });
        this.jAvailAttrsScrollPane.setViewportView((Component)((Object)this.jAvailAttrs));
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jAvailableLabel, -1, 277, Short.MAX_VALUE).addComponent(this.jAvailAttrsScrollPane, GroupLayout.Alignment.TRAILING, -1, 277, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jSelectBtn, -1, 49, Short.MAX_VALUE).addComponent(this.jSelectAllBtn, -1, 49, Short.MAX_VALUE).addComponent(this.jRemoveBtn, -1, 49, Short.MAX_VALUE).addComponent(this.jRemoveAllBtn, -1, 49, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSelectedAttrsScrollPane, -1, 289, Short.MAX_VALUE).addComponent(this.jSelectedLabel, -1, 289, Short.MAX_VALUE))));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jSelectedLabel).addComponent(this.jAvailableLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSelectedAttrsScrollPane, -1, 210, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addGap(32, 32, 32).addComponent(this.jSelectBtn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSelectAllBtn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRemoveBtn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRemoveAllBtn)).addComponent(this.jAvailAttrsScrollPane, -1, 210, Short.MAX_VALUE)).addContainerGap()));
    }

    @Override
    public void initRes() {
        ResourceUtils.resLabel((JLabel)this.jAvailableLabel, (Component)((Object)this.jAvailAttrs), (String)DataDialogsLrb.get("AVAILABLE_LABEL"));
        ResourceUtils.resLabel((JLabel)this.jSelectedLabel, (Component)((Object)this.jSelectedAttrs), (String)DataDialogsLrb.get("SELECTED_LABEL"));
        this.initIcons();
    }

    private void initIcons() {
        this.jSelectBtn.setIcon(OracleIcons.getIcon((String)"shuttle_right.png"));
        this.jSelectAllBtn.setIcon(OracleIcons.getIcon((String)"shuttle_rightall.png"));
        this.jRemoveBtn.setIcon(OracleIcons.getIcon((String)"shuttle_left.png"));
        this.jRemoveAllBtn.setIcon(OracleIcons.getIcon((String)"shuttle_leftall.png"));
    }

    @Override
    public void initUI() {
        this.jSelectBtn.setText("");
        this.jSelectAllBtn.setText("");
        this.jRemoveBtn.setText("");
        this.jRemoveAllBtn.setText("");
        this.removeSelectedAttrs(this.availAttrsCache, this.selectedAttrsCache);
        AttrTableModel<AttributeType> attrTableModel = new AttrTableModel<AttributeType>(this.availAttrsCache);
        this.jAvailAttrs.setModel((TableModel)((Object)attrTableModel));
        this.jAvailAttrs.setSorted(true);
        TableColumn tableColumn = this.jAvailAttrs.getColumnModel().getColumn(0);
        AttributeNameCellRenderer attributeNameCellRenderer = new AttributeNameCellRenderer(OracleIcons.getIcon((String)"attribute.png"), OracleIcons.getIcon((String)"warning.png"));
        tableColumn.setCellRenderer(attributeNameCellRenderer);
        AttrTableModel<AttributeType> attrTableModel2 = new AttrTableModel<AttributeType>(this.selectedAttrsCache);
        this.jSelectedAttrs.setModel((TableModel)((Object)attrTableModel2));
        this.jSelectedAttrs.setSorted(true);
        tableColumn = this.jSelectedAttrs.getColumnModel().getColumn(0);
        attributeNameCellRenderer = new AttributeNameCellRenderer(OracleIcons.getIcon((String)"attribute.png"), OracleIcons.getIcon((String)"warning.png"));
        tableColumn.setCellRenderer(attributeNameCellRenderer);
        this.jAvailAttrs.getRowSorter().toggleSortOrder(0);
        this.jSelectedAttrs.getRowSorter().toggleSortOrder(0);
        this.jAvailAttrs.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2 && SwingUtilities.isLeftMouseButton(mouseEvent)) {
                    SuppAttrsPanel.this.moveItems(SuppAttrsPanel.this.jAvailAttrs, SuppAttrsPanel.this.jSelectedAttrs, false);
                }
            }
        });
        this.jSelectedAttrs.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2 && SwingUtilities.isLeftMouseButton(mouseEvent)) {
                    SuppAttrsPanel.this.moveItems(SuppAttrsPanel.this.jSelectedAttrs, SuppAttrsPanel.this.jAvailAttrs, false);
                }
            }
        });
        this.jSelectBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SuppAttrsPanel.this.moveItems(SuppAttrsPanel.this.jAvailAttrs, SuppAttrsPanel.this.jSelectedAttrs, false);
            }
        });
        this.jSelectAllBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SuppAttrsPanel.this.moveItems(SuppAttrsPanel.this.jAvailAttrs, SuppAttrsPanel.this.jSelectedAttrs, true);
            }
        });
        this.jRemoveBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SuppAttrsPanel.this.moveItems(SuppAttrsPanel.this.jSelectedAttrs, SuppAttrsPanel.this.jAvailAttrs, false);
            }
        });
        this.jRemoveAllBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SuppAttrsPanel.this.moveItems(SuppAttrsPanel.this.jSelectedAttrs, SuppAttrsPanel.this.jAvailAttrs, true);
            }
        });
    }

    private void moveItems(GenericTable genericTable, GenericTable genericTable2, boolean bl) {
        int n;
        Object object2;
        int[] nArray = genericTable.getSelectedRowsInModel();
        List list = ((AttrTableModel)((Object)genericTable.getModel())).getSrcData();
        ArrayList<AttributeType> arrayList = new ArrayList<AttributeType>();
        if (!bl) {
            for (var7_7 = 0; var7_7 < nArray.length; ++var7_7) {
                object2 = (AttributeType)list.get(nArray[var7_7]);
                arrayList.add((AttributeType)object2);
            }
        } else {
            for (var7_7 = 0; var7_7 < list.size(); ++var7_7) {
                arrayList.add((AttributeType)list.get(var7_7));
            }
        }
        for (Object object2 : arrayList) {
            n = list.indexOf(object2);
            if (n == -1) continue;
            list.remove(n);
        }
        List list2 = ((AttrTableModel)((Object)genericTable2.getModel())).getSrcData();
        list2.addAll(arrayList);
        ((AttrTableModel)((Object)genericTable2.getModel())).setRowCount(list2.size());
        ((AttrTableModel)((Object)genericTable.getModel())).setRowCount(list.size());
        ((AbstractTableModel)genericTable.getModel()).fireTableDataChanged();
        ((AbstractTableModel)genericTable2.getModel()).fireTableDataChanged();
        object2 = new int[arrayList.size()];
        for (n = 0; n < arrayList.size(); ++n) {
            int n2 = list2.indexOf(arrayList.get(n));
            assert (n2 != -1) : "Unexpected state - added item should be present and must have an index";
            object2[n] = (AttributeType)n2;
        }
        genericTable2.setSelectedRowsInModel((int[])object2);
        this._dirty = true;
    }

    private void removeSelectedAttrs(List<AttributeType> list, List<AttributeType> list2) {
        HashMap<String, AttributeType> hashMap = new HashMap<String, AttributeType>();
        for (AttributeType attributeType : list2) {
            hashMap.put(attributeType.getName(), attributeType);
        }
        Iterator<AttributeType> iterator = list.iterator();
        while (iterator.hasNext()) {
            AttributeType attributeType;
            attributeType = iterator.next();
            AttributeType attributeType2 = (AttributeType)hashMap.get(attributeType.getName());
            if (attributeType2 == null || !attributeType2.getName().equals(attributeType.getName()) || !attributeType2.getDataType().equals(attributeType.getDataType())) continue;
            iterator.remove();
        }
    }

    public List<AttributeType> getSelectedAttrsCache() {
        return this.selectedAttrsCache;
    }

    public boolean isDirty() {
        return this._dirty;
    }

    @Override
    protected String getDialogTitle() {
        return DialogsLrb.get("APPLY_DATA_SUPPL_DIALOG_TITLE");
    }

    @Override
    protected String getHelpTopic() {
        return "apply_supplemental";
    }

    @Override
    protected void customizeDialogProperties(JEWTDialog jEWTDialog) {
        super.customizeDialogProperties(jEWTDialog);
        jEWTDialog.setMinimumSize(new Dimension(650, 300));
    }
}

