/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.server.model;

import java.util.HashMap;
import java.util.Map;
import oracle.dmt.dataminer.core.model.CoreServerConstantsLrb;
import oracle.dmt.dataminer.workflow.xmlschema.AnomalyDetectionModelType;
import oracle.dmt.dataminer.workflow.xmlschema.AprioriModelType;
import oracle.dmt.dataminer.workflow.xmlschema.CGeneralizedLinearModelType;
import oracle.dmt.dataminer.workflow.xmlschema.CSupportVectorMachineModelType;
import oracle.dmt.dataminer.workflow.xmlschema.DecisionTreeModelType;
import oracle.dmt.dataminer.workflow.xmlschema.ExpectationMaximizationModelType;
import oracle.dmt.dataminer.workflow.xmlschema.ExplicitSemanticAnalysisModelType;
import oracle.dmt.dataminer.workflow.xmlschema.KMeansModelType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningAlgorithmType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelSettingODMType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelSettingsODM;
import oracle.dmt.dataminer.workflow.xmlschema.ModelType;
import oracle.dmt.dataminer.workflow.xmlschema.NaiveBayesModelType;
import oracle.dmt.dataminer.workflow.xmlschema.NonNegativeMatrixFactorModelType;
import oracle.dmt.dataminer.workflow.xmlschema.OClusterModelType;
import oracle.dmt.dataminer.workflow.xmlschema.PCAModelType;
import oracle.dmt.dataminer.workflow.xmlschema.RGeneralizedLinearModelType;
import oracle.dmt.dataminer.workflow.xmlschema.RModelType;
import oracle.dmt.dataminer.workflow.xmlschema.RSupportVectorMachineModelType;
import oracle.dmt.dataminer.workflow.xmlschema.SVDModelType;

public final class MiningAlgorithms
extends Enum<MiningAlgorithms> {
    public static final /* enum */ MiningAlgorithms APRIORI = new MiningAlgorithms(CoreServerConstantsLrb.get((String)"ALGO_APRIORI_ASSOCIATION_RULES"));
    public static final /* enum */ MiningAlgorithms DECISION_TREE = new MiningAlgorithms(CoreServerConstantsLrb.get((String)"ALGO_DECISION_TREE"));
    public static final /* enum */ MiningAlgorithms EXPECTATION_MAXIMIZATION = new MiningAlgorithms(CoreServerConstantsLrb.get((String)"ALGO_EXPECTATION_MAXIMIZATION"));
    public static final /* enum */ MiningAlgorithms GENERALIZED_LINEAR_MODEL = new MiningAlgorithms(CoreServerConstantsLrb.get((String)"ALGO_GENERALIZED_LINEAR_MODEL"));
    public static final /* enum */ MiningAlgorithms KMEANS = new MiningAlgorithms(CoreServerConstantsLrb.get((String)"ALGO_KMEANS"));
    public static final /* enum */ MiningAlgorithms NAIVE_BAYES = new MiningAlgorithms(CoreServerConstantsLrb.get((String)"ALGO_NAIVE_BAYES"));
    public static final /* enum */ MiningAlgorithms NON_NEGATIVE_MATRIX_FACTORIZATION = new MiningAlgorithms(CoreServerConstantsLrb.get((String)"ALGO_NONNEGATIVE_MATRIX_FACTOR"));
    public static final /* enum */ MiningAlgorithms PRINCIPAL_COMPONENT_ANALYSIS = new MiningAlgorithms(CoreServerConstantsLrb.get((String)"ALGO_PRINCIPAL_COMPONENT_ANALYSIS"));
    public static final /* enum */ MiningAlgorithms SINGULAR_VALUE_DECOMP = new MiningAlgorithms(CoreServerConstantsLrb.get((String)"ALGO_SINGULAR_VALUE_DECOMP"));
    public static final /* enum */ MiningAlgorithms OCLUSTER = new MiningAlgorithms(CoreServerConstantsLrb.get((String)"ALGO_O_CLUSTER"));
    public static final /* enum */ MiningAlgorithms SUPPORT_VECTOR_MACHINE = new MiningAlgorithms(CoreServerConstantsLrb.get((String)"ALGO_SUPPORT_VECTOR_MACHINE"));
    public static final /* enum */ MiningAlgorithms EXPLICIT_SEMANTIC_ANALYSIS = new MiningAlgorithms(CoreServerConstantsLrb.get((String)"ALGO_EXPLICIT_SEMANTIC_ANALYS"));
    public static final /* enum */ MiningAlgorithms R_EXTENSIBLE = new MiningAlgorithms(CoreServerConstantsLrb.get((String)"ALGO_R_USER_DEFINED"));
    private final String translation;
    private static final Map<String, MiningAlgorithms> stringToEnum;
    private static final /* synthetic */ MiningAlgorithms[] $VALUES;

    public static MiningAlgorithms[] values() {
        return (MiningAlgorithms[])$VALUES.clone();
    }

    public static MiningAlgorithms valueOf(String string) {
        return Enum.valueOf(MiningAlgorithms.class, string);
    }

    private MiningAlgorithms(String string2) {
        this.translation = string2;
    }

    public static MiningAlgorithms fromString(String string) {
        return stringToEnum.get(string);
    }

    public String toString() {
        return this.translation;
    }

    public static String translateFromODMServerAlgorithm(String string, String string2) {
        ModelSettingsODM modelSettingsODM = null;
        if (string2 != null) {
            modelSettingsODM = new ModelSettingsODM();
            ModelSettingODMType modelSettingODMType = new ModelSettingODMType();
            modelSettingODMType.setName("SVDS_SCORING_MODE");
            modelSettingODMType.setValue(string2);
            modelSettingODMType.setType("Default");
            modelSettingsODM.getModelSettingODM().add(modelSettingODMType);
        }
        return MiningAlgorithms.translateFromODMServerAlgorithm(string, modelSettingsODM);
    }

    public static String translateFromODMServerAlgorithm(String string, ModelSettingsODM modelSettingsODM) {
        Object object;
        block15 : switch (string) {
            case "PRINCIPAL_COMPONENT_ANALYSIS": {
                object = PRINCIPAL_COMPONENT_ANALYSIS.toString();
                break;
            }
            case "APRIORI_ASSOCIATION_RULES": {
                object = APRIORI.toString();
                break;
            }
            case "DECISION_TREE": {
                object = DECISION_TREE.toString();
                break;
            }
            case "EXPECTATION_MAXIMIZATION": {
                object = EXPECTATION_MAXIMIZATION.toString();
                break;
            }
            case "GENERALIZED_LINEAR_MODEL": {
                object = GENERALIZED_LINEAR_MODEL.toString();
                break;
            }
            case "KMEANS": {
                object = KMEANS.toString();
                break;
            }
            case "NAIVE_BAYES": {
                object = NAIVE_BAYES.toString();
                break;
            }
            case "O_CLUSTER": {
                object = OCLUSTER.toString();
                break;
            }
            case "SUPPORT_VECTOR_MACHINES": {
                object = SUPPORT_VECTOR_MACHINE.toString();
                break;
            }
            case "NONNEGATIVE_MATRIX_FACTOR": {
                object = NON_NEGATIVE_MATRIX_FACTORIZATION.toString();
                break;
            }
            case "SINGULAR_VALUE_DECOMP": {
                object = SINGULAR_VALUE_DECOMP.toString();
                if (modelSettingsODM == null) break;
                for (ModelSettingODMType modelSettingODMType : modelSettingsODM.getModelSettingODM()) {
                    if (!"SVDS_SCORING_MODE".equals(modelSettingODMType.getName())) continue;
                    if ("SVDS_SCORING_SVD".equals(modelSettingODMType.getValue())) {
                        object = SINGULAR_VALUE_DECOMP.toString();
                        break block15;
                    }
                    object = PRINCIPAL_COMPONENT_ANALYSIS.toString();
                    break block15;
                }
                break;
            }
            case "EXPLICIT_SEMANTIC_ANALYS": {
                object = EXPLICIT_SEMANTIC_ANALYSIS.toString();
                break;
            }
            case "R_EXTENSIBLE": {
                object = R_EXTENSIBLE.toString();
                break;
            }
            default: {
                object = "UNKNOWN:" + string;
            }
        }
        return object;
    }

    public static MiningAlgorithmType translateToDataMinerServerMiningAlgorithm(MiningAlgorithms miningAlgorithms) {
        MiningAlgorithmType miningAlgorithmType = null;
        switch (miningAlgorithms) {
            case APRIORI: {
                miningAlgorithmType = MiningAlgorithmType.APRIORI_ASSOCIATION_RULES;
                break;
            }
            case DECISION_TREE: {
                miningAlgorithmType = MiningAlgorithmType.DECISION_TREE;
                break;
            }
            case EXPECTATION_MAXIMIZATION: {
                miningAlgorithmType = MiningAlgorithmType.EXPECTATION_MAXIMIZATION;
                break;
            }
            case GENERALIZED_LINEAR_MODEL: {
                miningAlgorithmType = MiningAlgorithmType.GENERALIZED_LINEAR_MODEL;
                break;
            }
            case KMEANS: {
                miningAlgorithmType = MiningAlgorithmType.KMEANS;
                break;
            }
            case NAIVE_BAYES: {
                miningAlgorithmType = MiningAlgorithmType.NAIVE_BAYES;
                break;
            }
            case NON_NEGATIVE_MATRIX_FACTORIZATION: {
                miningAlgorithmType = MiningAlgorithmType.NONNEGATIVE_MATRIX_FACTOR;
                break;
            }
            case SINGULAR_VALUE_DECOMP: {
                miningAlgorithmType = MiningAlgorithmType.SINGULAR_VALUE_DECOMP;
                break;
            }
            case OCLUSTER: {
                miningAlgorithmType = MiningAlgorithmType.O_CLUSTER;
                break;
            }
            case SUPPORT_VECTOR_MACHINE: {
                miningAlgorithmType = MiningAlgorithmType.SUPPORT_VECTOR_MACHINES;
                break;
            }
            case PRINCIPAL_COMPONENT_ANALYSIS: {
                miningAlgorithmType = MiningAlgorithmType.PRINCIPAL_COMPONENT_ANALYSIS;
                break;
            }
            case EXPLICIT_SEMANTIC_ANALYSIS: {
                miningAlgorithmType = MiningAlgorithmType.EXPLICIT_SEMANTIC_ANALYSIS;
                break;
            }
            case R_EXTENSIBLE: {
                miningAlgorithmType = MiningAlgorithmType.R_EXTENSIBLE;
                break;
            }
            default: {
                assert (false) : "Invalid Algorithm Type";
                break;
            }
        }
        return miningAlgorithmType;
    }

    public static MiningAlgorithms translateFromDataMinerServerMiningAlgorithm(MiningAlgorithmType miningAlgorithmType) {
        MiningAlgorithms miningAlgorithms = null;
        switch (miningAlgorithmType) {
            case APRIORI_ASSOCIATION_RULES: {
                miningAlgorithms = APRIORI;
                break;
            }
            case DECISION_TREE: {
                miningAlgorithms = DECISION_TREE;
                break;
            }
            case EXPECTATION_MAXIMIZATION: {
                miningAlgorithms = EXPECTATION_MAXIMIZATION;
                break;
            }
            case GENERALIZED_LINEAR_MODEL: {
                miningAlgorithms = GENERALIZED_LINEAR_MODEL;
                break;
            }
            case KMEANS: {
                miningAlgorithms = KMEANS;
                break;
            }
            case NAIVE_BAYES: {
                miningAlgorithms = NAIVE_BAYES;
                break;
            }
            case NONNEGATIVE_MATRIX_FACTOR: {
                miningAlgorithms = NON_NEGATIVE_MATRIX_FACTORIZATION;
                break;
            }
            case O_CLUSTER: {
                miningAlgorithms = OCLUSTER;
                break;
            }
            case PRINCIPAL_COMPONENT_ANALYSIS: {
                miningAlgorithms = PRINCIPAL_COMPONENT_ANALYSIS;
                break;
            }
            case SINGULAR_VALUE_DECOMP: {
                miningAlgorithms = SINGULAR_VALUE_DECOMP;
                break;
            }
            case SUPPORT_VECTOR_MACHINES: {
                miningAlgorithms = SUPPORT_VECTOR_MACHINE;
                break;
            }
            case EXPLICIT_SEMANTIC_ANALYSIS: {
                miningAlgorithms = EXPLICIT_SEMANTIC_ANALYSIS;
                break;
            }
            case R_EXTENSIBLE: {
                miningAlgorithms = R_EXTENSIBLE;
                break;
            }
            default: {
                assert (false) : "Invalid Algorithm";
                break;
            }
        }
        return miningAlgorithms;
    }

    public static String getModelTypeAlgorithm(ModelType modelType) {
        String string = null;
        if (modelType instanceof AnomalyDetectionModelType) {
            string = SUPPORT_VECTOR_MACHINE.toString();
        } else if (modelType instanceof AprioriModelType) {
            string = APRIORI.toString();
        } else if (modelType instanceof DecisionTreeModelType) {
            string = DECISION_TREE.toString();
        } else if (modelType instanceof NaiveBayesModelType) {
            string = NAIVE_BAYES.toString();
        } else if (modelType instanceof CGeneralizedLinearModelType) {
            string = GENERALIZED_LINEAR_MODEL.toString();
        } else if (modelType instanceof CSupportVectorMachineModelType) {
            string = SUPPORT_VECTOR_MACHINE.toString();
        } else if (modelType instanceof ExpectationMaximizationModelType) {
            string = EXPECTATION_MAXIMIZATION.toString();
        } else if (modelType instanceof KMeansModelType) {
            string = KMEANS.toString();
        } else if (modelType instanceof OClusterModelType) {
            string = OCLUSTER.toString();
        } else if (modelType instanceof ExplicitSemanticAnalysisModelType) {
            string = EXPLICIT_SEMANTIC_ANALYSIS.toString();
        } else if (modelType instanceof NonNegativeMatrixFactorModelType) {
            string = NON_NEGATIVE_MATRIX_FACTORIZATION.toString();
        } else if (modelType instanceof PCAModelType) {
            string = PRINCIPAL_COMPONENT_ANALYSIS.toString();
        } else if (modelType instanceof SVDModelType) {
            string = SINGULAR_VALUE_DECOMP.toString();
        } else if (modelType instanceof RGeneralizedLinearModelType) {
            string = GENERALIZED_LINEAR_MODEL.toString();
        } else if (modelType instanceof RSupportVectorMachineModelType) {
            string = SUPPORT_VECTOR_MACHINE.toString();
        } else if (modelType instanceof RModelType) {
            string = R_EXTENSIBLE.toString();
        }
        return string;
    }

    private static /* synthetic */ MiningAlgorithms[] $values() {
        return new MiningAlgorithms[]{APRIORI, DECISION_TREE, EXPECTATION_MAXIMIZATION, GENERALIZED_LINEAR_MODEL, KMEANS, NAIVE_BAYES, NON_NEGATIVE_MATRIX_FACTORIZATION, PRINCIPAL_COMPONENT_ANALYSIS, SINGULAR_VALUE_DECOMP, OCLUSTER, SUPPORT_VECTOR_MACHINE, EXPLICIT_SEMANTIC_ANALYSIS, R_EXTENSIBLE};
    }

    static {
        $VALUES = MiningAlgorithms.$values();
        stringToEnum = new HashMap<String, MiningAlgorithms>();
        for (MiningAlgorithms miningAlgorithms : MiningAlgorithms.values()) {
            stringToEnum.put(miningAlgorithms.toString(), miningAlgorithms);
        }
    }
}

