/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.server.model;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import oracle.dmt.dataminer.core.model.clas.common.FilterSetting;
import oracle.dmt.dataminer.core.model.common.build.AttributeBiCoefficient;
import oracle.dmt.dataminer.core.model.filter.SortDirection;
import oracle.dmt.dataminer.core.model.filter.SortSpec;
import oracle.dmt.dataminer.core.model.filter.WhereSpec;
import oracle.dmt.dataminer.mviewer.ModelViewerPreferenceSettings;
import oracle.dmt.dataminer.mviewer.coefficients.CoefViewerState;
import oracle.dmt.dataminer.server.model.ModelLrb;
import oracle.dmt.dataminer.server.model.TargetPriorsPredictionSet;
import oracle.ide.config.Preferences;
import oracle.javatools.data.PropertyStorage;

public class CoefficientFilterSetting
implements FilterSetting {
    public static final double NB_MAX_PROBABILITY = 100.0;
    public static final double NB_MIN_PROBABILITY = 0.0;
    public static final double NB_PROBABILITY_STEP = 1.0;
    public static final double COEFFICIENT_STEP = 0.01;
    private BigDecimal _minCoefficient;
    private BigDecimal _maxCoefficient;
    private int _fetchSize;
    private boolean _filterAndSortByAbsolute;
    private List<SortSpec> _sortSpecs;
    private List<WhereSpec> _whereSpecs;
    private Object _targetValue;
    private Object _secondTargetValue;
    private CoefViewerState _viewerState;
    private boolean bUseFilterSpec = false;
    private List<AttributeBiCoefficient> _itemFilters;
    private ModelViewerPreferenceSettings _modelViewerPrefenceSettings = ModelViewerPreferenceSettings.getInstance((PropertyStorage)Preferences.getPreferences());
    private List<TargetPriorsPredictionSet> _targetValuePriors;

    public CoefficientFilterSetting() {
        this._fetchSize = this._modelViewerPrefenceSettings.getFetchSizeOtherModels();
        this._minCoefficient = new BigDecimal(-1.0);
        this._maxCoefficient = new BigDecimal(1.0);
        this._filterAndSortByAbsolute = false;
        this._sortSpecs = new ArrayList<SortSpec>();
        this._sortSpecs.add(new SortSpec("std_coefficient", SortDirection.DESCENDING, true));
        this._sortSpecs.add(new SortSpec("attribute_name_subname", SortDirection.ASCENDING, true));
        this._sortSpecs.add(new SortSpec("attribute_value", SortDirection.ASCENDING, true));
        this._targetValuePriors = null;
        this._whereSpecs = new ArrayList<WhereSpec>();
        this._whereSpecs.add(new WhereSpec("attribute_name_subname", 1, "", false));
    }

    public CoefficientFilterSetting(boolean bl) {
        this._fetchSize = this._modelViewerPrefenceSettings.getFetchSizeOtherModels();
        this._minCoefficient = new BigDecimal(-1.0);
        this._maxCoefficient = new BigDecimal(1.0);
        this._filterAndSortByAbsolute = false;
        this._sortSpecs = new ArrayList<SortSpec>();
        this._sortSpecs.add(new SortSpec("coefficient", SortDirection.DESCENDING, true));
        this._sortSpecs.add(new SortSpec("attribute_name_subname", SortDirection.ASCENDING, true));
        if (bl) {
            this._sortSpecs.add(new SortSpec("attribute_value", SortDirection.ASCENDING, true));
        }
        this._targetValuePriors = null;
        this._whereSpecs = new ArrayList<WhereSpec>();
        this._whereSpecs.add(new WhereSpec("attribute_name_subname", 1, "", false));
    }

    public CoefficientFilterSetting(CoefViewerState coefViewerState) {
        this._viewerState = coefViewerState;
        this._fetchSize = this._modelViewerPrefenceSettings.getFetchSizeOtherModels();
        this._filterAndSortByAbsolute = false;
        this._sortSpecs = new ArrayList<SortSpec>();
        if (this._viewerState.isSVM() || this._viewerState.isAnomaly()) {
            this._sortSpecs.add(new SortSpec("coefficient", SortDirection.DESCENDING, true));
            this._sortSpecs.add(new SortSpec("attribute_name_subname", SortDirection.ASCENDING, true));
            this._sortSpecs.add(new SortSpec("attribute_value", SortDirection.ASCENDING, true));
            this._minCoefficient = new BigDecimal(-1.0);
            this._maxCoefficient = new BigDecimal(1.0);
        } else if (this._viewerState.isGLM()) {
            this._sortSpecs.add(new SortSpec("std_coefficient", SortDirection.DESCENDING, true));
            this._sortSpecs.add(new SortSpec("attribute_name_subname", SortDirection.ASCENDING, true));
            this._sortSpecs.add(new SortSpec("attribute_value", SortDirection.ASCENDING, false));
            this._minCoefficient = new BigDecimal(-1000.0);
            this._maxCoefficient = new BigDecimal(1000.0);
        } else if (this._viewerState.isNB()) {
            this._sortSpecs.add(new SortSpec("probability", SortDirection.DESCENDING, true));
            this._sortSpecs.add(new SortSpec("attribute_name_subname", SortDirection.ASCENDING, true));
            this._sortSpecs.add(new SortSpec("attribute_value", SortDirection.ASCENDING, true));
            this._minCoefficient = new BigDecimal(0.0);
            this._maxCoefficient = new BigDecimal(100.0);
        } else if (this._viewerState.isNMF()) {
            this._sortSpecs.add(new SortSpec("coefficient", SortDirection.DESCENDING, true));
            this._sortSpecs.add(new SortSpec("attribute_name_subname", SortDirection.ASCENDING, true));
            this._sortSpecs.add(new SortSpec("attribute_value", SortDirection.ASCENDING, true));
            this._minCoefficient = new BigDecimal(0.0);
            this._maxCoefficient = new BigDecimal(1.0);
        } else if (this._viewerState.isESA()) {
            this._sortSpecs.add(new SortSpec("coefficient".toUpperCase(), SortDirection.DESCENDING, true));
            this._sortSpecs.add(new SortSpec("attribute_name".toUpperCase(), SortDirection.ASCENDING, true));
            this._sortSpecs.add(new SortSpec("attribute_subname".toUpperCase(), SortDirection.ASCENDING, true));
            this._sortSpecs.add(new SortSpec("attribute_value".toUpperCase(), SortDirection.ASCENDING, true));
            this._minCoefficient = new BigDecimal(0.0);
            this._maxCoefficient = new BigDecimal(1.0);
        } else if (this._viewerState.isSVD() || this._viewerState.isPCA()) {
            this._sortSpecs.add(new SortSpec("value", SortDirection.DESCENDING, true));
            this._sortSpecs.add(new SortSpec("attribute_name_subname", SortDirection.ASCENDING, true));
            this._minCoefficient = new BigDecimal(0.0);
            this._maxCoefficient = new BigDecimal(1.0);
        } else assert (false) : "Filter Panel does not supported specified model type.";
        this._targetValuePriors = null;
        this._whereSpecs = new ArrayList<WhereSpec>();
        this._whereSpecs.add(new WhereSpec("attribute_name_subname", 1, "", false));
    }

    public CoefficientFilterSetting(int n, BigDecimal bigDecimal, BigDecimal bigDecimal2, boolean bl, List<SortSpec> list, List<WhereSpec> list2, String string) {
        this._fetchSize = n;
        this.setMinCoefficient(bigDecimal);
        this.setMaxCoefficient(bigDecimal2);
        this._filterAndSortByAbsolute = bl;
        this._sortSpecs = list;
        this._whereSpecs = list2;
        this._targetValuePriors = null;
    }

    public void setMinCoefficient(BigDecimal bigDecimal) {
        if (this._viewerState != null && this._viewerState.isNB() && (bigDecimal.doubleValue() < 0.0 || bigDecimal.doubleValue() > 100.0)) {
            throw new IllegalArgumentException(ModelLrb.get("MINIMUM_COEFFICIENT_RANGE_ERROR"));
        }
        this._minCoefficient = bigDecimal;
    }

    public BigDecimal getMinCoefficient() {
        return this._minCoefficient;
    }

    public void setMaxCoefficient(BigDecimal bigDecimal) {
        if (this._viewerState != null && this._viewerState.isNB() && (bigDecimal.doubleValue() < 0.0 || bigDecimal.doubleValue() > 100.0)) {
            throw new IllegalArgumentException(ModelLrb.get("MAXIMUM_COEFFICIENT_RANGE_ERROR"));
        }
        this._maxCoefficient = bigDecimal;
    }

    public BigDecimal getMaxCoefficient() {
        return this._maxCoefficient;
    }

    public boolean getFilterAndSortByAbsolute() {
        return this._filterAndSortByAbsolute;
    }

    public void setFilterByAbsolute(boolean bl) {
        this._filterAndSortByAbsolute = bl;
    }

    public int getFetchSize() {
        return this._fetchSize;
    }

    public void setFetchSize(int n) {
        this._fetchSize = n;
    }

    public List<SortSpec> getSortSpecification() {
        return this._sortSpecs;
    }

    public void setSortSpecification(List<SortSpec> list) {
        this._sortSpecs = list;
    }

    public List<WhereSpec> getWhereSpecification() {
        return this._whereSpecs;
    }

    public void setWhereSpecification(List<WhereSpec> list) {
        this._whereSpecs = list;
    }

    public void setTargetValue(Object object) {
        this._targetValue = object;
    }

    public Object getTargetValue() {
        return this._targetValue;
    }

    public void setTargetValuePriors(List<TargetPriorsPredictionSet> list) {
        this._targetValuePriors = list;
    }

    public List<TargetPriorsPredictionSet> getTargetValuePriors() {
        return this._targetValuePriors;
    }

    public Object getNonSelectedBinaryClassValue() {
        if (this._targetValuePriors == null) {
            return null;
        }
        Object object = null;
        Object object2 = this.getTargetValue();
        for (TargetPriorsPredictionSet targetPriorsPredictionSet : this._targetValuePriors) {
            BigDecimal bigDecimal;
            Object object3 = targetPriorsPredictionSet.getPrediction();
            if (object2 instanceof Integer) {
                bigDecimal = new BigDecimal((Integer)object2);
                if (bigDecimal.equals(targetPriorsPredictionSet.getPrediction())) continue;
                object = targetPriorsPredictionSet.getPrediction();
                continue;
            }
            if (object2 instanceof Float) {
                bigDecimal = new BigDecimal(((Float)object2).doubleValue());
                if (bigDecimal.equals(targetPriorsPredictionSet.getPrediction())) continue;
                object = targetPriorsPredictionSet.getPrediction();
                continue;
            }
            if (object2 instanceof Double) {
                bigDecimal = new BigDecimal((Double)object2);
                if (bigDecimal.equals(targetPriorsPredictionSet.getPrediction())) continue;
                object = targetPriorsPredictionSet.getPrediction();
                continue;
            }
            if (object2.equals(object3)) continue;
            object = targetPriorsPredictionSet.getPrediction();
        }
        return object;
    }

    public Object getAnomalyNonSelectedBinaryClassValue() {
        if (this._targetValuePriors == null) {
            return null;
        }
        Object object = null;
        for (TargetPriorsPredictionSet targetPriorsPredictionSet : this._targetValuePriors) {
            if (this.getTargetValue().equals(targetPriorsPredictionSet.getPrediction())) continue;
            object = targetPriorsPredictionSet.getPrediction();
            break;
        }
        return object;
    }

    public boolean isBinaryClassModel() {
        if (this._targetValuePriors == null) {
            return false;
        }
        return this._targetValuePriors.size() == 2;
    }

    public CoefViewerState getViewerState() {
        return this._viewerState;
    }

    public void setSecondTargetValue(Object object) {
        this._secondTargetValue = object;
    }

    public Object getSecondTargetValue() {
        return this._secondTargetValue;
    }

    public void setUseFilterSpecification(boolean bl) {
        this.bUseFilterSpec = bl;
    }

    public boolean isUseFilterSpecification() {
        return this.bUseFilterSpec;
    }

    public List<AttributeBiCoefficient> getItemFilters() {
        return this._itemFilters;
    }
}

