/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.compare;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.swing.AbstractButton;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import oracle.dmt.dataminer.DataminerGUIPanel;
import oracle.dmt.dataminer.controls.renderers.ComboBoxListRenderer;
import oracle.dmt.dataminer.core.model.common.build.partition.PartitionVO;
import oracle.dmt.dataminer.mviewer.ModelViewerPartitionToolbar;
import oracle.dmt.dataminer.mviewer.compare.CoefCompareMainPanel;
import oracle.dmt.dataminer.mviewer.compare.CompareLrb;
import oracle.dmt.dataminer.mviewer.compare.CompareState;
import oracle.dmt.dataminer.navigator.modelnodes.ANModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.ModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.NBModelNode;
import oracle.dmt.dataminer.server.model.CompareFilterSetting;
import oracle.ide.Ide;
import oracle.ide.dialogs.ProgressException;
import oracle.ide.dialogs.ProgressRunnable;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;

public class CompareFilterPanel
extends JPanel
implements DataminerGUIPanel {
    private CompareState _state;
    private boolean _loaded;
    private CoefCompareMainPanel _mainPanel;
    private CompareFilterSetting _coefFilterSetting;
    private JCheckBox _jAbsoluteValueFilter;
    private JButton _jApplyFilterButton;
    private JSpinner _jFetchSize;
    private JLabel _jFetchSizeLabel;
    private JComboBox<Object> _jTargetValueComboOne;
    private JComboBox<Object> _jTargetValueComboTwo;
    private JLabel _jTargetValueLabelOne;
    private JLabel _jTargetValueLabelTwo;
    private JPanel bottomPanel;
    private ModelViewerPartitionToolbar modelViewerPartitionToolbar1;
    private JPanel topPanel;

    public CompareFilterPanel() {
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    public CompareFilterPanel(CoefCompareMainPanel coefCompareMainPanel, CompareState compareState) {
        this._mainPanel = coefCompareMainPanel;
        this._state = compareState;
        this.initComponents();
        this.initRes();
        this.initUI();
        this.initializeUIState();
    }

    private void initComponents() {
        this.topPanel = new JPanel();
        this._jTargetValueLabelOne = new JLabel();
        this._jTargetValueComboOne = new JComboBox();
        this._jTargetValueLabelTwo = new JLabel();
        this._jTargetValueComboTwo = new JComboBox();
        this._jAbsoluteValueFilter = new JCheckBox();
        this._jFetchSizeLabel = new JLabel();
        this._jFetchSize = new JSpinner();
        this._jApplyFilterButton = new JButton();
        this.bottomPanel = new JPanel();
        this.modelViewerPartitionToolbar1 = new ModelViewerPartitionToolbar();
        this.topPanel.setLayout(new FlowLayout(0, 12, 0));
        this._jTargetValueLabelOne.setText("Target Value 1:");
        this.topPanel.add(this._jTargetValueLabelOne);
        this._jTargetValueComboOne.setPreferredSize(new Dimension(130, 23));
        this.topPanel.add(this._jTargetValueComboOne);
        this._jTargetValueLabelTwo.setText("Target Value 2:");
        this.topPanel.add(this._jTargetValueLabelTwo);
        this._jTargetValueComboTwo.setPreferredSize(new Dimension(130, 23));
        this.topPanel.add(this._jTargetValueComboTwo);
        this._jAbsoluteValueFilter.setText("Sort By Absolute Value");
        this.topPanel.add(this._jAbsoluteValueFilter);
        this._jFetchSizeLabel.setText("Fetch Size:");
        this._jFetchSize.setMaximumSize(new Dimension(87, 20));
        this._jFetchSize.setMinimumSize(new Dimension(87, 20));
        this._jFetchSize.setPreferredSize(new Dimension(110, 20));
        this._jApplyFilterButton.setText("Query");
        this._jApplyFilterButton.setMaximumSize(new Dimension(87, 23));
        this._jApplyFilterButton.setMinimumSize(new Dimension(87, 23));
        this._jApplyFilterButton.setPreferredSize(new Dimension(87, 23));
        this.bottomPanel.setLayout(new BorderLayout());
        this.bottomPanel.add((Component)this.modelViewerPartitionToolbar1, "Center");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.topPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this._jFetchSizeLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this._jFetchSize, -2, 90, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this._jApplyFilterButton, -2, 110, -2)).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.bottomPanel, -1, 1041, Short.MAX_VALUE))).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this._jApplyFilterButton, -2, -1, -2).addComponent(this._jFetchSize, -2, -1, -2).addComponent(this._jFetchSizeLabel)).addComponent(this.topPanel, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bottomPanel, -1, 30, Short.MAX_VALUE)));
    }

    @Override
    public void initRes() {
        if (this.isAnomaly()) {
            this._jTargetValueLabelOne.setVisible(false);
            this._jTargetValueLabelTwo.setVisible(false);
        } else {
            ResourceUtils.resLabel((JLabel)this._jTargetValueLabelOne, this._jTargetValueComboOne, (String)CompareLrb.get("TARGET_VALUE_1"));
            this._jTargetValueLabelOne.getAccessibleContext().setAccessibleName(CompareLrb.get("TARGET_VALUE_1"));
            this._jTargetValueLabelOne.getAccessibleContext().setAccessibleDescription(CompareLrb.get("TARGET_VALUE_ADA"));
            ResourceUtils.resLabel((JLabel)this._jTargetValueLabelTwo, this._jTargetValueComboTwo, (String)CompareLrb.get("TARGET_VALUE_2"));
            this._jTargetValueLabelTwo.getAccessibleContext().setAccessibleName(CompareLrb.get("TARGET_VALUE_2"));
            this._jTargetValueLabelTwo.getAccessibleContext().setAccessibleDescription(CompareLrb.get("TARGET_VALUE_ADA"));
        }
        ResourceUtils.resButton((AbstractButton)this._jApplyFilterButton, (String)CompareLrb.get("QUERY"));
        this._jApplyFilterButton.getAccessibleContext().setAccessibleName(CompareLrb.get("QUERY"));
        this._jApplyFilterButton.getAccessibleContext().setAccessibleDescription(CompareLrb.get("QUERY_ADA"));
        this._jApplyFilterButton.setIcon(OracleIcons.getIcon((String)"run.png"));
        ResourceUtils.resLabel((JLabel)this._jFetchSizeLabel, (Component)this._jFetchSize, (String)CompareLrb.get("FETCH_SIZE"));
        this._jFetchSizeLabel.getAccessibleContext().setAccessibleName(CompareLrb.get("FETCH_SIZE"));
        this._jFetchSizeLabel.getAccessibleContext().setAccessibleDescription(CompareLrb.get("FETCH_SIZE_ADA"));
        this._jFetchSize.setToolTipText(CompareLrb.get("FETCH_SIZE_ADA") + "\n" + CompareLrb.get("FETCH_SIZE_RANGE"));
        this._jFetchSize.setModel(new SpinnerNumberModel(1000, 1, Integer.MAX_VALUE, 1000));
        ResourceUtils.resButton((AbstractButton)this._jAbsoluteValueFilter, (String)CompareLrb.get("ABSOLUTE_VALUE"));
        this._jAbsoluteValueFilter.getAccessibleContext().setAccessibleName(CompareLrb.get("ABSOLUTE_VALUE"));
        this._jAbsoluteValueFilter.getAccessibleContext().setAccessibleDescription(CompareLrb.get("ABSOLUTE_VALUE_ADA"));
        this._jAbsoluteValueFilter.setToolTipText(CompareLrb.get("ABSOLUTE_VALUE_ADA"));
    }

    public boolean isLoading() {
        return this._mainPanel.isLoading();
    }

    private void _jAbsoluteValueFilter_actionPerformed() {
        if (this.isLoading()) {
            return;
        }
        this._state.setSortByAbsoluteValue(this._jAbsoluteValueFilter.isSelected());
        this._coefFilterSetting.setFilterByAbsolute(this._jAbsoluteValueFilter.isSelected());
    }

    private void setLoading(boolean bl) {
        this._mainPanel.updateLoading(bl);
    }

    @Override
    public void initUI() {
        this.setLocale(this._jFetchSize, Locale.getDefault());
        this.addListeners();
        ((GroupLayout)this.getLayout()).invalidateLayout(this);
        if (this.isNB()) {
            this._jAbsoluteValueFilter.setVisible(false);
        }
        this.loadPartitionToolbar();
    }

    void loadPartitionToolbar() {
        this.modelViewerPartitionToolbar1.load(this._mainPanel.getEditor());
    }

    public String getSelectedParitionId() {
        return this.modelViewerPartitionToolbar1.getSelectedPartitionID();
    }

    public PartitionVO getPartitionVO() {
        return this.modelViewerPartitionToolbar1.getPartitionVO();
    }

    private boolean isAnomaly() {
        ModelNode modelNode = (ModelNode)this._state.getContext().getNode();
        return modelNode instanceof ANModelNode ? ((ANModelNode)modelNode).isLinearKernel() : false;
    }

    private boolean isNB() {
        ModelNode modelNode = (ModelNode)this._state.getContext().getNode();
        return modelNode instanceof NBModelNode;
    }

    public void setupUI(CompareFilterSetting compareFilterSetting) {
        this._coefFilterSetting = compareFilterSetting;
        this.loadStateAttributes();
        this.requestFocusInWindow();
        this.setLoaded(true);
    }

    private void initializeUIState() {
        this._coefFilterSetting = new CompareFilterSetting();
        this.loadStateAttributes();
    }

    private void loadStateAttributes() {
        if (this._coefFilterSetting.getViewerState() != null) {
            this.setNumber(this._jFetchSize, this._coefFilterSetting.getViewerState().getFetchSizeValue());
            this._jAbsoluteValueFilter.setSelected(this._coefFilterSetting.getViewerState().getSortByAbsoluteValue());
        }
    }

    private void addListeners() {
        this._jApplyFilterButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CompareFilterPanel.this._jApplyFilterButton_actionPerformed();
                CompareFilterPanel.this._coefFilterSetting.getViewerState().setFetchSizeValue(CompareFilterPanel.this.getNumber(CompareFilterPanel.this._jFetchSize).intValue());
                CompareFilterPanel.this._coefFilterSetting.getViewerState().setSortByAbsoluteValue(CompareFilterPanel.this._jAbsoluteValueFilter.isSelected());
            }
        });
        this._jTargetValueComboOne.setRenderer(new ComboBoxListRenderer());
        this._jTargetValueComboOne.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CompareFilterPanel.this._jTargetValueComboOne_actionPerformed();
            }
        });
        this._jTargetValueComboTwo.setRenderer(new ComboBoxListRenderer());
        this._jTargetValueComboTwo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CompareFilterPanel.this._jTargetValueComboTwo_actionPerformed();
            }
        });
        this._jAbsoluteValueFilter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CompareFilterPanel.this._jAbsoluteValueFilter_actionPerformed();
            }
        });
    }

    private void _jTargetValueComboOne_actionPerformed() {
        if (this.isLoading()) {
            return;
        }
        this.setLoading(true);
        Object object = this._jTargetValueComboOne.getSelectedItem();
        this._state.setSelectedTargetClass(object);
        ComboBoxModel<Object> comboBoxModel = this._jTargetValueComboOne.getModel();
        ComboBoxModel<Object> comboBoxModel2 = this._jTargetValueComboTwo.getModel();
        Object object2 = comboBoxModel2.getSelectedItem();
        boolean bl = false;
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < comboBoxModel.getSize(); ++i) {
            Object e = comboBoxModel.getElementAt(i);
            if (e.equals(object)) {
                if (!object2.equals(object)) continue;
                bl = true;
                continue;
            }
            arrayList.add(e);
        }
        DefaultComboBoxModel<Object> defaultComboBoxModel = new DefaultComboBoxModel<Object>(arrayList.toArray());
        this._jTargetValueComboTwo.setModel(defaultComboBoxModel);
        if (bl) {
            this._state.setSecondSelectedTargetClass(this._jTargetValueComboTwo.getItemAt(0));
            this._jTargetValueComboTwo.setSelectedItem(this._state.getSecondSelectedTargetClass());
        } else {
            this._jTargetValueComboTwo.setSelectedItem(object2);
        }
        this.prepareReload();
    }

    void prepareReload() {
        this._mainPanel.prepareReload();
    }

    void updateTargetCombos() {
        List<Object> list = this._state.getTargetPredictions();
        Object object = this._state.getSelectedTargetClass();
        DefaultComboBoxModel<Object> defaultComboBoxModel = new DefaultComboBoxModel<Object>(list.toArray());
        this._jTargetValueComboOne.setModel(defaultComboBoxModel);
        if (object instanceof Number) {
            this._jTargetValueComboOne.setSelectedItem(object);
        } else {
            this._jTargetValueComboOne.setSelectedItem(object.toString());
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Object object2 : list) {
            if (object2 instanceof Number ? object2.equals(object) : object2.equals(object.toString())) continue;
            arrayList.add(object2);
        }
        DefaultComboBoxModel<Object> defaultComboBoxModel2 = new DefaultComboBoxModel<Object>(arrayList.toArray());
        this._jTargetValueComboTwo.setModel((ComboBoxModel<Object>)defaultComboBoxModel2);
        if (this._state.getSecondSelectedTargetClass() instanceof Number) {
            this._jTargetValueComboTwo.setSelectedItem(this._state.getSecondSelectedTargetClass());
        } else {
            this._jTargetValueComboTwo.setSelectedItem(this._state.getSecondSelectedTargetClass().toString());
        }
    }

    private void _jTargetValueComboTwo_actionPerformed() {
        if (this.isLoading()) {
            return;
        }
        this.setLoading(true);
        this._state.setSecondSelectedTargetClass(this._jTargetValueComboTwo.getSelectedItem());
        this.prepareReload();
    }

    protected void _jApplyFilterButton_actionPerformed() {
        ValidateUpdateState validateUpdateState = new ValidateUpdateState();
        try {
            validateUpdateState.setTitle(CompareLrb.get("FILTER_PROCESS_TITLE"));
            validateUpdateState.setMessage(CompareLrb.get("FILTER_PROCESS_MESG"));
            validateUpdateState.setCancelable(false);
            validateUpdateState.start(true);
        }
        catch (ProgressException progressException) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)progressException.getCause(), (String)CompareLrb.get("FILTER_PROCESS_FAILURE_TITLE"), (String)CompareLrb.get("FILTER_PROCESS_FAILURE_MESG"), null);
        }
        finally {
            if (validateUpdateState.getValidation()) {
                this._mainPanel.setFilterState(this._coefFilterSetting);
            }
        }
    }

    private void setNumber(JSpinner jSpinner, Number number) {
        jSpinner.setValue(number);
    }

    private void setLocale(JSpinner jSpinner, Locale locale) {
        jSpinner.setLocale(locale);
    }

    private Number getNumber(JSpinner jSpinner) {
        return (Number)jSpinner.getValue();
    }

    public boolean isLoaded() {
        return this._loaded;
    }

    private void setLoaded(boolean bl) {
        this._loaded = bl;
    }

    private class ValidateUpdateState
    extends ProgressRunnable {
        private boolean _validated;

        private ValidateUpdateState() {
        }

        public boolean getValidation() {
            return this._validated;
        }

        protected Object doWork() throws Exception {
            Number number = CompareFilterPanel.this.getNumber(CompareFilterPanel.this._jFetchSize);
            if (null == number || number.longValue() <= 0L) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)CompareLrb.get("FETCH_SIZE_RANGE_ERROR"), (String)CompareLrb.get("COEFFICIENT_ERROR_TITLE"), null);
                return this._validated;
            }
            this._validated = true;
            CompareFilterPanel.this._coefFilterSetting.setFetchSize(number.intValue());
            return this._validated;
        }
    }
}

