/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.compare;

import java.awt.BorderLayout;
import java.awt.Component;
import oracle.dmt.dataminer.DataMinerViewGUI;
import oracle.dmt.dataminer.core.model.common.build.partition.PartitionVO;
import oracle.dmt.dataminer.mviewer.ModelMessagePanel;
import oracle.dmt.dataminer.mviewer.ModelViewerLrb;
import oracle.dmt.dataminer.mviewer.compare.CompareFilterPanel;
import oracle.dmt.dataminer.mviewer.compare.CompareState;
import oracle.dmt.dataminer.mviewer.compare.CompareViewer;
import oracle.dmt.dataminer.navigator.modelnodes.ModelNode;
import oracle.dmt.dataminer.server.model.CompareFilterSetting;
import oracle.ide.Context;
import oracle.ide.editor.Editor;
import oracle.ide.help.HelpInfo;

public class CoefCompareMainPanel
extends DataMinerViewGUI {
    private CompareState state;
    private CompareViewer comparePanel;
    private CompareFilterPanel filterPanel;

    public CoefCompareMainPanel(Editor editor, Context context) {
        super(editor, context);
        ModelNode modelNode = (ModelNode)context.getNode();
        if (!modelNode.exists()) {
            this.add(new ModelMessagePanel(ModelViewerLrb.get("MODEL_DOES_NOT_EXIST")));
            return;
        }
        this.state = new CompareState(context);
        this.initComponents();
        this.initUI();
    }

    private void initUI() {
        this.filterPanel = new CompareFilterPanel(this, this.state);
        this.comparePanel = new CompareViewer(this, this.state);
        this.add((Component)this.filterPanel, "North");
        this.add((Component)this.comparePanel, "Center");
    }

    PartitionVO getSelectedPartition() {
        return this.filterPanel.getPartitionVO();
    }

    void updateLoaded(boolean bl) {
        this.setLoaded(bl);
    }

    void updateLoading(boolean bl) {
        this.setLoading(bl);
    }

    void setFilterState(CompareFilterSetting compareFilterSetting) {
        this.comparePanel.setFilterState(compareFilterSetting);
    }

    void setFilterPanelInitialState(CompareFilterSetting compareFilterSetting) {
        this.filterPanel.setupUI(compareFilterSetting);
    }

    void updateTargetCombos() {
        this.filterPanel.updateTargetCombos();
    }

    void prepareReload() {
        this.comparePanel.reload();
    }

    void loadPartitionInformation() {
        this.filterPanel.loadPartitionToolbar();
    }

    @Override
    public void load() {
        this.comparePanel.setBlockingComponent(this.overLayPanel);
        this.comparePanel.load();
    }

    @Override
    public HelpInfo getHelpInfo() {
        return this.state.getHelpInfo();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }
}

