/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.clustering;

import java.util.Comparator;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import oracle.dmt.dataminer.controls.models.SimpleBaseTableModel;
import oracle.dmt.dataminer.core.utils.comparator.NumberComparator;
import oracle.dmt.dataminer.mviewer.clustering.ClusterDetailsModelRow;
import oracle.dmt.dataminer.mviewer.clustering.ClusterLrb;

public class ClusterDetailsModel
extends SimpleBaseTableModel {
    private Vector<ClusterDetailsModelRow> _data = new Vector();
    private Hashtable<String, ClusterDetailsModelRow> _attributeNameToRowMap = new Hashtable();
    static final String[] COL_NAMES = new String[]{ClusterLrb.get("DETAIL_TABLE_COLUMN_NAME"), ClusterLrb.get("DETAIL_TABLE_COLUMN_HISTOGRAM"), ClusterLrb.get("DETAIL_TABLE_COLUMN_CONFIDENCE"), ClusterLrb.get("DETAIL_TABLE_COLUMN_SUPPORT"), ClusterLrb.get("DETAIL_TABLE_COLUMN_MODE"), ClusterLrb.get("DETAIL_TABLE_COLUMN_MEAN"), ClusterLrb.get("DETAIL_TABLE_COLUMN_VARIANCE")};
    public static final int NAME = 0;
    public static final int HISTOGRAM = 1;
    public static final int CONFIDENCE = 2;
    public static final int SUPPORT = 3;
    public static final int MEAN = 5;
    public static final int MODE = 4;
    public static final int VARIANCE = 6;

    public ClusterDetailsModel(List<ClusterDetailsModelRow> list) {
        this.setColumnIdentifiers(COL_NAMES);
        this.setDataVector(new Vector<ClusterDetailsModelRow>(list));
    }

    private void addDataItem(ClusterDetailsModelRow clusterDetailsModelRow) {
        this._data.add(clusterDetailsModelRow);
    }

    private void clear() {
        this._data.clear();
        this._attributeNameToRowMap.clear();
    }

    private int getDataSize() {
        return this._data.size();
    }

    public ClusterDetailsModelRow getClusterDetailRow(String string) {
        return this._attributeNameToRowMap.get(string);
    }

    public void setDataVector(Vector<ClusterDetailsModelRow> vector) {
        this._data = vector;
        this.setRowCount(this._data.size());
        this._attributeNameToRowMap.clear();
        for (ClusterDetailsModelRow clusterDetailsModelRow : vector) {
            this._attributeNameToRowMap.put(clusterDetailsModelRow.getFullAttributeName(), clusterDetailsModelRow);
        }
    }

    public ClusterDetailsModel(Boolean bl) {
        this.setColumnIdentifiers(COL_NAMES);
        if (bl.booleanValue()) {
            ClusterDetailsModelRow clusterDetailsModelRow = new ClusterDetailsModelRow(ClusterLrb.get("DETAIL_CLUSTER_EDITOR_LOADING"));
            this.addDataItem(clusterDetailsModelRow);
        }
        this.setRowCount(this.getDataSize());
        this.setColumnCount(COL_NAMES.length);
    }

    public void clearRows() {
        for (ClusterDetailsModelRow clusterDetailsModelRow : this._data) {
            clusterDetailsModelRow.setGraphDataModel(null);
            clusterDetailsModelRow.setHistogram(null);
        }
        this._data.clear();
        ClusterDetailsModelRow clusterDetailsModelRow = new ClusterDetailsModelRow(ClusterLrb.get("DETAIL_CLUSTER_EDITOR_LOADING"));
        this.addDataItem(clusterDetailsModelRow);
        this.setRowCount(1);
        this.fireTableDataChanged();
    }

    public Object getValueAt(int n, int n2) {
        assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds!";
        assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
        ClusterDetailsModelRow clusterDetailsModelRow = this._data.get(n);
        Object object = null;
        switch (n2) {
            case 0: {
                object = clusterDetailsModelRow.getFullAttributeName();
                break;
            }
            case 1: {
                object = clusterDetailsModelRow.getGraphDataModel();
                break;
            }
            case 2: {
                if (clusterDetailsModelRow.getConfidence() != null) {
                    object = clusterDetailsModelRow.getConfidence() * 100.0;
                    break;
                }
                object = clusterDetailsModelRow.getConfidence();
                break;
            }
            case 3: {
                object = clusterDetailsModelRow.getSupport();
                break;
            }
            case 5: {
                if (clusterDetailsModelRow.getMean() == null) {
                    object = "";
                    break;
                }
                if (clusterDetailsModelRow.getMean() == 0.0) {
                    object = "";
                    break;
                }
                object = clusterDetailsModelRow.getMean();
                break;
            }
            case 4: {
                object = clusterDetailsModelRow.getMode();
                break;
            }
            case 6: {
                if (clusterDetailsModelRow.getVariance() == null) {
                    object = "";
                    break;
                }
                if (clusterDetailsModelRow.getVariance() == 0.0) {
                    object = "";
                    break;
                }
                object = clusterDetailsModelRow.getVariance();
                break;
            }
            default: {
                assert (false) : "Out of bounds column when accessing cluster details";
                break;
            }
        }
        return object != null ? object : "";
    }

    public Comparator getColumnSortComparator(int n) {
        switch (n) {
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                return NumberComparator.getComparator();
            }
        }
        return super.getColumnSortComparator(n);
    }

    public void setFailedStatus() {
        ClusterDetailsModelRow clusterDetailsModelRow = new ClusterDetailsModelRow(ClusterLrb.get("DETAIL_CLUSTER_FAILED_TO_LOAD"));
        this.addDataItem(clusterDetailsModelRow);
        this.clear();
        this.addDataItem(clusterDetailsModelRow);
        this.setRowCount(1);
        this.fireTableDataChanged();
    }

    public Vector getDataVector() {
        return this._data;
    }
}

