/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.expressionbuilder2;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.sql.Array;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import oracle.bali.ewt.help.HelpUtils;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.dialogs.Messages;
import oracle.dbtools.raptor.dialogs.SQLErrorDialog;
import oracle.dbtools.raptor.phighlight.HighlightEditorPlugin;
import oracle.dbtools.raptor.utils.oerr.Oerr;
import oracle.dbtools.raptor.utils.oerr.OerrException;
import oracle.dmt.dataminer.controls.DialogDisplayer;
import oracle.dmt.dataminer.controls.TextFieldLimit;
import oracle.dmt.dataminer.core.dal.ConnectionManager;
import oracle.dmt.dataminer.core.model.common.ColumnDataRow;
import oracle.dmt.dataminer.expressionbuilder2.CreateViewPanel;
import oracle.dmt.dataminer.expressionbuilder2.DialogsLrb;
import oracle.dmt.dataminer.expressionbuilder2.MySnippetPanel;
import oracle.dmt.dataminer.expressionbuilder2.PLSQLFunctionsPanel;
import oracle.dmt.dataminer.expressionbuilder2.RScriptsPanel;
import oracle.dmt.dataminer.expressionbuilder2.SQLContext;
import oracle.dmt.dataminer.expressionbuilder2.SourcesPanel;
import oracle.dmt.dataminer.expressionbuilder2.WithClauseNoInputException;
import oracle.dmt.dataminer.expressionbuilder2.WithClauseViewOutputException;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.teditor.data.DataViewerPanel;
import oracle.dmt.dataminer.teditor.data.ODMrGraphOutputPanel;
import oracle.dmt.dataminer.teditor.data.ODMrXMLOutputPanel;
import oracle.dmt.dataminer.teditor.structure.StructureViewPanel;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.dmt.dataminer.utils.TableNameValidator;
import oracle.dmt.dataminer.utils.UITools;
import oracle.dmt.dataminer.workflow.dialog.data.DataDialogsLrb;
import oracle.dmt.dataminer.workflow.inspect.SQLQuery.SQLQueryPIPropertyLrb;
import oracle.dmt.dataminer.workflow.model.AbstractDataNode;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.NodeMessagesLrb;
import oracle.dmt.dataminer.workflow.xmlschema.NodeStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.dmt.dataminer.workflow.xmlschema.SQLQueryNodeType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.keymap.EditorFactory;
import oracle.ide.dialogs.ProgressException;
import oracle.ide.dialogs.ProgressRunnable;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.gutter.Gutter;
import oracle.javatools.editor.gutter.GutterClickListener;
import oracle.javatools.editor.gutter.LineGutterPlugin;
import oracle.javatools.editor.plugins.BraceMatchingPlugin;
import oracle.javatools.editor.plugins.EditorPlugin;
import oracle.javatools.icons.OracleIcons;
import oracle.jdbc.OracleCallableStatement;
import oracle.jdbc.OracleConnection;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public abstract class SQLExpressionBuilderPanel
extends DialogDisplayer<AbstractNode> {
    protected Logger theLogger = Logger.getLogger(this.getClass().getName());
    protected transient SQLContext _sqlContext;
    protected String _name;
    protected String _sqlExpression;
    protected boolean _hasWithClause;
    protected boolean _generateView;
    protected SourcesPanel _sourcesPanel;
    protected PLSQLFunctionsPanel _functionsPanel;
    protected MySnippetPanel _snippetPanel;
    protected RScriptsPanel _RScriptsPanel;
    protected BasicEditorPane _sqlEditor = EditorFactory.createIdeEditorPane();
    protected JTextArea _validationResults = new JTextArea();
    protected JTabbedPane _viewerTabPane = new JTabbedPane();
    protected DataViewerPanel _dataViewerPane;
    protected StructureViewPanel _structureViewPane;
    protected ArrayList<ODMrXMLOutputPanel> _xmlPanels = new ArrayList();
    protected ArrayList<ODMrGraphOutputPanel> _GraphOutputPanels = new ArrayList();
    protected boolean _isRScriptsAvailable;
    protected boolean _expressionDirty;
    protected boolean _validateExpression;
    protected boolean _outputColumnsDirty;
    protected boolean _previewColumnsLoaded;
    protected boolean _previewDataLoaded;
    protected transient Vector<ColumnDataRow> _columnMetaData = new Vector();
    protected UndoManager _undoManager = new UndoManager();
    protected static String SOURCES_TAB = DialogsLrb.get("SQLQUERY_SOURCE_TAB");
    protected static String SNIPPETS_TAB = DialogsLrb.get("SQLQUERY_SNIPPETS_TAB");
    protected static String FUNCTIONS_TAB = DialogsLrb.get("SQLQUERY_PLSQL_TAB");
    protected static String RSCRIPTS_TAB = DialogsLrb.get("SQLQUERY_RSCRIPTS_TAB");
    protected static String COLUMN_TAB = DialogsLrb.get("SQLQUERY_DATA_COLUMN");
    protected static String DATA_TAB = DialogsLrb.get("SQLQUERY_DATA_DATA");
    protected static String GRAPH_TAB = DialogsLrb.get("SQLQUERY_DATA_GRAPH");
    private static int MAX_LENGTH = 32;
    private static int MAX_LENGTH_EX = 130;
    protected JCheckBox chkIncludeAllAvailableColumns;
    private JLabel jNameLabel;
    private JTextField jNameTextField;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPreviewPanel;
    private JToolBar jPreviewToolBar;
    private JProgressBar jProgressBar;
    private JButton jRedoButton;
    private JButton jRefreshButton;
    private JPanel jSQLPanel;
    private JScrollPane jSQLScrollPane;
    private JPanel jSQLStatusPanel;
    private JToolBar jSQLTextToolBar;
    private JTabbedPane jSourceTabbedPane;
    private JSplitPane jSplitPane1;
    private JSplitPane jSplitPane2;
    private JButton jUndoButton;
    private JButton jValidateButton;
    private JLabel locationLabel;

    public SQLExpressionBuilderPanel(SQLContext sQLContext) {
        super(sQLContext.getContext(), sQLContext.getNode());
        assert (sQLContext != null) : "Context must not be null.";
        assert (sQLContext.getNode() != null) : "SQLQuery node must not be null.";
        assert (sQLContext.getNode() instanceof AbstractNode) : "Must be an instance of AbstractNode.";
        this._sqlContext = sQLContext;
        NodeType nodeType = sQLContext.getNode().getData();
        if (nodeType.getStatus() == NodeStatusType.INVALID || nodeType.getStatus() == NodeStatusType.FAILURE) {
            this._validateExpression = true;
        }
        this._sqlExpression = sQLContext.getSqlExpression();
        this._name = sQLContext.getName();
        this._hasWithClause = sQLContext.hasWithClause();
        this._generateView = sQLContext.isGenerateView();
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    @Override
    public void initRes() {
        this.jValidateButton.setIcon(OracleIcons.getIcon((String)"validator.png"));
        this.jValidateButton.getAccessibleContext().setAccessibleDescription(DialogsLrb.get("SQLQUERY_QUERY_RUN_ADA"));
        this.jValidateButton.setToolTipText(DialogsLrb.get("SQLQUERY_QUERY_RUN_ADA"));
        this.jUndoButton.setIcon(OracleIcons.getIcon((String)"undo.png"));
        this.jUndoButton.getAccessibleContext().setAccessibleDescription(DialogsLrb.get("SQLQUERY_QUERY_UNDO_ADA"));
        this.jUndoButton.setToolTipText(DialogsLrb.get("SQLQUERY_QUERY_UNDO_ADA"));
        this.jRedoButton.setIcon(OracleIcons.getIcon((String)"redo.png"));
        this.jRedoButton.getAccessibleContext().setAccessibleDescription(DialogsLrb.get("SQLQUERY_QUERY_REDO_ADA"));
        this.jRedoButton.setToolTipText(DialogsLrb.get("SQLQUERY_QUERY_REDO_ADA"));
        this.jRefreshButton.setIcon(OracleIcons.getIcon((String)"refresh.png"));
        this.jRefreshButton.getAccessibleContext().setAccessibleDescription(DialogsLrb.get("SQLQUERY_QUERY_REFRESH_ADA"));
        this.jRefreshButton.setToolTipText(DialogsLrb.get("SQLQUERY_QUERY_REFRESH_ADA"));
        if (this._context.getNode() != null && this._context.getNode().getData() != null) {
            this.chkIncludeAllAvailableColumns.setText(DialogsLrb.get("SQLQUERY_QUERY_INCLUDE_ALL_COLUMNS"));
            if (this._context.getNode().getData() instanceof SQLQueryNodeType) {
                SQLQueryNodeType sQLQueryNodeType = (SQLQueryNodeType)this._context.getNode().getData();
                this.chkIncludeAllAvailableColumns.setSelected(sQLQueryNodeType.isIncludeAllAvailableAttributes());
            }
        }
    }

    @Override
    public void initUI() {
        HelpUtils.setHelpID((JComponent)this, (String)"sql_query_editor");
        final class Initialization
        extends ProgressRunnable {
            SQLExpressionBuilderPanel _parent;

            Initialization(SQLExpressionBuilderPanel sQLExpressionBuilderPanel2) {
                this._parent = sQLExpressionBuilderPanel2;
            }

            protected Object doWork() throws Exception {
                SQLExpressionBuilderPanel.this._sourcesPanel = new SourcesPanel(this._parent, SQLExpressionBuilderPanel.this._sqlContext);
                SQLExpressionBuilderPanel.this._snippetPanel = new MySnippetPanel(this._parent, SQLExpressionBuilderPanel.this._sqlContext);
                SQLExpressionBuilderPanel.this._functionsPanel = new PLSQLFunctionsPanel(this._parent, SQLExpressionBuilderPanel.this._sqlContext);
                SQLExpressionBuilderPanel.this._isRScriptsAvailable = SQLExpressionBuilderPanel.this.isRScriptsAvailable();
                if (SQLExpressionBuilderPanel.this._isRScriptsAvailable) {
                    SQLExpressionBuilderPanel.this._RScriptsPanel = new RScriptsPanel(this._parent, SQLExpressionBuilderPanel.this._sqlContext);
                    SQLExpressionBuilderPanel.this._RScriptsPanel.load();
                }
                return null;
            }

            protected void finish(Object object) {
                Object object2;
                Object object3;
                if (SQLExpressionBuilderPanel.this._sqlContext.isExpressionOnly()) {
                    boolean bl = SQLHelper.isExpandedObjNameEnabled(SQLExpressionBuilderPanel.this._sqlContext.getContext());
                    SQLExpressionBuilderPanel.this.jNameTextField.setDocument(new TextFieldLimit(bl ? MAX_LENGTH_EX : MAX_LENGTH));
                    object3 = new ViewNameInputVerifier(SQLExpressionBuilderPanel.this.jNameTextField, SQLExpressionBuilderPanel.this._sqlContext.getContext());
                    SQLExpressionBuilderPanel.this.jNameTextField.setInputVerifier((InputVerifier)object3);
                    if (!StringUtils.isValidNonQuotedDBObjectName(SQLExpressionBuilderPanel.this._name)) {
                        SQLExpressionBuilderPanel.this._name = StringUtils.addDoubleQuotes(SQLExpressionBuilderPanel.this._name);
                    }
                    SQLExpressionBuilderPanel.this.jNameTextField.setText(SQLExpressionBuilderPanel.this._name);
                    object2 = new CustomViewNameValidator((ViewNameInputVerifier)object3);
                    SQLExpressionBuilderPanel.this.jNameTextField.addFocusListener((FocusListener)object2);
                    SQLExpressionBuilderPanel.this.jNameTextField.addKeyListener((KeyListener)object2);
                }
                SQLExpressionBuilderPanel.this.jSourceTabbedPane.add(SOURCES_TAB, SQLExpressionBuilderPanel.this._sourcesPanel);
                SQLExpressionBuilderPanel.this.jSourceTabbedPane.add(SNIPPETS_TAB, (Component)((Object)SQLExpressionBuilderPanel.this._snippetPanel));
                SQLExpressionBuilderPanel.this.jSourceTabbedPane.add(FUNCTIONS_TAB, SQLExpressionBuilderPanel.this._functionsPanel);
                if (SQLExpressionBuilderPanel.this._isRScriptsAvailable) {
                    SQLExpressionBuilderPanel.this.jSourceTabbedPane.add(RSCRIPTS_TAB, SQLExpressionBuilderPanel.this._RScriptsPanel);
                }
                SQLExpressionBuilderPanel.this.jSourceTabbedPane.setSelectedIndex(0);
                SQLExpressionBuilderPanel.this.jSQLScrollPane.setViewportView((Component)SQLExpressionBuilderPanel.this._sqlEditor);
                SQLExpressionBuilderPanel.this._sqlEditor.setDocument((Document)new BasicDocument("foo.plsql"));
                SQLExpressionBuilderPanel.this._sqlEditor.setText(SQLExpressionBuilderPanel.this._sqlExpression);
                LineGutterPlugin lineGutterPlugin = new LineGutterPlugin();
                SQLExpressionBuilderPanel.this._sqlEditor.installPlugin((EditorPlugin)lineGutterPlugin);
                SQLExpressionBuilderPanel.this._sqlEditor.installPlugin((EditorPlugin)new HighlightEditorPlugin());
                SQLExpressionBuilderPanel.this._sqlEditor.installPlugin((EditorPlugin)new BraceMatchingPlugin());
                SQLExpressionBuilderPanel.this._sqlEditor.addCaretListener(new CaretListener(){

                    @Override
                    public void caretUpdate(CaretEvent caretEvent) {
                        SQLExpressionBuilderPanel.this.setLineCol();
                    }
                });
                SQLExpressionBuilderPanel.this.setLineCol();
                lineGutterPlugin.setShowLineNumbers(3);
                SQLExpressionBuilderPanel.this.jSQLScrollPane.setRowHeaderView((Component)lineGutterPlugin);
                object3 = new JPopupMenu(oracle.dbtools.raptor.Messages.getString((String)"DisplayCodeEditor.3"));
                object2 = new JMenuItem(oracle.dbtools.raptor.Messages.getString((String)"DisplayCodeEditor.4"));
                ((JPopupMenu)object3).add((JMenuItem)object2);
                ((AbstractButton)object2).addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        EditorProperties editorProperties = EditorProperties.getProperties();
                        boolean bl = !editorProperties.getBooleanProperty("show-line-numbers");
                        editorProperties.putBooleanProperty("show-line-numbers", bl);
                    }
                });
                lineGutterPlugin.addGutterClickListener(new GutterClickListener(){
                    final /* synthetic */ JPopupMenu val$_gridCtxMenu;
                    final /* synthetic */ LineGutterPlugin val$sqlGutter;
                    {
                        this.val$_gridCtxMenu = jPopupMenu;
                        this.val$sqlGutter = lineGutterPlugin;
                    }

                    public void lineClicked(Gutter gutter, int n, MouseEvent mouseEvent) {
                        gutter.hashCode();
                        this.val$_gridCtxMenu.show((Component)this.val$sqlGutter, mouseEvent.getX(), mouseEvent.getY());
                    }
                });
                SQLExpressionBuilderPanel.this.jSQLScrollPane.getRowHeader().addMouseListener(new MouseAdapter((JPopupMenu)object3, lineGutterPlugin){
                    final /* synthetic */ JPopupMenu val$_gridCtxMenu;
                    final /* synthetic */ LineGutterPlugin val$sqlGutter;
                    {
                        this.val$_gridCtxMenu = jPopupMenu;
                        this.val$sqlGutter = lineGutterPlugin;
                    }

                    @Override
                    public void mousePressed(MouseEvent mouseEvent) {
                        int n = mouseEvent.getModifiers();
                        if ((n & 8) != 0 || (n & 4) != 0) {
                            this.val$_gridCtxMenu.show((Component)this.val$sqlGutter, mouseEvent.getX(), mouseEvent.getY());
                        }
                    }
                });
                Document document = SQLExpressionBuilderPanel.this._sqlEditor.getDocument();
                document.addDocumentListener(new DocumentListener(){

                    @Override
                    public void changedUpdate(DocumentEvent documentEvent) {
                        SQLExpressionBuilderPanel.this.setExpressionDirty();
                    }

                    @Override
                    public void insertUpdate(DocumentEvent documentEvent) {
                        SQLExpressionBuilderPanel.this.setExpressionDirty();
                    }

                    @Override
                    public void removeUpdate(DocumentEvent documentEvent) {
                        SQLExpressionBuilderPanel.this.setExpressionDirty();
                    }
                });
                SQLExpressionBuilderPanel.this._sqlEditor.setDragEnabled(true);
                document.addUndoableEditListener(new UndoableEditListener(){

                    @Override
                    public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
                        SQLExpressionBuilderPanel.this._undoManager.addEdit(undoableEditEvent.getEdit());
                    }
                });
                SQLExpressionBuilderPanel.this._sqlEditor.getActionMap().put("Undo", new AbstractAction("Undo"){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        try {
                            if (SQLExpressionBuilderPanel.this._undoManager.canUndo()) {
                                SQLExpressionBuilderPanel.this._undoManager.undo();
                            }
                        }
                        catch (CannotUndoException cannotUndoException) {
                            SQLExpressionBuilderPanel.this.theLogger.log(Level.SEVERE, cannotUndoException.getLocalizedMessage(), cannotUndoException);
                        }
                    }
                });
                SQLExpressionBuilderPanel.this._sqlEditor.getInputMap().put(KeyStroke.getKeyStroke("control Z"), "Undo");
                SQLExpressionBuilderPanel.this._sqlEditor.getActionMap().put("Redo", new AbstractAction("Redo"){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        try {
                            if (SQLExpressionBuilderPanel.this._undoManager.canRedo()) {
                                SQLExpressionBuilderPanel.this._undoManager.redo();
                            }
                        }
                        catch (CannotRedoException cannotRedoException) {
                            SQLExpressionBuilderPanel.this.theLogger.log(Level.SEVERE, cannotRedoException.getLocalizedMessage(), cannotRedoException);
                        }
                    }
                });
                SQLExpressionBuilderPanel.this._sqlEditor.getInputMap().put(KeyStroke.getKeyStroke("control Y"), "Redo");
                SQLExpressionBuilderPanel.this.enableControls(true);
                SQLExpressionBuilderPanel.this._structureViewPane = new StructureViewPanel(SQLExpressionBuilderPanel.this.getContext(), null);
                SQLExpressionBuilderPanel.this._viewerTabPane.addTab(COLUMN_TAB, SQLExpressionBuilderPanel.this._structureViewPane);
                SQLExpressionBuilderPanel.this._viewerTabPane.addChangeListener(new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent changeEvent) {
                        if (changeEvent.getSource() instanceof JTabbedPane) {
                            Component component = SQLExpressionBuilderPanel.this._viewerTabPane.getSelectedComponent();
                            if (component instanceof StructureViewPanel) {
                                SQLExpressionBuilderPanel.this.showSQLExpressionColumns();
                            } else if (component instanceof DataViewerPanel) {
                                SQLExpressionBuilderPanel.this.showSQLExpressionResult();
                            }
                        }
                    }
                });
                SQLExpressionBuilderPanel.this.jProgressBar.setVisible(false);
                SQLExpressionBuilderPanel.this.jSplitPane2.setRightComponent(null);
            }
        }
        Initialization initialization = new Initialization(this);
        initialization.setTitle(DialogsLrb.get("EDIT_DIALOG_TITLE"));
        initialization.setMessage(DialogsLrb.get("SQLQUERY_LOADING"));
        initialization.setCancelable(false);
        try {
            initialization.start(true);
        }
        catch (ProgressException progressException) {
            this.theLogger.log(Level.SEVERE, progressException.getMessage(), progressException);
        }
    }

    protected abstract String getStackSQLExpression(SQLContext var1, String var2);

    protected void enableControls(boolean bl) {
        this.jNameLabel.setVisible(this._sqlContext.isExpressionOnly());
        this.jNameTextField.setVisible(this._sqlContext.isExpressionOnly());
        this.jValidateButton.setEnabled(bl && this._sqlExpression != null && this._sqlExpression.length() > 0);
        this.jUndoButton.setEnabled(bl && this._undoManager.canUndo());
        this.jRedoButton.setEnabled(bl && this._undoManager.canRedo());
        this.jRefreshButton.setEnabled(bl && this._sqlExpression != null && this._sqlExpression.length() > 0);
        this._sqlEditor.setEditable(bl);
    }

    private void setExpressionDirty() {
        String string = this._sqlEditor.getText().trim();
        while (!string.isEmpty() && string.endsWith(";")) {
            string = string.substring(0, string.length() - 1);
        }
        if (this._sqlExpression != null && this._sqlExpression.compareToIgnoreCase(string) != 0 || this._sqlExpression == null && !string.isEmpty()) {
            this._expressionDirty = true;
            this._validateExpression = true;
            this._sqlExpression = string;
        }
        this.enableControls(true);
    }

    public boolean isExpressionDirty() {
        return this._expressionDirty;
    }

    public boolean isOutputColumnsDirty() {
        return this._outputColumnsDirty;
    }

    protected void insertSQLExpression(String string) {
        int n;
        int n2 = this._sqlEditor.getCaretPosition();
        int n3 = this._sqlEditor.getSelectionStart();
        if (n3 < (n = this._sqlEditor.getSelectionEnd())) {
            this._sqlEditor.replaceSelection(string);
            this._sqlEditor.setCaretPosition(n3 + string.length());
        } else {
            try {
                this._sqlEditor.insertString(n2, string, null);
            }
            catch (BadLocationException badLocationException) {
                this.theLogger.log(Level.SEVERE, badLocationException.getLocalizedMessage(), badLocationException);
            }
            this._sqlEditor.setCaretPosition(n2 + string.length());
        }
        this._sqlEditor.requestFocusInWindow();
    }

    protected void showSQLExpressionColumns() {
        this.jPreviewPanel.removeAll();
        this.jPreviewPanel.add((Component)this._viewerTabPane, "Center");
        this._viewerTabPane.setSelectedComponent(this._structureViewPane);
        if (!this._previewColumnsLoaded) {
            try {
                String string = null;
                if (this._hasWithClause) {
                    string = this._sqlExpression;
                } else {
                    String string2 = this._sqlContext.getName();
                    this._sqlContext.setName(this._name);
                    string = this.getStackSQLExpression(this._sqlContext, this._sqlExpression);
                    this._sqlContext.setName(string2);
                }
                this._structureViewPane.loadTable(string);
                this._previewColumnsLoaded = true;
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)DialogsLrb.get("ERROR_TITLE"), (String)DialogsLrb.get("UNEXPECTED_ERROR_MSG"), null);
            }
        }
    }

    protected void showSQLExpressionResult() {
        this._viewerTabPane.setSelectedComponent(this._dataViewerPane);
        if (!this._previewDataLoaded) {
            try {
                String string = null;
                if (this._hasWithClause) {
                    string = this._sqlExpression;
                } else {
                    String string2 = this._sqlContext.getName();
                    this._sqlContext.setName(this._name);
                    string = this.getStackSQLExpression(this._sqlContext, this._sqlExpression);
                    this._sqlContext.setName(string2);
                }
                this._dataViewerPane.loadTable(string);
                this._previewDataLoaded = true;
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)DialogsLrb.get("ERROR_TITLE"), (String)DialogsLrb.get("UNEXPECTED_ERROR_MSG"), null);
            }
        }
    }

    protected void showSQLExpressionError(String string) {
        this._validationResults.setEditable(false);
        this._validationResults.setLineWrap(true);
        this._validationResults.setWrapStyleWord(true);
        this._validationResults.setText(string);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.getViewport().add(this._validationResults);
        this.jPreviewPanel.removeAll();
        this.jPreviewPanel.add((Component)jScrollPane, "Center");
        if (this.jSplitPane2.getRightComponent() == null) {
            this.jSplitPane2.setRightComponent(this.jPanel2);
            int n = (int)this.jSplitPane2.getSize().getHeight() * 1 / 2;
            this.jSplitPane2.setDividerLocation(n);
        }
        this.jPreviewPanel.updateUI();
    }

    private void validateSQLExpression() throws Exception {
        this.jPreviewPanel.removeAll();
        this.jPreviewPanel.add((Component)new JPanel(), "Center");
        if (this.jSplitPane2.getRightComponent() == null) {
            this.jSplitPane2.setRightComponent(this.jPanel2);
            int n = (int)this.jSplitPane2.getSize().getHeight() * 1 / 2;
            this.jSplitPane2.setDividerLocation(n);
        }
        ValidateSQL validateSQL = new ValidateSQL();
        validateSQL.execute();
    }

    @Override
    protected void doCancel() {
        super.doCancel();
        if (this._dataViewerPane != null) {
            this._dataViewerPane.getState().getResultSetModel().closeConnection();
        }
    }

    @Override
    protected void onFailure(Exception exception) {
        super.onFailure(exception);
        if (this._dataViewerPane != null) {
            this._dataViewerPane.getState().getResultSetModel().closeConnection();
        }
    }

    @Override
    protected boolean doWork() {
        Object object;
        boolean bl = true;
        if (this._validateExpression) {
            Object object2;
            object = null;
            try {
                class ValidateSQLThread
                extends ProgressRunnable {
                    boolean _validated = true;
                    Exception _ex = null;

                    public boolean getValidation() {
                        return this._validated;
                    }

                    public Exception getException() {
                        return this._ex;
                    }

                    protected Object doWork() throws Exception {
                        try {
                            SQLExpressionBuilderPanel.this.validateSQLExpression(SQLExpressionBuilderPanel.this._sqlExpression, SQLExpressionBuilderPanel.this._columnMetaData);
                        }
                        catch (Exception exception) {
                            this._validated = false;
                            this._ex = exception;
                        }
                        finally {
                            if (SQLExpressionBuilderPanel.this._dataViewerPane != null) {
                                SQLExpressionBuilderPanel.this._dataViewerPane.getState().getResultSetModel().closeConnection();
                            }
                        }
                        return true;
                    }
                }
                object2 = new ValidateSQLThread();
                object2.setTitle(DialogsLrb.get("SQLQUERY_VALIDATE"));
                object2.setMessage(DialogsLrb.get("SQLQUERY_VALIDATE_DESC"));
                object2.setCancelable(false);
                object2.start(true);
                bl = ((ValidateSQLThread)((Object)object2)).getValidation();
                object = ((ValidateSQLThread)((Object)object2)).getException();
            }
            catch (Exception exception) {
                this.theLogger.log(Level.SEVERE, exception.getLocalizedMessage(), exception);
            }
            if (!bl) {
                if (object instanceof WithClauseViewOutputException) {
                    this._hasWithClause = true;
                    object2 = new CreateViewPanel(this.getContext(), this._name);
                    if (((DialogDisplayer)object2).showAsDialog(this)) {
                        this._generateView = true;
                        this._name = ((CreateViewPanel)object2).getViewName().trim();
                        this._outputColumnsDirty = true;
                        this._expressionDirty = true;
                        this._validateExpression = false;
                        bl = true;
                    } else {
                        this._generateView = false;
                        bl = false;
                    }
                } else if (object instanceof WithClauseNoInputException) {
                    this._hasWithClause = true;
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)DialogsLrb.get("SQLQUERY_VALIDATE_USE_OF_WITH_CLAUSE_NO_INPUT"), (String)DialogsLrb.get("ERROR_TITLE"), null);
                } else {
                    this._hasWithClause = false;
                    this._generateView = false;
                    if (MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)DialogsLrb.get("SQLQUERY_VALIDATE_FAILED_CONFIRM"), (String)DialogsLrb.get("WARNING_TITLE"), null)) {
                        bl = false;
                    }
                }
            }
        }
        if (bl) {
            if (StringUtils.checkDataLossWithMsg(this._sqlContext.getContext(), this._sqlExpression, DialogsLrb.get("ERROR_TITLE"))) {
                return false;
            }
            object = this._sqlContext.getNode().getData();
            if (object.getStatus() == NodeStatusType.INVALID || object.getStatus() == NodeStatusType.FAILURE) {
                this._expressionDirty = true;
            }
        }
        return true;
    }

    public String getSqlExpression() {
        return this._sqlExpression;
    }

    public Vector<ColumnDataRow> getResultColumnInfo() {
        return this._columnMetaData;
    }

    @Override
    public String getName() {
        return this._name;
    }

    public boolean HasWithClause() {
        return this._hasWithClause;
    }

    public boolean isGenerateView() {
        return this._generateView;
    }

    private void initComponents() {
        this.jNameLabel = new JLabel();
        this.jNameTextField = new JTextField();
        this.jSplitPane1 = new JSplitPane();
        this.jPanel1 = new JPanel();
        this.jSourceTabbedPane = new JTabbedPane();
        this.jSplitPane2 = new JSplitPane();
        this.jSQLPanel = new JPanel();
        this.jSQLTextToolBar = new JToolBar();
        this.jValidateButton = new JButton();
        this.jUndoButton = new JButton();
        this.jRedoButton = new JButton();
        this.jSQLScrollPane = new JScrollPane();
        this.jSQLStatusPanel = new JPanel();
        this.locationLabel = new JLabel();
        this.jPanel2 = new JPanel();
        this.jPreviewToolBar = new JToolBar();
        this.jRefreshButton = new JButton();
        this.jProgressBar = new JProgressBar();
        this.jPreviewPanel = new JPanel();
        this.chkIncludeAllAvailableColumns = new JCheckBox();
        this.setPreferredSize(new Dimension(800, 600));
        this.jNameLabel.setLabelFor(this.jNameTextField);
        this.jNameLabel.setText("Name:");
        this.jNameTextField.setText("jTextField1");
        this.jSplitPane1.setDividerLocation(300);
        GroupLayout groupLayout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSourceTabbedPane, -1, 299, Short.MAX_VALUE));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSourceTabbedPane, -1, 529, Short.MAX_VALUE));
        this.jSplitPane1.setLeftComponent(this.jPanel1);
        this.jSplitPane2.setDividerLocation(250);
        this.jSplitPane2.setOrientation(0);
        this.jSplitPane2.setResizeWeight(0.5);
        this.jSplitPane2.setOneTouchExpandable(true);
        this.jSQLPanel.setLayout(new BorderLayout());
        this.jSQLTextToolBar.setRollover(true);
        this.jValidateButton.setFocusable(false);
        this.jValidateButton.setHorizontalTextPosition(0);
        this.jValidateButton.setVerticalTextPosition(3);
        this.jValidateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SQLExpressionBuilderPanel.this.jValidateButtonActionPerformed(actionEvent);
            }
        });
        this.jSQLTextToolBar.add(this.jValidateButton);
        this.jUndoButton.setFocusable(false);
        this.jUndoButton.setHorizontalTextPosition(0);
        this.jUndoButton.setVerticalTextPosition(3);
        this.jUndoButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SQLExpressionBuilderPanel.this.jUndoButtonActionPerformed(actionEvent);
            }
        });
        this.jSQLTextToolBar.add(this.jUndoButton);
        this.jRedoButton.setFocusable(false);
        this.jRedoButton.setHorizontalTextPosition(0);
        this.jRedoButton.setVerticalTextPosition(3);
        this.jRedoButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SQLExpressionBuilderPanel.this.jRedoButtonActionPerformed(actionEvent);
            }
        });
        this.jSQLTextToolBar.add(this.jRedoButton);
        this.jSQLPanel.add((Component)this.jSQLTextToolBar, "North");
        this.jSQLPanel.add((Component)this.jSQLScrollPane, "Center");
        this.jSQLStatusPanel.setLayout(new BorderLayout());
        this.locationLabel.setText("1:1");
        this.jSQLStatusPanel.add((Component)this.locationLabel, "East");
        this.jSQLPanel.add((Component)this.jSQLStatusPanel, "South");
        this.jSplitPane2.setTopComponent(this.jSQLPanel);
        this.jPanel2.setLayout(new BorderLayout());
        this.jPreviewToolBar.setRollover(true);
        this.jRefreshButton.setFocusable(false);
        this.jRefreshButton.setHorizontalTextPosition(0);
        this.jRefreshButton.setVerticalTextPosition(3);
        this.jRefreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SQLExpressionBuilderPanel.this.jRefreshButtonActionPerformed(actionEvent);
            }
        });
        this.jPreviewToolBar.add(this.jRefreshButton);
        this.jProgressBar.setMaximumSize(new Dimension(100, 14));
        this.jProgressBar.setPreferredSize(new Dimension(100, 14));
        this.jPreviewToolBar.add(this.jProgressBar);
        this.jPanel2.add((Component)this.jPreviewToolBar, "North");
        this.jPreviewPanel.setLayout(new BorderLayout());
        this.jPanel2.add((Component)this.jPreviewPanel, "Center");
        this.jSplitPane2.setRightComponent(this.jPanel2);
        this.jSplitPane1.setRightComponent(this.jSplitPane2);
        this.chkIncludeAllAvailableColumns.setText("Include all available columns");
        GroupLayout groupLayout2 = new GroupLayout(this);
        this.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane1, -1, 780, Short.MAX_VALUE).addGroup(groupLayout2.createSequentialGroup().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.chkIncludeAllAvailableColumns).addGroup(groupLayout2.createSequentialGroup().addComponent(this.jNameLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jNameTextField, -2, 250, -2))).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout2.createSequentialGroup().addContainerGap().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jNameLabel).addComponent(this.jNameTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.chkIncludeAllAvailableColumns).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSplitPane1).addContainerGap()));
    }

    private void jValidateButtonActionPerformed(ActionEvent actionEvent) {
        try {
            this.validateSQLExpression();
        }
        catch (WithClauseViewOutputException withClauseViewOutputException) {
            this.showSQLExpressionError(DialogsLrb.get("SQLQUERY_VALIDATE_USE_OF_WITH_CLAUSE_NO_VIEW"));
        }
        catch (WithClauseNoInputException withClauseNoInputException) {
            this.showSQLExpressionError(DialogsLrb.get("SQLQUERY_VALIDATE_USE_OF_WITH_CLAUSE_NO_INPUT"));
        }
        catch (Exception exception) {
            this.showSQLExpressionError(exception.getLocalizedMessage());
        }
    }

    private void jUndoButtonActionPerformed(ActionEvent actionEvent) {
        try {
            this._undoManager.undo();
        }
        catch (CannotUndoException cannotUndoException) {
            this.theLogger.log(Level.SEVERE, cannotUndoException.getLocalizedMessage(), cannotUndoException);
        }
        this.enableControls(true);
    }

    private void jRedoButtonActionPerformed(ActionEvent actionEvent) {
        try {
            this._undoManager.redo();
        }
        catch (CannotUndoException cannotUndoException) {
            this.theLogger.log(Level.SEVERE, cannotUndoException.getLocalizedMessage(), cannotUndoException);
        }
        this.enableControls(true);
    }

    private void jRefreshButtonActionPerformed(ActionEvent actionEvent) {
        try {
            this.validateSQLExpression();
        }
        catch (WithClauseViewOutputException withClauseViewOutputException) {
            this.showSQLExpressionError(DialogsLrb.get("SQLQUERY_VALIDATE_USE_OF_WITH_CLAUSE_NO_VIEW"));
        }
        catch (WithClauseNoInputException withClauseNoInputException) {
            this.showSQLExpressionError(DialogsLrb.get("SQLQUERY_VALIDATE_USE_OF_WITH_CLAUSE_NO_INPUT"));
        }
        catch (Exception exception) {
            this.showSQLExpressionError(exception.getLocalizedMessage());
        }
    }

    protected void validateSQLExpression(String string, Vector<ColumnDataRow> vector) throws Exception {
        String string2 = null;
        ConnectionFolder connectionFolder = ConnectionFolder.getConnectionFolder(this.getContext());
        try {
            String string3 = this._sqlContext.getName();
            this._sqlContext.setName(this._name);
            string2 = this.getStackSQLExpression(this._sqlContext, this._sqlExpression);
            this._sqlContext.setName(string3);
            this.getMetaData(connectionFolder, string2, vector);
            this._validateExpression = false;
        }
        catch (SQLException sQLException) {
            int n = sQLException.getErrorCode();
            if (n == 32034) {
                List<AbstractNode> list = this._sqlContext.getSourceNodes();
                for (AbstractNode abstractNode : list) {
                    if (!(abstractNode instanceof AbstractDataNode) || !string.contains(abstractNode.getAliasName())) continue;
                    throw new WithClauseNoInputException();
                }
                this.getMetaData(connectionFolder, string, vector);
                if (!this._sqlContext.isGenerateView()) {
                    throw new WithClauseViewOutputException();
                }
            }
            throw sQLException;
        }
        catch (Exception exception) {
            throw exception;
        }
    }

    protected void getMetaData(ConnectionManager connectionManager, String string, Vector<ColumnDataRow> vector) throws Exception {
        if (string == null) {
            return;
        }
        if (vector == null) {
            return;
        }
        vector.clear();
        StringBuilder stringBuilder = new StringBuilder("SELECT * FROM ( ");
        stringBuilder.append(string);
        stringBuilder.append(")");
        try (SQLHelper sQLHelper = new SQLHelper();){
            String string2;
            sQLHelper.conn = connectionManager.getConnection();
            OracleConnection oracleConnection = (OracleConnection)sQLHelper.conn;
            Array array = oracleConnection.createOracleArray("ODMR_OBJECT_VALUES", (Object)new String[0]);
            Array array2 = oracleConnection.createOracleArray("ODMR_OBJECT_NAMES", (Object)new String[0]);
            Array array3 = oracleConnection.createOracleArray("ODMR_OBJECT_IDS", null);
            Array array4 = oracleConnection.createOracleArray("ODMR_OBJECT_IDS", null);
            Array array5 = oracleConnection.createOracleArray("ODMR_OBJECT_IDS", null);
            sQLHelper.cstmt = (OracleCallableStatement)sQLHelper.conn.prepareCall("{call ODMR_UTIL.DESCRIBE_SQL_EXPRESSION(?,?,?,?,?,?)}");
            sQLHelper.cstmt.setCharacterStream(1, (Reader)new StringReader(stringBuilder.toString()), stringBuilder.length());
            sQLHelper.cstmt.setArray(2, array);
            sQLHelper.cstmt.setArray(3, array2);
            sQLHelper.cstmt.setArray(4, array3);
            sQLHelper.cstmt.setArray(5, array4);
            sQLHelper.cstmt.setArray(6, array5);
            sQLHelper.cstmt.registerOutParameter(2, 2003, "ODMR_OBJECT_VALUES");
            sQLHelper.cstmt.registerOutParameter(3, 2003, "ODMR_OBJECT_NAMES");
            sQLHelper.cstmt.registerOutParameter(4, 2003, "ODMR_OBJECT_IDS");
            sQLHelper.cstmt.registerOutParameter(5, 2003, "ODMR_OBJECT_IDS");
            sQLHelper.cstmt.registerOutParameter(6, 2003, "ODMR_OBJECT_IDS");
            sQLHelper.cstmt.execute();
            Array array6 = sQLHelper.cstmt.getArray(2);
            String[] stringArray = (String[])array6.getArray();
            Array array7 = sQLHelper.cstmt.getArray(3);
            String[] stringArray2 = (String[])array7.getArray();
            sQLHelper.close();
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < stringArray.length; ++i) {
                string2 = stringArray[i];
                String string3 = stringArray2[i];
                ColumnDataRow columnDataRow = new ColumnDataRow(string2, string3, null, null, null, null);
                vector.add(columnDataRow);
            }
            if (stringBuffer.length() > 0) {
                String string4 = NodeMessagesLrb.get("SQL_QUERY_COL_INVALID");
                string2 = MessageFormat.format(string4, stringBuffer.toString());
                throw new Exception(string2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isRScriptsAvailable() {
        String string = "select count(*) from sys.rq_scripts";
        boolean bl = false;
        try (SQLHelper sQLHelper = new SQLHelper();){
            sQLHelper.conn = ConnectionFolder.getConnection(this._sqlContext.getContext());
            sQLHelper.pstmt = sQLHelper.conn.prepareStatement(string);
            sQLHelper.rs = sQLHelper.pstmt.executeQuery();
            if (sQLHelper.rs.next()) {
                bl = true;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected String createErrorComp(Throwable throwable) {
        Object object = null;
        Object object2 = null;
        int n = -1;
        SQLException sQLException = null;
        if (throwable != null) {
            if (throwable instanceof SQLException) {
                sQLException = (SQLException)throwable;
            } else if (throwable.getCause() instanceof SQLException) {
                sQLException = (SQLException)throwable.getCause();
            }
            if (sQLException != null && (object2 = sQLException.getLocalizedMessage()) != null && ((String)object2).indexOf("ORA") > -1) {
                Oerr oerr = new Oerr();
                Connection connection = null;
                try {
                    object2 = (String)object2 + oerr.oerr((String)object2);
                    connection = ConnectionFolder.getConnection(this._sqlContext.getContext());
                    n = DBUtil.getInstance((Connection)connection).getErrorOffset(this._sqlExpression);
                }
                catch (OerrException oerrException) {
                    this.theLogger.log(Level.FINEST, oerrException.getMessage(), oerrException);
                    SQLHelper.close(connection);
                }
                catch (SQLException sQLException2) {
                    object2 = (String)object2 + sQLException2.getLocalizedMessage();
                    this.theLogger.log(Level.FINEST, (String)object2, sQLException2);
                    {
                        catch (Throwable throwable2) {
                            SQLHelper.close(connection);
                            throw throwable2;
                        }
                    }
                    SQLHelper.close(connection);
                }
                SQLHelper.close(connection);
            }
            if (object2 == null) {
                object2 = throwable.getLocalizedMessage();
            }
        }
        object = n < 1 ? object2 : object2 + "\n" + this.getCommandDetails(n);
        return object;
    }

    protected String getCommandDetails(int n) {
        Object[] objectArray = null;
        if (n != -1) {
            int n2 = 1;
            objectArray = SQLErrorDialog.getLineAndColumn((String)this._sqlExpression, (int)n, (int)n2, (int)1);
        }
        return MessageFormat.format(Messages.getString((String)"SQLErrorDialog.10"), objectArray);
    }

    protected void setLineCol() {
        int n = this._sqlEditor.getCaretPosition();
        int n2 = 1;
        int n3 = 0;
        int n4 = -1;
        String string = this._sqlEditor.getText().replaceAll("\r", "");
        for (int i = 0; i < n; ++i) {
            if (string.charAt(i) != '\n') continue;
            ++n2;
            n4 = i;
        }
        n3 = n - n4;
        String string2 = DialogsLrb.get("SQLQUERY_QUERY_LINE_COL");
        String string3 = MessageFormat.format(string2, n2, n3);
        this.locationLabel.setText(string3);
    }

    private class ValidateSQL
    extends SwingWorker {
        ArrayList<String> _textData = new ArrayList();
        ArrayList<String> _imageData = new ArrayList();
        boolean _otherData = false;
        Exception _ex;
        Boolean _success = false;

        public ValidateSQL() {
            SQLExpressionBuilderPanel.this.enableControls(false);
            SQLExpressionBuilderPanel.this.jProgressBar.setVisible(true);
            SQLExpressionBuilderPanel.this.jProgressBar.setIndeterminate(true);
            SQLExpressionBuilderPanel.this._previewColumnsLoaded = false;
            SQLExpressionBuilderPanel.this._previewDataLoaded = false;
        }

        private boolean getRData(String string) {
            boolean bl = false;
            try {
                InputSource inputSource = new InputSource(new StringReader(string));
                org.w3c.dom.Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(inputSource);
                TransformerFactory transformerFactory = TransformerFactory.newInstance();
                Transformer transformer = transformerFactory.newTransformer();
                if (document.getElementsByTagName("root") != null) {
                    Object object;
                    Object object2;
                    Object object3;
                    NodeList nodeList = document.getElementsByTagName("img");
                    for (int i = 0; i < nodeList.getLength(); ++i) {
                        Element element = (Element)nodeList.item(i);
                        object3 = new DOMSource(element);
                        object2 = new StreamResult(new StringWriter());
                        transformer.transform((Source)object3, (Result)object2);
                        object = ((StreamResult)object2).getWriter().toString();
                        this._imageData.add((String)object);
                    }
                    nodeList = document.getElementsByTagName("root");
                    Element element = (Element)nodeList.item(0);
                    nodeList = element.getChildNodes();
                    for (int i = 0; i < nodeList.getLength(); ++i) {
                        object3 = nodeList.item(i);
                        if (!(object3 instanceof Element) || "images".equals((element = (Element)nodeList.item(i)).getTagName()) || !element.hasChildNodes()) continue;
                        object2 = new DOMSource(element);
                        object = new StreamResult(new StringWriter());
                        transformer.transform((Source)object2, (Result)object);
                        String string2 = ((StreamResult)object).getWriter().toString();
                        this._textData.add(string2);
                    }
                    bl = true;
                }
            }
            catch (Exception exception) {
                bl = false;
            }
            return bl;
        }

        private void getData(ColumnDataRow columnDataRow) throws SQLException {
            try (SQLHelper sQLHelper = new SQLHelper();){
                Object object;
                String string = null;
                if (SQLExpressionBuilderPanel.this._hasWithClause) {
                    string = SQLExpressionBuilderPanel.this._sqlExpression;
                } else {
                    object = SQLExpressionBuilderPanel.this._sqlContext.getName();
                    SQLExpressionBuilderPanel.this._sqlContext.setName(SQLExpressionBuilderPanel.this._name);
                    string = SQLExpressionBuilderPanel.this.getStackSQLExpression(SQLExpressionBuilderPanel.this._sqlContext, SQLExpressionBuilderPanel.this._sqlExpression);
                    SQLExpressionBuilderPanel.this._sqlContext.setName((String)object);
                }
                sQLHelper.conn = ConnectionFolder.getConnection(SQLExpressionBuilderPanel.this._sqlContext.getContext());
                sQLHelper.pstmt = sQLHelper.conn.prepareStatement(string);
                sQLHelper.rs = sQLHelper.pstmt.executeQuery();
                while (sQLHelper.rs.next()) {
                    long l;
                    object = sQLHelper.rs.getClob(columnDataRow.getName());
                    String string2 = object.getSubString(1L, (int)(l = object.length()));
                    boolean bl = this.getRData(string2);
                    if (bl) continue;
                    this._otherData = true;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        protected Object doInBackground() throws Exception {
            try {
                Object object;
                SQLExpressionBuilderPanel.this._sqlExpression = SQLExpressionBuilderPanel.this._sqlExpression.trim();
                try {
                    SQLExpressionBuilderPanel.this.validateSQLExpression(SQLExpressionBuilderPanel.this._sqlExpression, SQLExpressionBuilderPanel.this._columnMetaData);
                }
                catch (Exception exception) {
                    if (exception instanceof WithClauseViewOutputException) {
                        SQLExpressionBuilderPanel.this._hasWithClause = true;
                        object = new CreateViewPanel(SQLExpressionBuilderPanel.this.getContext(), SQLExpressionBuilderPanel.this._name);
                        if (((DialogDisplayer)object).showAsDialog(SQLExpressionBuilderPanel.this)) {
                            SQLExpressionBuilderPanel.this._generateView = true;
                            SQLExpressionBuilderPanel.this._name = ((CreateViewPanel)object).getViewName().trim();
                            SQLExpressionBuilderPanel.this._outputColumnsDirty = true;
                            SQLExpressionBuilderPanel.this._expressionDirty = true;
                            SQLExpressionBuilderPanel.this._validateExpression = false;
                        }
                        SQLExpressionBuilderPanel.this._generateView = false;
                        throw exception;
                    }
                    if (exception instanceof WithClauseNoInputException) {
                        SQLExpressionBuilderPanel.this._hasWithClause = true;
                        throw exception;
                    }
                    throw exception;
                }
                boolean bl = false;
                if (SQLExpressionBuilderPanel.this._isRScriptsAvailable) {
                    for (Object object2 : object = SQLExpressionBuilderPanel.this._RScriptsPanel.getRQFunctions()) {
                        if (!SQLExpressionBuilderPanel.this._sqlExpression.toUpperCase().contains(((String)object2).toUpperCase())) continue;
                        bl = true;
                    }
                }
                for (ColumnDataRow columnDataRow : SQLExpressionBuilderPanel.this._columnMetaData) {
                    if (columnDataRow.getDataType().equals("CLOB") && bl) {
                        this.getData(columnDataRow);
                        continue;
                    }
                    this._otherData = true;
                }
                this._success = true;
            }
            catch (SQLException sQLException) {
                void var3_12;
                int n = sQLException.getLocalizedMessage().indexOf("ORA", 3);
                String string = sQLException.getLocalizedMessage();
                if (n > 0) {
                    String string2 = sQLException.getLocalizedMessage().substring(0, n);
                }
                this._ex = new SQLException((String)var3_12);
                this._success = false;
            }
            catch (Exception exception) {
                this._ex = exception;
                this._success = false;
            }
            return this._success;
        }

        @Override
        protected void done() {
            super.done();
            SQLExpressionBuilderPanel.this.jProgressBar.setVisible(false);
            SQLExpressionBuilderPanel.this.enableControls(true);
            if (!this._success.booleanValue()) {
                String string = null;
                string = this._ex instanceof WithClauseNoInputException ? DialogsLrb.get("SQLQUERY_VALIDATE_USE_OF_WITH_CLAUSE_NO_INPUT") : (this._ex instanceof WithClauseViewOutputException ? DialogsLrb.get("SQLQUERY_VALIDATE_USE_OF_WITH_CLAUSE_NO_VIEW") : SQLExpressionBuilderPanel.this.createErrorComp(this._ex));
                SQLExpressionBuilderPanel.this.showSQLExpressionError(string);
            } else {
                try {
                    JPanel jPanel;
                    SQLExpressionBuilderPanel.this._viewerTabPane.remove(SQLExpressionBuilderPanel.this._dataViewerPane);
                    for (ODMrXMLOutputPanel object : SQLExpressionBuilderPanel.this._xmlPanels) {
                        SQLExpressionBuilderPanel.this._viewerTabPane.remove(object);
                    }
                    SQLExpressionBuilderPanel.this._xmlPanels.clear();
                    for (ODMrGraphOutputPanel oDMrGraphOutputPanel : SQLExpressionBuilderPanel.this._GraphOutputPanels) {
                        SQLExpressionBuilderPanel.this._viewerTabPane.remove(oDMrGraphOutputPanel);
                    }
                    SQLExpressionBuilderPanel.this._GraphOutputPanels.clear();
                    if (this._otherData) {
                        SQLExpressionBuilderPanel.this._dataViewerPane = new DataViewerPanel(SQLExpressionBuilderPanel.this.getContext(), null);
                        SQLExpressionBuilderPanel.this._viewerTabPane.addTab(DATA_TAB, SQLExpressionBuilderPanel.this._dataViewerPane);
                    }
                    for (String string : this._textData) {
                        jPanel = new ODMrXMLOutputPanel(string);
                        SQLExpressionBuilderPanel.this._xmlPanels.add((ODMrXMLOutputPanel)jPanel);
                        SQLExpressionBuilderPanel.this._viewerTabPane.addTab(DATA_TAB, jPanel);
                    }
                    for (String string : this._imageData) {
                        jPanel = new ODMrGraphOutputPanel(string);
                        SQLExpressionBuilderPanel.this._GraphOutputPanels.add((ODMrGraphOutputPanel)jPanel);
                        SQLExpressionBuilderPanel.this._viewerTabPane.addTab(GRAPH_TAB, jPanel);
                    }
                    SQLExpressionBuilderPanel.this.showSQLExpressionColumns();
                }
                catch (Exception exception) {
                    ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)DialogsLrb.get("ERROR_TITLE"), (String)DialogsLrb.get("UNEXPECTED_ERROR_MSG"), null);
                }
            }
        }
    }

    class ViewNameInputVerifier
    extends InputVerifier {
        JTextField _textField;
        String _currentValue;
        Context _context;

        public ViewNameInputVerifier(JTextField jTextField, Context context) {
            this._textField = jTextField;
            this._context = context;
        }

        @Override
        public boolean verify(JComponent jComponent) {
            boolean bl = true;
            this._currentValue = SQLExpressionBuilderPanel.this._name;
            if (jComponent instanceof JTextField) {
                JTextField jTextField = (JTextField)jComponent;
                String string = jTextField.getText().trim();
                if (string.length() == 0) {
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)SQLQueryPIPropertyLrb.get("PI_SQLQUERY_GROUP_NAME_MISSING"), (String)SQLQueryPIPropertyLrb.get("PI_SQLQUERY_GROUP_SPEC_ERROR_TITLE"), null);
                    bl = false;
                }
                if (StringUtils.isDoubleQuotedString(string)) {
                    this._currentValue = StringUtils.addDoubleQuotes(this._currentValue);
                }
                if (bl && !StringUtils.isDoubleQuotedString(string)) {
                    string = string.toUpperCase();
                }
                try {
                    if (this._currentValue != null && this._currentValue.compareTo(string) != 0) {
                        if (bl && !TableNameValidator.validateTableName(string, null, this._context, true)) {
                            bl = false;
                        }
                        if (bl && !TableNameValidator.isTableNameUnique(this._context, string)) {
                            String string2 = MessageFormat.format(DataDialogsLrb.get("TABLE_VALIDATION_ERROR_IN_USE"), string);
                            if (!MessageDialog.confirm((Component)UITools.getParentWindow(SQLExpressionBuilderPanel.this), (Object)string2, (String)DataDialogsLrb.get("TABLE_VALIDATION_ERROR_TITLE"), null)) {
                                bl = false;
                            }
                        }
                    }
                }
                catch (Exception exception) {
                    ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)DataDialogsLrb.get("TABLE_VALIDATION_ERROR_TITLE"), (String)DataDialogsLrb.get("TABLE_VALIDATION_ERROR_SYSTEM_ERROR"), null);
                    bl = false;
                }
                if (!bl) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ViewNameInputVerifier.this._textField.setText(ViewNameInputVerifier.this._currentValue);
                        }
                    });
                } else {
                    SQLExpressionBuilderPanel.this._name = StringUtils.trimDoubleQuotes(string);
                    SQLExpressionBuilderPanel.this._outputColumnsDirty = true;
                }
            }
            return bl;
        }
    }

    class CustomViewNameValidator
    extends KeyAdapter
    implements FocusListener {
        boolean busy = false;
        ViewNameInputVerifier _verifier;

        public CustomViewNameValidator(ViewNameInputVerifier viewNameInputVerifier) {
            this._verifier = viewNameInputVerifier;
        }

        private void validateName() {
            if (this.busy) {
                return;
            }
            try {
                this.busy = true;
                this._verifier.verify(SQLExpressionBuilderPanel.this.jNameTextField);
            }
            finally {
                this.busy = false;
            }
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            if (keyEvent.getKeyChar() == '\n') {
                this.validateName();
            }
        }
    }
}

