/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.gallery;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ide.extension.BooleanVisitor;
import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementEndContext;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ElementVisitor;
import javax.ide.extension.ExtensionHook;
import javax.ide.extension.I18NStringVisitor;
import javax.ide.extension.MetaClassVisitor;
import javax.ide.util.MetaClass;
import oracle.ide.ExtensionRegistry;
import oracle.ide.extension.rules.RuleEngine;
import oracle.ide.gallery.ElementInfo;
import oracle.ide.gallery.FolderInfo;
import oracle.ide.gallery.GalleryFilter;
import oracle.javatools.util.Pair;

public class GalleryHandler
extends ExtensionHook {
    private static final ElementName HOOK_NAME = new ElementName("http://xmlns.oracle.com/jdeveloper/1013/extension", "gallery");
    private static final String FOLDER_ITEM_KEY = "folders_item_key";
    private static final String TRANSLATED_LABEL_ATTRIBUTE = "label";
    private static final String ITEM_KEY = "item_key";
    private static final String PARAMETER_KEY = "parameter_key";
    private static final String TECHNOLOGY_KEY = "technology_key";
    private static final String PATH_KEY = "category-folder_key";
    private static final String NB_RESOURCE = "nbresloc";
    private static final ElementName ITEM = new ElementName("http://xmlns.oracle.com/jdeveloper/1013/extension", "item");
    private static final ElementName GENERATORS = new ElementName("http://xmlns.oracle.com/jdeveloper/1013/extension", "generators");
    private static final ElementName FOLDERS = new ElementName("http://xmlns.oracle.com/jdeveloper/1013/extension", "folders");
    private static final ElementName KEY = new ElementName("http://xmlns.oracle.com/jdeveloper/1013/extension", "key");
    private static final ElementName VALUE = new ElementName("http://xmlns.oracle.com/jdeveloper/1013/extension", "value");
    private static final ElementName NAME = new ElementName("http://xmlns.oracle.com/jdeveloper/1013/extension", "name");
    private static final ElementName ID = new ElementName("http://xmlns.oracle.com/jdeveloper/1013/extension", "id");
    private static final ElementName CATEGORY = new ElementName("http://xmlns.oracle.com/jdeveloper/1013/extension", "category");
    private static final ElementName FOLDER = new ElementName("http://xmlns.oracle.com/jdeveloper/1013/extension", "folder");
    private static final ElementName DESCRIPTION = new ElementName("http://xmlns.oracle.com/jdeveloper/1013/extension", "description");
    private static final ElementName HELP = new ElementName("http://xmlns.oracle.com/jdeveloper/1013/extension", "help");
    private static final ElementName ICON = new ElementName("http://xmlns.oracle.com/jdeveloper/1013/extension", "icon");
    private static final ElementName TECH_KEY = new ElementName("http://xmlns.oracle.com/jdeveloper/1013/extension", "technologyKey");
    private static final ElementName UNSORTED = new ElementName("http://xmlns.oracle.com/jdeveloper/1013/extension", "unsorted");
    private static final ElementName PROJECT_NEW_MENU = new ElementName("http://xmlns.oracle.com/jdeveloper/1013/extension", "canAddToProjectNewMenu");
    private static final ElementName RESCLASS = new ElementName("http://xmlns.oracle.com/jdeveloper/1013/extension", "resClass");
    private static final ElementName PARAMETER = new ElementName("http://xmlns.oracle.com/jdeveloper/1013/extension", "parameter");
    private static final String RULE_ATTR_NAME = "rule";
    private static final Logger LOGGER = Logger.getLogger(GalleryHandler.class.getName());
    private ElementVisitor _itemHandler = new ItemHandler();
    private ElementVisitor _generatorItemVisitor = new GeneratorItemVisitor();
    private ElementVisitor _galleryHandler = new GeneratorHandler();
    private ElementVisitor _foldersHandler = new FoldersHandler();
    private boolean _customizationsApplied;
    private final List<GalleryFilter> _filters = new ArrayList<GalleryFilter>();
    private final Set<ElementInfo> _allItemsCache = new LinkedHashSet<ElementInfo>();
    private final Set<ElementInfo> _items = new LinkedHashSet<ElementInfo>();
    private final Map<String, MetaClass> _generators = new LinkedHashMap<String, MetaClass>();
    private final Set<FolderInfo> _folders = new LinkedHashSet<FolderInfo>();
    static final boolean DEBUG_GALLERY_HOOK_ITEMS = Boolean.getBoolean("debug.gallery.hook");
    private Map<String, Set<ElementInfo>> _debugItems;

    public static GalleryHandler get() {
        return (GalleryHandler)ExtensionRegistry.getExtensionRegistry().getHook(HOOK_NAME);
    }

    Map<String, MetaClass> getGenerators() {
        return Collections.unmodifiableMap(this._generators);
    }

    Set<ElementInfo> getItems() {
        return Collections.unmodifiableSet(this._items);
    }

    Set<FolderInfo> getFolders() {
        return Collections.unmodifiableSet(this._folders);
    }

    ElementInfo elementInfo(String invokableName, String id) {
        this.applyGalleryCustomizations();
        ArrayList<String> potentialIds = new ArrayList<String>();
        for (ElementInfo e : this._allItemsCache) {
            if (!e.getInvokableClassName().equals(invokableName)) continue;
            if (e.getId() == null ? id == null : e.getId().equals(id)) {
                return e;
            }
            potentialIds.add(e.getId());
        }
        StringBuilder b = new StringBuilder();
        if (potentialIds.isEmpty()) {
            b.append(invokableName);
            b.append(" does not match a registered gallery item. ");
            b.append("This will happen if the item is not available in the current role, or it has been hidden with shaping, or the extension that provides the element has not been loaded. It could also signify an error in the new-menu-hook registration.\n");
        } else {
            b.append(invokableName);
            b.append(" matches a registered gallery item name, but not its id. ");
            b.append("The new-menu-hook registration may be missing the id attribute. These ids were registered for the gallery item: ");
            String delim = "";
            for (String p : potentialIds) {
                b.append(delim);
                b.append(p);
                delim = ", ";
            }
            b.append(".\n");
        }
        LOGGER.log(Level.INFO, b.toString());
        return null;
    }

    private void applyGalleryCustomizations() {
        if (!this._customizationsApplied) {
            this._customizationsApplied = true;
            Iterator<ElementInfo> iter = this._allItemsCache.iterator();
            while (iter.hasNext()) {
                ElementInfo info = iter.next();
                if (this.accept(info)) continue;
                iter.remove();
            }
        }
    }

    public void start(ElementStartContext context) {
        context.registerChildVisitor(ITEM, this._itemHandler);
        context.registerChildVisitor(GENERATORS, this._galleryHandler);
        context.registerChildVisitor(FOLDERS, this._foldersHandler);
        String rsbundleClass = this.getAttributeHelper(context, "rsbundle-class", true, false);
        if (rsbundleClass != null) {
            context.getScopeData().put("rsbundleclass", rsbundleClass);
        }
        if (DEBUG_GALLERY_HOOK_ITEMS) {
            this._debugItems = new HashMap<String, Set<ElementInfo>>();
        }
    }

    public void end(ElementEndContext context) {
        if (DEBUG_GALLERY_HOOK_ITEMS) {
            String ret = "\n";
            StringBuilder b = new StringBuilder();
            b.append(context.getExtension().getName());
            b.append(" (").append(context.getExtension().getID()).append(") registered gallery items");
            Set<ElementInfo> items = this._debugItems.get(context.getExtension().getID());
            if (items != null && !items.isEmpty()) {
                for (ElementInfo e : items) {
                    b.append(ret);
                    b.append("- ").append(e.getName());
                    b.append(": item name = ").append(e.getInvokableClassName());
                    String id = e.getId();
                    if (id == null) continue;
                    b.append(", id = ").append(id);
                }
                b.append(ret).append("----------------------------------------------------------------------");
                System.out.println(b.toString());
            }
        }
    }

    boolean accept(ElementInfo elementInfo) {
        for (GalleryFilter f : this._filters) {
            if (f.accept(elementInfo)) continue;
            return false;
        }
        return true;
    }

    boolean accept(FolderInfo folderInfo) {
        for (GalleryFilter f : this._filters) {
            if (f.accept(folderInfo)) continue;
            return false;
        }
        return true;
    }

    public void addGalleryFilter(GalleryFilter filter) {
        this._filters.add(filter);
    }

    public void removeGalleryFilter(GalleryFilter filter) {
        this._filters.remove(filter);
    }

    boolean isRegistered(ElementInfo info) {
        return this._allItemsCache.contains(info);
    }

    private final class ItemHandler
    extends ElementVisitor {
        private ElementVisitor _wizardClassNameHandler = new NameHandler();
        private ElementVisitor _wizardIdHandler = new WizardIdHandler();
        private ElementVisitor _shortLabelHandler = new DescriptionHandler();
        private ElementVisitor _longLabelHandler = new HelpHandler();
        private ElementVisitor _iconHandler = new IconHandler();
        private ElementVisitor _unsortedHandler = new UnsortedHandler();
        private ElementVisitor _projectNewMenuHandler = new ProjectNewMenuHandler();
        private ElementVisitor _categoryHandler = new CategoryHandler();
        private ElementVisitor _folderHandler = new FolderHandler();
        private ElementVisitor _technologyHandler = new TechnologyKeyHandler();
        private ElementVisitor _resClassHandler = new ResClassHandler();
        private ElementVisitor _parameterHandler = new ParameterHandler();

        private ItemHandler() {
        }

        public void start(ElementStartContext context) {
            RuleEngine ruleEngine;
            context.registerChildVisitor(NAME, this._wizardClassNameHandler);
            context.registerChildVisitor(ID, this._wizardIdHandler);
            context.registerChildVisitor(DESCRIPTION, this._shortLabelHandler);
            context.registerChildVisitor(HELP, this._longLabelHandler);
            context.registerChildVisitor(ICON, this._iconHandler);
            context.registerChildVisitor(UNSORTED, this._unsortedHandler);
            context.registerChildVisitor(PROJECT_NEW_MENU, this._projectNewMenuHandler);
            context.registerChildVisitor(CATEGORY, this._categoryHandler);
            context.registerChildVisitor(FOLDER, this._folderHandler);
            context.registerChildVisitor(TECH_KEY, this._technologyHandler);
            context.registerChildVisitor(RESCLASS, this._resClassHandler);
            context.registerChildVisitor(PARAMETER, this._parameterHandler);
            String rsbundleClass = this.getAttributeHelper(context, "rsbundle-class", true, false);
            if (rsbundleClass != null) {
                context.getScopeData().put("rsbundleclass", rsbundleClass);
            }
            ElementInfo elementInfo = new ElementInfo();
            String ruleId = this.getAttributeHelper(context, GalleryHandler.RULE_ATTR_NAME, true, true);
            if (ruleId != null && (ruleEngine = RuleEngine.getInstance()).validateRuleReference(ruleId, (ElementContext)context)) {
                elementInfo.setRule(ruleId);
            }
            context.getScopeData().put(GalleryHandler.ITEM_KEY, elementInfo);
            context.getScopeData().put(GalleryHandler.PARAMETER_KEY, new ArrayList());
            context.getScopeData().put(GalleryHandler.TECHNOLOGY_KEY, new ArrayList());
            context.getScopeData().put(GalleryHandler.PATH_KEY, new Pair());
        }

        public void end(ElementEndContext context) {
            List parameters = (List)context.getScopeData().get(GalleryHandler.PARAMETER_KEY);
            this.getItem((ElementContext)context).setWizardParameters(this.convertToArray(parameters));
            List technology = (List)context.getScopeData().get(GalleryHandler.TECHNOLOGY_KEY);
            this.getItem((ElementContext)context).setTechnologyKeys(this.convertToArray(technology));
            Pair path = (Pair)context.getScopeData().get(GalleryHandler.PATH_KEY);
            if (path.getFirst() == null) {
                if (path.getSecond() == null) {
                    this.log((ElementContext)context, Level.WARNING, "gallery item missing folder, use <folder> and/or <category>");
                } else {
                    this.getItem((ElementContext)context).setPath((String)path.getSecond());
                }
            } else {
                this.getItem((ElementContext)context).setPath((String)path.getFirst(), (String)path.getSecond());
            }
            if (this.getItem((ElementContext)context).getPath() == null) {
                return;
            }
            GalleryHandler.this._items.add(this.getItem((ElementContext)context));
            GalleryHandler.this._allItemsCache.add(this.getItem((ElementContext)context));
            if (DEBUG_GALLERY_HOOK_ITEMS && GalleryHandler.this._debugItems != null) {
                String xId = context.getExtension().getID();
                if (!GalleryHandler.this._debugItems.containsKey(xId)) {
                    GalleryHandler.this._debugItems.put(xId, new LinkedHashSet());
                }
                GalleryHandler.this._debugItems.get(xId).add(this.getItem((ElementContext)context));
            }
        }

        private ElementInfo getItem(ElementContext context) {
            return (ElementInfo)context.getScopeData().get(GalleryHandler.ITEM_KEY);
        }

        private String[] convertToArray(List l) {
            return l != null ? l.toArray(new String[l.size()]) : null;
        }

        public class NameHandler
        extends ElementVisitor {
            public void end(ElementEndContext context) {
                ClassLoader loader = (ClassLoader)context.getScopeData().get("classLoader");
                ElementInfo info = ItemHandler.this.getItem((ElementContext)context);
                String className = context.getText();
                if (className == null || className.trim().isEmpty()) {
                    this.log((ElementContext)context, Level.WARNING, "gallery item missing wizard class name, use <name>");
                }
                className = className == null ? null : className.trim();
                info.setInvokableClass(className);
                info.setInvokableClassLoader(loader);
            }
        }

        public class WizardIdHandler
        extends ElementVisitor {
            public void end(ElementEndContext context) {
                ItemHandler.this.getItem((ElementContext)context).setId(context.getText().trim());
            }
        }

        public class DescriptionHandler
        extends I18NStringVisitor {
            protected void string(ElementContext context, String value) {
                ItemHandler.this.getItem(context).setName(value);
                if (value == null || value.trim().isEmpty()) {
                    this.log(context, Level.WARNING, "gallery item missing short label, use <description>");
                }
            }
        }

        public class HelpHandler
        extends ElementVisitor {
            boolean nbResource = false;

            public void start(ElementStartContext context) {
                this.nbResource = Boolean.parseBoolean(context.getAttributeValue(GalleryHandler.NB_RESOURCE));
            }

            public void end(ElementEndContext context) {
                String text = context.getText();
                if (text == null || text.trim().isEmpty()) {
                    this.log((ElementContext)context, Level.WARNING, "gallery item missing long label, use <help>");
                }
                if (this.nbResource) {
                    ItemHandler.this.getItem((ElementContext)context).setDescriptionURL(text);
                } else {
                    ItemHandler.this.getItem((ElementContext)context).setDescription(text);
                }
            }
        }

        public class IconHandler
        extends ElementVisitor {
            public void end(ElementEndContext context) {
                String text = context.getText().trim();
                if (text.isEmpty()) {
                    this.log((ElementContext)context, Level.WARNING, "Missing icon value");
                    return;
                }
                if (text.startsWith("uri:") && text.length() > 4) {
                    text = text.substring(4);
                } else if (text.charAt(0) != '/') {
                    this.log((ElementContext)context, Level.WARNING, "Icon path is not valid: " + text + ". Valid path must start with forward slash (/)");
                    return;
                }
                ItemHandler.this.getItem((ElementContext)context).setIconFile(text);
            }
        }

        public class UnsortedHandler
        extends BooleanVisitor {
            protected void booleanValue(ElementContext context, boolean value) {
                ItemHandler.this.getItem(context).setUnsorted(value);
            }
        }

        public class ProjectNewMenuHandler
        extends BooleanVisitor {
            protected void booleanValue(ElementContext context, boolean value) {
                ItemHandler.this.getItem(context).setCanAddToMruMenu(value);
            }
        }

        public class CategoryHandler
        extends I18NStringVisitor {
            protected void string(ElementContext context, String value) {
                Pair path = (Pair)context.getScopeData().get(GalleryHandler.PATH_KEY);
                path.setFirst((Object)value);
            }
        }

        public class FolderHandler
        extends I18NStringVisitor {
            public void string(ElementContext context, String value) {
                Pair path = (Pair)context.getScopeData().get(GalleryHandler.PATH_KEY);
                path.setSecond((Object)value);
            }
        }

        public class TechnologyKeyHandler
        extends ElementVisitor {
            public void end(ElementEndContext context) {
                List technology = (List)context.getScopeData().get(GalleryHandler.TECHNOLOGY_KEY);
                String text = context.getText();
                text = text == null ? null : text.trim();
                technology.add(text);
            }
        }

        public class ResClassHandler
        extends ElementVisitor {
            public void end(ElementEndContext context) {
                StringBuilder buf = new StringBuilder();
                ElementInfo elementInfo = ItemHandler.this.getItem((ElementContext)context);
                buf.append("Gallery item [");
                buf.append(elementInfo.getName() != null ? elementInfo.getName() : elementInfo.getInvokableClassName());
                buf.append("] is using the <resClass> element, which has been deprecated. ");
                buf.append("Translated strings can be used by referencing a key in the extension manifest's rsbundle-class, ");
                buf.append("e.g.: <elementname>${RESOURCE_KEY}</elementname>");
                this.log((ElementContext)context, Level.WARNING, buf.toString());
            }
        }

        public class ParameterHandler
        extends ElementVisitor {
            public void end(ElementEndContext context) {
                List parameters = (List)context.getScopeData().get(GalleryHandler.PARAMETER_KEY);
                parameters.add(context.getText().trim());
            }
        }
    }

    private final class GeneratorItemVisitor
    extends NameMetaClassVisitor {
        GeneratorItemVisitor() {
            super(KEY, VALUE);
        }

        @Override
        protected void mapStringMetaClass(ElementContext context, String name, MetaClass metaClass) {
            GalleryHandler.this._generators.put(name, metaClass);
        }
    }

    private final class GeneratorHandler
    extends ElementVisitor {
        private GeneratorHandler() {
        }

        public void start(ElementStartContext context) {
            context.registerChildVisitor(ITEM, GalleryHandler.this._generatorItemVisitor);
        }
    }

    private final class FoldersHandler
    extends ElementVisitor {
        private ElementVisitor _nameHandler = new FolderNameHandler();
        private ElementVisitor _unsortedHandler = new UnsortedHandler();
        private ElementVisitor _categoryHandler = new CategoryHandler();

        private FoldersHandler() {
        }

        public void start(ElementStartContext context) {
            context.registerChildVisitor(NAME, this._nameHandler);
            context.registerChildVisitor(UNSORTED, this._unsortedHandler);
            context.registerChildVisitor(CATEGORY, this._categoryHandler);
            context.getScopeData().put(GalleryHandler.FOLDER_ITEM_KEY, new FolderInfo());
        }

        public void end(ElementEndContext context) {
            GalleryHandler.this._folders.add(this.getFolder((ElementContext)context));
        }

        private FolderInfo getFolder(ElementContext context) {
            return (FolderInfo)context.getScopeData().get(GalleryHandler.FOLDER_ITEM_KEY);
        }

        private final class FolderNameHandler
        extends I18NStringVisitor {
            private FolderNameHandler() {
            }

            public void start(ElementStartContext context) {
                super.start(context);
                String nlsLabel = context.getAttributeValue(GalleryHandler.TRANSLATED_LABEL_ATTRIBUTE);
                if (nlsLabel != null) {
                    FolderInfo folder = FoldersHandler.this.getFolder((ElementContext)context);
                    String currentLabel = folder.getLabel();
                    if (currentLabel != null) {
                        this.log((ElementContext)context, Level.WARNING, folder.getName() + " folder label has already been set to " + currentLabel);
                    } else {
                        folder.setLabel(nlsLabel);
                    }
                }
            }

            protected void string(ElementContext context, String value) {
                FolderInfo folder = FoldersHandler.this.getFolder(context);
                folder.setName(value);
                if (folder.getLabel() == null) {
                    this.log(context, Level.WARNING, value + " folder may be missing a translated label");
                }
            }
        }

        private final class UnsortedHandler
        extends BooleanVisitor {
            private UnsortedHandler() {
            }

            public void booleanValue(ElementContext context, boolean value) {
                FoldersHandler.this.getFolder(context).setUnsorted(value);
            }
        }

        private class CategoryHandler
        extends I18NStringVisitor {
            private CategoryHandler() {
            }

            public void string(ElementContext context, String value) {
                FoldersHandler.this.getFolder(context).setCategory(value);
            }
        }
    }

    private abstract class NameMetaClassVisitor
    extends ElementVisitor {
        private final ElementName _nameElement;
        private final ElementName _valueElement;
        private static final String PAIR = "pair";

        public NameMetaClassVisitor(ElementName nameElement, ElementName valueElement) {
            this._nameElement = nameElement;
            this._valueElement = valueElement;
        }

        public void start(ElementStartContext context) {
            context.getScopeData().put(PAIR, new Pair());
            context.registerChildVisitor(this._nameElement, new ElementVisitor(){

                public void end(ElementEndContext context) {
                    Pair p = (Pair)context.getScopeData().get(NameMetaClassVisitor.PAIR);
                    p.setFirst((Object)context.getText());
                }
            });
            context.registerChildVisitor(this._valueElement, (ElementVisitor)new MetaClassVisitor(){

                protected void metaClass(ElementContext context, MetaClass mc) {
                    Pair p = (Pair)context.getScopeData().get(NameMetaClassVisitor.PAIR);
                    p.setSecond((Object)mc);
                }
            });
        }

        public void end(ElementEndContext context) {
            Pair p = (Pair)context.getScopeData().get(PAIR);
            this.mapStringMetaClass((ElementContext)context, (String)p.getFirst(), (MetaClass)p.getSecond());
        }

        protected abstract void mapStringMetaClass(ElementContext var1, String var2, MetaClass var3);
    }
}

