/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.worksheet.extension;

import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.editors.DbEditor;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.templates.TemplateVariableHandler;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.worksheet.Messages;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.javatools.db.DBException;

public class ConnectionVarHandler
extends TemplateVariableHandler {
    public static final String USER_VAR = "#user#";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected String computeVariable(Object object) {
        Object object2;
        Editor editor = EditorManager.getEditorManager().getCurrentEditor();
        String string = null;
        if (editor instanceof DbEditor) {
            string = ((DbEditor)editor).getConnectionName();
        } else if (editor.getContext().getNode() != null && (object2 = editor.getContext().getNode().getURL()) != null) {
            string = DBURLFormatHelper.getConnectionName((URL)object2);
        }
        object2 = null;
        if (string != null) {
            try {
                object2 = Connections.getInstance().getConnection(string);
            }
            catch (DBException dBException) {
                // empty catch block
            }
        }
        if (object2 == null) throw new IllegalArgumentException(Messages.getString("ConnectionVarHandler.1"));
        try {
            Connections.getInstance().lock((Connection)object2);
            if (object2.isClosed()) return this.getContextVariable();
            String string2 = object2.getMetaData().getUserName();
            return string2;
        }
        catch (SQLException sQLException) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
            return this.getContextVariable();
        }
        finally {
            Connections.getInstance().unlock((Connection)object2);
        }
    }

    public String getDescription() {
        return Messages.getString("ConnectionVarHandler.2");
    }
}

