/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.worksheet.commands.autotrace;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import oracle.dbtools.worksheet.commands.autotrace.AutotraceTreeNode;
import oracle.dbtools.worksheet.commands.autotrace.RowSrcNode;
import oracle.javatools.ui.treetable.JTreeTable;

public class NodeRenderer
extends DefaultTreeCellRenderer {
    private static final long serialVersionUID = 1L;
    public JTreeTable tbl;

    public NodeRenderer(JTreeTable jTreeTable) {
        this.tbl = jTreeTable;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        JLabel jLabel = (JLabel)super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
        this.setBackgroundSelectionColor(this.tbl.getBackground());
        try {
            RowSrcNode rowSrcNode = (RowSrcNode)object;
            jLabel.setIcon(rowSrcNode.getIcon());
            jLabel.setText(rowSrcNode.toString());
            jLabel.setForeground(rowSrcNode.getColor());
            jLabel.setToolTipText(rowSrcNode.tooltip());
            if (!bl2 && rowSrcNode.isSpanned() && rowSrcNode instanceof AutotraceTreeNode) {
                AutotraceTreeNode autotraceTreeNode = (AutotraceTreeNode)rowSrcNode;
                if (autotraceTreeNode.filterPredicates != null) {
                    jLabel.setText(autotraceTreeNode.filterPredicates);
                }
                if (autotraceTreeNode.accessPredicates != null) {
                    jLabel.setText(autotraceTreeNode.accessPredicates);
                }
            }
        }
        catch (Exception exception) {
            jLabel.setText(exception.getMessage());
            jLabel.setForeground(Color.RED);
        }
        return jLabel;
    }
}

